/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Ellipse.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/25
 *    Last                 : 2007/10/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_Undo.h"
#include "culcfunc.h"

#define _LIST_ELLIPSE_
#include "List_Ellipse.h"





/* ELLIPSE Data の初期化 */
int init_ellipse(ELLIPSE *ellipse)
{
	ellipse->layer = 0;
	ellipse->color = 0xffffff;
	ellipse->style = 0;
	ellipse->cx = 0;
	ellipse->cy = 0;
	ellipse->dx = 0;
	ellipse->dy = 0;
	ellipse->k = 1;
	ellipse->k = 0;
	ellipse->k = 360;
	return 1;
}





/* -------------------------------------------------------------------
 * 領域確保済みの ELLIPSE Data をリストの最初に追加
 * 
 */
ELLIPSE_LIST *r_ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));

	/* 確保した領域にデータ (ellipse) を書き込む */
	p_ellipse_list->ellipse = add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_ellipse_list_info->head;
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list->next = p;
	}

	return p_ellipse_list_info->head;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data をリストの最初に追加
 * 
 */
ELLIPSE_LIST *ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* データ (ellipse) を書き込むための領域を確保する */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* 確保した領域にデータ (ellipse) を書き込む */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_ellipse_list_info->head;
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list->next = p;
	}

	return p_ellipse_list_info->head;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む
 *	
 */
ELLIPSE_LIST *ellipse_list_add_first_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	ELLIPSE ellipse = {0,0,0, 0,0,0,0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* データ (ellipse) を書き込むための領域を確保する */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* 確保した領域にデータ (ellipse) を書き込む */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_ellipse_list_info->head;
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list->next = p;
	}

	lpdiagram.ellipse_point = p_ellipse_list_info->head->ellipse;
	diagram.ellipse = ellipse;

	/* Undo Buffa Write */
	undo_list_add_first(ELLIPSE_NEW, lpdiagram, diagram);
	return p_ellipse_list_info->head;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data をリストの最後に追加
 * 
 */
ELLIPSE_LIST *ellipse_list_add_last(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* データ (ellipse) を書き込むための領域を確保する */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* 確保した領域にデータ (ellipse) を書き込む */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_ellipse_list_info->head != NULL 
				&& p_ellipse_list_info->tail != NULL 
					&& p_ellipse_list_info->head == p_ellipse_list_info->tail) {
		p_ellipse_list_info->head->next = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_ellipse_list_info->tail;
		p_ellipse_list_info->tail = p_ellipse_list;
		p->next = p_ellipse_list_info->tail;
	}

	/* アンドゥバッファに書込む */
//	undo_list_add_first(11, p_ellipse_list_info->tail, NULL);
	return p_ellipse_list_info->tail;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data をリストの最後に追加、 Undo Baffer に書込む
 *	
 */
ELLIPSE_LIST *ellipse_list_add_last_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	ELLIPSE ellipse = {0,0,0, 0,0,0,0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));
	/* データ (ellipse) を書き込むための領域を確保する */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* 確保した領域にデータ (ellipse) を書き込む */
	*p_ellipse_list->ellipse = *add_ellipse;
	p_ellipse_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_ellipse_list_info->head == NULL && p_ellipse_list_info->tail == NULL) {
		p_ellipse_list_info->head = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_ellipse_list_info->head != NULL 
				&& p_ellipse_list_info->tail != NULL 
					&& p_ellipse_list_info->head == p_ellipse_list_info->tail) {
		p_ellipse_list_info->head->next = p_ellipse_list;
		p_ellipse_list_info->tail = p_ellipse_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_ellipse_list_info->tail;
		p_ellipse_list_info->tail = p_ellipse_list;
		p->next = p_ellipse_list_info->tail;
	}

	lpdiagram.ellipse_point = p_ellipse_list_info->tail->ellipse;
	diagram.ellipse = ellipse;

	/* Undo Buffa Write */
	undo_list_add_first(ELLIPSE_NEW, lpdiagram, diagram);
	return p_ellipse_list_info->tail;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data の削除機能 (メモリの削除ではない)
 * 
 */
int ellipse_list_delete(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p = NULL;
	ELLIPSE_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == p_ellipse_list_info->head && del_List->next == NULL) {
		p_ellipse_list_info->head = NULL;
		p_ellipse_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_ellipse_list_info->head && del_List->next != NULL) {
		p_ellipse_list_info->head = p_ellipse_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_ellipse_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}

		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_ellipse_list_info->tail) {
				pb->next = NULL;
				p_ellipse_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_ellipse_list_info->head && del_List != p_ellipse_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_ellipse.c : ellipse_list_delete() : There is not data of structure data ELLIPSE.\n");
			return 0;
		}
	}
	xfree(del_List);
//	StartData = p_ellipse_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * ELLIPSE Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す)
 * 
 */
int ellipse_list_delete_Undo(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p = NULL;
	ELLIPSE_LIST *pb = NULL;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データが先頭で１個だけ  */
	if (del_List == p_ellipse_list_info->head && del_List->next == NULL) {
		p_ellipse_list_info->head = NULL;
		p_ellipse_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_ellipse_list_info->head && del_List->next != NULL) {
		p_ellipse_list_info->head = p_ellipse_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_ellipse_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}

		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_ellipse_list_info->tail) {
				pb->next = NULL;
				p_ellipse_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_ellipse_list_info->head && del_List != p_ellipse_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_ellipse.c : ellipse_list_delete() : There is not data of structure data ELLIPSE.\n");
			return 0;
		}
	}

	lpdiagram.ellipse_point = del_List->ellipse;
	diagram.ellipse = *del_List->ellipse;

	undo_list_add_first(ELLIPSE_DEL, lpdiagram, diagram);
	xfree(del_List);
//	StartData = p_ellipse_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * ELLIPSE のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れる。
 *	
 * 戻り値　元のデータのアドレス
 */
ELLIPSE_LIST *ellipse_list_edit(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	/* データ (LIST) を書き込むための領域を確保する */
	p_ellipse_list = (ELLIPSE_LIST *)xmalloc(sizeof(ELLIPSE_LIST));

	/* データ (ellipse) を書き込むための領域を確保する */
	p_ellipse_list->ellipse = (ELLIPSE *)xmalloc(sizeof(ELLIPSE));

	/* 確保した領域に変更前のデータ (ellipse) を書き込む */
	*p_ellipse_list->ellipse = *point->ellipse;
	p_ellipse_list->next = point;

	/* 変更データを書き込む */
	*point->ellipse = *change_ellipse;

//	undo_list_add_first(13, p_ellipse_list, NULL);
	return p_ellipse_list;
}





/* -------------------------------------------------------------------
 * ELLIPSE のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れ、Undo Baffer に書込む
 *	
 * 戻り値　元のデータのアドレス
 */
ELLIPSE_LIST *ellipse_list_edit_with_undo(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE ellipse = {0,0,0, 0,0,0,0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* 確保した領域に変更前のデータ (ELLIPSE) を書き込む */
	ellipse = *point->ellipse;

	/* 変更データを書き込む */
	*point->ellipse = *change_ellipse;

	lpdiagram.ellipse_point = point->ellipse;
	diagram.ellipse = ellipse;

	undo_list_add_first(ELLIPSE_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 *	リストの総数を調べる
 */
long ellipse_list_num(ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	long i;

	p = p_ellipse_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n 番目のデータの検索
 * 
 */
ELLIPSE_LIST *ellipse_search_num(long search_number, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	long i;


	p = p_ellipse_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * ELLIPSE のデータの検索
 * 
 * 戻値  ELLIPSE_LIST
 */
ELLIPSE_LIST *ellipse_search_ellipse(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;


	p = p_ellipse_list_info->head;
	/*	*/
	while( p != NULL && p->ellipse != p_ellipse) {
		p = p->next;
	}

	/* p_ellipse のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * ELLIPSE のデータの検索
 * 
 * 戻値  long
 */
long ellipse_search_ellipse_to_num(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	long i;

	i = 1;
	p = p_ellipse_list_info->head;
	/*	*/
	while( p != NULL && p->ellipse != p_ellipse) {
		p = p->next;
		i++;
	}

	/* p_ellipse のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	ELLIPSE Data をリストから削除
 */
int ellipse_list_free(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p = NULL;
	ELLIPSE_LIST *pb = NULL;


	if (del_List == EllipseStartData) {
		EllipseStartData = NULL;
		//g_print ("List_Ellipse.c : ellipse_list_free() : del_List = EllipseStartData\n");
	}


	/* データが先頭で１個だけ  */
	if (del_List == p_ellipse_list_info->head && del_List->next == NULL) {
		p_ellipse_list_info->head = NULL;
		p_ellipse_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_ellipse_list_info->head && del_List->next != NULL) {
		p_ellipse_list_info->head = p_ellipse_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_ellipse_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_ellipse_list_info->tail) {
				pb->next = NULL;
				p_ellipse_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_ellipse_list_info->head && del_List != p_ellipse_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_ellipse.c : ellipse_list_free() : There is not data of structure data ELLIPSE.\n");
			return 0;
		}
	}
	xfree(del_List->ellipse);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 *	全リストを削除
 */
void ellipse_list_all_free(ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	while(p_ellipse_list_info->head != NULL) {
		if (ellipse_list_free(p_ellipse_list_info->head, p_ellipse_list_info) == 0) {
			g_print("List_ellipse.c : ellipse_list_all_free() : ellipse_list_free() でエラー\n");
			g_print("%s : %d : ellipse_list_all_free() : ERROR\n", __FILE__, __LINE__);
		}
	}
}





void ellipse_list_print(ELLIPSE_LIST_INFO *p_ellipse_list_info)
{
	ELLIPSE_LIST *p;
	int i = 0;

	g_print("----- ELLIPSE リストを表示 -----\n");
	p = p_ellipse_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d(0x%x) : layer[%d] : color[%d] : style[0x%x]\n", 
					i, (int)p->ellipse, p->ellipse->layer, (int)p->ellipse->color, p->ellipse->style);
		g_print("    中心(%f,%f) 長軸の位置(%f,%f) [短軸の％ %f] [開始角 %f] [終了角 %f]\n", 
					p->ellipse->cx, p->ellipse->cy, p->ellipse->dx, p->ellipse->dy, 
					p->ellipse->k, p->ellipse->sa, p->ellipse->ea);
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Ellipse.c
 * ====================================================================
 */
