/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cam.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/10/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "etc.h"
#define _LIST_CAM_
#include "List_cam.h"





/* -------------------------------------------------------------------
 * CAM Data をリストの最初に追加
 * 
 */
CAM_LIST *cam_list_add_first(CAM *add_cam)
{
	CAM_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_cam_list = (CAM_LIST *)xmalloc(sizeof(CAM_LIST));
	/* データ (cam) を書き込むための領域を確保する */
	p_cam_list->cam = (CAM *)xmalloc(sizeof(CAM));
	/* 確保した領域にデータ (cam) を書き込む */
	*p_cam_list->cam = *add_cam;
	p_cam_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (cam_list_info.head == NULL && cam_list_info.tail == NULL) {
		cam_list_info.head = p_cam_list;
		cam_list_info.tail = p_cam_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = cam_list_info.head;
		cam_list_info.head = p_cam_list;
		p_cam_list->next = p;
	}

	return cam_list_info.head;
}





/* -------------------------------------------------------------------
 * CAM Data をリストの最後に追加
 * 
 */
CAM_LIST *cam_list_add_last(CAM *add_cam)
{
	CAM_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_cam_list = (CAM_LIST *)xmalloc(sizeof(CAM_LIST));
	/* データ (cam) を書き込むための領域を確保する */
	p_cam_list->cam = (CAM *)xmalloc(sizeof(CAM));
	/* 確保した領域にデータ (cam) を書き込む */
	*p_cam_list->cam = *add_cam;
	p_cam_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (cam_list_info.head == NULL && cam_list_info.tail == NULL) {
		cam_list_info.head = p_cam_list;
		cam_list_info.tail = p_cam_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (cam_list_info.head != NULL 
				&& cam_list_info.tail != NULL 
					&& cam_list_info.head == cam_list_info.tail) {
		cam_list_info.head->next = p_cam_list;
		cam_list_info.tail = p_cam_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = cam_list_info.tail;
		cam_list_info.tail = p_cam_list;
		p->next = cam_list_info.tail;
	}

	/* アンドゥバッファに書込む */
//	undo_list_add_first(11, cam_list_info.tail, NULL);
	return cam_list_info.tail;
}





/* -------------------------------------------------------------------
 * リストの総数を調べる
 */
long cam_list_num(void)
{
	CAM_LIST *p;
	long i;

	p = cam_list_info.head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n 番目のデータの検索
 * 
 */
CAM_LIST *cam_search_num(long search_number)
{
	CAM_LIST *p;
	long i;

	p = cam_list_info.head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * CAM のデータの検索
 * 
 * 戻値  CAM_LIST
 */
CAM_LIST *cam_search_cam(CAM *p_cam)
{
	CAM_LIST *p;

	p = cam_list_info.head;
	/*	*/
	while( p != NULL && p->cam != p_cam) {
		p = p->next;
	}

	/* p_cam のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * CAM のデータの検索
 * 
 * 戻値  long
 */
long cam_search_cam_to_num(CAM *p_cam)
{
	CAM_LIST *p;
	long i;

	i = 1;
	p = cam_list_info.head;
	/*	*/
	while( p != NULL && p->cam != p_cam) {
		p = p->next;
		i++;
	}

	/* p_cam のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	CAM Data をリストから削除
 */
int cam_list_free(CAM_LIST *del_List)
{
	CAM_LIST *p;
	CAM_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == cam_list_info.head && del_List->next == NULL) {
		cam_list_info.head = NULL;
		cam_list_info.tail = NULL;
		//g_print("データが先頭で１個だけ\n");
	}
	/* データが先頭で２個以上  */
	else if (del_List == cam_list_info.head && del_List->next != NULL) {
		cam_list_info.head = cam_list_info.head->next;
		//g_print("データが先頭で２個以上\n");
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = cam_list_info.head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
			/* 最後のデータ */
			if (del_List == cam_list_info.tail) {
				pb->next = NULL;
				cam_list_info.tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != cam_list_info.head && del_List != cam_list_info.tail) {
				pb->next = p->next;
			}
		}
		else {
			//g_print("リストの CAM データではない\n");
			return 0;
		}
	}
	xfree(del_List->cam);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 * 全リストを削除
 */
void cam_list_all_free(void)
{
	while(cam_list_info.head != NULL) {
		cam_list_free(cam_list_info.head);
	}
}





/* ---------------------------------------------------------
 * CAM_LIST のデータ log
 *	
 */
void cam_list_log(void)
{
	CAM_LIST *p;
	long i = 0;
	char str[256];

	sprintf(str, "----- CAM リストを表示 -----\n");
	OneShotLog(str);
	p = cam_list_info.head;
	while( p != NULL) {
		i++;
		sprintf(str, "CAM LIST %d : CAM adress = [%x]   gcode = [%d]\n", (int)i, (int)p->cam, p->cam->gcode);
		OneShotLog(str);
		sprintf(str, "            : sx = [%f]   sy = [%f]   ex = [%f]   ey = [%f]\n", p->cam->sx, p->cam->sy, p->cam->ex, p->cam->ey);
		OneShotLog(str);
		p = p->next;
	}
	sprintf(str, "-------------------------------\n");
	OneShotLog(str);
}



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_cam.c
 * ====================================================================
 */
