/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : MsgBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/10/11
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define MSGBOX
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "MsgBox.h"


/* -------------------------------------------------------
 * 説明
 */
void set_value(GtkWidget *widget, msg_box *mbox)
{
	mbox->value = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
}



/* -------------------------------------------------------
 * 説明
 */
gint MsgBox(const char *title, const char *message1, const char *message2,	
		char *button1, char *button2, char *button3)
{
	char *defaultbutton = "OK";
	msg_box *mbox;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *button;


	mbox = (msg_box *)g_malloc(sizeof(msg_box));

	/* ダイアログ生成 */
	mbox->dialog = gtk_dialog_new();
	gtk_window_set_position(GTK_WINDOW(mbox->dialog),
				GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_modal(GTK_WINDOW(mbox->dialog), TRUE);
	/* ダイアログがメインウィンドウの後ろに隠れてしまわないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(mbox->dialog), GTK_WINDOW(MainWindow));
	gtk_window_set_title(GTK_WINDOW(mbox->dialog), title);
	vbox = GTK_DIALOG(mbox->dialog)->vbox;

	/* 一つ目のラベルを付ける */
	if (message1 != NULL) {
		label = gtk_label_new(message1);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* 二つ目のラベルを付ける */
	if (message2 != NULL) {
		label = gtk_label_new(message2);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* ボタンを並べる */
	if (!button1 && !button2 && !button3)
		button3 = defaultbutton;

	if (button1 != NULL) {
		button = gtk_button_new_with_label(button1);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(mbox->dialog)->action_area),	
				   button, TRUE, TRUE, 2);
		g_object_set_data(G_OBJECT(button), "value", (gpointer)1);
		g_signal_connect(G_OBJECT(button), "clicked",
				   G_CALLBACK(set_value), mbox);
		g_signal_connect(G_OBJECT(button), "clicked",
				   G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(button);
	}

	if(button2 != NULL) {
		button = gtk_button_new_with_label(button2);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(mbox->dialog)->action_area),	
				   button, TRUE, TRUE, 2);
		g_object_set_data(G_OBJECT(button), "value", (gpointer)0);
		g_signal_connect(G_OBJECT(button), "clicked",
				   G_CALLBACK(set_value), mbox);
		g_signal_connect(G_OBJECT(button), "clicked",
				   G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(button);
  }

	if(button3 != NULL) {
		button = gtk_button_new_with_label(button3);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(mbox->dialog)->action_area),	
				   button, TRUE, TRUE, 2);
		g_object_set_data(G_OBJECT(button), "value", (gpointer)-1);
		g_signal_connect(G_OBJECT(button), "clicked",
				   G_CALLBACK(set_value), mbox);
		g_signal_connect(G_OBJECT(button), "clicked",
				   G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(button);
	}

	gtk_widget_show(mbox->dialog);

	gtk_main();
	gtk_widget_destroy(mbox->dialog);
	return mbox->value; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SAgCAD
 *    Description          : CAD/CAM
 *    Source               : MsgBox.c
 * ====================================================================
 */
