/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : OutsideProcess.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/05/25
 *    Last                 : 2006/05/25
 * ====================================================================
 */
#ifndef __OUTSIDEPROCESS_H__
#define __OUTSIDEPROCESS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

#define OPS_MSGBAR 			1
#define OPS_MSGBOX 			2
#define OPS_INPUT  			4
#define OPS_SELECT_ONE 		8
#define OPS_SELECT_MANY 	16
#define OPS_OUT_FILE 		32
#define OPS_INP_FILE 		64
#define OPS_EXEC 			128
#define OPS_END 			256
#define OPS_LOOP 			512

#define OPS_POINT 			1
#define OPS_LINE 			2
#define OPS_ARC 			4
#define OPS_CIRCLE 			8
#define OPS_ANY_POINT		128
#define OPS_DIMENSION		256
#define OPS_POLYLINE		512
#define OPS_ELLIPSE			2048



struct _PRE_WORK {
	/* ---------------------------------
	 * work :
	 * 
	 *      : 0 : None
	 *      : 1 : MSGBAR : ơСˡå
	 *      : 2 : MSGBOX : åɽ
	 *      : 4 : INPUT : ܡɤ
	 *      : 8 : SELECT,ONE : ޷򣱸
	 *      : 16 : SELECT,MANY : ޷򤿤
	 * 
	 *      : 32 : OUT_FILE : 
	 *      : 64 : INP_FILE : 
	 *      : 128 : EXEC : 
	 *      : 256 : END : 
	 */
	int		work;

	/* ---------------------------------
	 * ޷
	 *		 1 : 
	 *		 2 : 
	 *		 4 : ߸
	 *		 8 : 
	 *	   128 : Ǥ
	 *	   256 : ˡ޷
	 *	   512 : ݥ饤
	 *	  2048 : ʱ
	 */
	int 	sel_obj;
	
	/* ---------------------------------
	 * If Cut then 1
	 * If Copy then 0
	 */
	int 	Cut;
	/* ---------------------------------
	 * keyword
	 * run program name
	 * Input Output File Name
	 */
	char	keyword[256];

	/* ---------------------------------
	 * message
	 * Script File Name
	 */
	char	msg[256];
};
typedef struct _PRE_WORK PRE_WORK;


struct _OUTSIDE_PROCESS {
	char 	opsName[256];
	char    opsDir[256];
	char 	opsFile[256];
	int 	version;
	int 	now;
	int 	index;
	PRE_WORK	Work[100];
};
typedef struct _OUTSIDE_PROCESS OUTSIDE_PROCESS;



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _OUTSIDEPROCESS_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL int outside_process_on GLOBAL_VAL(0);
	GLOBAL OUTSIDE_PROCESS outside_process;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _OUTSIDEPROCESS_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

int os_process(void);
int ops_read(OUTSIDE_PROCESS *outside_process);
int ops_next_go(OUTSIDE_PROCESS *op);

int ops_select_output_info(OUTSIDE_PROCESS *op);
int ops_select_output(OUTSIDE_PROCESS *op);
int ops_select_output_select(FILE *stream, SELECT *select);

int ops_select_input(FILE *stream);
int opsStartSectionRead(FILE *stream);
int ops_Point_read(char *str);
int ops_Line_read(char *str);
int ops_Arc_read(char *str);
int ops_Circle_read(char *str);
int ops_Ellipse_read(char *str);
int ops_Dimension_read(char *str, FILE *stream);
int ops_PolyLine_read(char *str, FILE *stream);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __OUTSIDEPROCESS_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : OutsideProcess.h
 * ====================================================================
 */
