/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CopyDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/19
 *    Last                 : 2003/02/19
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "Trace.h"
#define _COPYDLG_
#include "CopyDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void copy_dlg_cancel_pushed(GtkWidget *widget, COPY_DLG *copy_dlg)
{
	copy_dlg->x_pitch = 0;
	copy_dlg->y_pitch = 0;
	copy_dlg->repeats = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void copy_dlg_ok_pushed(GtkWidget *widget, COPY_DLG *copy_dlg)
{
	char str[256];


	/* ƥȥȥ꡼ʸ */
	if (copy_dlg->x_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(copy_dlg->x_pitch_entry)));
		copy_dlg->x_pitch = atof(str);
	}

	if (copy_dlg->y_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(copy_dlg->y_pitch_entry)));
		copy_dlg->y_pitch = atof(str);
	}

	if (copy_dlg->repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(copy_dlg->repeats_entry)));
		copy_dlg->repeats = atoi(str);
	}

}



/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint copy_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, COPY_DLG *copy_dlg)
{
//	g_print("sagcad.c : copy_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* ե x_pitch_entry  Enter ʤե y_pitch_entry ˰ܤ */
		if (GTK_WIDGET( copy_dlg->x_pitch_entry) == GTK_WINDOW(copy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->y_pitch_entry);
			gtk_entry_select_region( GTK_ENTRY(copy_dlg->y_pitch_entry), 0, 
									 GTK_ENTRY(copy_dlg->y_pitch_entry)->text_length);
		}
		/* ե y_pitch_entry  Enter ʤե repeats_entry ˰ܤ */
		else if (GTK_WIDGET(copy_dlg->y_pitch_entry) == GTK_WINDOW(copy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->repeats_entry);
			gtk_entry_select_region( GTK_ENTRY(copy_dlg->repeats_entry), 0, 
									 GTK_ENTRY(copy_dlg->repeats_entry)->text_length);
		}
		/* ե repeats_entry  Enter ʤ齪 */
		else if (GTK_WIDGET(copy_dlg->repeats_entry) == GTK_WINDOW(copy_dlg->dialog)->focus_widget) {
			copy_dlg_ok_pushed(widget, copy_dlg);
			gtk_main_quit();
		}
	}
	return TRUE; 
}



/* -------------------------------------------------------------------
 * ԡڰư/ʣ̡
 * 
 * 
 * copy_dlg->x_pitch && copy_dlg->x_pitch  0 ʤ focus 
 * copy_dlg->x_pitch_entry ˤ
 * 
 * copy_dlg->x_pitch || copy_dlg->x_pitch  0 ʳʤ focus 
 * copy_dlg->repeats_entry ˤ
 * 
 */
gint CopyDialog(COPY_DLG *copy_dlg)
{
	char str[256];

//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *hbox;
				GtkWidget *label_vbox;
					GtkWidget *x_pitch_label;
					GtkWidget *y_pitch_label;
					GtkWidget *repeats_label;
				GtkWidget *entry_vbox;
//					GtkWidget *x_pitch_entry;
//					GtkWidget *y_pitch_entry;
//					GtkWidget *repeats_entry;
			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


	/* (copy_dlg->dialog) */
	copy_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(copy_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(copy_dlg->dialog), _("Parallel [Move/Copy] Setting") );
	gtk_signal_connect( GTK_OBJECT(copy_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(copy_dlg_key_press_event), copy_dlg);



		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(copy_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(copy_dlg->dialog), 5);
		gtk_widget_show(main_vbox);

		/* -----------------------------------------------------
		 * ѥå󥰥ܥå(main_vbox) 
		 * ѥå󥰥ܥå(hbox & action_hbox) 
		 * Ǽ
		 */
		/* ѥå󥰥ܥå(hbox) */
		hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
							hbox, TRUE, TRUE, 0);
		gtk_widget_show(hbox);


			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(hbox) 
			 * ѥå󥰥ܥå(label_vbox & entry_vbox) 
			 * Ǽ
			 */
			/* ѥå󥰥ܥå(label_vbox) */
			label_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
			gtk_widget_show(label_vbox);

				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(label_vbox) 
				 * ٥(x_pitch_label & y_pitch_label & repeats_label) 
				 * Ǽ
				 */
				x_pitch_label = gtk_label_new( _("Pitch X") );
				gtk_widget_set_usize (x_pitch_label, 100, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), x_pitch_label, TRUE, TRUE, 0);
				gtk_widget_show(x_pitch_label);

				y_pitch_label = gtk_label_new( _("Pitch Y") );
				gtk_widget_set_usize (y_pitch_label, 100, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), y_pitch_label, TRUE, TRUE, 0);
				gtk_widget_show(y_pitch_label);

				repeats_label = gtk_label_new( _("Number of times") );
				gtk_widget_set_usize (repeats_label, 100, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), repeats_label, TRUE, TRUE, 0);
				gtk_widget_show(repeats_label);


			/* ѥå󥰥ܥå(entry_vbox) */
			entry_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), entry_vbox, TRUE, TRUE, 0);
			gtk_widget_show(entry_vbox);


				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(entry_vbox) 
				 * ƥȥȥ꡼
				 * copy_dlg->x_pitch_entry & 
				 * copy_dlg->y_pitch_entry & 
				 * copy_dlg->repeats_entry) 
				 * ,Ǽ
				 */
				/* ƥȥȥ꡼ */
				copy_dlg->x_pitch_entry = gtk_entry_new();
				gtk_widget_set_usize (copy_dlg->x_pitch_entry, 150, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), copy_dlg->x_pitch_entry, TRUE, TRUE, 1);
				/*  */
				FloatOut_n(str, copy_dlg->x_pitch, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(copy_dlg->x_pitch_entry), str);
				//gtk_signal_connect (GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(entry_callback), NULL);
				gtk_widget_show(copy_dlg->x_pitch_entry);


				copy_dlg->y_pitch_entry = gtk_entry_new();
				gtk_widget_set_usize (copy_dlg->y_pitch_entry, 150, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), copy_dlg->y_pitch_entry, TRUE, TRUE, 1);
				/*  */
				FloatOut_n(str, copy_dlg->y_pitch, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(copy_dlg->y_pitch_entry), str);
				gtk_widget_show(copy_dlg->y_pitch_entry);


				copy_dlg->repeats_entry = gtk_entry_new();
				gtk_widget_set_usize (copy_dlg->repeats_entry, 150, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), copy_dlg->repeats_entry, TRUE, TRUE, 1);
				/*  */
				sprintf(str, "%d", copy_dlg->repeats);
				gtk_entry_set_text(GTK_ENTRY(copy_dlg->repeats_entry), str);
				gtk_widget_show(copy_dlg->repeats_entry);



		/* ѥ졼(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);



		/* ѥå󥰥ܥå(action_hbox) */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);

			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(action_hbox) 
			 * ܥ(cancel_buttun & ok_buttun) 
			 * Ǽ
			 */
			/* CANCELܥ */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
			gtk_widget_set_usize (cancel_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(copy_dlg_cancel_pushed), copy_dlg);
			gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);

			/* OKܥ */
			ok_buttun = gtk_button_new_with_label("OK");
			gtk_widget_set_usize (ok_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(copy_dlg_ok_pushed), copy_dlg);
			gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
		//	  gtk_widget_grab_default(ok_buttun);
			gtk_widget_show(ok_buttun);





	/*  ե x_pitch_entry  */
	if (copy_dlg->x_pitch == 0 && copy_dlg->x_pitch == 0) {
		gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->x_pitch_entry);
		//GTK_WINDOW(copy_dlg->dialog)->focus_widget = GTK_WIDGET(copy_dlg->x_pitch_entry);
		gtk_entry_select_region( GTK_ENTRY(copy_dlg->x_pitch_entry), 0, 
								 GTK_ENTRY(copy_dlg->x_pitch_entry)->text_length);
	}
	/*  ե repeats_entry  */
	else if (copy_dlg->x_pitch != 0 || copy_dlg->repeats_entry != 0) {
		gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->repeats_entry);
		gtk_entry_select_region( GTK_ENTRY(copy_dlg->repeats_entry), 0, 
								 GTK_ENTRY(copy_dlg->repeats_entry)->text_length);
	}


	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(copy_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(copy_dlg->dialog), GTK_WINDOW(copy_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(copy_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(copy_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CopyDlg.c
 * ====================================================================
 */
