/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : SnapDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2003/02/20
 * ====================================================================
 */
#ifndef __SNAPDLG_H__
#define __SNAPDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

/* 
 *	  ޷	 1 : 
 *				 2 : 
 *				 4 : ߸
 *				 8 : 
 *				15 : ޷
 *	
 *	  ˡ޷	16 : 
 *				32 : Ⱦ
 *				64 : 濴
 *			   128 : Ǥ (optional point)
 *			   256 : ˡ޷
 *			   512 : ݥ饤
 *			  1024 : ֥å
 * 			  2048 : ʱ (ellipse)
 */
struct _SNAP_DLG
{
	gint value;		// ok/1   cancel/0   chain/2   chain2/4   color/8
	gint mask;		// ǤΤƤ (3 ʤǤʤ)
	gint snap;

	GtkWidget *point_check_button;
	GtkWidget *line_check_button;
	GtkWidget *arc_check_button;
	GtkWidget *circle_check_button;

	GtkWidget *polyline_check_button;
	GtkWidget *dimension_check_button;
	GtkWidget *block_check_button;
	GtkWidget *ellipse_check_button;

	GtkWidget *start_end_check_button;
	GtkWidget *half_4_point_check_button;
	GtkWidget *center_check_button;
	GtkWidget *any_check_button;

	GtkWidget *chain_check_button;
	GtkWidget *chain2_check_button;
	GtkWidget *color_check_button;

	GtkWidget *parent;
	GtkWidget *dialog;
};
typedef struct _SNAP_DLG SNAP_DLG;



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _SNAPDLG_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _SNAPDLG_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
gint SnapDialog(SNAP_DLG *snap_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SNAPDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : SnapDlg.h
 * ====================================================================
 */
