/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TextEditDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/25
 *    Last                 : 2003/02/25
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "etc.h"
#include "Trace.h"
#define _TEXTEDITDLG_
#include "TextEditDlg.h"





/* -------------------------------------------------------------------
 * FileName
 */
void text_edit_dlg_FileName_pushed(GtkWidget *widget, TEXT_EDIT_DLG *text_edit_dlg)
{
	char str[256], FileName[256], dummy[256];


	/* text_edit_dlg->text_entry äƤʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(text_edit_dlg->entry_Text)));

	strcpy(dummy, NowFile);
	strcpy(FileName, getFileName(dummy));
	cutExtName(FileName);

	strcat(FileName, str);

	/* text_edit_dlg->text_entry ʸꤹ */
	gtk_entry_set_text(GTK_ENTRY(text_edit_dlg->entry_Text), FileName);
}





/* -------------------------------------------------------------------
 * 
 */
void text_edit_dlg_Fai_pushed(GtkWidget *widget, TEXT_EDIT_DLG *text_edit_dlg)
{
	char str[256], fai_str[256];

	/* text_edit_dlg->text_entry äƤʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(text_edit_dlg->entry_Text)));

	strcpy(fai_str, "");
	strcat(fai_str, str);

	/* text_edit_dlg->text_entry ʸꤹ */
	gtk_entry_set_text(GTK_ENTRY(text_edit_dlg->entry_Text), fai_str);
}





/* -------------------------------------------------------------------
 * R
 */
void text_edit_dlg_R_pushed(GtkWidget *widget, TEXT_EDIT_DLG *text_edit_dlg)
{
	char str[256], fai_str[256];

	/* text_edit_dlg->text_entry äƤʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(text_edit_dlg->entry_Text)));

	strcpy(fai_str, "R");
	strcat(fai_str, str);

	/* text_edit_dlg->text_entry ʸꤹ */
	gtk_entry_set_text(GTK_ENTRY(text_edit_dlg->entry_Text), fai_str);
}





/* -------------------------------------------------------------------
 * CANCEL
 */
void text_edit_dlg_cancel_pushed(GtkWidget *widget, TEXT_EDIT_DLG *a)
{
	strcpy(a->Text, "");
	strcpy(a->UpperText, "");
	strcpy(a->LowerText, "");
	a->FontHeight = 0;
	a->FontSpace = 0;
	a->WordSpace = 0;
	a->FontOverLineSpace = 0;
	a->Angle = 0;
	a->SearchPointX = 0;
	a->SearchPointY = 0;
	a->FitPointX = 0;
	a->FitPointY = 0;
}





/* -------------------------------------------------------------------
 * OK
 */
void text_edit_dlg_ok_pushed(GtkWidget *widget, TEXT_EDIT_DLG *a)
{
	/* ƥȥȥ꡼ʸ */

	/* Text */
	strcpy(a->Text, gtk_entry_get_text(GTK_ENTRY(a->entry_Text)));
	/* UpperText */
	strcpy(a->UpperText, gtk_entry_get_text(GTK_ENTRY(a->entry_UpperText)));
	/* LowerText */
	strcpy(a->LowerText, gtk_entry_get_text(GTK_ENTRY(a->entry_LowerText)));

	/* FontHeight */
	a->FontHeight = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FontHeight)));
	/* FontSpace */
	a->FontSpace = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FontSpace)));
	/* WordSpace */
	a->WordSpace = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_WordSpace)));
	/* FontOverLineSpace */
	a->FontOverLineSpace = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FontOverLineSpace)));

	/* SearchPointX */
	a->SearchPointX = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_SearchPointX)));
	/* SearchPointY */
	a->SearchPointY = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_SearchPointY)));
	/* Angle */
	a->Angle = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_Angle)));
	/* FitPointX */
	a->FitPointX = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FitPointX)));
	/* FitPointY */
	a->FitPointY = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FitPointY)));
}





/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint text_edit_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, TEXT_EDIT_DLG *text_edit_dlg)
{
//	g_print("sagcad.c : text_edit_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);

#ifdef TEST
	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* ե x_pitch_entry  Enter ʤե y_pitch_entry ˰ܤ */
		if (GTK_WIDGET( text_edit_dlg->x_pitch_entry) == GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->y_pitch_entry);
			gtk_entry_select_region( GTK_ENTRY(text_edit_dlg->y_pitch_entry), 0, 
									 GTK_ENTRY(text_edit_dlg->y_pitch_entry)->text_length);
		}
		/* ե y_pitch_entry  Enter ʤե repeats_entry ˰ܤ */
		else if (GTK_WIDGET(text_edit_dlg->y_pitch_entry) == GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->repeats_entry);
			gtk_entry_select_region( GTK_ENTRY(text_edit_dlg->repeats_entry), 0, 
									 GTK_ENTRY(text_edit_dlg->repeats_entry)->text_length);
		}
		/* ե repeats_entry  Enter ʤ齪 */
		else if (GTK_WIDGET(text_edit_dlg->repeats_entry) == GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) {
			text_edit_dlg_ok_pushed(widget, text_edit_dlg);
			gtk_main_quit();
		}
	}
#endif
	return TRUE; 
}





/* -------------------------------------------------------------------
 * ˡܥå
 */
gint make_box_text(GtkWidget *vbox_Text, TEXT_EDIT_DLG *a)
{
	GtkWidget *hbox_Text1;
		GtkWidget *label_Text;
//		GtkWidget *entry_Text;
	GtkWidget *hbox_Text2;
		GtkWidget *label_UpperText;
//		GtkWidget *entry_UpperText;
		GtkWidget *label_LowerText;
//		GtkWidget *entry_LowerText;


	/* ѥå󥰥ܥå(hbox_Text1)  */
	hbox_Text1 = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(vbox_Text), hbox_Text1, TRUE, TRUE, 0);
	gtk_widget_show(hbox_Text1);

			/* label_Text */
			label_Text = gtk_label_new( _("Size Value") );
			gtk_misc_set_alignment(GTK_MISC(label_Text), 0.0f, 1.0f);
			gtk_widget_set_usize (label_Text, TED_LABEL_WIDTH, TED_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text1), label_Text, FALSE, TRUE, 0);
			gtk_widget_show(label_Text);

			/* entry_Text */
			a->entry_Text = gtk_entry_new();
			gtk_widget_set_usize (a->entry_Text, TED_ENTRY_WIDTH, TED_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text1), a->entry_Text, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_Text), a->Text);	/*  */
			gtk_widget_show(a->entry_Text);


	/* ѥå󥰥ܥå(hbox_Text2)  */
	hbox_Text2 = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(vbox_Text), hbox_Text2, TRUE, TRUE, 0);
	gtk_widget_show(hbox_Text2);

		/* label_UpperText */
		label_UpperText = gtk_label_new( _("Maximum") );
		gtk_misc_set_alignment(GTK_MISC(label_UpperText), 0.0f, 1.0f);
		gtk_widget_set_usize (label_UpperText, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), label_UpperText, FALSE, TRUE, 0);
		gtk_widget_show(label_UpperText);

		/* entry_UpperText */
		a->entry_UpperText = gtk_entry_new();
		gtk_widget_set_usize (a->entry_UpperText, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), a->entry_UpperText, FALSE, TRUE, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_UpperText), a->UpperText);	/*  */
		gtk_widget_show(a->entry_UpperText);

		/* label_LowerText */
		label_LowerText = gtk_label_new( _("Minimum") );
		gtk_misc_set_alignment(GTK_MISC(label_LowerText), 0.0f, 1.0f);
		gtk_widget_set_usize (label_LowerText, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), label_LowerText, FALSE, TRUE, 0);
		gtk_widget_show(label_LowerText);

		/* entry_LowerText */
		a->entry_LowerText = gtk_entry_new();
		gtk_widget_set_usize (a->entry_LowerText, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), a->entry_LowerText, FALSE, TRUE, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_LowerText), a->UpperText);	/*  */
		gtk_widget_show(a->entry_LowerText);

	return 1;
}





/* -------------------------------------------------------------------
 * ¾ܥå
 */
gint make_box_etc(GtkWidget *hbox_etc, TEXT_EDIT_DLG *a)
{
	char str[256];

	GtkWidget *vbox_label_etc1;
		GtkWidget *label_FontHeight;
		GtkWidget *label_FontSpace;
		GtkWidget *label_WordSpace;
		GtkWidget *label_FontOverLineSpace;
	GtkWidget *vbox_entry_etc1;
//		GtkWidget *entry_FontHeight;
//		GtkWidget *entry_FontSpace;
//		GtkWidget *entry_WordSpace;
//		GtkWidget *entry_FontOverLineSpace;
	GtkWidget *vbox_label_etc2;
		GtkWidget *label_SearchPointX;
		GtkWidget *label_SearchPointY;
		GtkWidget *label_Angle;
		GtkWidget *label_FitPointX;
		GtkWidget *label_FitPointY;
	GtkWidget *vbox_entry_etc2;
//		GtkWidget *entry_SearchPointX;
//		GtkWidget *entry_SearchPointY;
//		GtkWidget *entry_Angle;
//		GtkWidget *entry_FitPointX;
//		GtkWidget *entry_FitPointY;


	/* ѥå󥰥ܥå(vbox_label_etc1)  */
	vbox_label_etc1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_label_etc1, TRUE, TRUE, 0);
	gtk_widget_show(vbox_label_etc1);

		/* label_FontHeight */
		label_FontHeight = gtk_label_new( _("Height of the character") );
		gtk_misc_set_alignment(GTK_MISC(label_FontHeight), 0.0f, 1.0f);
		gtk_widget_set_usize (label_FontHeight, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_FontHeight, FALSE, TRUE, 0);
		gtk_widget_show(label_FontHeight);

		/* label_FontSpace */
		label_FontSpace = gtk_label_new( _("Interval of the character") );
		gtk_misc_set_alignment(GTK_MISC(label_FontSpace), 0.0f, 1.0f);
		gtk_widget_set_usize (label_FontSpace, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_FontSpace, FALSE, TRUE, 0);
		gtk_widget_show(label_FontSpace);

		/* label_WordSpace */
		label_WordSpace = gtk_label_new( _("Interval of the word") );
		gtk_misc_set_alignment(GTK_MISC(label_WordSpace), 0.0f, 1.0f);
		gtk_widget_set_usize (label_WordSpace, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_WordSpace, FALSE, TRUE, 0);
		gtk_widget_show(label_WordSpace);

		/* label_FontOverLineSpace */
		label_FontOverLineSpace = gtk_label_new( _("The offset from the size line") );
		gtk_misc_set_alignment(GTK_MISC(label_FontOverLineSpace), 0.0f, 1.0f);
		gtk_widget_set_usize (label_FontOverLineSpace, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_FontOverLineSpace, FALSE, TRUE, 0);
		gtk_widget_show(label_FontOverLineSpace);


	/* ѥå󥰥ܥå(vbox_entry_etc1)  */
	vbox_entry_etc1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_entry_etc1, TRUE, TRUE, 0);
	gtk_widget_show(vbox_entry_etc1);

		/* entry_FontHeight */
		a->entry_FontHeight = gtk_entry_new();
		gtk_widget_set_usize (a->entry_FontHeight, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_FontHeight, FALSE, TRUE, 0);
		FloatOut_n(str, a->FontHeight, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FontHeight), str);	/*  */
		gtk_widget_show(a->entry_FontHeight);

		/* entry_FontSpace */
		a->entry_FontSpace = gtk_entry_new();
		gtk_widget_set_usize (a->entry_FontSpace, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_FontSpace, FALSE, TRUE, 0);
		FloatOut_n(str, a->FontSpace, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FontSpace), str);	/*  */
		gtk_widget_show(a->entry_FontSpace);

		/* entry_WordSpace */
		a->entry_WordSpace = gtk_entry_new();
		gtk_widget_set_usize (a->entry_WordSpace, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_WordSpace, FALSE, TRUE, 0);
		FloatOut_n(str, a->WordSpace, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_WordSpace), str);	/*  */
		gtk_widget_show(a->entry_WordSpace);

		/* entry_FontOverLineSpace */
		a->entry_FontOverLineSpace = gtk_entry_new();
		gtk_widget_set_usize (a->entry_FontOverLineSpace, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_FontOverLineSpace, FALSE, TRUE, 0);
		FloatOut_n(str, a->FontOverLineSpace, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FontOverLineSpace), str);	/*  */
		gtk_widget_show(a->entry_FontOverLineSpace);


	/* ѥå󥰥ܥå(vbox_label_etc2)  */
	vbox_label_etc2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_label_etc2, TRUE, TRUE, 0);
	gtk_widget_show(vbox_label_etc2);

		/* label_SearchPointX */
		label_SearchPointX = gtk_label_new( _("Insertion point X") );
		gtk_misc_set_alignment(GTK_MISC(label_SearchPointX), 0.0f, 1.0f);
		gtk_widget_set_usize (label_SearchPointX, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_SearchPointX, FALSE, TRUE, 0);
		gtk_widget_show(label_SearchPointX);

		/* label_SearchPointY */
		label_SearchPointY = gtk_label_new( _("Insertion point Y") );
		gtk_misc_set_alignment(GTK_MISC(label_SearchPointY), 0.0f, 1.0f);
		gtk_widget_set_usize (label_SearchPointY, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_SearchPointY, FALSE, TRUE, 0);
		gtk_widget_show(label_SearchPointY);

		/* label_Angle */
		label_Angle = gtk_label_new( _("Angle") );
		gtk_misc_set_alignment(GTK_MISC(label_Angle), 0.0f, 1.0f);
		gtk_widget_set_usize (label_Angle, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_Angle, FALSE, TRUE, 0);
		gtk_widget_show(label_Angle);

		/* label_FitPointX */
		label_FitPointX = gtk_label_new( _("It adjusts in the horizontal."));
		gtk_misc_set_alignment(GTK_MISC(label_FitPointX), 0.0f, 1.0f);
		gtk_widget_set_usize (label_FitPointX, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_FitPointX, FALSE, TRUE, 0);
		gtk_widget_show(label_FitPointX);

		/* label_FitPointY */
		label_FitPointY = gtk_label_new( _("It adjusts in the vertical.") );
		gtk_misc_set_alignment(GTK_MISC(label_FitPointY), 0.0f, 1.0f);
		gtk_widget_set_usize (label_FitPointY, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_FitPointY, FALSE, TRUE, 0);
		gtk_widget_show(label_FitPointY);


	/* ѥå󥰥ܥå(vbox_entry_etc2)  */
	vbox_entry_etc2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_entry_etc2, TRUE, TRUE, 0);
	gtk_widget_show(vbox_entry_etc2);

		/* entry_SearchPointX */
		a->entry_SearchPointX = gtk_entry_new();
		gtk_widget_set_usize (a->entry_SearchPointX, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_SearchPointX, FALSE, TRUE, 0);
		FloatOut_n(str, a->SearchPointX, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_SearchPointX), str);	/*  */
		gtk_widget_show(a->entry_SearchPointX);

		/* entry_SearchPointY */
		a->entry_SearchPointY = gtk_entry_new();
		gtk_widget_set_usize (a->entry_SearchPointY, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_SearchPointY, FALSE, TRUE, 0);
		FloatOut_n(str, a->SearchPointY, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_SearchPointY), str);	/*  */
		gtk_widget_show(a->entry_SearchPointY);

		/* entry_Angle */
		a->entry_Angle = gtk_entry_new();
		gtk_widget_set_usize (a->entry_Angle, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_Angle, FALSE, TRUE, 0);
		FloatOut_n(str, a->Angle, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_Angle), str);	/*  */
		gtk_widget_show(a->entry_Angle);

		/* entry_FitPointX */
		a->entry_FitPointX = gtk_entry_new();
		gtk_widget_set_usize (a->entry_FitPointX, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_FitPointX, FALSE, TRUE, 0);
		sprintf(str, "%d", a->FitPointX);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FitPointX), str);	/*  */
		gtk_widget_show(a->entry_FitPointX);

		/* entry_FitPointY */
		a->entry_FitPointY = gtk_entry_new();
		gtk_widget_set_usize (a->entry_FitPointY, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_FitPointY, FALSE, TRUE, 0);
		sprintf(str, "%d", a->FitPointY);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FitPointY), str);	/*  */
		gtk_widget_show(a->entry_FitPointY);

	return 1;
}





/* -------------------------------------------------------------------
 * ˡ
 * 
 */
gint TextEditDialog(TEXT_EDIT_DLG *text_edit_dlg)
{
	GtkWidget *main_vbox;
		GtkWidget *vbox_Text;
		GtkWidget *separator;
		GtkWidget *hbox_etc;
		GtkWidget *action_hbox;
			GtkWidget *file_name_button;
			GtkWidget *fai_button;
			GtkWidget *R_button;
			GtkWidget *cancel_button;
			GtkWidget *ok_button;



	/* (text_edit_dlg->dialog) */
	text_edit_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(text_edit_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(text_edit_dlg->dialog),  _("Text Setting") );
	gtk_signal_connect( GTK_OBJECT(text_edit_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(text_edit_dlg_key_press_event), text_edit_dlg);


		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(text_edit_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(text_edit_dlg->dialog), 5);
		gtk_widget_show(main_vbox);


			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(main_vbox) 
			 * ѥå󥰥ܥå(vbox_Text & separator & action_hbox) 
			 * Ǽ
			 */
			/* ѥå󥰥ܥå(vbox_Text) */
			vbox_Text = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), vbox_Text, TRUE, TRUE, 0);
			gtk_widget_show(vbox_Text);

				/*  */
				make_box_text(vbox_Text, text_edit_dlg);

			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);

			/* ѥå󥰥ܥå(hbox_etc) */
			hbox_etc = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
								hbox_etc, TRUE, TRUE, 0);
			gtk_widget_show(hbox_etc);

				/*  */
				make_box_etc(hbox_etc, text_edit_dlg);

			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);


			/* ѥå󥰥ܥå(action_hbox) */
			action_hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
			gtk_widget_show(action_hbox);

				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(action_hbox) 
				 * ܥ
				 * file_name_button 
				 * fai_button 
				 * R_button 
				 * cancel_button 
				 * ok_button
				 * 
				 * Ǽ
				 */
				/* FileName ܥ */
				file_name_button = gtk_button_new_with_label( _("File Name") );
				gtk_widget_set_usize (file_name_button, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), file_name_button, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(file_name_button), "clicked", 
									GTK_SIGNAL_FUNC(text_edit_dlg_FileName_pushed), text_edit_dlg);
				gtk_widget_show(file_name_button);

				/*  ܥ */
				fai_button = gtk_button_new_with_label("");
				gtk_widget_set_usize (fai_button, 30, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), fai_button, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(fai_button), "clicked", 
									GTK_SIGNAL_FUNC(text_edit_dlg_Fai_pushed), text_edit_dlg);
				gtk_widget_show(fai_button);

				/* R ܥ */
				R_button = gtk_button_new_with_label("R");
				gtk_widget_set_usize (R_button, 30, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), R_button, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(R_button), "clicked", 
									GTK_SIGNAL_FUNC(text_edit_dlg_R_pushed), text_edit_dlg);
				gtk_widget_show(R_button);

				/* CANCELܥ */
				cancel_button = gtk_button_new_with_label("CANCEL");
				gtk_widget_set_usize (cancel_button, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_button, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(cancel_button), "clicked", 
									GTK_SIGNAL_FUNC(text_edit_dlg_cancel_pushed), text_edit_dlg);
				gtk_signal_connect( GTK_OBJECT(cancel_button), "clicked", 
									GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
				gtk_widget_show(cancel_button);

				/* OKܥ */
				ok_button = gtk_button_new_with_label("OK");
				gtk_widget_set_usize (ok_button, 30, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_button, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(ok_button), "clicked", 
									GTK_SIGNAL_FUNC(text_edit_dlg_ok_pushed), text_edit_dlg);
				gtk_signal_connect( GTK_OBJECT(ok_button), "clicked", 
									GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
			//	  GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
			//	  gtk_widget_grab_default(ok_button);
				gtk_widget_show(ok_button);





	/*  ե entry_Text  */
	gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_Text);

	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(text_edit_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(text_edit_dlg->dialog), GTK_WINDOW(text_edit_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(text_edit_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(text_edit_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TextEditDlg.c
 * ====================================================================
 */
