/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : sagcad.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/02/04
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
//#include <libintl.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <locale.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#define _SAGCAD_
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_insert.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#include "etc.h"
#include "Trace.h"
#include "global.h"
#include "toolbar.h"
#include "DrawArea.h"
#include "LineStyleBox.h"
#include "Draw.h"
#include "Mouse.h"
#include "MsgBox.h"
#include "Command.h"
#include "sgy.h"
#include "DXF_read.h"
#include "sagcad.h"


/* -------------------------------------------------------------------
 * ץꥱνλ
 * 
 */
void file_quit_cmd_callback(gpointer callback_data, guint callback_action, GtkWidget *widget)
{	
	gtk_exit(0); 
}



/* -------------------------------------------------------------------
 * ɥĤ٥
 * 
 */
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	int Ret;


	if (Undo_index != 0) {
		//                                                                    1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!"), _("Does it save?"), "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return TRUE;
		}
	}

	ending();

#ifdef DEBUG
	g_print("sagcad : delete_event\n");
#endif

	return(FALSE); 
}



/* -------------------------------------------------------------------
 * 줿٥
 * 
 */
static gint key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
//	g_print("sagcad.c : key_press_event : time:%d  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			 event->time, event->state, event->keyval, event->length, event->string);


	if (OnlyOne_mode == 210) {
		/* Enter */
		if (event->keyval == 0xff0d || event->keyval == 0xff8d) {
			OnlyOne (1);
			UpDate();
			return TRUE;
		}
		/* ESC */
		else if (event->keyval == 0xff1b) {
			if (OnlyOne_mode != 0) {
				OnlyOne (0);
				UpDate();
			}
			else {
				cmd_cancel();
			}
				return TRUE;
		}
		/* SPACE */
		else if (event->keyval == 0x20) {
			OnlyOne (2);
//			UpDate();
			UpDate_widget(drawing_area);
//			MouseRet_OnlyOne(drawing_area, 1, 0, 0);
			return TRUE;
		}
	}
	if(event->keyval == 0xff52) MoveUp();			/*  */
	if(event->keyval == 0xff54) MoveDown();			/*  */
	if(event->keyval == 0xff53) MoveRight();		/*  */
	if(event->keyval == 0xff51) MoveLeft();			/*  */
	
	if(event->keyval == 0xffab) ZoomUp();			/* + */
	if(event->keyval == 0xffad) ZoomDown();			/* - */

	if(event->keyval == 0xff1b) cmd_all_cancel();	/* ESC */

//	if(event->keyval == 0x20) cmd_all_cancel();		/* SPACE */
//	if(event->keyval == 0xff0d) cmd_all_cancel();	/* Enter */
	if(event->keyval == 0xffff) cmd_delete();	    /* Delete */
//	if(event->keyval == 0xff50) cmd_all_cancel();	/* Home */
//	if(event->keyval == 0xff08) cmd_all_cancel();	/* BackSpace */
//	if(event->keyval == 0xff57) cmd_all_cancel();	/* End */
//	if(event->keyval == 0xff63) cmd_all_cancel();	/* Insert */
	if(event->keyval == 0xff55) ZoomUp();	        /* PageUp */
	if(event->keyval == 0xff56) ZoomDown();	        /* PageDown */

//	if(event->keyval == 0x61) cmd_select_chain();	/* a */
//	if(event->keyval == 0x62) cmd_select_chain2();	/* b */
//	if(event->keyval == 0x63) cmd_select_color();	/* c */
	if(event->keyval == 0x74) test();				/* t */

	return TRUE; 
}



/* -------------------------------------------------------------------
 * ɥĤ٥
 * 
 */
static void destroy(GtkWidget *widget, gpointer data)
{		
#ifdef DEBUG
	g_print("sagcad : destroy\n");
#endif
	gtk_main_quit(); 
}



/* -------------------------------------------------------------------
 * main ؿ
 * 
 * 
 */
int main(int argc, char *argv[])
{
//#define TEST_HANDLE_BOX

#ifdef TEST_HANDLE_BOX
	GtkWidget *handle_toolbar;
	GtkWidget *handle_textbar;
	GtkWidget *handle_statusbar;
#endif

	char str[64], str2[64], msg[256];
	GtkWidget *vbox;
	GtkWidget *toolbar;
	GtkWidget *text_hbox;
	GtkWidget *separator;
	GtkWidget *mag_box;
	GtkWidget *layer_box;
	GtkWidget *filletR_box;
	GtkWidget *length_box;
	GtkWidget *scroll_pitch_box;
//	GtkWidget *hbox;//work_hbox;
	GtkWidget *toolbarY1;
	GtkWidget *toolbarY2;

//	GdkCursor *cursor;

	int debug = 0;


#ifdef DEBUG
	debug = 1;
#endif



	/* ---------------------------------------------------------------
	 * GTK+ ν
	 */
	/*  */
	gtk_set_locale();
	/* ν */
	gtk_init( &argc, &argv );
	/* rc եɤ߹ */
	gtk_rc_parse( "./gtkrc" );


	/* ---------------------------------------------------------------
	 * åιݲν 
	 */
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);

	//g_print("LOCALEDIR = %s", LOCALEDIR);


	/* ---------------------------------------------------------------
	 * SagCAD ưν 
	 */
	/* ѿν */
	sagcad_global_init();
	/* եɤ߹ */
	ConfigRead();
	/* å */
	starting();

	DeleteMemoryDebugLog();
	DeleteOneShotLog();



	/* -------------------------
	 * ᥤ󥦥ɥ 
	 * -------------------------
	 */
	MainWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(MainWindow), TRUE, TRUE, TRUE);
	gtk_container_border_width(GTK_CONTAINER(MainWindow), 2);
	SetTitle("NoName.sgy");

	/* ɥɽ */
	if (sagcad_system.WinMode > 0) {
		gtk_widget_set_uposition (MainWindow, sagcad_system.win_x_pos, sagcad_system.win_y_pos);
		//g_print("window position = (%d,%d)\n", sagcad_system.win_x_pos, sagcad_system.win_y_pos);
	}
	/* ɥ */
	gtk_widget_set_usize (MainWindow, sagcad_system.win_width, sagcad_system.win_height);
	gtk_widget_show(MainWindow);
	/* "delete_event" Υ٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(MainWindow), "delete_event",	
					   GTK_SIGNAL_FUNC(delete_event), NULL);
	/* "destroy" Υ٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(MainWindow), "destroy",
					   GTK_SIGNAL_FUNC(destroy), NULL);
	/* "button_press_event" ٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(MainWindow), "key_press_event",
					   GTK_SIGNAL_FUNC(key_press_event), NULL);


	/* ᥤ󥦥ɥɽǤʤȥ */
	font_open(sagcad_dimension.font_file);

	/* vbox  (Ĥɲ) */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(MainWindow), vbox);
	gtk_widget_show(vbox);





#ifdef TEST_HANDLE_BOX
	handle_toolbar = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(vbox), handle_toolbar, FALSE, FALSE, 0);
	gtk_widget_show(handle_toolbar);
#endif

	/* ġС  (OutMode1) */
	toolbar = create_toolbar_OutMode1(MainWindow);
#ifdef TEST_HANDLE_BOX
	gtk_container_add(GTK_CONTAINER(handle_toolbar), toolbar);
#else
	gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);
#endif
	gtk_widget_show(toolbar);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);
	gtk_widget_show(separator);





#ifdef TEST_HANDLE_BOX
	handle_textbar = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(vbox), handle_textbar, FALSE, FALSE, 0);
	gtk_widget_show(handle_textbar);
#endif

	/* text_hbox  (ɲ) */
	text_hbox = gtk_hbox_new(FALSE, 2);
#ifdef TEST_HANDLE_BOX
	gtk_container_add(GTK_CONTAINER(handle_textbar), text_hbox);
#else
	gtk_container_border_width(GTK_CONTAINER(text_hbox), 2);
	gtk_box_pack_start(GTK_BOX(vbox), text_hbox, FALSE, FALSE, 0);
#endif
	gtk_widget_show(text_hbox);





	/* ơС */
	line_status = create_line_style_box();
	gtk_box_pack_start(GTK_BOX(text_hbox), line_status, FALSE, FALSE, 0);
	gtk_widget_show(line_status);

	/* Ψɽܥå */
	mag_box = gtk_button_new();
	gtk_widget_set_usize (mag_box, 80, 18);
	gtk_box_pack_start(GTK_BOX(text_hbox), mag_box, FALSE, FALSE, 0);
	gtk_signal_connect( GTK_OBJECT(mag_box), "clicked", 
						GTK_SIGNAL_FUNC(mag_box_click), NULL);
	gtk_widget_show(mag_box);

	/* Ψɽ٥ */
	mag = gtk_label_new(" Mag 1 ");
	gtk_container_add(GTK_CONTAINER(mag_box), mag);
	gtk_widget_show(mag);
	
	/* 쥤䡼ɽܥå */
	layer_box = gtk_button_new();
	gtk_widget_set_usize (layer_box, 160, 18);
	gtk_box_pack_start(GTK_BOX(text_hbox), layer_box, FALSE, FALSE, 0);
	gtk_signal_connect( GTK_OBJECT(layer_box), "clicked",	
						GTK_SIGNAL_FUNC(cmd_LayerSet), NULL);
	gtk_widget_show(layer_box);
	
	/* 쥤䡼ɽ٥ */
	layer = gtk_label_new("Layer-1 [ 1 ]");
	gtk_container_add(GTK_CONTAINER(layer_box), layer);
	gtk_widget_show(layer);
	
	/* Fillet ɽܥå */
	filletR_box = gtk_button_new();
	gtk_widget_set_usize (filletR_box, 80, 18);
	gtk_box_pack_start(GTK_BOX(text_hbox), filletR_box, FALSE, FALSE, 0);
	gtk_signal_connect( GTK_OBJECT(filletR_box), "clicked",	
						GTK_SIGNAL_FUNC(fillet_box_click), NULL);
	gtk_widget_show(filletR_box);

	/* Fillet ɽ٥ */
	FloatOut6(str, sagcad_system.FilletRC, 0);
	sprintf(str2, " R %s ", str);
	fillet = gtk_label_new(str2);
	gtk_container_add(GTK_CONTAINER(filletR_box), fillet);
	gtk_widget_show(fillet);
				
	/* length ɽܥå */
	length_box = gtk_button_new();
	gtk_widget_set_usize (length_box, 80, 18);
	gtk_box_pack_start(GTK_BOX(text_hbox), length_box, FALSE, FALSE, 0);
	gtk_signal_connect( GTK_OBJECT(length_box), "clicked",	
						GTK_SIGNAL_FUNC(length_box_click), NULL);
	gtk_widget_show(length_box);
	
	/* length ɽ٥ */
	FloatOut6(str, sagcad_system.Length, 0);
	sprintf(str2, " L %s ", str);
	length = gtk_label_new(str2);
	gtk_container_add(GTK_CONTAINER(length_box), length);
	gtk_widget_show(length);

	/* scroll_pitch ɽܥå */
	scroll_pitch_box = gtk_button_new();
	gtk_widget_set_usize (scroll_pitch_box, 80, 18);
	gtk_box_pack_start(GTK_BOX(text_hbox), scroll_pitch_box, FALSE, FALSE, 0);
	gtk_signal_connect( GTK_OBJECT(scroll_pitch_box), "clicked",	
						GTK_SIGNAL_FUNC(scroll_pitch_box_click), NULL);
	gtk_widget_show(scroll_pitch_box);
	
	/* scroll_pitch ɽ٥ */
	FloatOut6(str, sagcad_system.ScrollPitch, 0);
	sprintf(str2, " SP %s ", str);
	scroll_pitch = gtk_label_new(str2);
	gtk_container_add(GTK_CONTAINER(scroll_pitch_box), scroll_pitch);
	gtk_widget_show(scroll_pitch);
	
	/* Mouse Y ɽܥå */
	MouseY = gtk_label_new("y 0.000");
	gtk_widget_set_usize (MouseY, 80, 18);
	gtk_box_pack_end(GTK_BOX(text_hbox), MouseY, FALSE, FALSE, 0);
	gtk_widget_show(MouseY);
	
	/* Mouse X ɽܥå */
	MouseX = gtk_label_new("x 0.000");
	gtk_widget_set_usize (MouseX, 80, 18);
	gtk_box_pack_end(GTK_BOX(text_hbox), MouseX, FALSE, FALSE, 0);
	gtk_widget_show(MouseX);
	
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);
	gtk_widget_show(separator);
	
	/* work_hbox  (ɲ) */
	work_hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), work_hbox, TRUE, TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(work_hbox), 2);
	gtk_widget_show(work_hbox);
	
	/* ġС */
	toolbarY1 = create_toolbar_InMode1(MainWindow);
	gtk_box_pack_start(GTK_BOX(work_hbox), toolbarY1, FALSE, FALSE, 0);
	gtk_widget_show(toolbarY1);
	
	/* ġС */
	toolbarY2 = create_toolbar_InMode2(MainWindow);
	gtk_box_pack_start(GTK_BOX(work_hbox), toolbarY2, FALSE, FALSE, 0);
	gtk_widget_show(toolbarY2);
	
	separator = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(work_hbox), separator, FALSE, FALSE, 2);
	gtk_widget_show(separator);
	
	/* ɥ󥰥ꥢ */
	drawing_area = create_drawing_area();
	gtk_box_pack_start(GTK_BOX(work_hbox), drawing_area, TRUE, TRUE, 0);
	gtk_widget_show(drawing_area);
	/* -------------------------------------------------------------------------------
	   ޥ 
	   GDK_CROSS  GDK_IRON_CROSS  [GDK_CROSSHAIR]  GDK_DIAMOND_CROSS  [GDK_TCROSS]
	 */
//	cursor = gdk_cursor_new(GDK_TCROSS);
//	gdk_window_set_cursor(drawing_area->window, cursor);





#ifdef TEST_HANDLE_BOX
	handle_statusbar = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(vbox), handle_statusbar, FALSE, FALSE, 0);
	gtk_widget_show(handle_statusbar);
#endif

	/* ơС */
	statusbar = gtk_entry_new();
#ifdef TEST_HANDLE_BOX
	gtk_container_add(GTK_CONTAINER(handle_statusbar), statusbar);
#else
	gtk_box_pack_start(GTK_BOX(vbox), statusbar, FALSE, FALSE, 0);
	gtk_entry_set_editable((GtkEntry *)statusbar, FALSE);
#endif
	gtk_widget_show(statusbar);





	/* -----------------------------
	 * Ͻ
	 */
	ReturnFunc = MouseRet_Non;



	/* GC */
//	gc = create_gc(drawing_area);
	ls_gc = create_gc(line_status);

	/* ޥɥ饤Υե򳫤 */
	if(argc == 2) {
		strcpy(NowFile, argv[1]);

		if (strstr(NowFile, ".sgy") != NULL || strstr(NowFile, ".SGY") != NULL) {
			sprintf(msg, "Reading SGY       ");
			StatusMsg(msg);
			UpDate_widget(MainWindow);
			sgyFileOpen(NowFile);
		}
		else if(strstr(NowFile, ".dxf") != NULL || strstr(NowFile, ".DXF") != NULL) {
			sprintf(msg, "Reading DXF       ");
			StatusMsg(msg);
			UpDate_widget(MainWindow);
			DxfFileOpen(NowFile, 0, 0);
		}

		SetTitle(NowFile);
	}
	else {
		/* ɥΥȥ */
		sprintf(NowFile, "%s/NoName.dxf", sagcad_user.CadPath);
		SetTitle(NowFile);
	}
	/* -----------------------------
	 * ᥤ󥤥٥ȥ롼
	 */
	gtk_main ();


	/* -----------------------------
	 * λ
	 */

	/* GC  */
	delete_gc(gc);
//	delete_gc(ls_gc);


	/* 곫 */
	if (debug > 0) g_print("\n--- < Memory Block Free start > ---\n");
	if (debug > 0) g_print("CAD Data Free ---> ");
	if (debug > 0) g_print("CAD Data [%d]\n", (int)cad_list_num(&cad_list_info));
	cad_list_all_free(&cad_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("DIMENSION Data Free ---> ");
	if (debug > 0) g_print("DIMENSION Data [%d]\n", (int)dimension_list_num(&dimension_list_info));
	dimension_list_all_free(&dimension_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("POLYLINE Data Free ---> ");
	if (debug > 0) g_print("POLYLINE Data [%d]\n", (int)polyline_list_num(&polyline_list_info));
	polyline_list_all_free(&polyline_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("ELLIPSE Data Free ---> ");
	if (debug > 0) g_print("ELLIPSE Data [%d]\n", (int)ellipse_list_num(&ellipse_list_info));
	ellipse_list_all_free(&ellipse_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("INSERT Data Free ---> ");
	if (debug > 0) g_print("INSERT Data [%d]\n", (int)insert_list_num(&insert_list_info));
	insert_list_all_free(&insert_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("BLOCK Data Free ---> ");
	if (debug > 0) g_print("BLOCK Data [%d]\n", (int)block_list_num(&block_list_info));
	block_list_all_free(&block_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("UNDO Data Free ---> ");
	//g_print("UNDO Data [%d]\n", (int)undo_list_num());
	undo_list_all_free();
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("SELECT Data Free ---> ");
	select_list_all_free();
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("FONT Data Free ---> ");
	//g_print("FONT Data [%d]\n", (int)font_list_num());
	font_list_all_free();
	if (debug > 0) g_print("OK !\n");
	if (debug > 0) g_print("--- < Memory Block Free end > ---\n\n");

	xdump();
	return 0;
}



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : sagcad.c
 * ====================================================================
 */





/* -------------------------------------------------------------------
 * ȥ
 *	
 */
int SetTitle(char *FileName)
{
	char str[256];

	sprintf(str, " [ %s ] - %s Version ", FileName, Title);
	strcat(str, VERSION);
	set_window_text(MainWindow, str);
	return 1;
}





/* -------------------------------------------------------------------
 * ƥ󥰡å
 * 
 */
int starting(void)
{
//	char *pt;

	g_print("\nSagCAD ");
	g_print(VERSION);
	g_print("\n");
	g_print("Copyright (C) 1998-2003 Sagiya Metal Mold Factory,Inc.\n");
	g_print("Yutaka Sagiya.\n");
	g_print("SagCAD comes with NO WARRANTY,\n");
	g_print("to the extent permitted by law.\n");
	g_print("You may redistribute copies of SagCAD\n");
	g_print("under the terms of the GNU General Public License.\n");
	g_print("For more information about these matters,\n");
	g_print("see the files named COPYING.\n\n");
	g_print("Report bugs to <kappa@a6s.highway.ne.jp>\n");

#ifdef TEST
	g_print("Font Directry ->");
	g_print(FONTDIR);
	g_print("\n");

	g_print("Tool Directry ->");
	g_print(TOOLDIR);
	g_print("\n");

	g_print("Locale Directry ->");
	g_print(LOCALEDIR);
	g_print("\n");

	g_print("DOCUMENT Directry ->");
	g_print(DOCDIR);
	g_print("\n");
#endif
	return 1;
}





/* -------------------------------------------------------------------
 * ǥ󥰡å
 * 
 */
int ending(void)
{
	int bar_x, bar_y, x, y, width, height, dummy;

	gdk_window_get_geometry(MainWindow->window, &bar_x, &bar_y, &width, &height, &dummy);
//	g_print("sagcad.c : delete_event() : Bar Size (%d, %d)   Window Size(%d,%d)\n", 
//			bar_x, bar_y, width, height);

	gdk_window_get_position(MainWindow->window, &x, &y);
//	g_print("sagcad.c : delete_event() : position (%d,%d)\n", x, y);

	if (sagcad_system.WinMode == 2) {
		sagcad_system.win_x_pos = x - bar_x/* -1*/;
		sagcad_system.win_y_pos = y - bar_y/* -1*/;
		sagcad_system.win_width = width;
		sagcad_system.win_height = height;
		
		if (sagcad_system.win_x_pos < 10) sagcad_system.win_x_pos = 0;
		if (sagcad_system.win_y_pos < 10) sagcad_system.win_y_pos = 0;
		
		ConfigWrite();
	}


	g_print("\nThanks to...\n");
	g_print("  Adviser         mosoku <f_mosoku@lycos.jp>\n");
	g_print("                  allentown <pulsar@sea.plala.or.jp>\n");	// Narita Koichi 
	g_print("                  0110110 <sora@tka.att.ne.jp>\n");		// Yoshihiro Horii 
	g_print("  Japanese Font   Yoshimune Kobayashi <cfg47520@syd.odn.ne.jp>\n");
	g_print("  German          Thomas Formella <thomas-formella@web.de>\n");
	g_print("\n");

	return 1;
}



int StatusMsg(char *str)
{
	gtk_entry_set_text(GTK_ENTRY(statusbar), str);
	UpDate_widget(statusbar);
	return 1;
}

int StatusMsg_MouseX(char *str)
{
	set_label_text(MouseX, str);
	return 1;
}

int StatusMsg_MouseY(char *str)
{
	set_label_text(MouseY, str);
	return 1;
}



