/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : spline.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/06
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __SPLINE_H__
#define __SPLINE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */
struct _SPLINE {
	//int code;
	double x;
	double y;
	double p;
	double a;
	double b;
};
typedef struct _SPLINE SPLINE;





/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _SPLINE_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _SPLINE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
void open_maketable(int n, double x[], double y[], double z[], double h[], double d[]);
double open_spline(int n, double t, double x[], double y[], double z[]);
void open_maketable2(int n, double p[], double x[], double y[], double a[], double b[], double h[], double d[]);
void open_spline2(int n, double t, double *px, double *py, double p[], double x[], double	y[], double a[], double b[]);
int open_spline_main(int n, VERTEX *vertex, long color, int split);
void close_maketable(int n, double x[], double y[], double z[], double h[], double d[], double w[]);
double close_spline(int n, double t, double x[], double y[], double z[]);
void close_maketable2(int n, double p[], double x[], double y[], double a[], double b[], double h[], double d[], double w[]);
void close_spline2(int n, double t, double *px, double *py, double p[], double x[], double	y[], double a[], double b[]);
int close_spline_main(int n, VERTEX *vertex, long color, int split);

void close_spline_test(void);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SPLINE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : spline.h
 * ====================================================================
 */
