/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CamSetDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/17
 *    Last                 : 2003/04/17
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "Command.h"
#include "etc.h"

#define _CAMSETDLG_
#include "CamSetDlg.h"




/* -------------------------------------------------------------------
 * NCJ_read
 */
int NCJ_read(CAM_SET_DLG *cam_set_dlg)
{
	FILE *stream;
	gchar FileName[256], str[256];
	gint start_len = 0, end_len = 0, frag = 0;


	GetConfigPath(str);
	sprintf(FileName, "%s/NoName.NCJ", str);
	if (read_file_name_get(FileName) == 0) {
		return 0;
	}
	if (FileName == NULL) {
		return 0;
	}
	//g_print("FileName = %s\n", FileName);


	if( (stream	 = fopen( FileName , "r" )) == NULL ){
		printf( _("The file could not be opened. [%s]\n") , FileName);
		return 0;
	}


	while (1) {
		if (LineRead(stream, str) == 0) return 0;

		/*NC START */
		if ( strstr(str, "NC START {") != NULL ) {
			frag = 0;
			start_len = 0;
			while (1) {
				if (LineRead(stream, str) == 0) return 0;
				if (strstr(str, "}") != NULL ) {
					break;
				}
				else if (strstr(str, "END") != NULL ) {
					fclose(stream);
					return 0;
				}
				else {
					if (frag == 0) {
						frag = 1;
					}
					else {
						start_len = start_len + 1;
					}
					start_len = start_len + strlen(str);
				}
			}
		}

		/* NC END */
		if ( strstr(str, "NC END {") != NULL ) {
			frag = 0;
			end_len = 0;
			while(1) {
				if (LineRead(stream, str) == 0) return 0;
				if (strstr(str, "}") != NULL ) {
					break;
				}
				else if (strstr(str, "END") != NULL ) {
					fclose(stream);
					return 0;
				}
				else {
					if (frag == 0) {
						frag = 1;
					}
					else {
						end_len = end_len + 1;
					}
					end_len = end_len + strlen(str);
				}
			}
		}

		/* END */
		if (strstr(str, "END") != NULL ) {
			break;
		}
	}
	fclose(stream);


//g_print ("NCJ_read() : %d  %d\n", start_len, end_len);


	if (start_len > 0) {
		cam_set_dlg->start_str = (gchar *)xmalloc((start_len + 1) * sizeof(gchar));
	}
	else cam_set_dlg->start_str = NULL;

	if (end_len > 0) {
		cam_set_dlg->end_str = (gchar *)xmalloc((end_len + 1) * sizeof(gchar));
	}
	else cam_set_dlg->end_str = NULL;





	/*  */
	if( (stream	 = fopen( FileName , "r" )) == NULL ){
		printf( _("The file could not be opened. [%s]\n") , FileName);
		return 0;
	}


	/* ABS INC */
	if (LineRead(stream, str) == 0) return 0;
	cam_set_dlg->AbsInc = atoi(str);

	if (cam_set_dlg->AbsInc == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->abs_check), TRUE);
	}
	else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->inc_check), TRUE);
	}


	/* R IJ */
	if (LineRead(stream, str) == 0) return 0;
	cam_set_dlg->RIJ = atoi(str);

	if (cam_set_dlg->RIJ == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->r_check), TRUE);
	}
	else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->ij_check), TRUE);
	}


	/* Heel */
	if (LineRead(stream, str) == 0) return 0;
	cam_set_dlg->Heel = atoi(str);


	/* Modal */
	if (LineRead(stream, str) == 0) return 0;
	cam_set_dlg->Modal = atoi(str);

	if (cam_set_dlg->Modal == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_on_check), TRUE);
	}
	else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_off_check), TRUE);
	}



	while (1) {
		if (LineRead(stream, str) == 0) return 0;

		/*NC START */
		if ( strstr(str, "NC START {") != NULL ) {
			if (cam_set_dlg->start_str != NULL) {
//g_print("START\n");
				frag = 0;
				strcpy(cam_set_dlg->start_str, "");
				while (1) {
					if (LineRead(stream, str) == 0) return 0;
					if (strstr(str, "}") != NULL ) {
						break;
					}
					else if (strstr(str, "END") != NULL ) {
						fclose(stream);
						return 0;
					}
					else {
						if (frag == 0) {
							frag = 1;
						}
						else {
							strcat(cam_set_dlg->start_str, "\n");
						}
						strcat(cam_set_dlg->start_str, str);
//g_print("%s\n", str);
					}
				}
			}


			if (cam_set_dlg->start_str != NULL) {
//g_print("Before gtk_text_insert()\n");
				gtk_text_insert(GTK_TEXT(cam_set_dlg->start_text), 
								NULL, // GdkFont    *font,
								NULL, // GdkColor   *fore,
								NULL, // GdkColor   *back,
								cam_set_dlg->start_str, // const char *chars,
								-1);  // gint        length );
//g_print("After gtk_text_insert()\n");
				xfree(cam_set_dlg->start_str);
				cam_set_dlg->start_str = NULL;
			}
		}

		/* NC END */
		if ( strstr(str, "NC END {") != NULL ) {
			if (cam_set_dlg->end_str != NULL) {
//g_print("END\n");
				frag = 0;
				strcpy(cam_set_dlg->end_str, "");
				while(1) {
					if (LineRead(stream, str) == 0) return 0;
					if (strstr(str, "}") != NULL ) {
						break;
					}
					else if (strstr(str, "END") != NULL ) {
						fclose(stream);
						return 0;
					}
					else {
						if (frag == 0) {
							frag = 1;
						}
						else {
							strcat(cam_set_dlg->end_str, "\n");
						}
						strcat(cam_set_dlg->end_str, str);
//g_print("%s\n", str);
					}
				}
			}


			if (cam_set_dlg->end_str != NULL) {
//g_print("Before gtk_text_insert()\n");
				gtk_text_insert(GTK_TEXT(cam_set_dlg->end_text), 
								NULL, // GdkFont    *font,
								NULL, // GdkColor   *fore,
								NULL, // GdkColor   *back,
								cam_set_dlg->end_str, // const char *chars,
								-1);  // gint        length );
//g_print("After gtk_text_insert()\n");
				xfree(cam_set_dlg->end_str);
				cam_set_dlg->end_str = NULL;
			}
		}


		/* END */
		if (strstr(str, "END") != NULL ) {
			break;
		}
	}

	fclose(stream);
	return 1;
}



/* -------------------------------------------------------------------
 * cam_set_dlg_condition_read_pushed
 */
void cam_set_dlg_condition_read_pushed(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	guint length;


	/* ʸ */
	length = gtk_text_get_length(GTK_TEXT(cam_set_dlg->start_text));
	/* ֤ */
	gtk_text_set_point(GTK_TEXT(cam_set_dlg->start_text), 0);
	/* θ length ʸ */
	gtk_text_forward_delete(GTK_TEXT(cam_set_dlg->start_text), length);

	/* ʸ */
	length = gtk_text_get_length(GTK_TEXT(cam_set_dlg->end_text));
	/* ֤ */
	gtk_text_set_point(GTK_TEXT(cam_set_dlg->end_text), 0);
	/* θ length ʸ */
	gtk_text_forward_delete(GTK_TEXT(cam_set_dlg->end_text), length);

	NCJ_read(cam_set_dlg);
}





/* -------------------------------------------------------------------
 * NCJ_save
 */
int NCJ_save(CAM_SET_DLG *cam_set_dlg)
{
	FILE *stream;
	char FileName[256], str[256];


	GetConfigPath(str);
	sprintf(FileName, "%s/NoName.NCJ", str);
	if (save_file_name_get(FileName) == 0) {
		return 0;
	}
	if (FileName == NULL) {
		return 0;
	}
	//g_print("FileName = %s\n", FileName);


	if( (stream	 = fopen( FileName , "w" )) == NULL ){
		printf( _("The file could not be opened. [%s]\n") ,FileName);
		return TRUE;
	}

	sprintf(str, "%d\n", cam_set_dlg->AbsInc);
	fputs(str, stream );
	sprintf(str, "%d\n", cam_set_dlg->RIJ);
	fputs(str, stream );
	sprintf(str, "%d\n", cam_set_dlg->Heel);
	fputs(str, stream );
	sprintf(str, "%d\n", cam_set_dlg->Modal);
	fputs(str, stream );

	sprintf(str, "NC START {\n");
	fputs(str, stream );
	if (cam_set_dlg->start_str != NULL) {
		fputs(cam_set_dlg->start_str, stream);
		g_free(cam_set_dlg->start_str);
		cam_set_dlg->start_str = NULL;
	}
	fputs("\n", stream );
	fputs("}\n", stream );

	sprintf(str, "NC END {\n");
	fputs(str, stream );
	if (cam_set_dlg->end_str != NULL) {
		fputs(cam_set_dlg->end_str, stream);
		g_free(cam_set_dlg->end_str);
		cam_set_dlg->end_str = NULL;
	}
	fputs("\n", stream );
	fputs("}\n", stream );

	sprintf(str, "END\n");
	fputs(str, stream );

	fclose(stream);
	g_print("Save As %s\n", FileName);
	return 1;
}



/* -------------------------------------------------------------------
 * condition_write_buttun
 */
void cam_set_dlg_condition_write_pushed(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	guint length;


	/* ƥȥȥ꡼ʸ */
	/* Start Code */
	cam_set_dlg->start_str = NULL;
	length = gtk_text_get_length(GTK_TEXT(cam_set_dlg->start_text));
	if (length > 0) {
		cam_set_dlg->start_str = gtk_editable_get_chars(GTK_EDITABLE(cam_set_dlg->start_text), 0, length);
	}

	/* End Code */
	cam_set_dlg->end_str = NULL;
	length = gtk_text_get_length(GTK_TEXT(cam_set_dlg->end_text));
	if (length > 0) {
		cam_set_dlg->end_str = gtk_editable_get_chars(GTK_EDITABLE(cam_set_dlg->end_text), 0, length);
	}

	/* ABS INC */
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->inc_check)->active) {
		cam_set_dlg->AbsInc = 1;
	}
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->abs_check)->active) {
		cam_set_dlg->AbsInc = 0;
	}

	/* R IJ */
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->ij_check)->active) {
		cam_set_dlg->RIJ = 1;
	}
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->r_check)->active) {
		cam_set_dlg->RIJ = 0;
	}

	/* Modal */
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->modal_on_check)->active) {
		cam_set_dlg->Modal = 0;
	}
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->modal_off_check)->active) {
		cam_set_dlg->Modal = 1;
	}

	cam_set_dlg->Heel = 0;
	NCJ_save(cam_set_dlg);
}



/* -------------------------------------------------------------------
 * ABS(G90) INC(G91) ܥ ٥
 */
void abs_inc_button_toggled(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	if (cam_set_dlg->toggle_frag == 0) {
		cam_set_dlg->toggle_frag = 1;
	}
	else { return; }

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

	/* abs_check */
	if (cam_set_dlg->abs_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->abs_check), FALSE);
	}
	/* inc_check */
	if (cam_set_dlg->inc_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->inc_check), FALSE);
	}

	cam_set_dlg->toggle_frag = 0;
}



/* -------------------------------------------------------------------
 * [R]  [IJ]  ܥ ٥
 */
void rij_button_toggled(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	if (cam_set_dlg->toggle_frag == 0) {
		cam_set_dlg->toggle_frag = 1;
	}
	else { return; }

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

	/* r_check */
	if (cam_set_dlg->r_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->r_check), FALSE);
	}
	/* ij_check */
	if (cam_set_dlg->ij_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->ij_check), FALSE);
	}

	cam_set_dlg->toggle_frag = 0;
}



/* -------------------------------------------------------------------
 * Modal [ON] [OFF]  ܥ ٥
 */
void modal_button_toggled(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	if (cam_set_dlg->toggle_frag == 0) {
		cam_set_dlg->toggle_frag = 1;
	}
	else { return; }

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

	/* modal_off_check */
	if (cam_set_dlg->modal_off_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_off_check), FALSE);
	}
	/* modal_on_check */
	if (cam_set_dlg->modal_on_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_on_check), FALSE);
	}

	cam_set_dlg->toggle_frag = 0;
}



/* -------------------------------------------------------------------
 * CANCEL
 */
void cam_set_dlg_cancel_pushed(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	cam_set_dlg->value = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void cam_set_dlg_ok_pushed(GtkWidget *widget, CAM_SET_DLG *cam_set_dlg)
{
	guint length;


//g_print("Start Code\n");
	/* ƥȥȥ꡼ʸ */
	/* Start Code */
	cam_set_dlg->start_str = NULL;
	length = gtk_text_get_length(GTK_TEXT(cam_set_dlg->start_text));
	if (length > 0) {
		cam_set_dlg->start_str = gtk_editable_get_chars(GTK_EDITABLE(cam_set_dlg->start_text), 0, length);
	}

//g_print("End Code\n");
	/* End Code */
	cam_set_dlg->end_str = NULL;
	length = gtk_text_get_length(GTK_TEXT(cam_set_dlg->end_text));
	if (length > 0) {
		cam_set_dlg->end_str = gtk_editable_get_chars(GTK_EDITABLE(cam_set_dlg->end_text), 0, length);
	}

//g_print("ABS INC\n");
	/* ABS INC */
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->inc_check)->active) {
		cam_set_dlg->AbsInc = 1;
	}
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->abs_check)->active) {
		cam_set_dlg->AbsInc = 0;
	}

	/* R IJ */
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->ij_check)->active) {
		cam_set_dlg->RIJ = 1;
	}
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->r_check)->active) {
		cam_set_dlg->RIJ = 0;
	}

	/* Modal */
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->modal_on_check)->active) {
		cam_set_dlg->Modal = 0;
	}
	if (GTK_TOGGLE_BUTTON(cam_set_dlg->modal_off_check)->active) {
		cam_set_dlg->Modal = 1;
	}

	cam_set_dlg->Heel = 0;


	cam_set_dlg->value = 1;
}



/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint cam_set_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, CAM_SET_DLG *cam_set_dlg)
{
//	g_print("sagcad.c : cam_set_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


//	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
//		cam_set_dlg_ok_pushed(widget, cam_set_dlg);
//		gtk_main_quit();
//	}
	return TRUE; 
}



/* -------------------------------------------------------------------
 * CAM 
 * 
 */
gint CamSetDialog(CAM_SET_DLG *cam_set_dlg)
{
//	char str[256];

//	GtkWidget *dialog;
			GtkWidget *separator;
				GtkWidget *label;


		GtkWidget *main_vbox;
			GtkWidget *abs_inc_vbox;
//				GtkWidget *label;
//				GtkWidget *abs_check;
//				GtkWidget *inc_check;
//			GtkWidget *separator;

			GtkWidget *arc_vbox;
//				GtkWidget *label;
//				GtkWidget *r_check;
//				GtkWidget *ij_check;
//			GtkWidget *separator;

			GtkWidget *modal_vbox;
//				GtkWidget *label;
//				GtkWidget *modal_off_check;
//				GtkWidget *modal_on_check;
//			GtkWidget *separator;

			GtkWidget *start_vbox;
//				GtkWidget *label;
//				GtkWidget *start_text;
			GtkWidget *end_vbox;
//				GtkWidget *label;
//				GtkWidget *end_text;


//			GtkWidget *separator;
			GtkWidget *action_hbox1;
				GtkWidget *condition_read_buttun;
				GtkWidget *condition_write_buttun;
			GtkWidget *action_hbox2;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;

	cam_set_dlg->toggle_frag = 0;



	/* (cam_set_dlg->dialog) */
	cam_set_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(cam_set_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(cam_set_dlg->dialog), _("CAM Setting") );
	gtk_signal_connect( GTK_OBJECT(cam_set_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(cam_set_dlg_key_press_event), cam_set_dlg);



		/* ѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(cam_set_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(cam_set_dlg->dialog), 5);
		gtk_widget_show(main_vbox);





			/* label */
			label = gtk_button_new_with_label( _("ABS or INC") );
//			gtk_widget_set_usize (label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(main_vbox), label, TRUE, TRUE, 0);
			gtk_widget_show(label);

			/* ѥå󥰥ܥå(abs_inc_vbox)  */
			abs_inc_vbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), abs_inc_vbox, TRUE, TRUE, 0);
			gtk_widget_show(abs_inc_vbox);

				/* -----------------------------------------
				 * ABS INC 
				 */
				/* ABS */
				cam_set_dlg->abs_check = gtk_check_button_new_with_label(" ABS(G90)");
				gtk_box_pack_start( (GtkBox *)GTK_BOX(abs_inc_vbox), cam_set_dlg->abs_check, TRUE, TRUE, 0);
				if (cam_set_dlg->AbsInc == 0) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->abs_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->abs_check), FALSE);
				}
				gtk_signal_connect (GTK_OBJECT(cam_set_dlg->abs_check), 
									"toggled", 
									GTK_SIGNAL_FUNC(abs_inc_button_toggled), 
									cam_set_dlg);
				gtk_widget_show(cam_set_dlg->abs_check);

				/* INC */
				cam_set_dlg->inc_check = gtk_check_button_new_with_label(" INC(G91)");
				gtk_box_pack_start( (GtkBox *)GTK_BOX(abs_inc_vbox), cam_set_dlg->inc_check, TRUE, TRUE, 0);
				if (cam_set_dlg->AbsInc == 1) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->inc_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->inc_check), FALSE);
				}
				gtk_signal_connect (GTK_OBJECT(cam_set_dlg->inc_check), 
									"toggled", 
									GTK_SIGNAL_FUNC(abs_inc_button_toggled), 
									cam_set_dlg);
				gtk_widget_show(cam_set_dlg->inc_check);

			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);





			/* label */
			label = gtk_button_new_with_label( _("R or IJ") );
//			gtk_widget_set_usize (label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(main_vbox), label, TRUE, TRUE, 0);
			gtk_widget_show(label);

			/* ѥå󥰥ܥå(arc_vbox)  */
			arc_vbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), arc_vbox, TRUE, TRUE, 0);
			gtk_widget_show(arc_vbox);

				/* -----------------------------------------
				 * R IJ
				 */
				/* R */
				cam_set_dlg->r_check = gtk_check_button_new_with_label( _("R") );
				gtk_box_pack_start( (GtkBox *)GTK_BOX(arc_vbox), cam_set_dlg->r_check, TRUE, TRUE, 0);
				if (cam_set_dlg->RIJ == 0) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->r_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->r_check), FALSE);
				}
				gtk_signal_connect (GTK_OBJECT(cam_set_dlg->r_check), 
									"toggled", 
									GTK_SIGNAL_FUNC(rij_button_toggled), 
									cam_set_dlg);
				gtk_widget_show(cam_set_dlg->r_check);

				/* IJ */
				cam_set_dlg->ij_check = gtk_check_button_new_with_label( _("IJ") );
				gtk_box_pack_start( (GtkBox *)GTK_BOX(arc_vbox), cam_set_dlg->ij_check, TRUE, TRUE, 0);
				if (cam_set_dlg->RIJ == 1) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->ij_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->ij_check), FALSE);
				}
				gtk_signal_connect (GTK_OBJECT(cam_set_dlg->ij_check), 
									"toggled", 
									GTK_SIGNAL_FUNC(rij_button_toggled), 
									cam_set_dlg);
				gtk_widget_show(cam_set_dlg->ij_check);

			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);





			label = gtk_button_new_with_label(" Modal");
			//gtk_widget_set_usize (label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(main_vbox), label, TRUE, TRUE, 0);
			gtk_widget_show(label);

			/* ѥå󥰥ܥå(modal_vbox)  */
			modal_vbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), modal_vbox, TRUE, TRUE, 0);
			gtk_widget_show(modal_vbox);

				/* -----------------------------------------
				 * Modal
				 */
				/* ON */
				cam_set_dlg->modal_on_check = gtk_check_button_new_with_label(" ON");
				gtk_box_pack_start( (GtkBox *)GTK_BOX(modal_vbox), cam_set_dlg->modal_on_check, TRUE, TRUE, 0);
				if (cam_set_dlg->Modal == 0) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_on_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_on_check), FALSE);
				}
				gtk_signal_connect (GTK_OBJECT(cam_set_dlg->modal_on_check), 
									"toggled", 
									GTK_SIGNAL_FUNC(modal_button_toggled), 
									cam_set_dlg);
				gtk_widget_show(cam_set_dlg->modal_on_check);

				/* OFF */
				cam_set_dlg->modal_off_check = gtk_check_button_new_with_label(" OFF");
				gtk_box_pack_start( (GtkBox *)GTK_BOX(modal_vbox), cam_set_dlg->modal_off_check, TRUE, TRUE, 0);
				if (cam_set_dlg->Modal == 1) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_off_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cam_set_dlg->modal_off_check), FALSE);
				}
				gtk_signal_connect (GTK_OBJECT(cam_set_dlg->modal_off_check), 
									"toggled", 
									GTK_SIGNAL_FUNC(modal_button_toggled), 
									cam_set_dlg);
				gtk_widget_show(cam_set_dlg->modal_off_check);

			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);





			/* ѥå󥰥ܥå(start_vbox)  */
			start_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), start_vbox, TRUE, TRUE, 0);
			gtk_widget_show(start_vbox);

				label = gtk_button_new_with_label(" Start Code");
//				gtk_widget_set_usize (label, 100, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(start_vbox), label, TRUE, TRUE, 0);
				gtk_widget_show(label);

				/* ƥȥȥ꡼ */
				cam_set_dlg->start_text = gtk_text_new(NULL, NULL);
				gtk_text_set_editable(GTK_TEXT(cam_set_dlg->start_text), TRUE);
//				gtk_widget_set_usize (cam_set_dlg->up_scale_entry, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(start_vbox), cam_set_dlg->start_text, TRUE, TRUE, 1);
				/*  */
				if (cam_set_dlg->start_str != NULL) {
					gtk_text_insert(GTK_TEXT(cam_set_dlg->start_text), 
									NULL, // GdkFont    *font,
									NULL, // GdkColor   *fore,
									NULL, // GdkColor   *back,
									cam_set_dlg->start_str, // const char *chars,
									-1);  // gint        length );
//					cam_set_dlg->start_str = NULL;
				}
				gtk_widget_show(cam_set_dlg->start_text);




			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);





			/* ѥå󥰥ܥå(end_vbox)  */
			end_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), end_vbox, TRUE, TRUE, 0);
			gtk_widget_show(end_vbox);

				label = gtk_button_new_with_label(" End Code");
//				gtk_widget_set_usize (label, 100, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(end_vbox), label, TRUE, TRUE, 0);
				gtk_widget_show(label);

				/* ƥȥȥ꡼ */
				cam_set_dlg->end_text = gtk_text_new(NULL, NULL);
				gtk_text_set_editable(GTK_TEXT(cam_set_dlg->end_text), TRUE);
//				gtk_widget_set_usize (cam_set_dlg->up_scale_entry, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(end_vbox), cam_set_dlg->end_text, TRUE, TRUE, 1);
				/*  */
				if (cam_set_dlg->end_str != NULL) {
					gtk_text_insert(GTK_TEXT(cam_set_dlg->end_text), 
									NULL, // GdkFont    *font,
									NULL, // GdkColor   *fore,
									NULL, // GdkColor   *back,
									cam_set_dlg->end_str, // const char *chars,
									-1);  // gint        length );
//					cam_set_dlg->end_str = NULL;
				}
				gtk_widget_show(cam_set_dlg->end_text);

			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);





			/* ѥå󥰥ܥå(action_hbox1) */
			action_hbox1 = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox1, TRUE, TRUE, 0);
			gtk_widget_show(action_hbox1);


				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(action_hbox) 
				 * ܥ(cancel_buttun & ok_buttun) 
				 * Ǽ
				 */
				/* condition_read ܥ */
				condition_read_buttun = gtk_button_new_with_label("Read");
				gtk_widget_set_usize (condition_read_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox1), condition_read_buttun, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(condition_read_buttun), 
									"clicked", 
									GTK_SIGNAL_FUNC(cam_set_dlg_condition_read_pushed), 
									cam_set_dlg);
				gtk_widget_show(condition_read_buttun);

				/* condition_write ܥ */
				condition_write_buttun = gtk_button_new_with_label("Write");
				gtk_widget_set_usize (condition_write_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox1), condition_write_buttun, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(condition_write_buttun), 
									"clicked", 
									GTK_SIGNAL_FUNC(cam_set_dlg_condition_write_pushed), 
									cam_set_dlg);
				gtk_widget_show(condition_write_buttun);





			/* ѥå󥰥ܥå(action_hbox2) */
			action_hbox2 = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox2, TRUE, TRUE, 0);
			gtk_widget_show(action_hbox2);

				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(action_hbox) 
				 * ܥ(cancel_buttun & ok_buttun) 
				 * Ǽ
				 */
				/* CANCELܥ */
				cancel_buttun = gtk_button_new_with_label("CANCEL");
				gtk_widget_set_usize (cancel_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox2), cancel_buttun, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(cam_set_dlg_cancel_pushed), cam_set_dlg);
				gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
				gtk_widget_show(cancel_buttun);

				/* OKܥ */
				ok_buttun = gtk_button_new_with_label("OK");
				gtk_widget_set_usize (ok_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox2), ok_buttun, TRUE, TRUE, 2);
				gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(cam_set_dlg_ok_pushed), cam_set_dlg);
				gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
			//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
			//	  gtk_widget_grab_default(ok_buttun);
				gtk_widget_show(ok_buttun);





	/*  ե x_pitch_entry  */
//	gtk_window_set_focus(GTK_WINDOW(cam_set_dlg->dialog), cam_set_dlg->x_pitch_entry);


	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(cam_set_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(cam_set_dlg->dialog), GTK_WINDOW(cam_set_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(cam_set_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(cam_set_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CamSetDlg.c
 * ====================================================================
 */









#ifdef TEST
#endif





