/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Ellipse.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/22
 *    Last                 : 2003/04/22
 * ====================================================================
 */
#ifndef __ELLIPSE_H__
#define __ELLIPSE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

/* Ellipse.c ñΤǥƥ */
#ifdef MAIN_TEST
struct _POINT {
	double x;
	double y;
};
typedef struct _POINT POINT;



struct _ELLIPSE {
	int layer;
	long color;
	int style;

	double cx;		/* 濴 */
	double cy;		/* 濴 */
	double dx;		/* Ĺΰ֣(濴а) */
	double dy;		/* Ĺΰ֣(濴а) */
	double k;		/* ûΡ */
	double sa;		/* ϳ */
	double ea;		/* λ */
};
typedef struct _ELLIPSE ELLIPSE;
#endif






/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _ELLIPSE_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ELLIPSE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
/* a */
double get_ellipse_a(ELLIPSE ellipse);
/* b */
double get_ellipse_b(ELLIPSE ellipse);
/*  */
double get_ellipse_angle(ELLIPSE ellipse);
/*   */
int get_ellipse_se_point(ELLIPSE ellipse, POINT *s_point, POINT *e_point);
/*  */
int get_ellipse_focus(ELLIPSE ellipse, POINT *focus1, POINT *focus2);

/*  (px, py) ϡʱ߾Ǥ뤫Ƚ */
int point_on_ellipse (ELLIPSE *ellipse, double px, double py);
/* ʱߤˤ뤫ˤ뤫Ƚ */
int point_in_ellipse (ELLIPSE *ellipse, double px, double py, double value);

/* ʱߤȳ٤ʱ߾ */
int get_ellipse_point_from_angle (ELLIPSE ellipse, double angle, POINT *point);
/* ʱߤʱ߾γ٤ */
double get_ellipse_angle_from_point (ELLIPSE ellipse, POINT point);


/* ʱߤ */
int pel(struct RtnDat *a, ELLIPSE ellipse);
/* ʱߤθ */
int lep(struct RtnDat *rtn, ELLIPSE ellipse, int degits);

/* ʱ߾(angle)Ǥ */
int ellipse_tangent(struct RtnDat *rtn, ELLIPSE ellipse, double angle);

/* cc_check : ߤΰִطĴ٤ */
int cc_check(struct RtnDat *rtn);

/* ʱߤʱߤθ */
int ellipse_on_ellipse(struct RtnDat *rtn, ELLIPSE ellipseA, ELLIPSE ellipseB);
/* ʱߣʱߣ¤θȤʤ롢ʱߣγ٤ϰ */
int ellipse_on_ellipse_point(ELLIPSE ellipseA, ELLIPSE ellipseB, double *sa, double *ea, double angle_degits, double last_degits );


/* ʱߤʱ() */
int ellipse_to_ellipse(struct RtnDat *rtn, ELLIPSE ellipseA, ELLIPSE ellipseB);
int ellipse_to_ellipse_search (ELLIPSE ellipseA, ELLIPSE ellipseB, double *sp, double *ep, POINT *point, double angle_degits, double last_degits);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ELLIPSE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Ellipse.h
 * ====================================================================
 */
