/*----------------------------------------------------------------------------
   ImeControler.cpp

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#include "ImeControler.h"

const std::string UniqueString( "agddoclhbmclhbmclhbmclhbmsxyrd" );

enum TImeCommand {
    None,
    ImeOn,
    ImeOff,
    AlphaNumeric,
    Native,
    Dakuon
};

struct TDllRecord {
    bool isHooking;
    HWND hosthandle;            //  bZ[Wʒmnh
    HHOOK hookhandle;           //  imetbNnh
    unsigned int message;       //  imeݒʒmpbZ[W
    unsigned int inputmessage;  //  ime͒ʒmpbZ[W
} *PDllRecord = NULL;
HINSTANCE DllInstance;
HANDLE FileMapObject = NULL;

//----------------------------------------------------------------------------
// ݒ^ʒm֘A
unsigned int GetUniqueMessage( void ) 
{
   if (PDllRecord !=NULL) {
      return PDllRecord->message;
   } else {
      return 0;
   }
}

unsigned int GetInputUniqueMessage( void ) 
{
   if (PDllRecord !=NULL) {
      return PDllRecord->inputmessage;
   } else {
      return 0;
   }
}

//----------------------------------------------------------------------------
// IME֘A
bool __stdcall Saikoro::ImeControler::SetCurrentWindowImeOn()
{
   SendMessage(
         GetForegroundWindow(), GetUniqueMessage(), ImeOn, 0L );
   return true;
}

bool __stdcall Saikoro::ImeControler::SetCurrentWindowImeOff()
{
   SendMessage(
         GetForegroundWindow(), GetUniqueMessage(), ImeOff, 0L );
   return true;
}

bool __stdcall
      Saikoro::ImeControler::SetCurrentWindowImeAlphaNum()
{
   SendMessage( GetForegroundWindow(), GetUniqueMessage(), AlphaNumeric, 0L );
   return true;
}

bool __stdcall Saikoro::ImeControler::SetCurrentWindowImeNative()
{
   SendMessage( GetForegroundWindow(), GetUniqueMessage(), Native, 0L );
   return true;
}

bool __stdcall Saikoro::ImeControler::InputIme(
      std::string InputString )
{
   WPARAM w( 0L );
   LPARAM l( 0L );
   for ( std::string::iterator i = InputString.begin();
         i != InputString.end(); ++i ) {
      if ((*i & 0x80) && (w == 0L)) {
         w = *i & 0xFF;
      } else {
         l =  *i & 0xFF;
         SendMessage( GetForegroundWindow(), GetInputUniqueMessage(), w, l );
         w = 0L;
      }
   }
   return true;
}

//----------------------------------------------------------------------------
void InputChar( HIMC himcon, std::string str ) 
{
   char c[3];
   c[0] = str[0];
   c[1] = str[1];
   c[2] = '\0';

   //ImmSetConversionStatus( himcon, d, IME_SMODE_NONE );
   DWORD len = static_cast<DWORD> ( strlen( c ));
   ImmSetCompositionString( himcon, SCS_SETSTR, c, len, c, len ); 

/*    if( !b ) {
        ImmNotifyIME( himcon, NI_SELECTCANDIDATESTR, CPS_CONVERT, 0 );
        ImmNotifyIME( himcon, NI_COMPOSITIONSTR, CPS_COMPLETE, 0 );
        ImmSetOpenStatus( himcon, false );
    }
*/
}

//----------------------------------------------------------------------------
bool WINAPI DllMain( HINSTANCE hinstDLL, DWORD fwdreason, LPVOID /*lpReserved*/ ) 
{
   switch (fwdreason) {
      case DLL_PROCESS_ATTACH : {
         DllInstance = hinstDLL;
         FileMapObject = CreateFileMapping(
               INVALID_HANDLE_VALUE, (LPSECURITY_ATTRIBUTES)NULL,
               PAGE_READWRITE, 0, sizeof(TDllRecord), UniqueString.c_str());
         if (FileMapObject != NULL) {
            PDllRecord = (TDllRecord*)MapViewOfFile(
                  FileMapObject, FILE_MAP_ALL_ACCESS, 0, 0, 0 );
         } 
      } break;
      case DLL_PROCESS_DETACH : {
         UnmapViewOfFile( PDllRecord );
         if (FileMapObject != NULL) {
            CloseHandle( FileMapObject );
         }
      } break;
   }
   return  true;
};

//----------------------------------------------------------------------------
LRESULT CALLBACK getImeMessageProc( int code, WPARAM wparam, LPARAM lparam ) 
{
   if ((code < 0)&&(code == HC_ACTION))
      return ::CallNextHookEx( PDllRecord->hookhandle, code, wparam, lparam );
   if (lparam == NULL)
      return ::CallNextHookEx( PDllRecord->hookhandle, code, wparam, lparam );
   
   PCWPRETSTRUCT p = reinterpret_cast<PCWPRETSTRUCT>(lparam);
   bool is_target_message = (p->message == PDllRecord->message);
   bool is_input_message = (p->message == PDllRecord->inputmessage);
   if (is_target_message||is_input_message) {
      HWND hw = ::GetForegroundWindow();
      HIMC himcon = ::ImmGetContext( hw );
      DWORD conv, sent;
      ImmGetConversionStatus( himcon, &conv, &sent );
      if (is_input_message) {
         std::string s;
         s.push_back( static_cast<char> ( p->wParam ));
         s.push_back( static_cast<char> ( p->lParam ));
         InputChar( himcon, s );
      } else if (p->wParam == ImeOn) {
         ImmSetOpenStatus( himcon, true );
      } else if (p->wParam == ImeOff) {
         ImmSetOpenStatus( himcon, false );
      } else if (p->wParam == AlphaNumeric) {
         ImmSetConversionStatus( himcon, IME_CMODE_FULLSHAPE, sent );
      } else if (p->wParam == Native) {
         ImmSetConversionStatus(
               himcon, IME_CMODE_NATIVE | IME_CMODE_FULLSHAPE, sent );
      }
      ImmReleaseContext( hw ,himcon );
   }
   return CallNextHookEx( PDllRecord->hookhandle, code, wparam, lparam );
}
//----------------------------------------------------------------------------
bool __stdcall Saikoro::ImeControler::InstallImeControler( HWND Host )
{
   if (PDllRecord->isHooking) return false;
   PDllRecord->message 
         = RegisterWindowMessage( (UniqueString+UniqueString).c_str() );
   PDllRecord->inputmessage = RegisterWindowMessage( UniqueString.c_str() );
   PDllRecord->hosthandle = Host;
   UninstallImeControler();
   PDllRecord->hookhandle = SetWindowsHookEx(
         WH_CALLWNDPROCRET /*WH_GETMESSAGE*/, (HOOKPROC)getImeMessageProc,
         DllInstance, 0 );
   if (!PDllRecord->hookhandle) return false;
   PDllRecord->isHooking = true;
   return true;
}

bool __stdcall Saikoro::ImeControler::UninstallImeControler( void )
{
   if (PDllRecord->hookhandle) {
      UnhookWindowsHookEx( PDllRecord->hookhandle );
   }
   PDllRecord->hookhandle = NULL;
   PDllRecord->isHooking = false;
   return true;
}
