/*----------------------------------------------------------------------------
   Word.cpp

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#if defined( __BORLANDC__ ) || defined( _MSC_VER )
#pragma hdrstop
#endif 

#ifdef NDEBUG
   #undef _STLP_DEBUG
#else
   #pragma warning( disable:4786 )
   #define _STLP_DEBUG 1
#endif 

#include <windows.h>
#include <winuser.h>
#include "Word.h"
#include "Key.h"
#include "BurglarFunc.h"

using namespace std;


//----------------------------------------------------------------------------
template < typename InputIterator, typename Token >
bool Saikoro::TShiftJisCharSeparator::operator()(
      InputIterator& next, InputIterator end, Token& tok)
{
   if (next == end) return false;
   tok = Token();
   if (*next & 0x80) {
      tok += *next;
      ++next;
      if (next == end) return false;
   }
   tok += *next;
   ++next;
   return true;
}

//----------------------------------------------------------------------------
Saikoro::TKanaChange::TKanaChange()
      :  hiragana("\
               ÂĂłƂǂȂɂʂ˂̂͂΂ςЂт҂ӂԂՂւׂ؂قڂۂ܂݂\
               ߂"),
         katakana("@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^\
               _`abcdefghijklmnopqrstuvwxyz{|}~\
               "),
         seion("͂ЂӂւقĂƂ"),
         dakuon("΂тԂׂڂÂłǃ"),
         han_dakuon("ς҂Ղ؂")
{
   TShiftJisTokenizer h(hiragana);
   TShiftJisTokenizer k(katakana);
   TShiftJisTokenizer::iterator i = h.begin();
   TShiftJisTokenizer::iterator j = k.begin();
   while ((i != h.end())&&(j != k.end())) {
      hiragana_katakana.insert( make_pair( *i, *j ) );
      ++i; ++j;
   }
   TShiftJisTokenizer s(seion);
   TShiftJisTokenizer d(dakuon);
   TShiftJisTokenizer hd(han_dakuon);
   i = s.begin();
   j = d.begin();
   while ((i != s.end())&&(j != d.end())) {
      seion_dakuon.insert( make_pair( *i, *j ) );
      ++i; ++j;
   }
   i = s.begin();
   j = hd.begin();
   while ((i != s.end())&&(j != hd.end())) {
      seion_han_dakuon.insert( make_pair( *i, *j ) );
      ++i; ++j;
   }
};

string Saikoro::TKanaChange::convert_token( std::string text, t_map map )
{
   TShiftJisTokenizer jt( text );
   string r;
   for ( TShiftJisTokenizer::iterator i = jt.begin(); i != jt.end(); ++i ) {
      t_map::iterator j = map.find( *i );
      if (j == map.end()) {
         r += *i;
      } else {
         r += j->second;
      }
   }
   return r;
};

//----------------------------------------------------------------------------
void Saikoro::SendWordToWindow( std::string s )
{
   DWORD thread = GetWindowThreadProcessId( GetForegroundWindow(), NULL );
   DWORD mythread = GetCurrentThreadId();
   AttachThreadInput( mythread, thread, TRUE );
   HWND activewindow = GetFocus();
   int tmp( 0 );
   for ( std::string::iterator i = s.begin(); i != s.end(); ++i) {
      if ( (*i & 0x80 ) && ( tmp == 0 ) ) {
         tmp = (unsigned char) *i << 8;
      } else {
         tmp = tmp + static_cast<unsigned char>(*i);
         SendMessage( activewindow, WM_IME_CHAR, tmp, 1);
         tmp = 0;
      }
   }
   AttachThreadInput( mythread, thread, FALSE );
};

//----------------------------------------------------------------------------
#if defined( __BORLANDC__ )
#pragma package( smart_init )
#endif //__BORLANDC__
