/*---------------------------------------------------------------------------
   Word.h

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#ifndef WordH
#define WordH


#ifdef NDEBUG
   #undef _STLP_DEBUG
#else
   #pragma warning( disable:4786 )
   #define _STLP_DEBUG 1
#endif 

#include <string>
#include <map>
#include <boost/tokenizer.hpp>
#include <boost/shared_ptr.hpp>

//----------------------------------------------------------------------------
namespace Saikoro {
   const char* const InnerCode = "Shif t_JIS";
   const char* const DocVersion = "1.1";
   const int SjisCodepage = 932;

   void SendWordToWindow( std::string s );
   void OutputString( const char * s );

   //-------------------------------------------------------------------------
   class TShiftJisCharSeparator {
   public:
      explicit TShiftJisCharSeparator() {}
      void reset() {}
      template < typename InputIterator, typename Token >
      bool operator()( InputIterator& Next, InputIterator End, Token& Tok );
   };
   typedef boost::tokenizer<TShiftJisCharSeparator> TShiftJisTokenizer;

   //-------------------------------------------------------------------------
   class TKanaChange {
   public:
      TKanaChange();
      std::string convertToKatakana( std::string Hiragana )
            { return convert_token( Hiragana, hiragana_katakana ); };
      std::string convertToDakuon( std::string Seion )
            { return convert_token( Seion, seion_dakuon ); };
      std::string convertToHanDakuon( std::string Seion )
            { return convert_token( Seion, seion_han_dakuon ); };
   private:
      typedef std::map<std::string, std::string> t_map;
      t_map hiragana_katakana;
      t_map seion_dakuon;
      t_map seion_han_dakuon;
      std::string hiragana;
      std::string katakana;
      std::string seion;
      std::string dakuon;
      std::string han_dakuon;
      std::string convert_token( std::string text, t_map map );
   };
   static boost::shared_ptr<TKanaChange> SrKanaChange( new TKanaChange );
};

#endif //WordH
