/*---------------------------------------------------------------------------
   SaikoroTable.h

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#ifndef SaikoroTableH
#define SaikoroTableH

#ifdef NDEBUG
   #undef _STLP_DEBUG
#else
   #pragma warning(disable:4786)
   #define _STLP_DEBUG 1
#endif

#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#if defined(__WXGTK__) || defined(__WXX11__) || defined(__WXMOTIF__) || defined(__WXMAC__)
   #include "../../../Common/SaikoroIcon.xpm"
#endif

#ifdef __BORLANDC__
#pragma warn -8066
#pragma warn -8058
#endif //__BORLANDC__

#ifdef _MSC_VER
#endif //_MSC_VER


//---------------------------------------------------------------------------

#include <string>
#include <vector>
#include <deque>
#include <map>
#include <iostream>
#include <fstream>
#include <sstream>
#include <algorithm>
#include <stdlib.h>

#include <Loki/Factory.h>
#include <boost/smart_ptr.hpp>
#include <boost/weak_ptr.hpp>
#include <boost/shared_ptr.hpp>

#include <xercesc/util/XMLUniDefs.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/sax2/Attributes.hpp>
#include <xercesc/sax2/DefaultHandler.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>
#include <xercesc/framework/XMLFormatter.hpp>
#include <xercesc/framework/XMLDocumentHandler.hpp>
#include <xercesc/framework/URLInputSource.hpp>

#include "./MSWin/Key.h"
#include "./MSWin/Word.h"
#include "./MSWin/Ime.h"

using namespace std;
XERCES_CPP_NAMESPACE_USE

//---------------------------------------------------------------------------

class THolderHandler;

namespace Saikoro{
   class TItem;
   class TAppropriateWord;
   class TAppropriateWordHolder;
   class TValueStatus;
   class TTable;
   class TBaseDictionary;
   class TLearningDictionary;
   class THolder;
   typedef deque<string> TStrings;
   typedef boost::shared_ptr<TAppropriateWord> TSrAppropriateWord;
   typedef boost::weak_ptr<TAppropriateWord> TWkAppropriateWord;
   typedef boost::shared_ptr<TAppropriateWordHolder> TSrAppropriateWordHolder;
   typedef boost::shared_ptr<TItem> TSrItem;
   typedef vector<TSrItem> TSrItems;
   typedef vector<TSrItems> TSrItemMatrix2;
   typedef boost::shared_ptr<TTable> TSrTable;
   typedef boost::weak_ptr<TTable> TWkTable;
   typedef boost::shared_ptr<TBaseDictionary> TSrDictionary;
   typedef vector<TSrDictionary> TSrDictionaries;
   typedef boost::shared_ptr<TLearningDictionary> TSrLearningDictionary;
   typedef boost::weak_ptr<TLearningDictionary> TWkLearningDictionary;
   typedef deque<TWkLearningDictionary> TWkLearningDictionaries;
   typedef boost::shared_ptr<THolder> TSrHolder;
   typedef boost::weak_ptr<THolder> TWkHolder;
   typedef boost::shared_ptr<TValueStatus> TSrValueStatus;
   typedef vector<TSrValueStatus> TSrValueStatuses;

   enum TKeyUpDown {
      Down,
      Up,
      DownAndUp
   };
   enum TThreeStates {
      Positive, 
      Neutral, 
      Negative
   };
   enum IndexType {
      AsIs = -1,
      Katakana = -2,
      Ignore = -3
   };
   enum ConvertStatus {
      Dakuon = -1,
      HanDakuon = -2,
      DeleteBack = -3,
      DeleteFront = -4
   };

   //---------------------------------------------------------------------------
   //---------------------------------------------------------------------------
   class TItem {
   public:
      virtual ~TItem() = 0;
      virtual void setHolder( TWkHolder Holder ) { holder = Holder; };
      virtual void setValue( const string Attribute, const string Value ) {};
      virtual void addChild( TSrItem Item ) {};
      virtual bool executeKeyEvent()
            { return true; };
      virtual string getWord() { return ""; };
   protected:
      TWkHolder holder;
      int get_key_code();
      TKeyUpDown get_key_action();
   };

   //---------------------------------------------------------------------------
   //---------------------------------------------------------------------------
   class TAppropriateWord : public TItem {
   public:
      TAppropriateWord() :  store_with_next( false ) {};
      virtual ~TAppropriateWord();
      static TItem* Create() { return (new TAppropriateWord); };     
      void setValue( const string Attribute, const string Value );
      void addChild( TSrItem Item );
      string getName() { return name; };
      string getWord( int KeyIndex, TKeyUpDown KeyAction ) { return name; };
      void addHeadwordToken( const string Token );
      void addHeadwordToken( const int Token );
      string getHeadword();
      string getWord( const int index );
      void addWordToLearningDictionary( string Headword, string Word );
      void addWordToLearningDictionary( const int Index );
      void clear();
      virtual void doStoreLearningDictionaryWithNext()
            { store_with_next = true; };
      virtual bool isHeadwordExists() { return (getHeadword() != ""); };
   private:
      THolder *holder;
      string name;
      typedef deque<pair<string, TStrings> > t_headword_table;
      t_headword_table headword_table;
      int current_index;
      string index_word, registed_word;
      TStrings postfix_token_list;
      string learning_headword, learning_word;
      TSrDictionaries dics;
      TWkLearningDictionaries learndics;
      bool store_with_next;
      void set_index( int Index );
      string postfix();
      void addWord( const string s );
      void delete_first_token();
      void delete_last_token();
      TStrings divid_to_token( const string Text );
      string connect_to_text( TStrings Text );
   };

   class TBaseDictionary : public TItem {
   public:
      virtual TStrings getWords(string headword) = 0;
   protected:
      string locale;
   };

   class TSkkDictionary : public TBaseDictionary {
   public:
      TStrings getWords(string headword);
      void setValue(const string Attribute, const string Value);
      static TItem* Create() { return (new TSkkDictionary); };
   private:
      typedef map<string, TStrings> Items;
      Items items;
   };

   class TLearningDictionary : public TBaseDictionary {
   public:
      TLearningDictionary() : maxcount( 65535 ) {};
      TStrings getWords(string headword);
      void setValue( const string Attribute, const string Value );
      void addWord(
            const string headword, const string word,
            const unsigned int count = 1 );
      void save();
      static TItem* Create() { return (new TLearningDictionary); };
   private:
      unsigned int maxcount;
      typedef pair<unsigned int, string> ItemPair;
      typedef multimap<unsigned int, string, greater<unsigned int> > ItemPairs;
      typedef map<string, ItemPairs> Items;
      Items items;
      string filename;
      bool addCount(
         const string headword, const string word, unsigned int count = 1);
   };

   //---------------------------------------------------------------------------
   //---------------------------------------------------------------------------
   class TSendKey : public TItem {
   public:
      TSendKey()
         :  code( AsIs ), keyupdown( DownAndUp ), shift( DownAndUp ),
            ctrl( DownAndUp ), alt( DownAndUp ), kana( DownAndUp ),
            fontcolor( AsIs )
         {};
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord() {return guideword;};
      static TItem* Create() { return (new TSendKey); };
   private:
      int code;
      TKeyUpDown keyupdown;
      TKeyUpDown shift;
      TKeyUpDown ctrl;
      TKeyUpDown alt;
      TKeyUpDown kana;
      string guideword;
      int fontcolor;
      bool setupKeyStatus(TKeyUpDown st, bool cs, int vk);
   };

   class TUseTable : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord();
      static TItem* Create() { return (new TUseTable); };
   private:
      string name;
   };

   class TChangeTable : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      static TItem* Create() { return (new TChangeTable); };
   private:
      string name;
   };

	class TSetGlobalImeStatus : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      static TItem* Create() { return (new TSetGlobalImeStatus); };
   private:
		enum Status {ImeOn, ImeOff, AlphaNumeric, Native};
      Status status;
	};

	class TInputGlobalIme : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      static TItem* Create() { return (new TInputGlobalIme); };
   private:
      string s;
	};

   class TInputIme : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      static TItem* Create() { return (new TInputIme); };
   private:
      string s, awname;
   };

   class TDeleteImeHeadword : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord() {return _("Clear"); };
      static TItem* Create() { return (new TDeleteImeHeadword); };
   private:
      string s, awname;
   };

   class TDeleteImeFirstToken : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord() {return _("BS"); };
      static TItem* Create() { return (new TDeleteImeFirstToken); };
   private:
      string s, awname;
   };

   class TDeleteImeLastToken : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord() {return _("BS"); };
      static TItem* Create() { return (new TDeleteImeLastToken); };
   private:
      string s, awname;
   };

   class TChangeImeLastTokenToDakuon : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord() {return "J"; };
      static TItem* Create() { return (new TChangeImeLastTokenToDakuon); };
   private:
      string s, awname;
   };

   class TChangeImeLastTokenToHanDakuon: public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord() {return "K"; };
      static TItem* Create() { return (new TChangeImeLastTokenToHanDakuon); };
   private:
      string s, awname;
   };


   class TSendImeWord : public TItem {
   public:
      void setValue(const string Attribute, const string Value);
      bool executeKeyEvent();
      string getWord();
      static TItem* Create() { return (new TSendImeWord); };
   private:
      int index;
      string awname;
   };

   class TStoreLearningDictionaryWithNext : public TItem {
   public:
      bool executeKeyEvent();
      static TItem* Create() { return (new TStoreLearningDictionaryWithNext); };
   private:
      string awname;
   };

   class TValueStatus : public TItem {
   public:
      void setHolder(TWkHolder Holder);
      void setValue(const string Attribute, const string Value);
      void addChild(TSrItem Item);
      void setGlobalStatus();
      bool checkGlobalStatus();
      static TItem* Create() { return (new TValueStatus); };
   private:
      int index;
      static const int all = -1;
      static const int headword_exists = -2;
      static const int current_equal_second_from_last_time = -3;
      bool val;
      TSrValueStatuses items;
      TWkAppropriateWord aw;
   };

   class TSetStatus : public TItem {
   public:
      void addChild(TSrItem Item);
      bool executeKeyEvent();
      static TItem* Create() { return (new TSetStatus); };
   private:
      TSrValueStatuses val;
   };

   class TExecuteIf : public TItem {
   public:
      void addChild(TSrItem Item);
      bool executeKeyEvent();
      string getWord();
      static TItem* Create() { return (new  TExecuteIf); };
   private:
      TSrValueStatuses val;
      TSrItems items;
   };
   /////////////////////////////////////////////////////////////////////////////
   class TKeyEvent : public TItem {
   public:
      TKeyEvent() : code(0), dootherkey(Neutral), key(DownAndUp) {};
      void setValue(const string Attribute, const string Value);
      void addChild(TSrItem Item);
      bool executeKeyEvent();
      string getWord();
      bool isAllKey() { return (code == 0); };
      bool isOtherKey() { return code == -1; };
      bool isUpKey() { return (key == Up)||(key == DownAndUp); };
      bool isDownKey() { return (key == Down)||(key == DownAndUp); };
      int getCode() { return code; };
      static TItem* Create() { return (new TKeyEvent); };
   private:
      int code;
      static const int AllKey = 0;
      static const int OtherKey = -1; // NoDefine Key 
      TKeyUpDown key;
      TThreeStates dootherkey;
      TSrItems items;
   };

   //---------------------------------------------------------------------------
   class TTable : public TItem {
   public:
      TTable();
      string getName() { return name; };
      void setValue(const string Attribute, const string Value);
      void addChild(TSrItem Item);
      bool executeKeyEvent();
      string getWord();
      static TItem* Create() { return (new TTable); };
   private:
      string name;
      TSrItemMatrix2 upkeytable;
      TSrItemMatrix2 downkeytable;
      TSrItems otherupkeylist;
      TSrItems otherdownkeylist;
   };

   /////////////////////////////////////////////////////////////////////////////
   // SaikoroFrame Control
   class TShowFrame : public TItem {
   public:
      bool executeKeyEvent();
      static TItem* Create() { return (new TShowFrame); };
   };
   class THideFrame : public TItem {
   public:
      bool executeKeyEvent();
      static TItem* Create() { return (new THideFrame); };
   };
   /////////////////////////////////////////////////////////////////////////////
   // SaikoroRegistWordFrame Control
   class TShowRegistFrame : public TItem {
   public:
      bool executeKeyEvent();
      static TItem* Create() { return (new TShowRegistFrame); };
   };
   /////////////////////////////////////////////////////////////////////////////
   class TAppropriateWordHolder : public TAppropriateWord {
   public:
      TWkAppropriateWord getAppropriateWord(const string s);
      void addAppropriateWord(string name, TSrAppropriateWord aword);
      void addHeadwordToken(const string s);
      void deleteLastToken();
      void clear();
      string getHeadword();
      string getKatakanaHeadword();
      string getWord(const int index);
      void addWordToLearningDictionary(string Headword, string Word);
      void doStoreLearningDictionaryWithNext();
      bool getStoreLearningDictionaryWithNext();
      bool getStoreLearnDicWithBefore();
      bool isHeadwordExists();
   private:
      typedef map<string, TSrAppropriateWord> AppropriateWordTable;
      AppropriateWordTable awt;
      TWkAppropriateWord aw;
   };

   class THolder : public TItem {
   public:
      THolder();
      static TItem* Create() { return (new THolder); };
      void addChild(TSrItem Item);
      bool executeKeyEvent(int KeyCode, TKeyUpDown KeyAction);
      bool executeKeyEvent(string tablename, int KeyCode, TKeyUpDown KeyAction);
      void changeCurrentTable(string name);
      string getCurrentTableName() { return currenttable.lock()->getName(); };
      string getSecondFromLastTimeTableName() { return secondfromlasttimetable.lock()->getName(); };
      void setDownedKey(int RealKeyCode, int SimulatedKeyCode);
      TWkAppropriateWord getAppropriateWord(string s = "");
      string getWord(int KeyCode, TKeyUpDown KeyAction);
      string getWord(string name, int KeyCode, TKeyUpDown KeyAction);
      void setGlobalValue(unsigned int index, bool Value);
      bool getGlobalValue(unsigned int index);
      unsigned int getGlobalValueCount() { return val.size(); };
      int getKeyCode() { return key_code; };
      TKeyUpDown getKeyAction() { return key_action; };
      bool isUsingClipboardAtInputString() {return isusingclipboard; };
      void setUsingClipboardAtInputString(bool t) { isusingclipboard = t; };
   private:
      TSrAppropriateWordHolder awh;
      map<string, TSrTable> tableitems;
      deque<bool> val;
      TWkTable currenttable;
      TWkTable lasttimetable;
      TWkTable secondfromlasttimetable;
      bool downedkey[MaxKeyCode][MaxKeyCode];   //  RealKeyCode, SimulatedKeyCode
      bool isusingclipboard;
      int key_code;
      TKeyUpDown key_action;
   };

   class THolderFactory : public DefaultHandler {
   public:
      TSrHolder createHolder( string filename );
      void startElement( THolderHandler* const t );
      void characters( THolderHandler* const t );
      void endElement( THolderHandler* const t );
      void endDocument( THolderHandler* const t );
      void startElement( const XMLCh* const uri,
         const XMLCh* const localname, const XMLCh* const qname,
         const Attributes& Attributes );
      void endElement( const XMLCh* const uri, const XMLCh* const localname,
         const XMLCh* const qname )
         { items.pop_back(); }
   private:
      vector<TSrItem> items;
      Loki::Factory<TItem, string> factory;
      TWkHolder wh;
      boost::shared_ptr<XMLTranscoder> transcoder;
      const static int bufStringSize = 1024;
   };
}

#endif
