/*
 * Decompiled with CFR 0.152.
 */
package sakana.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseAccessor {
    private final Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    private static DatabaseAccessor da;
    private Connection conn;

    public static DatabaseAccessor getInstance(String driver) throws NamingException, SQLException {
        return da == null ? new DatabaseAccessor(driver) : da;
    }

    private DatabaseAccessor(String driver) throws NamingException, SQLException {
        InitialContext cont = new InitialContext();
        DataSource ds = (DataSource)cont.lookup(driver);
        this.conn = ds.getConnection();
        this.conn.setAutoCommit(false);
    }

    public PreparedStatement createStatement(String sql) throws SQLException {
        this.log.info("sql=" + sql);
        return this.conn.prepareStatement(sql);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public void forceRollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

