/*
 * Decompiled with CFR 0.152.
 */
package sakana.database;

import java.util.Collection;
import java.util.Map;
import sakana.database.ColumnData;
import sakana.database.dao.ColumnOption;

public class DtoAnalysisData {
    private String tableName;
    private Map<String, ColumnData> columnDataMap;
    private int count;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, ColumnData> getColumnDataMap() {
        return this.columnDataMap;
    }

    public void setColumnDataMap(Map<String, ColumnData> columnDataMap) {
        this.columnDataMap = columnDataMap;
    }

    public int getColumnDataMapSize() {
        return this.columnDataMap.size();
    }

    public String getColumnNames(ColumnOption opt) {
        this.count = 0;
        StringBuilder sb = new StringBuilder();
        Collection<ColumnData> view = this.columnDataMap.values();
        for (ColumnData cd : view) {
            if (opt != ColumnOption.ALL && (opt != ColumnOption.NOT_NULL || cd.getValue() == null)) continue;
            ++this.count;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(cd.getName());
        }
        return sb.toString();
    }

    public String getSetStatement(ColumnOption opt) {
        this.count = 0;
        StringBuilder sb = new StringBuilder();
        Collection<ColumnData> view = this.columnDataMap.values();
        for (ColumnData cd : view) {
            if (opt != ColumnOption.ALL && (opt != ColumnOption.NOT_NULL || cd.getValue() == null)) continue;
            ++this.count;
            if (sb.length() == 0) {
                sb.append("SET ");
            } else {
                sb.append(",");
            }
            sb.append(cd.getName());
            sb.append("=?");
        }
        return sb.toString();
    }

    public String getWhereStatement(ColumnOption opt) {
        this.count = 0;
        StringBuilder sb = new StringBuilder();
        if (!opt.equals((Object)ColumnOption.NO)) {
            Collection<ColumnData> view = this.columnDataMap.values();
            for (ColumnData cd : view) {
                if (opt != ColumnOption.ALL && (opt != ColumnOption.NOT_NULL || cd.getValue() == null)) continue;
                ++this.count;
                if (sb.length() == 0) {
                    sb.append("WHERE ");
                } else {
                    sb.append(" AND ");
                }
                sb.append(cd.getName());
                sb.append("=?");
            }
        }
        return sb.toString();
    }

    public int getCount() {
        return this.count;
    }
}

