/*
 * Decompiled with CFR 0.152.
 */
package sakana.database.dao;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import sakana.database.ColumnData;
import sakana.database.DataTypes;
import sakana.database.DatabaseAccessor;
import sakana.database.DtoAnalysisData;
import sakana.database.dao.ColumnOption;
import sakana.database.dto.Dto;
import sakana.database.dto.NotForColumn;
import sakana.database.dto.StreamLength;
import sakana.database.dto.Table;
import sakana.system.MethodPrefix;
import sakana.system.SystemException;
import sakana.util.StringUtil;

public abstract class AbstractDao {
    private DatabaseAccessor da;
    private final Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    public void setDa(DatabaseAccessor da) {
        this.da = da;
    }

    public boolean selectTest(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.NOT_NULL, ColumnOption.NOT_NULL, false, ps);
        boolean res = rs.next();
        this.closeStatement(rs, ps);
        return res;
    }

    public boolean selectTestForUpdate(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.NOT_NULL, ColumnOption.NOT_NULL, true, ps);
        boolean res = rs.next();
        this.closeStatement(rs, ps);
        return res;
    }

    public boolean selectTestAll(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.NOT_NULL, ColumnOption.NO, false, ps);
        boolean res = rs.next();
        this.closeStatement(rs, ps);
        return res;
    }

    public boolean selectTestAllForUpdate(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.NOT_NULL, ColumnOption.NO, true, ps);
        boolean res = rs.next();
        this.closeStatement(rs, ps);
        return res;
    }

    public Dto select(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.ALL, ColumnOption.NOT_NULL, false, ps);
        Dto res = this.storeDto(rs, ana, dto);
        this.closeStatement(rs, ps);
        return res;
    }

    public Dto selectForUpdate(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.ALL, ColumnOption.NOT_NULL, true, ps);
        Dto res = this.storeDto(rs, ana, dto);
        this.closeStatement(rs, ps);
        return res;
    }

    public Dto selectAll(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.ALL, ColumnOption.NO, false, ps);
        Dto res = this.storeDto(rs, ana, dto);
        this.closeStatement(rs, ps);
        return res;
    }

    public Dto selectAllForUpdate(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.ALL, ColumnOption.NO, true, ps);
        Dto res = this.storeDto(rs, ana, dto);
        this.closeStatement(rs, ps);
        return res;
    }

    public List<Dto> selectList(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.ALL, ColumnOption.NOT_NULL, false, ps);
        List<Dto> res = this.storeDtoList(rs, ana, dto);
        this.closeStatement(rs, ps);
        return res;
    }

    public List<Dto> selectListAll(Dto dto) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        PreparedStatement ps = null;
        ResultSet rs = this.doSelect(ana, ColumnOption.ALL, ColumnOption.NO, false, ps);
        List<Dto> res = this.storeDtoList(rs, ana, dto);
        this.closeStatement(rs, ps);
        return res;
    }

    public Dto getDto(Dto dto, ResultSet rs) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        return this.storeDto(rs, ana, dto);
    }

    public List<Dto> getDtoList(Dto dto, ResultSet rs) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        return this.storeDtoList(rs, ana, dto);
    }

    private ResultSet doSelect(DtoAnalysisData ana, ColumnOption columnOpt, ColumnOption whereOpt, boolean forUpdate, PreparedStatement ps) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(ana.getColumnNames(columnOpt));
        sb.append(" FROM ");
        sb.append(ana.getTableName());
        if (!whereOpt.equals((Object)ColumnOption.NO)) {
            sb.append(" ");
            sb.append(ana.getWhereStatement(whereOpt));
        }
        if (forUpdate) {
            sb.append(" FOR UPDATE");
        }
        this.log.info("sql=" + sb.toString());
        ps = null;
        ResultSet rs = null;
        ps = this.da.createStatement(sb.toString());
        ps = this.bind(ps, 1, ana, whereOpt);
        rs = ps.executeQuery();
        return rs;
    }

    public int merge(Dto insDto, ColumnOption opt, Dto dataDto, Dto conditionDto) throws SQLException, SystemException {
        int res = 0;
        res = this.selectTestForUpdate(conditionDto) ? this.update(dataDto, conditionDto) : this.insert(insDto, opt);
        return res;
    }

    public int merge(Dto insDto, ColumnOption opt, Dto dataDto) throws SQLException, SystemException {
        int res = 0;
        res = this.selectTestForUpdate(insDto) ? this.update(dataDto) : this.insert(insDto, opt);
        return res;
    }

    public int insert(Dto dto, ColumnOption opt) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(ana.getTableName());
        sb.append("(");
        sb.append(ana.getColumnNames(opt));
        sb.append(") VALUES(");
        int i = 0;
        while (i < ana.getCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
            ++i;
        }
        sb.append(")");
        this.log.info("sql=" + sb.toString());
        PreparedStatement ps = null;
        int res = 0;
        try {
            ps = this.da.createStatement(sb.toString());
            ps = this.bind(ps, 1, ana, opt);
            res = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        return res;
    }

    public int insertNotExists(Dto dataDto, ColumnOption opt, Dto condDto) throws SQLException, SystemException {
        int res = 0;
        if (!this.selectTest(condDto)) {
            res = this.insert(dataDto, opt);
        }
        return res;
    }

    public int update(Dto dataDto, Dto conditionDto) throws SQLException, SystemException {
        return this.doUpdate(dataDto, conditionDto, ColumnOption.NOT_NULL);
    }

    public int update(Dto dataDto) throws SQLException, SystemException {
        return this.doUpdate(dataDto, dataDto.newInstance(), ColumnOption.NOT_NULL);
    }

    public int updateAll(Dto dataDto, Dto conditionDto) throws SQLException, SystemException {
        return this.doUpdate(dataDto, conditionDto, ColumnOption.ALL);
    }

    public int updateAll(Dto dataDto) throws SQLException, SystemException {
        return this.doUpdate(dataDto, dataDto.newInstance(), ColumnOption.ALL);
    }

    private int doUpdate(Dto dataDto, Dto conditionDto, ColumnOption opt) throws SQLException, SystemException {
        DtoAnalysisData anaData = this.analyzeDto(dataDto);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(anaData.getTableName());
        sb.append(" ");
        sb.append(anaData.getSetStatement(opt));
        sb.append(" ");
        DtoAnalysisData anaCond = this.analyzeDto(conditionDto);
        sb.append(anaCond.getWhereStatement(ColumnOption.NOT_NULL));
        this.log.info("sql=" + sb.toString());
        PreparedStatement ps = null;
        int res = 0;
        try {
            ps = this.da.createStatement(sb.toString());
            int bindNo = 1;
            ps = this.bind(ps, bindNo, anaData, opt);
            ps = this.bind(ps, bindNo += anaData.getCount(), anaCond, opt);
            res = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        return res;
    }

    public int delete(Dto dto, ColumnOption whereOpt) throws SQLException, SystemException {
        DtoAnalysisData ana = this.analyzeDto(dto);
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(ana.getTableName());
        if (!whereOpt.equals((Object)ColumnOption.NO)) {
            sb.append(" ");
            sb.append(ana.getWhereStatement(whereOpt));
        }
        this.log.info("sql=" + sb.toString());
        PreparedStatement ps = null;
        int res = 0;
        try {
            ps = this.da.createStatement(sb.toString());
            ps = this.bind(ps, 1, ana, whereOpt);
            res = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        return res;
    }

    public PreparedStatement createStatement(String sql) throws SQLException {
        return this.da.createStatement(sql);
    }

    private DtoAnalysisData analyzeDto(Dto dto) throws SystemException {
        HashMap<String, ColumnData> cdMap = new HashMap<String, ColumnData>();
        Method[] methods = dto.getClass().getDeclaredMethods();
        String getterPrefix = MethodPrefix.GETTER.getValue();
        int getterLength = getterPrefix.length();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            NotForColumn notFor;
            Method method = methodArray[n2];
            ColumnData cd = null;
            String methodName = method.getName();
            if (methodName.startsWith(getterPrefix) && (notFor = method.getAnnotation(NotForColumn.class)) == null) {
                StreamLength sl = method.getAnnotation(StreamLength.class);
                if (sl != null) {
                    int len = 0;
                    try {
                        len = (Integer)dto.getClass().getMethod(methodName, null).invoke((Object)dto, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new SystemException(e);
                    }
                    String originalMethodName = String.valueOf(getterPrefix) + StringUtil.toCapital(sl.value());
                    if (cdMap.containsKey(originalMethodName)) {
                        cd = (ColumnData)cdMap.get(originalMethodName);
                    } else {
                        cd = new ColumnData();
                        cd.setCapitalName(originalMethodName.substring(getterLength, originalMethodName.length()));
                    }
                    cd.setLength(len);
                    cdMap.put(originalMethodName, cd);
                } else {
                    if (cdMap.containsKey(methodName)) {
                        cd = (ColumnData)cdMap.get(methodName);
                    } else {
                        cd = new ColumnData();
                        cd.setCapitalName(methodName.substring(getterLength, methodName.length()));
                    }
                    String returnType = method.getReturnType().getCanonicalName();
                    try {
                        if (returnType.equals(DataTypes.TYPES_INT.getName())) {
                            cd.setType(DataTypes.TYPES_INT);
                        } else if (returnType.equals(DataTypes.TYPES_SHORT.getName())) {
                            cd.setType(DataTypes.TYPES_SHORT);
                        } else if (returnType.equals(DataTypes.TYPES_LONG.getName())) {
                            cd.setType(DataTypes.TYPES_LONG);
                        } else if (returnType.equals(DataTypes.TYPES_STRING.getName())) {
                            cd.setType(DataTypes.TYPES_STRING);
                        } else if (returnType.equals(DataTypes.TYPES_BINARY.getName())) {
                            cd.setType(DataTypes.TYPES_BINARY);
                        } else if (returnType.equals(DataTypes.TYPES_BOOLEAN.getName())) {
                            cd.setType(DataTypes.TYPES_BOOLEAN);
                        }
                        cd.setValue(dto.getClass().getMethod(methodName, null).invoke((Object)dto, null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new SystemException(e);
                    }
                    cdMap.put(methodName, cd);
                }
            }
            ++n2;
        }
        DtoAnalysisData ana = new DtoAnalysisData();
        ana.setTableName(dto.getClass().getAnnotation(Table.class).value());
        ana.setColumnDataMap(cdMap);
        return ana;
    }

    private PreparedStatement bind(PreparedStatement ps, int bindNo, DtoAnalysisData ana, ColumnOption opt) throws SQLException {
        Collection<ColumnData> view = ana.getColumnDataMap().values();
        for (ColumnData cd : view) {
            Object value = cd.getValue();
            if (opt != ColumnOption.ALL && (opt != ColumnOption.NOT_NULL || value == null)) continue;
            switch (cd.getType()) {
                case TYPES_INT: {
                    ps.setInt(bindNo, (Integer)value);
                    break;
                }
                case TYPES_SHORT: {
                    ps.setShort(bindNo, (Short)value);
                    break;
                }
                case TYPES_LONG: {
                    ps.setLong(bindNo, (Long)value);
                    break;
                }
                case TYPES_STRING: {
                    ps.setString(bindNo, (String)value);
                    break;
                }
                case TYPES_BINARY: {
                    ps.setBinaryStream(bindNo, (InputStream)value, cd.getLength());
                    break;
                }
                case TYPES_BOOLEAN: {
                    short newValue = 0;
                    if (((Boolean)value).booleanValue()) {
                        newValue = 1;
                    }
                    ps.setShort(bindNo, newValue);
                }
            }
            ++bindNo;
        }
        return ps;
    }

    private List<Dto> storeDtoList(ResultSet rs, DtoAnalysisData ana, Dto dto) throws SQLException, SystemException {
        ArrayList<Dto> list = new ArrayList<Dto>();
        Dto resultDto = this.storeDto(rs, ana, dto);
        while (!resultDto.isEmpty()) {
            list.add(resultDto);
            resultDto = this.storeDto(rs, ana, dto);
        }
        return list;
    }

    private Dto storeDto(ResultSet rs, DtoAnalysisData ana, Dto dto) throws SQLException, SystemException {
        Dto newDto = dto.newInstance();
        Collection<ColumnData> view = ana.getColumnDataMap().values();
        if (rs.next()) {
            for (ColumnData cd : view) {
                Object result = null;
                Class[] params = new Class[1];
                try {
                    switch (cd.getType()) {
                        case TYPES_INT: {
                            result = rs.getInt(cd.getName());
                            if (rs.wasNull()) {
                                result = null;
                            }
                            params[0] = Class.forName(DataTypes.TYPES_INT.getName());
                            break;
                        }
                        case TYPES_SHORT: {
                            result = rs.getShort(cd.getName());
                            if (rs.wasNull()) {
                                result = null;
                            }
                            params[0] = Class.forName(DataTypes.TYPES_SHORT.getName());
                            break;
                        }
                        case TYPES_LONG: {
                            result = rs.getLong(cd.getName());
                            if (rs.wasNull()) {
                                result = null;
                            }
                            params[0] = Class.forName(DataTypes.TYPES_LONG.getName());
                            break;
                        }
                        case TYPES_STRING: {
                            result = rs.getString(cd.getName());
                            params[0] = Class.forName(DataTypes.TYPES_STRING.getName());
                            break;
                        }
                        case TYPES_BINARY: {
                            result = rs.getBinaryStream(cd.getName());
                            params[0] = Class.forName(DataTypes.TYPES_BINARY.getName());
                            break;
                        }
                        case TYPES_BOOLEAN: {
                            short value = rs.getShort(cd.getName());
                            result = value == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                            params[0] = Class.forName(DataTypes.TYPES_BOOLEAN.getName());
                        }
                    }
                    Method method = newDto.getClass().getMethod(String.valueOf(MethodPrefix.SETTER.getValue()) + cd.getCapitalName(), params);
                    method.invoke((Object)newDto, result);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SystemException(e);
                }
            }
        }
        return newDto;
    }

    public void closeStatement(PreparedStatement ps) throws SQLException {
        if (ps != null) {
            ps.close();
        }
    }

    public void closeStatement(ResultSet rs, PreparedStatement ps) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
    }
}

