require "find"

 class Time
		 def w3cdtf
				 strftime("%Y-%m-%dT%H:%M:%S")
		 end
 end

 class Header
		 attr_accessor :id,:title,:link
		 attr_accessor :modified
 end
 class CategoryItem
 		attr_reader :category,:count
 		def initialize(c,n)
 			@category = c
 			@count = n
 		end
 end

 class Entry < Header
		 attr_accessor :content,:summary
		 def summary
				 if @summary.nil? then
						 if @content.nil? then
								 return ""
						 else
								 return @content[1,100].gsub(/<[\/]?[a-zA-z\s]+[\/]?>/,"")
						 end
				 else
						 return @summary
				 end 
		 end
 end

 module BlogAPI
		 SEARCH_LAST = "last"
		 SEARCH_CATEGORY = "category"
		 SEARCH_DATE = "date"
		 def search_entry(req)
		 end
		 def get_entry(req)
		 end
 end



 class Archive
		 attr_accessor :datadir ,:file_extension
		 def initialize (dir,ext)
				 @datadir = dir
				 @file_extension = ext
				 @catgeory_list = {}
				 @master_index = make_index(@datadir,@file_extension)
		 end
		 def make_categorylist(dir)
			list = {}
			Find.find(dir) do |path|
				Find.prune if [".",".."].include? path
				if FileTest.directory?(path) then
					s = path[dir.length,999]
					s = "/" if s.empty?
					list[s] = 0
				end
			end
			return list
		end
		def get_categorylist(dir)
			
			return @category_list
		end
		def make_index(dir,ext)
			list = []
			@category_list = make_categorylist(dir)
			pattern = Regexp.compile(sprintf("^.+%s$",ext))
			Find.find(dir) do |path|
				Find.prune if [".",".."].include? path
					if File.basename(path) =~ pattern then
					id = ""
					id << path[dir.length..(path.length - ext.length - 1)]
					list << [File.mtime(path),id]
					s = File.dirname(path)
					s = s[dir.length,999]
					s = "/" if s.empty?
					@category_list[s] = @category_list[s] + 1
				end
		 end
		 list.sort!
		 list.reverse!
		 index = []
		 list.each do |e|
				 h = Header.new
				 h.modified = e[0]
				 h.id = e[1]
				 index << h
		 end
		 return index
		 end
		 def get_entry(id)
				 entry = make_entry(id)
				 return entry
		 end
		 def make_entry(id)
				 path = @datadir + id + @file_extension
				 if !FileTest.file?(path) then
						 return nil
				 end
				 entry = Entry.new
				 entry.id = id
				 file = File.new(path)
				 File.open(path) do |file|
						 entry.modified = file.mtime
						 entry.content = ""
						 while line = file.gets
						 if entry.title == nil then
							 entry.title = line.chomp
						 else
							 entry.content << line
						 end
						 end
				 end
		 return entry
	 end
	 def make_title(id)
				 path = @datadir + id + @file_extension
				 if !FileTest.file?(path) then
						 return nil
				 end
				 title = nil
				 File.open(path) do |file|
						 title = file.gets
				 end
				 return title
	 end
	 def search_entry(req)
		 list = @master_index
		 if req  .has_key? BlogAPI::SEARCH_CATEGORY then
			 cat = req[BlogAPI::SEARCH_CATEGORY]
			 if cat.nil? || cat.empty? then
				 cat = "/"
			 end
			 if cat.nil? || !cat =~ /[\/A_Za-z0-9]+/ || !(cat.is_a? String) then
				 cat = "/"
			 end 
			 pattern = Regexp.compile(sprintf("^%s.*",cat))
			 l = []
			 list.each do |h|
				 if h.id =~ pattern then
					 l << h
				 end
			 end
			 list = l
		end
		if req.has_key? BlogAPI::SEARCH_DATE then
			day = req[BlogAPI::SEARCH_DATE]
			if day.is_a? Time then
				l = []
				list.each do |h|
				if h.modified.between?(day,day + 24 * 60 * 60) then
					l << h
				end
				list = l
				end
			end
		end
		if req.has_key? BlogAPI::SEARCH_LAST then
			last = req[BlogAPI::SEARCH_LAST]
			if !last.is_a? Integer then
				return list
			end
			if [list.length < last] then
				list
			end
				list = list[0,last]
		 end
		 list.each do |h|
				 if h.title == nil then
						 h.title = make_title(h.id)
				 end
		 end
		 list
	 end
 end

 class Blog
		 attr_accessor :datadir,:file_extension,:testval,:encoding,:title,:uri,:lang,:description
		 include BlogAPI
		 def initialize (&block)
				 if block != nil then
				 instance_eval &block
			 end
				 @arc = Archive.new(@datadir,@file_extension)
		 end
		 def get_entry(id)
				 entry = @arc.get_entry(id)
				 entry.link = "" 
				 entry.link << @uri
				 entry.link << entry.id
				 return entry
		 end
		 def search_entry(req)
				 index = @arc.search_entry(req)
				 index.each do |h|
						 h.link = ""
						 h.link << @uri
						 h.link << h.id
				 end 
				 return index
		 end

 end

