#!/usr/bin/ruby

require "cgi"
require "parts.rb"
require "viewer.rb"

#system setting
$blog_tilte = "Blog Title"
$blog_url = "http://localhost:8080/"
$blog_encoding = "UTF-8"
$blog_lang = "ja"
$blog_datadir = "../sampledata"
$blog_file_extension = ".txt"
$blog_description = "test unit blog"

$sakura_plugin = "plugin"
$sakura_debug = true

# cgi main
begin

#plugin
  Dir.foreach($sakura_plugin) do |plugin|
    next if[".",".."].include? plugin 
    file = File.join($sakura_plugin,plugin)
    require file
  end

  blog  = Blog.new do
      self.encoding = $blog_encoding
      self.title = $blog_title
      self.uri = $blog_url
      self.lang = $blog_lang
      self.datadir = $blog_datadir
      self.file_extension = $blog_file_extension
      self.description = $blog_description
  end

  viewer_list = Hash.new(HTMLViewer)
  viewer_list[".rss"] = RSSViewer



  cgi = CGI.new
  path = "/"
  if ENV.has_key?("PATH_INFO") then
    path = ENV["PATH_INFO"]
  end
  ext = ".html"
  index = path.rindex(/\.[A-Za-z]/)
  if !index.nil? then
    ext = path[index,999].downcase
  end

  viewer = viewer_list[ext].new
  viewer.blog = blog
  viewer.out = STDOUT
  viewer.view(path,nil)
rescue => err
  if $sakura_debug then
    print err ,"\n"
  else
    print "Sorry Internal Error"
  end
  
end

