<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * SaMMAեԽ
 *
 * $RCSfile: index.php,v $
 * $Revision: 1.14 $
 * $Date: 2010/12/11 02:04:50 $
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibldap");
include_once("lib/dglibsamma");

/********************************************************
ƥڡ
*********************************************************/

define("OPERATION", "եԽ");

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {
        global $sesskey;
        global $samma_conf;
        global $logfacility;
        global $db_types;
        global $str_code;

        /* ѥ */
        $commandpass = "";
        if (isset($samma_conf["commandpass"]) === TRUE && 
                  $samma_conf["commandpass"] != "") {
            $commandpass = htmlspecialchars($samma_conf["commandpass"]);
        }

        /* եƥ */
        $html_log = "";
        foreach ($logfacility as $log) {
            $selected = "";
            /* פ */
            if (isset($samma_conf["syslogfacility"]) === TRUE &&
                  $samma_conf["syslogfacility"] != "") {
                if ($log == $samma_conf["syslogfacility"]) {
                    $selected = "selected";
                } 
            } else {
                /* åȤƤʤϥǥե */
                if ($log == "local0") {
                    $selected = "selected";
                }
            }
            $html_log .=<<<EOD
            <option value="$log" $selected>$log
EOD;
        }

        /* Ǽǥ쥯ȥ */
        $encryptiontmpdir = "";
        if (isset($samma_conf["encryptiontmpdir"]) === TRUE && 
                  $samma_conf["encryptiontmpdir"] != "") {
            $encryptiontmpdir = htmlspecialchars($samma_conf["encryptiontmpdir"]);
        }

        /* zipޥɥѥ */
        $zipcommand = "";
        if (isset($samma_conf["zipcommand"]) === TRUE && 
                  $samma_conf["zipcommand"] != "") {
            $zipcommand = htmlspecialchars($samma_conf["zipcommand"]);
        }

        /* zipޥɥץ */
        $zipcommandopt = "";
        if (isset($samma_conf["zipcommandopt"]) === TRUE && 
                  $samma_conf["zipcommandopt"] != "") {
            $zipcommandopt = htmlspecialchars($samma_conf["zipcommandopt"]);
        }

        /* ɥᥤDB/ѥ */
       $html_sender = "";
        foreach ($db_types as $s_type) {
            $s_file = "";
            $type = "";
            if (isset($samma_conf["senderdb"]) === TRUE &&
                  $samma_conf["senderdb"] != "") {
                $send = explode(":", $samma_conf["senderdb"], 2);
                $type = $send[0];
                $s_file = htmlspecialchars($send[1]);
            }
            $selected = "";
            /* פ */
            if ($s_type == $type) {
                    $selected = "selected";
            }
            $html_sender .=<<<EOD
            <option value="$s_type" $selected>$s_type
EOD;
        }
            
        /* DB/ѥ */
        $html_rcpt = "";
        foreach ($db_types as $r_type) {
            $r_file = "";
            $type = "";
            if (isset($samma_conf["rcptdb"]) === TRUE &&
                  $samma_conf["rcptdb"] != "") {
                $rcpt = explode(":", $samma_conf["rcptdb"], 2);
                $type = $rcpt[0];
                $r_file = htmlspecialchars($rcpt[1]);
            }
            $selected = "";
            /* פ */
            if ($r_type == $type) {
                    $selected = "selected";
            }
            $html_rcpt .=<<<EOD
            <option value="$r_type" $selected>$r_type
EOD;
        }
            
        /* Υ᡼ƥץ졼ȥѥ */
        $templatepath = "";
        if (isset($samma_conf["templatepath"]) === TRUE && 
                  $samma_conf["templatepath"] != "") {
            $templatepath = htmlspecialchars($samma_conf["templatepath"]);
        }

        /* sendmailޥɥѥ/ץ */
        $sendmailcommand = "";
        if (isset($samma_conf["sendmailcommand"]) === TRUE && 
                  $samma_conf["sendmailcommand"] != "") {
            $sendmailcommand = htmlspecialchars($samma_conf["sendmailcommand"]);
        }

        /* Ź沽ZIPեեޥå */
        $zipfilename = "";
        if (isset($samma_conf["zipfilename"]) === TRUE && 
                  $samma_conf["zipfilename"] != "") {
            $zipfilename = htmlspecialchars($samma_conf["zipfilename"]);
        }

        /* ¸ǥ쥯ȥ */
        $mailsavetmpdir = "";
        if (isset($samma_conf["mailsavetmpdir"]) === TRUE && 
                  $samma_conf["mailsavetmpdir"] != "") {
            $mailsavetmpdir = htmlspecialchars($samma_conf["mailsavetmpdir"]);
        }

        /* ѥʸ */
        $passwordlength = "";
        if (isset($samma_conf["passwordlength"]) === TRUE && 
                  $samma_conf["passwordlength"] != "") {
            $passwordlength = htmlspecialchars($samma_conf["passwordlength"]);
        }

        /* ե̾Ѵʸ */
        $html_strcode = "";
        foreach ($str_code as $code) {
            $selected = "";
            /* פ */
            if (isset($samma_conf["strcode"]) === TRUE &&
                  $samma_conf["strcode"] != "") {
                if ($code == $samma_conf["strcode"]) {
                    $selected = "selected";
                } 
            } else {
                /* åȤƤʤϥǥե */
                if ($code == DEF_CODE) {
                    $selected = "selected";
                }
            }
            $html_strcode .=<<<EOD
            <option value="$code" $selected>$code
EOD;
        }

        /* ǥեȽ */
        $enc_on = "";
        $enc_off = "checked";
        if (isset($samma_conf["defaultencryption"]) === TRUE && 
                  $samma_conf["defaultencryption"] != "") {
            if ($samma_conf["defaultencryption"] == "yes") {
                $enc_on = "checked";
                $enc_off = "";
            }
        }

        /* ǥեȥѥ */
        $defaultpassword = "";
        if (isset($samma_conf["defaultpassword"]) === TRUE && 
                  $samma_conf["defaultpassword"] != "") {
            $defaultpassword = htmlspecialchars($samma_conf["defaultpassword"]);
        }

        /* 桼 */
        $user_on = "";
        $user_off = "checked";
        $disabled = "disabled";
        if (isset($samma_conf["userpolicy"]) === TRUE && 
                  $samma_conf["userpolicy"] != "") {
            if ($samma_conf["userpolicy"] == "yes") {
                $user_on = "checked";
                $user_off = "";
                $disabled = "";
            }
        }

        /* LDAPСݡ */
        $ldapserver = "";
        $ldapport = "";
        if (isset($samma_conf["ldapuri"]) === TRUE && 
                  $samma_conf["ldapuri"] != "") {
            /* ://פڤʬ */
            $uri = explode("://", $samma_conf["ldapuri"]);
            /* IPȥݡȤڤʬ */
            $serverdata = explode(":", $uri[1]);
            /* Ǽ(ݡȤΡ/פ) */
            $ldapserver = htmlspecialchars($serverdata[0]);
            $ldapport = htmlspecialchars(rtrim($serverdata[1], "/"));
        }

        /* LDAP١DN */
        $ldapbasedn = "";
        if (isset($samma_conf["ldapbasedn"]) === TRUE && 
                  $samma_conf["ldapbasedn"] != "") {
            $ldapbasedn = htmlspecialchars($samma_conf["ldapbasedn"]);
        }

        /* LDAPХDN */
        $ldapbinddn = "";
        if (isset($samma_conf["ldapbinddn"]) === TRUE && 
                  $samma_conf["ldapbinddn"] != "") {
            $ldapbinddn = htmlspecialchars($samma_conf["ldapbinddn"]);
        }

        /* LDAPХɥѥ */
        $ldapbindpassword = "";
        if (isset($samma_conf["ldapbindpassword"]) === TRUE && 
                  $samma_conf["ldapbindpassword"] != "") {
            $ldapbindpassword = htmlspecialchars($samma_conf["ldapbindpassword"]);
        }

        /* LDAPե륿 */
        $ldapfilter = "";
        if (isset($samma_conf["ldapfilter"]) === TRUE && 
                  $samma_conf["ldapfilter"] != "") {
            $ldapfilter = htmlspecialchars($samma_conf["ldapfilter"]);
        }

        print<<<EOD

<script type="text/javascript">
<!--
function ldap_disable(flg) {
    if (flg == "no") {
        document.config.ldapserver.disabled = true;
        document.config.ldapport.disabled = true;
        document.config.ldapbasedn.disabled = true;
        document.config.ldapbinddn.disabled = true;
        document.config.ldapbindpassword.disabled = true;
        document.config.ldapfilter.disabled = true;
    } else {
        document.config.ldapserver.disabled = false;
        document.config.ldapport.disabled = false;
        document.config.ldapbasedn.disabled = false;
        document.config.ldapbinddn.disabled = false;
        document.config.ldapbindpassword.disabled = false;
        document.config.ldapfilter.disabled = false;
    }
}
// -->
</script>
<form method="POST" action="index.php" name="config">
  <table class="table">

    <tbody>
      <tr>
        <td class="key1">Ϣѥѥ</td>
        <td class="value">
          <table>
          <td class="value_must1">
          <input type="text" size="30" maxlength="20" name="commandpass" value="$commandpass">
          </td>

          <td class="value_must2">
          <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">Syslogեƥ</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <select name="syslogfacility">
$html_log
            </select>
          </td>
          <td class="value_must2">
            <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">Ǽǥ쥯ȥ</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <input type="text" size="60" maxlength="256" name="encryptiontmpdir" value="$encryptiontmpdir">
          </td>
          <td class="value_must2">
            <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">zipޥɥѥ</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <input type="text" size="60" maxlength="256" name="zipcommand" value="$zipcommand">
          </td>
          <td class="value_must2"><span class="must_input">*</span>
          </td>
          </table> 
        </td>
      </tr>
      <tr>
        <td class="key1">zipޥɥץ</td>
        <td class="value">
          <input type="text" size="60" maxlength="256" name="zipcommandopt" value="$zipcommandopt">
        </td>
      </tr>
      <tr>
        <td class="key1">ɥᥤDB/ѥ</td>
        <td class="value">
          <select name="sd_dbtype">
$html_sender
          </select>
          <input type="text" size="48" maxlength="256" name="sd_dbfile" value="$s_file">
        </td>
      </tr>
      <tr>
        <td class="key1">DB/ѥ</td>

        <td class="value">
          <select name="rp_dbtype">
$html_rcpt
          </select>
          <input type="text" size="48" maxlength="256" name="rp_dbfile" value="$r_file">
        </td>
      </tr>
      <tr>
        <td class="key1">Υ᡼ƥץ졼ȥѥ</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <input type="text" size="60" maxlength="256" name="templatepath" value="$templatepath">
          </td>
          <td class="value_must2">
            <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">sendmailޥɥѥ/ץ</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <input type="text" size="60" maxlength="256" name="sendmailcommand" value="$sendmailcommand">
          </td>
          <td class="value_must2">
            <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">Ź沽ZIPեեޥå</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <input type="text" size="60" maxlength="256" name="zipfilename" value="$zipfilename">
          </td>
          <td class="value_must2">
            <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">¸ǥ쥯ȥ</td>
        <td class="value">
          <table>
          <td class="value_must1">
            <input type="text" size="60" maxlength="256" name="mailsavetmpdir" value="$mailsavetmpdir">
          </td>
          <td class="value_must2">
              <span class="must_input">*</span>
          </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">ѥʸ</td>

        <td class="value">
          <input type="text" size="5" maxlength="2" name="passwordlength" value="$passwordlength">
        </td>
      </tr>
      <tr>
        <td class="key1">ե̾Ѵʸ</td>
        <td class="value">
          <table>
            <td class ="value_must1">
              <select name="strcode">
$html_strcode
              </select>
            </td>
            <td class="value_must2">
              <span class="must_input">*</span>

            </td>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">ǥեȽ</td>
        <td class="value">
          <table>
            <tr>
              <td class="value_must1"><input type="radio" name="defaultencryption" value="yes" $enc_on>Ź沽</td>
              <td rowspan=2 class="value_must2">
              <span class="must_input">*</span>
             </td>
            </tr>
            <tr>
              <td class="value_must1">
              <input type="radio" name="defaultencryption" value="no" $enc_off>Ź沽ʤ
              </td>
            </tr>
          </table>

        </td>
      </tr>
      <tr>
        <td class="key1">ǥեȥѥ</td>
        <td class="value">
          <input type="text" size="30" maxlength="20" name="defaultpassword" value="$defaultpassword">
        </td>
      </tr>
      <tr>
        <td class="key1">桼</td>
        <td class="value">
          <table>
            <tr>
              <td class="value_must1"><input type="radio" name="userpolicy" value="yes" $user_on onClick="ldap_disable('yes');">ͭ</td>
             <td rowspan=2 class="value_must2">
              <span class="must_input">*</span>
             </td>
            </tr>
            <tr>
              <td class="value_must1">
              <input type="radio" name="userpolicy" value="no" $user_off onClick="ldap_disable('no');">̵
              </td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <td class="key1">LDAP</td>

        <td class="value">
          <input type="text" size="60" maxlength="15" name="ldapserver" value="$ldapserver" $disabled>
        </td>
      </tr>
      <tr>
        <td class="key1">LDAPݡ</td>
        <td class="value">
          <input type="text" size="60" maxlength="6" name="ldapport" value="$ldapport" $disabled>

        </td>
      </tr>
      <tr>
        <td class="key1">LDAP١DN</td>
        <td class="value">
          <input type="text" size="60" maxlength="256" name="ldapbasedn" value="$ldapbasedn" $disabled>
        </td>
      </tr>
      <tr>
        <td class="key1">LDAPХDN</td>
        <td class="value">
          <input type="text" size="60" maxlength="256" name="ldapbinddn" value="$ldapbinddn" $disabled>
        </td>
      </tr>
      <tr>
        <td class="key1">LDAPХɥѥ</td>

        <td class="value">
          <input type="text" size="30" maxlength="20" name="ldapbindpassword" value="$ldapbindpassword" $disabled>
        </td>
      </tr>
      <tr>
        <td class="key1">LDAPե륿</td>

        <td class="value">
          <input type="text" size="60" maxlength="128" name="ldapfilter" value="$ldapfilter" $disabled>
        </td>
      </tr>
    </tbody>

  </table>
<div><span class="must_input">*</span>ɬܹܤǤ</div>

  <br>
  <input type="submit" name="mod" value="" class="mod_btn">
  <input type="submit" name="cancel" value="" class="cancel_btn">
  <input type="hidden" name="sk" value="$sesskey">


</form>
EOD;
    }
};

/*********************************************************
 * check_conf_data
 *
 * եǡå
 *
 * []
 *       $data		եǡ
 *
 * [֤]
 *	TRUE		
 *	FALSE		۾
 **********************************************************/
function check_conf_data(&$data)
{
    global $err_msg;
    global $logfacility;
    global $str_code;

    /* Ϣѥѥ */
    /* å */
    if ($data["commandpass"] == "") {
        $err_msg = "ϢѥѥɤϤƤޤ";
        return FALSE;
    }
    /* å*/
    if (check_samma_pass($data["commandpass"]) !== TRUE) {
        $err_msg = "Ϣ" . $err_msg;
        return FALSE;
    }


    /* syslogեƥ */
    foreach ($logfacility as $log) {
        if ($log == $data["syslogfacility"]) {
            $data["syslogfacility"] = $log;
        }
    }


    /* Ǽǥ쥯ȥ */
    /* å */
    if ($data["encryptiontmpdir"] == "") {
        $err_msg = "Ǽǥ쥯ȥ꤬ϤƤޤ";
        return FALSE;
    }
    /* å*/
    if (check_dir($data["encryptiontmpdir"]) !== TRUE) {
        $err_msg = "Ǽ" . $err_msg;
        return FALSE;
    }


    /* zipޥɥѥ */
    /* å */
    if ($data["zipcommand"] == "") {
        $err_msg = "zipޥɥѥϤƤޤ";
        return FALSE;
    }
    /* å*/
    if (check_command($data["zipcommand"]) !== TRUE) {
        $err_msg = "zip" . $err_msg;
        return FALSE;
    }


    /* zipޥɥץ */
    /* å */
    if ($data["zipcommandopt"] != "") {
        /* å*/
        if (check_str($data["zipcommandopt"], CHECK_STR4) !== TRUE) {
            $err_msg = "zipޥɥץ" . $err_msg;
            return FALSE;
        }
    }


    /* ɥᥤDB/ѥ */
    /* å */
    if ($data["sd_dbfile"] == "") {
        $data["senderdb"] = "";
    } else {
        /* db̾å(".db"ĤƤ뤫) */
        if (substr($data["sd_dbfile"], -3, 3) != ".db") {
            $data["sd_dbfile"] .= ".db";
            $data["senderdb"] .= ".db";
        }

        /* å(ʤк) */
        if (check_db($data["sd_dbfile"], $data["sd_dbtype"]) === FALSE) {
            $err_msg = "ɥᥤ" . $err_msg;
            return FALSE;
        }
    }


    /* DB/ѥ */
    /* å */
    if ($data["rp_dbfile"] == "") {
        $data["rcptdb"] = "";
    } else {
        /* db̾å(".db"ĤƤ뤫) */
        if (substr($data["rp_dbfile"], -3, 3) != ".db") {
            $data["rp_dbfile"] .= ".db";
            $data["rcptdb"] .= ".db";
        }

        /* å(ʤк) */
        if (check_db($data["rp_dbfile"], $data["rp_dbtype"]) === FALSE) {
            $err_msg = "" . $err_msg;
            return FALSE;
        }
    }

    /* ƥץ졼 */
    /* å */
    if ($data["templatepath"] == "") {
        $err_msg = "Υ᡼ƥץ졼ȥѥϤƤޤ";
        return FALSE;
    }
    /* å(ʤк) */
    if (check_tmpl($data["templatepath"]) === FALSE) {
        return FALSE;
    }


    /* sendmailޥɥѥ/ץ */
    /* å */
    if ($data["sendmailcommand"] == "") {
        $err_msg = "sendmailޥɥѥ/ץϤƤޤ";
        return FALSE;
    }
    /* å*/
    if (check_str($data["sendmailcommand"], CHECK_STR4) !== TRUE) {
        $err_msg = "sendmailޥɥѥ/ץ" . $err_msg;
        return FALSE;
    }
    /* ޥɥå */
    $com = explode(" ", $data["sendmailcommand"], 2); 
    if (check_command($com[0]) !== TRUE) {
        $err_msg = "sendmail" . $err_msg;
        return FALSE;
    }


    /* Ź沽ZIPեեޥå */
    /* å */
    if ($data["zipfilename"] == "") {
        $err_msg = "Ź沽ZIPեեޥåȤϤƤޤ";
        return FALSE;
    }
    /* å*/
    if (check_str($data["zipfilename"], CHECK_STR3) !== TRUE) {
        $err_msg = "zipޥɥץ" . $err_msg;
        return FALSE;
    }


    /* ¸ǥ쥯ȥ */
    /* å */
    if ($data["mailsavetmpdir"] == "") {
        $err_msg = "¸ǥ쥯ȥ꤬ϤƤޤ";
        return FALSE;
    }
    /* å*/
    if (check_dir($data["mailsavetmpdir"]) !== TRUE) {
        $err_msg = "¸" . $err_msg;
        return FALSE;
    }


    /* ѥʸ */
    if ($data["passwordlength"] != "") {
        if (is_numeric($data["passwordlength"]) === FALSE) {
            $err_msg = "ѥʸηǤ";
            return FALSE;
        } elseif ($data["passwordlength"] < PASS_MIN || $data["passwordlength"] > PASS_MAX) {
            $err_msg = "ѥʸηǤ";
            return FALSE;
        }
    }

    /* ե̾Ѵʸ */
    foreach ($str_code as $code) {
        if ($code == $data["strcode"]) {
            $data["strcode"] = $code;
        }
    }


    /* ǥեȥѥ */
    /* å */
    if ($data["defaultpassword"] != "") {
        /* å*/
        if (check_samma_pass($data["defaultpassword"]) !== TRUE) {
            $err_msg = "ǥե" . $err_msg;
            return FALSE;
        }
    }

    /* 桼꤬ͭλ */
    if ($data["userpolicy"] == "yes") {

        /* LDAP */
        /* å */
        if ($data["ldapserver"] == "") {
            $err_msg = "LDAPФϤƤޤ";
            return FALSE;
        }
        /* å*/
        if (check_ip_addr($data["ldapserver"]) !== TRUE) {
            $err_msg = "LDAPФ" . $err_msg;
            return FALSE;
        }


        /* LDAPݡ */
        /* å */
        if ($data["ldapport"] == "") {
            $err_msg = "LDAPݡȤϤƤޤ";
            return FALSE;
        }
        /* å*/
        if (check_port($data["ldapport"]) === FALSE) {
            $err_msg = "LDAPݡȤηǤ";
            return FALSE;
        }


        /* LDAP١DN */
        /* å */
        if ($data["ldapbasedn"] == "") {
            $err_msg = "LDAP١DNϤƤޤ";
            return FALSE;
        }
        /* å*/
        if (check_str($data["ldapbasedn"], CHECK_STR3) !== TRUE) {
            $err_msg = "LDAP١DN" . $err_msg;
            return FALSE;
        }


        /* LDAPХDN */
        /* å */
        if ($data["ldapbinddn"] == "") {
            $err_msg = "LDAPХDNϤƤޤ";
            return FALSE;
        }
        /* å*/
        if (check_str($data["ldapbinddn"], CHECK_STR3) !== TRUE) {
            $err_msg = "LDAPХDN" . $err_msg;
            return FALSE;
        }


        /* LDAPХɥѥ */
        /* å */
        if ($data["ldapbindpassword"] == "") {
            $err_msg = "LDAPХɥѥɤϤƤޤ";
            return FALSE;
        }
        /* å*/
        if (check_samma_pass($data["ldapbindpassword"]) !== TRUE) {
            $err_msg = "LDAPХ" . $err_msg;
            return FALSE;
        }


        /* LDAPե륿 */
        /* å */
        if ($data["ldapfilter"] == "") {
            $err_msg = "LDAPե륿ϤƤޤ";
            return FALSE;
        }
        /* å*/
        if (check_str($data["ldapfilter"], CHECK_STR3, FILTER_MIN, FILTER_MAX) !== TRUE) {
            $err_msg = "LDAPե륿" . $err_msg;
            return FALSE;
        }
    }

    return TRUE;

}

/*********************************************************
 * check_db
 *
 * ǡ١եå
 *
 * []
 *       $db_file	DBե
 *	 $db_type	DB
 *
 * [֤]
 *	TRUE		
 *	FALSE		۾
 **********************************************************/
function check_db($db_file, $db_type)
{
    global $err_msg;

    /* å*/
    $ret = check_file($db_file);
    if ($ret === FAIL) {
        $err_msg = "DB" . $err_msg;
        return FALSE;
    /* DBե뤬ʤϺ */
    } elseif ($ret === FAIL_NO_EXIST) {
        /* DB */
        $type = 0;
        if ($db_type == "btree") {
            $type = 1;
        }
        if (make_db($db_file, $type) === FALSE) {
            $err_msg = "DBѤ" . $err_msg;
            return FALSE;
        }
    /* åOKʾϷå */
    } else {
        $command = sprintf(CONFIRM_DB, $db_type, escapeshellcmd($db_file));
        $ret = system($command, $result);
        if ($result != 0) {
            $err_msg = "DBǤ";
            return FALSE;
        }
        if ($ret === FALSE){
            $err_msg = "DBγǧ˼Ԥޤ";
            return FALSE;
        }
    }

    return TRUE;

}

/*********************************************************
 * check_tmpl
 *
 * ƥץ졼ȥեå
 *
 * []
 *       $filename	ƥץ졼ȥե
 *
 * [֤]
 *	TRUE		
 *	FALSE		۾
 **********************************************************/
function check_tmpl($filename)
{
    global $err_msg;

    /* å*/
    $ret = check_file($filename);
    if ($ret === FAIL) {
        $err_msg = "ƥץ졼" . $err_msg;
        return FALSE;
    /* ե뤬ʤϺ */
    } elseif ($ret === FAIL_NO_EXIST) {
        /* ǥ쥯ȥ񤭹߸å */
        if (is_writable(dirname($filename)) !== TRUE) {
            $err_msg = "ǥ쥯ȥ˽߸ޤ(" . $filename . ")";
            return FALSE;
        }

        /* ƥץ졼ȥե */
        $ret = make_def_tmpl($filename);
        if ($ret === FALSE) {
            return FALSE;
        }
    }

    return TRUE;

}

/*********************************************************
 * set_disp_data
 *
 * ͤɽ˥åȤޤ
 *
 * []
 *       $data		ǡ
 *	 $disp_data	ǡ
 *
 * [֤]
 *	ʤ
 **********************************************************/
function set_disp_data($data, &$disp_data)
{
    /* commandpass */
    if (isset($data["commandpass"]) === TRUE) {
        $disp_data["commandpass"] = $data["commandpass"];
    }

    /* syslogfacility */
    if (isset($data["syslogfacility"]) === TRUE) {
        $disp_data["syslogfacility"] = $data["syslogfacility"];
    }

    /* encryptiontmpdir */
    if (isset($data["encryptiontmpdir"]) === TRUE) {
        $disp_data["encryptiontmpdir"] = $data["encryptiontmpdir"];
    }

    /* zipcommand */
    if (isset($data["zipcommand"]) === TRUE) {
        $disp_data["zipcommand"] = $data["zipcommand"];
    }

    /* zipcommandopt */
    if (isset($data["zipcommandopt"]) === TRUE) {
        $disp_data["zipcommandopt"] = $data["zipcommandopt"];
    }

    /* senderdb */
    if (isset($data["sd_dbfile"]) === TRUE) {
        $disp_data["sd_dbfile"] = $data["sd_dbfile"];
        $disp_data["sd_dbtype"] = $data["sd_dbtype"];
        $disp_data["senderdb"] = $data["sd_dbtype"] . ":" . $data["sd_dbfile"];
    }

    /* rcptdb */
    if (isset($data["rp_dbfile"]) === TRUE) {
        $disp_data["rp_dbfile"] = $data["rp_dbfile"];
        $disp_data["rp_dbtype"] = $data["rp_dbtype"];
        $disp_data["rcptdb"] = $data["rp_dbtype"] . ":" . $data["rp_dbfile"];
    }

    /* templatepath */
    if (isset($data["templatepath"]) === TRUE) {
        $disp_data["templatepath"] = $data["templatepath"];
    }

    /* sendmailcommand */
    if (isset($data["sendmailcommand"]) === TRUE) {
        $disp_data["sendmailcommand"] = $data["sendmailcommand"];
    }

    /* zipfilename */
    if (isset($data["zipfilename"]) === TRUE) {
        $disp_data["zipfilename"] = $data["zipfilename"];
    }

    /* mailsavetmpdir */
    if (isset($data["mailsavetmpdir"]) === TRUE) {
        $disp_data["mailsavetmpdir"] = $data["mailsavetmpdir"];
    }

    /* passwordlength */
    if (isset($data["passwordlength"]) === TRUE) {
        $disp_data["passwordlength"] = $data["passwordlength"];
    }

    /* strcode */
    if (isset($data["strcode"]) === TRUE) {
        $disp_data["strcode"] = $data["strcode"];
    }

    /* defaultencryption */
    if (isset($data["defaultencryption"]) === TRUE) {
        $disp_data["defaultencryption"] = $data["defaultencryption"];
    }

    /* defaultpassword */
    if (isset($data["defaultpassword"]) === TRUE) {
        $disp_data["defaultpassword"] = $data["defaultpassword"];
    }

    /* userpolicy */
    if (isset($data["userpolicy"]) === TRUE) {
        $disp_data["userpolicy"] = $data["userpolicy"];
    }

    /* userpolicy"yes"λLDAPǡ */
    if (isset($data["userpolicy"]) === TRUE && $data["userpolicy"] == "yes") {

        /* ldapserver */
        if (isset($data["ldapserver"]) === TRUE) {
            $disp_data["ldapserver"] = $data["ldapserver"];
        }

        /* ldapport */
        if (isset($data["ldapport"]) === TRUE) {
            $disp_data["ldapport"] = $data["ldapport"];
        }

        /* server & port */
        if (isset($data["ldapserver"]) === TRUE && 
            isset($data["ldapport"]) === TRUE) { 
            $disp_data["ldapuri"] = "ldap://" . $data["ldapserver"] . ":" . $data["ldapport"] . "/";
        }

        /* ldapbasedn */
        if (isset($data["ldapbasedn"]) === TRUE) {
            $disp_data["ldapbasedn"] = $data["ldapbasedn"];
        }

        /* ldapbinddn */
        if (isset($data["ldapbinddn"]) === TRUE) {
            $disp_data["ldapbinddn"] = $data["ldapbinddn"];
        }

        /* ldapbindpassword */
        if (isset($data["ldapbindpassword"]) === TRUE) {
            $disp_data["ldapbindpassword"] = $data["ldapbindpassword"];
        }

        /* ldapfilter */
        if (isset($data["ldapfilter"]) === TRUE) {
            $disp_data["ldapfilter"] = $data["ldapfilter"];
        }
    }

    return;

}
/*********************************************************
 * make_def_tmpl
 *
 * ƥץ졼ȥե
 *
 * []
 *       $filename      ե̾
 *
 * [֤]
 *      TRUE            
 *      FALSE           
 **********************************************************/
function make_def_tmpl($filename)
{
    global $err_msg;
    global $basedir;

    /* ǥեȤΥƥץ졼ȥեѥ */
    $def_tmpl = $basedir .  ETCDIR . DEF_TMPL;

    /* ǥեȤΥƥץ졼ȥեå */
    if (is_readable_file($def_tmpl) === FALSE) {
        return FALSE;
    }

    /* ե륳ԡ */
    if (copy($def_tmpl, $filename) === FALSE) {
        $err_msg = "ƥץ졼ȥեκ˼Ԥޤ";
        return FALSE;
    }

    return TRUE;

}

/***********************************************************
 * 
 **********************************************************/

/* 󥹥󥹺 */
$pg = new my_page();

/* ե륿ִեɹåΥå */
$ret = init();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(NULL);
    exit (1);
}

/* SaMMAեɹ */
$ret = read_samma_conf($web_conf["postldapadmin"]["sammaconf"]);
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(NULL);
    exit (1);
}

/***********************************************************
 * main
 **********************************************************/
/* Ťcommandpass */
if (isset($samma_conf["commandpass"]) === TRUE) {
    $commandpass = $samma_conf["commandpass"];
}

/* ʬ */

/*  */
if (isset($_POST["mod"]) === TRUE) {
    /* ݻѥǡ */
    set_disp_data($_POST, $samma_conf);
    /* ϥå */
    if (check_conf_data($samma_conf) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        /*  */
        if (mod_samma_conf($samma_conf) === FALSE) {
            result_log(OPERATION . ":NG:" . $err_msg);
        /*  */
        } else {
            $err_msg = "ե򹹿ޤ";
            result_log(OPERATION . ":OK:" . $err_msg);
           /* ˥塼̤ */
           dgp_location("../index.php", $err_msg);
           exit (0);
        }
    }

/* 󥻥 */
} elseif (isset($_POST["cancel"]) === TRUE) {
    /* ˥塼̤ */
    dgp_location("../index.php", $err_msg);
    exit (0);

}

/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display(CONTENT);

?>
