<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ɥᥤϿ
 *
 * $RCSfile: add.php,v $
 * $Revision: 1.9 $
 * $Date: 2013/08/30 06:19:52 $
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibldap");
include_once("lib/dglibsamma");

/********************************************************
ƥڡ
*********************************************************/

define("OPERATION", "ɥᥤɲ");
define("TMPLFILE", "samma/samma_admin_sender_add.tmpl");

/***********************************************************
 * set_tag_data()
 *
 * ֤ξ򥻥åȤ
 *
 * []
 *      $tag  ֤
 *
 * [֤]
 *       ʤ
 **********************************************************/
function set_tag_data(&$tag) {
    global $sesskey;
    global $sender_name;
    global $status;

    /* ɥᥤ̾ */
    if (isset($sender_name) === TRUE) {
        $domain = escape_html($sender_name);
    }
    $tag["<<DOMAIN>>"] = $domain;

    /* Ź沽롼 */
    $rule1 = "checked";
    $rule0 = "";

    /* ݻŹȽ */
    if (isset($status) === TRUE) {
        if ($status == 0){
            $rule1 = "";
            $rule0 = "checked";
        }
    }

    $tag["<<RULE_RADIO_ON>>"] = $rule1;
    $tag["<<RULE_RADIO_OFF>>"] = $rule0;

    return TRUE;

}

/*********************************************************
 * check_senderadd_dbdata
 *
 * ϿǡΥå
 *
 * []
 *      $add_data       ɲåǡ
 *      $status         饸ܥ
 *
 * [֤]
 *      TRUE            
 *      FALSE           ۾
 **********************************************************/
function check_senderadd_dbdata($add_data, $status)
{
    global $err_msg;

    /* Ͷå*/
    if ($add_data == "") {
        $err_msg = "ɥᥤ̾/᡼륢ɥ쥹ϤƤޤ";
        return FALSE;
    }

    /* ɥᥤ/᡼륢ɥ쥹å */
    $ret = check_samma_mail($add_data);
    if ($ret === FALSE) {
        $err_msg = "ɥᥤ̾/᡼륢ɥ쥹" . $err_msg;
        return FALSE;
    }

    /* Ź沽롼å */
    if (check_flg($status) === FALSE) {
        $err_msg = "ѥɤηǤ";
        return FALSE;
    }

   return TRUE;
}

/*********************************************************
 * add_sender_dbdata
 *
 * ǡɲ
 *
 * []
 *      $add_data       ɲåǡ
 *      $status         饸ܥ
 *
 * [֤]
 *      SUCCESS         
 *      FAIL            ۾
 *      FAIL_EXIST      ۾(˥ǡ)
 **********************************************************/
function add_sender_dbdata($add_data, $status)
{
    global $db_file;
    global $db_type;

    /* Ͽɥ쥹Ѵ */
    if ($status == 0) {
        $domain = "!" . $add_data;
        $check_domain = $add_data;
    } else {
        $domain = $add_data;
        $check_domain = "!" . $add_data;
    }

    /* ɥᥤ/᡼륢ɥ쥹Ͽ */
    $ret = db_add($db_file, $db_type, $domain, $check_domain, "");
    if ($ret !== SUCCESS) {
        return $ret;
    }

    return SUCCESS;
}

/***********************************************************
 * 
 **********************************************************/
/* ѿν */
$err_msg = "";
$sender_name = "";
$status = 1;
$del_list = "";
$tag = array();

/* POSTϤäƤͤ */
if (isset($_POST["sender_name"]) === TRUE) {
    $sender_name = strtolower($_POST["sender_name"]);
}
if (isset($_POST["status"]) === TRUE) {
    $status = $_POST["status"];
}
if (isset($_POST["delete"]) === TRUE) {
    $del_list = $_POST["delete"];
}

/* å󥭡ѿ */
if (isset ($_POST["sk"]) === TRUE) {
    $sesskey = $_POST["sk"];
}

/* ե롦ִեɹåå */
$ret = init();
if ($ret === FALSE) {
    syserr_display();
    exit (1);
}

/* SaMMAեɹ */
$ret = read_samma_conf($web_conf["postldapadmin"]["sammaconf"]);
if ($ret === FALSE) {
    result_log(OPERATION . ":NG:" . $err_msg);
    syserr_display();
    exit (1);
}

/***********************************************************
 * main
 **********************************************************/

/* DBեѥ */
$db_file = "";
$db_type = "";
if (isset($samma_conf["senderdb"]) === TRUE) {
    $files = explode(":", $samma_conf["senderdb"], 2);
    $db_type = $files[0];
    $db_file = $files[1];
} else {
    $err_msg = "DBե뤬ꤵƤޤ";
    result_log(OPERATION . ":NG:" . $err_msg);
    syserr_display();
    exit (1);
}

/* Ͽܥ󤬲줿Ȥ */
if (isset($_POST["add"]) === TRUE) {

    /* ϥǡͥå */
    $ret = check_senderadd_dbdata($sender_name, $status);
    if ($ret === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        /* ɥᥤ/᡼륢ɥ쥹Ͽ */
        $ret = add_sender_dbdata($sender_name, $status);
        if ($ret === FAIL_EXIST) {
            $err_msg = "ɥᥤ" . $err_msg;
            result_log(OPERATION . ":NG:" . $err_msg);
        } elseif ($ret !== SUCCESS) {
            result_log(OPERATION . ":NG:" . $err_msg);
            syserr_display();
            exit (1);
        } else {
            /* ｪλ */
            $err_msg =  "ɥᥤϿޤ(" . $sender_name . ")";
            result_log(OPERATION . ":OK:" . $err_msg);

            /* ɥᥤ̤ */
            dgp_location("index.php", $err_msg);
            exit (0);
        }
    }

/* 󥻥ܥ󤬲줿Ȥ */
} elseif (isset($_POST["cancel"]) === TRUE) {

    /* ɥᥤ̤ */
    dgp_location("index.php");
    exit (0);
}

/***********************************************************
 * ɽ
 **********************************************************/
/* ̤Υ */
set_tag_common($tag);

/* bodyɽ */
set_tag_data($tag);

/* ڡν */
$ret = display(TMPLFILE, $tag, array(), "", "");
if ($ret === FALSE) {
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}

?>
