/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.constant.Constable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import jp.riken.brain.ni.samuraigraph.application.SGFigureIDSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGMultiDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGXYDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGConstants;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure;

class Connect
extends Thread
implements ActionListener,
WindowListener,
DropTargetListener {
    private Class mClassOfAxisElement = null;
    private Class mClassOfSXYGraphElement = null;
    private Class mClassOfVXYGraphElement = null;
    private Class mClassOfLegendElement = null;
    private Class mClassOfStringElement = null;
    public final String PROPERTY_FILE_READ_MSG_DIALOG_TITLE = "Property file has read.";
    public final String MSG_SUCCESSFUL_COMPLETION = "\u6b63\u5e38\u7d42\u4e86";
    public final String ERRMSG_PROPERTY_FILE_INCORRECT = "\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u304c\u4e0d\u6b63\u3067\u3059\u3002";
    public final String ERRMSG_DATA_TYPE_INCORRECT = "\u30c7\u30fc\u30bf\u306e\u30bf\u30a4\u30d7\u304c\u9055\u3044\u307e\u3059\u3002";
    public final String ERRMSG_DATA_NUMBER_SHORTAGE = "\u30c7\u30fc\u30bf\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
    public final String ERRMSG_DATA_NUMBER_EXCESS = "\u30c7\u30fc\u30bf\u6570\u304c\u904e\u5270\u3067\u3059\u3002";
    public final String ERRMSG_FILE_OPEN_FAILURE = "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    private float mRulerUnit = 0.035277776f;
    private ServerSocket mServerSocket = null;
    private TreeMap mWndMap = new TreeMap();
    private ArrayList mDataList = new ArrayList();
    private ArrayList mDataFileNameList = new ArrayList();
    public static final String DEFAULT_CLASS_NAME_OF_AXIS_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisElement";
    public static final String DEFAULT_CLASS_NAME_OF_SXY_GRAPH_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGSXYGraphElement";
    public static final String DEFAULT_CLASS_NAME_OF_VXY_GRAPH_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGVXYGraphElement";
    public static final String DEFAULT_CLASS_NAME_OF_STRING_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElement";
    public static final String DEFAULT_CLASS_NAME_OF_LEGEND_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendElement";
    public static final int MAX_WINDOW_ID = 256;
    private SGFigureIDSelectionWizardDialog mFigureIDSelectionWizardDialog = null;
    private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialog = null;
    private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
    private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialog = null;
    private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialogFromCLorDD = null;
    private SGPropertyFileChooserWizardDialog mPropertyFileChooserWizardDilaog = null;
    private String mTempDataFileType = null;
    public static final String TITLE_FILE_CHECK = "\u30d5\u30a1\u30a4\u30eb\u306e\u30c1\u30a7\u30c3\u30af";
    private boolean mCarryOnWizardFlag = true;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGVXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData;

    public Connect() {
    }

    public Connect(ServerSocket serverSocket) {
        this.mServerSocket = serverSocket;
        this.start();
    }

    public void run() {
        if (!this.setFigureElementClass()) {
            System.out.println("\u30af\u30e9\u30b9\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        if (!this.createNewWindow()) {
            System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        while (true) {
            try {
                while (true) {
                    String string;
                    Socket socket = this.mServerSocket.accept();
                    PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while ((string = bufferedReader.readLine()) != null) {
                        arrayList.add(new String(string));
                    }
                    if (arrayList.size() == 0) {
                        System.out.println("\u5165\u529b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        continue;
                    }
                    String[] stringArray = new String[arrayList.size()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = (String)arrayList.get(i);
                    }
                    if (!this.executeCommand(stringArray)) continue;
                    bufferedReader.close();
                    printWriter.close();
                    socket.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private boolean setFigureElementClass() {
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream("ListOfFigureElement.txt");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mClassOfAxisElement = Class.forName(DEFAULT_CLASS_NAME_OF_AXIS_ELEMENT);
                this.mClassOfSXYGraphElement = Class.forName(DEFAULT_CLASS_NAME_OF_SXY_GRAPH_ELEMENT);
                this.mClassOfVXYGraphElement = Class.forName(DEFAULT_CLASS_NAME_OF_VXY_GRAPH_ELEMENT);
                this.mClassOfStringElement = Class.forName(DEFAULT_CLASS_NAME_OF_STRING_ELEMENT);
                this.mClassOfLegendElement = Class.forName(DEFAULT_CLASS_NAME_OF_LEGEND_ELEMENT);
                return true;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            Class<?> clazz = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if ((string = SGUtilityText.getPropertyFromLine(string, "SGAxisElement")) == null) {
                return false;
            }
            clazz = Class.forName(string);
            if (!(clazz.newInstance() instanceof SGIAxisElement)) {
                return false;
            }
            this.mClassOfAxisElement = clazz;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if ((string = SGUtilityText.getPropertyFromLine(string, "SGSXYGraphElement")) == null) {
                return false;
            }
            clazz = Class.forName(string);
            if (!(clazz.newInstance() instanceof SGIGraphElement)) {
                return false;
            }
            this.mClassOfSXYGraphElement = clazz;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if ((string = SGUtilityText.getPropertyFromLine(string, "SGVXYGraphElement")) == null) {
                return false;
            }
            clazz = Class.forName(string);
            if (!(clazz.newInstance() instanceof SGIGraphElement)) {
                return false;
            }
            this.mClassOfVXYGraphElement = clazz;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if ((string = SGUtilityText.getPropertyFromLine(string, "SGLegendElement")) == null) {
                return false;
            }
            clazz = Class.forName(string);
            if (!(clazz.newInstance() instanceof SGILegendElement)) {
                return false;
            }
            this.mClassOfLegendElement = clazz;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if ((string = SGUtilityText.getPropertyFromLine(string, "SGStringElement")) == null) {
                return false;
            }
            clazz = Class.forName(string);
            if (!(clazz.newInstance() instanceof SGIStringElement)) {
                return false;
            }
            this.mClassOfStringElement = clazz;
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean executeCommand(String[] stringArray) {
        boolean bl = true;
        if ("wopen".equals(stringArray[0])) {
            bl = this.wopen(stringArray);
        } else if ("addData".equals(stringArray[0])) {
            bl = this.addData(stringArray);
        } else if ("readProperty".equals(stringArray[0])) {
            bl = this.readWindowProperty(stringArray);
        } else {
            System.out.println("\u30b3\u30de\u30f3\u30c9\u540d\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return false;
        }
        return bl;
    }

    private boolean wopen(String[] stringArray) {
        int n;
        Object object;
        if (stringArray.length < 1) {
            return false;
        }
        if (stringArray.length > 1) {
            object = stringArray[1];
            Integer n2 = this.getWindowIDFromString((String)object);
            if (n2 == null) {
                return false;
            }
            n = n2;
        } else {
            n = this.getCurrentWindowID();
        }
        object = this.getWindow(n);
        if (object != null) {
            System.out.println("\u305d\u306e\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        object = this.createWindow(n);
        if (object == null) {
            return false;
        }
        ((Window)object).show();
        return true;
    }

    private SGDrawingWindow getWindowForCommand(int n) {
        SGDrawingWindow sGDrawingWindow = this.getWindow(n);
        if (sGDrawingWindow == null) {
            System.out.println("\u6307\u5b9a\u3055\u308c\u305f\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u3092\u65b0\u898f\u4f5c\u6210\u3057\u307e\u3059\u3002");
            sGDrawingWindow = this.createWindow(n);
            if (sGDrawingWindow == null) {
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return null;
            }
        }
        return sGDrawingWindow;
    }

    private Integer getWindowIDFromString(String string) {
        Integer n;
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            System.out.println("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return null;
        }
        int n2 = n;
        if (n2 < 1) {
            System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u756a\u53f7\u306f\u6b63\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
            return null;
        }
        if (n2 > 256) {
            System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u756a\u53f7\u304c\u5927\u304d\u904e\u304e\u307e\u3059\u3002");
            return null;
        }
        return n;
    }

    private boolean addData(String[] stringArray) {
        int n;
        int n2;
        Object object;
        if (stringArray.length < 2) {
            System.out.println("\u30b3\u30de\u30f3\u30c9\u5f15\u6570\u304c\u8db3\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        String string = stringArray[1];
        if (stringArray.length > 2) {
            object = stringArray[2];
            Integer n3 = this.getWindowIDFromString((String)object);
            if (n3 == null) {
                return false;
            }
            n2 = n3;
        } else {
            n2 = this.getCurrentWindowID();
        }
        object = this.getWindowForCommand(n2);
        if (object == null) {
            return false;
        }
        if (stringArray.length > 3) {
            String string2 = stringArray[3];
            n = Integer.valueOf(string2);
        } else {
            n = ((SGDrawingWindow)object).getCurrentFigureId();
        }
        this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)object, true);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setEnabled(false);
        boolean bl = this.addDataToFigure((SGDrawingWindow)object, n, string);
        return bl;
    }

    private boolean readWindowProperty(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("\u5f15\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        String string = stringArray[1];
        this.mDataFileNameList.clear();
        for (int i = 2; i < stringArray.length; ++i) {
            this.mDataFileNameList.add(stringArray[i]);
        }
        SGDrawingWindow sGDrawingWindow = null;
        try {
            sGDrawingWindow = this.createWindowFromPropertyFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sGDrawingWindow == null) {
            System.out.println("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        return true;
    }

    private boolean readFigureProperty(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("\u5f15\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        int n = -1;
        try {
            n = Integer.valueOf(stringArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SGDrawingWindow sGDrawingWindow = this.getWindow(n);
        if (sGDrawingWindow == null) {
            System.out.println("\u6307\u5b9a\u3055\u308c\u305f\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        this.mDataFileNameList.clear();
        for (int i = 2; i < stringArray.length; ++i) {
            this.mDataFileNameList.add(stringArray[i]);
        }
        return true;
    }

    private boolean addDataToFigure(SGDrawingWindow sGDrawingWindow, int n, String string) {
        int n2;
        SGData sGData = this.createDataFromFile(string);
        if (sGData == null) {
            System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        SGFigure sGFigure = sGDrawingWindow.getFigure(n);
        boolean bl = false;
        if ((sGFigure == null || sGFigure != null && !sGFigure.isVisible()) && (sGFigure = this.createFigure(n, sGDrawingWindow, sGData)) == null) {
            return false;
        }
        if (!sGFigure.addData(sGData)) {
            System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (!sGFigure.initGraphAreaLocation()) {
            return false;
        }
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (n2 = 0; n2 < sGIFigureElementArray.length; ++n2) {
            sGIFigureElementArray[n2].chkBoundsVisible();
        }
        for (n2 = 0; n2 < sGIFigureElementArray.length; ++n2) {
            sGIFigureElementArray[n2].addPropertiesHistory();
        }
        sGDrawingWindow.addPropertiesHistory();
        TreeMap treeMap = sGDrawingWindow.getFigureMap();
        if (!treeMap.containsValue(sGFigure)) {
            sGDrawingWindow.addFigure(n, sGFigure);
        }
        sGDrawingWindow.addPropertiesHistory();
        sGFigure.addPropertiesHistory();
        sGDrawingWindow.show();
        return true;
    }

    private boolean setWindowLocation(SGDrawingWindow sGDrawingWindow) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(dimension.getWidth() - (double)sGDrawingWindow.getWidth()) / 2;
        int n2 = (int)(dimension.getHeight() - (double)sGDrawingWindow.getHeight()) / 2;
        sGDrawingWindow.setLocation(n, n2);
        return true;
    }

    public SGDrawingWindow getWindow(int n) {
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)this.mWndMap.get(new Integer(n));
        if (sGDrawingWindow == null) {
            return null;
        }
        return sGDrawingWindow;
    }

    private SGFigure createFigure(int n, SGDrawingWindow sGDrawingWindow, SGData sGData) {
        SGFigure sGFigure = null;
        if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
            sGFigure = new SGSXYFigure(sGDrawingWindow);
        } else if (sGData instanceof SGVXYData) {
            sGFigure = new SGVXYFigure(sGDrawingWindow);
        } else {
            System.out.println("\u5bfe\u5fdc\u3059\u308b\u30c7\u30fc\u30bf\u578b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            return null;
        }
        sGFigure.setID(n);
        if (!this.createFigureElements(sGFigure, sGData)) {
            return null;
        }
        float f = 425.19687f;
        float f2 = f / SGConstants.GOLDEN_RATIO;
        sGFigure.setGraphAreaSize(f, f2);
        return sGFigure;
    }

    private boolean createFigureElements(SGFigure sGFigure, SGData sGData) {
        try {
            SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
            Object t = this.mClassOfAxisElement.newInstance();
            JComponent jComponent = (JComponent)t;
            jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent.setVisible(true);
            jComponent.setOpaque(false);
            sGFigure.add(jComponent);
            sGFigure.setLayer(jComponent, 20);
            SGIAxisElement sGIAxisElement = (SGIAxisElement)t;
            sGFigure.setAxisElement(sGIAxisElement);
            sGIAxisElement.addActionListener(sGFigure);
            sGIAxisElement.setDialogOwner(sGDrawingWindow);
            Object var7_8 = null;
            if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
                var7_8 = this.mClassOfSXYGraphElement.newInstance();
            } else if (sGData instanceof SGVXYData) {
                var7_8 = this.mClassOfVXYGraphElement.newInstance();
            } else {
                System.out.println("\u5bfe\u5fdc\u3059\u308b\u30c7\u30fc\u30bf\u578b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            JComponent jComponent2 = var7_8;
            jComponent2.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent2.setVisible(true);
            jComponent2.setOpaque(false);
            sGFigure.add(jComponent2);
            sGFigure.setLayer(jComponent2, 10);
            SGIGraphElement sGIGraphElement = var7_8;
            sGFigure.setGraphElement(sGIGraphElement);
            sGIGraphElement.addActionListener(sGFigure);
            sGIGraphElement.setDialogOwner(sGDrawingWindow);
            Object t2 = this.mClassOfLegendElement.newInstance();
            JComponent jComponent3 = (JComponent)t2;
            jComponent3.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent3.setVisible(true);
            jComponent3.setOpaque(false);
            sGFigure.add(jComponent3);
            sGFigure.setLayer(jComponent3, 30);
            SGILegendElement sGILegendElement = (SGILegendElement)t2;
            sGFigure.setLegendElement(sGILegendElement);
            sGILegendElement.addActionListener(sGFigure);
            sGILegendElement.setDialogOwner(sGDrawingWindow);
            Object t3 = this.mClassOfStringElement.newInstance();
            JComponent jComponent4 = (JComponent)t3;
            jComponent4.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent4.setVisible(true);
            jComponent4.setOpaque(false);
            sGFigure.add(jComponent4);
            sGFigure.setLayer(jComponent4, 40);
            SGIStringElement sGIStringElement = (SGIStringElement)t3;
            sGFigure.setStringElement(sGIStringElement);
            sGIStringElement.addActionListener(sGFigure);
            sGIStringElement.setDialogOwner(sGDrawingWindow);
            sGIGraphElement.setAxisElement(sGIAxisElement);
            sGILegendElement.setGraphElement(sGIGraphElement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private SGData createDataFromFile(String string) {
        ArrayList arrayList = new ArrayList();
        boolean bl = this.readFile(string, arrayList);
        if (!bl) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SGData sGData = this.createData(string, arrayList);
        return sGData;
    }

    private boolean createAllWizardDialogsForDataAdditionFromToolBar(SGDrawingWindow sGDrawingWindow) {
        int n = sGDrawingWindow.getID();
        this.mFigureIDSelectionWizardDialog = new SGFigureIDSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mSingleDataFileChooserWizardDilaog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mXYDataTypeSelectionWizardDialog = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mFigureIDSelectionWizardDialog.setNext(this.mSingleDataFileChooserWizardDilaog);
        this.mSingleDataFileChooserWizardDilaog.setPrevious(this.mFigureIDSelectionWizardDialog);
        this.mSingleDataFileChooserWizardDilaog.setNext(this.mXYDataTypeSelectionWizardDialog);
        this.mXYDataTypeSelectionWizardDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
        this.mFigureIDSelectionWizardDialog.addActionListener(this);
        this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
        this.mXYDataTypeSelectionWizardDialog.addActionListener(this);
        return true;
    }

    private boolean createAllWizardDialogsToLoadPropertyFromToolBar(SGDrawingWindow sGDrawingWindow) {
        int n = sGDrawingWindow.getID();
        this.mPropertyFileChooserWizardDilaog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mMultiDataFileChooserWizardDialog = new SGMultiDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mPropertyFileChooserWizardDilaog.setNext(this.mMultiDataFileChooserWizardDialog);
        this.mMultiDataFileChooserWizardDialog.setPrevious(this.mPropertyFileChooserWizardDilaog);
        this.mPropertyFileChooserWizardDilaog.addActionListener(this);
        this.mMultiDataFileChooserWizardDialog.addActionListener(this);
        return true;
    }

    private boolean getFileTypeCandidateList(String string, ArrayList arrayList, ArrayList arrayList2) {
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = SGUtilityText.readLine(bufferedReader);
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
            if (string2 == null) {
                return false;
            }
            ArrayList arrayList3 = new ArrayList();
            SGUtilityText.tokenize(string2, arrayList3);
            int n = arrayList3.size();
            if (n == 0) {
                return false;
            }
            if (n == 2 || n == 3 || n == 5) {
                if (this.evaluateDataTypeSXY(arrayList3)) {
                    arrayList.add("SXY");
                }
            } else if (n == 4 && this.evaluateDataTypeSXY(arrayList3)) {
                arrayList.add("SXY");
            }
            if (n >= 2 && this.evaluateDataTypeSXYMultiple(arrayList3)) {
                arrayList.add("SXY_MULTIPLE");
            }
            if (n >= 1 && this.evaluateDataTypeSXYMultiple(arrayList3)) {
                arrayList.add("SXY_SAMPLING");
            }
            arrayList2.add(new Integer(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean evaluateDataTypeSXY(ArrayList arrayList) {
        int n = 0;
        if (arrayList.size() == 2 || arrayList.size() == 4) {
            n = arrayList.size();
        } else if (arrayList.size() == 3) {
            n = 2;
        } else if (arrayList.size() == 5) {
            n = 4;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            try {
                Double d = Double.valueOf(string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private boolean evaluateDataTypeSXYMultiple(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            try {
                Double d = Double.valueOf(string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private boolean readFile(String string, ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        if (!this.getFileTypeCandidateList(string, arrayList2, arrayList3)) {
            return false;
        }
        if (arrayList2.size() == 0) {
            System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return false;
        }
        String string2 = null;
        if (!this.mXYDataTypeSelectionWizardDialogFromCLorDD.setEffectiveDataType(arrayList2)) {
            return false;
        }
        Window window = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getOwner();
        int n = window.getX();
        int n2 = window.getY();
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.setLocation(n, n2);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.show();
        if (!this.mCarryOnWizardFlag) {
            return false;
        }
        string2 = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSelectedDataType();
        if (string2 == null) {
            return false;
        }
        arrayList.add(string2);
        if (string2.equals("SXY_SAMPLING")) {
            Double d = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSamplingRate();
            if (d == null) {
                return false;
            }
            arrayList.add(d);
        }
        return true;
    }

    private boolean readFile2(String string, ArrayList arrayList) {
        String string2 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string2 == null) {
            return false;
        }
        arrayList.add(string2);
        if (string2.equals("SXY_SAMPLING")) {
            Double d = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
            if (d == null) {
                return false;
            }
            arrayList.add(d);
        }
        return true;
    }

    private SGData createData(String string, ArrayList arrayList) {
        if (string == null || arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SGData sGData = null;
        String string2 = (String)arrayList.get(0);
        if (string2.equals("SXY")) {
            sGData = this.createSXYData(string);
        } else if (!string2.equals("VXY")) {
            if (string2.equals("SXY_MULTIPLE")) {
                sGData = this.createSXYMultipleData(string);
            } else if (string2.equals("SXY_SAMPLING")) {
                if (arrayList.size() <= 1) {
                    return null;
                }
                double d = (Double)arrayList.get(1);
                sGData = this.createSXYSamplingData(string, d);
            }
        }
        return sGData;
    }

    private int getColumnNumber(String string) {
        int n = -1;
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return n;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = SGUtilityText.readLine(bufferedReader);
            if (string2 == null) {
                return n;
            }
            ArrayList arrayList = new ArrayList();
            SGUtilityText.tokenize(string2, arrayList);
            n = arrayList.size();
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private ArrayList[] createListArray(String string, int n) {
        ArrayList[] arrayListArray = new ArrayList[n];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = SGUtilityText.readLine(bufferedReader)) != null) {
                ArrayList arrayList = new ArrayList();
                SGUtilityText.tokenize(string2, arrayList);
                if (arrayList.size() != n) {
                    return null;
                }
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)arrayList.get(i);
                    arrayListArray[i].add(string3);
                }
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return arrayListArray;
    }

    private SGSXYData createSXYData(String string) {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList[] arrayListArray = this.createListArray(string, n);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYData sGSXYData = null;
        try {
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = Double.valueOf((String)arrayListArray[0].get(i));
                dArray2[i] = Double.valueOf((String)arrayListArray[1].get(i));
            }
            double[] dArray3 = null;
            double[] dArray4 = null;
            String[] stringArray = null;
            switch (n) {
                case 2: {
                    break;
                }
                case 4: {
                    dArray3 = new double[n2];
                    dArray4 = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray3[i] = Double.valueOf((String)arrayListArray[2].get(i));
                        dArray4[i] = Double.valueOf((String)arrayListArray[3].get(i));
                    }
                    break;
                }
                case 3: {
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = (String)arrayListArray[2].get(i);
                    }
                    break;
                }
                case 5: {
                    dArray3 = new double[n2];
                    dArray4 = new double[n2];
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray3[i] = Double.valueOf((String)arrayListArray[2].get(i));
                        dArray4[i] = Double.valueOf((String)arrayListArray[3].get(i));
                        stringArray[i] = (String)arrayListArray[4].get(i);
                    }
                    break;
                }
            }
            sGSXYData = new SGSXYData(dArray, dArray2, dArray3, dArray4, stringArray);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return sGSXYData;
    }

    private SGSXYMultipleData createSXYMultipleData(String string) {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList[] arrayListArray = this.createListArray(string, n);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYMultipleData sGSXYMultipleData = null;
        try {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = Double.valueOf((String)arrayListArray[0].get(i));
            }
            double[][] dArrayArray = new double[n - 1][];
            for (int i = 0; i < n - 1; ++i) {
                dArrayArray[i] = new double[n2];
                for (int j = 0; j < n2; ++j) {
                    dArrayArray[i][j] = Double.valueOf((String)arrayListArray[i + 1].get(j));
                }
            }
            sGSXYMultipleData = new SGSXYMultipleData(dArray, dArrayArray);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return sGSXYMultipleData;
    }

    private SGSXYMultipleData createSXYSamplingData(String string, double d) {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        ArrayList[] arrayListArray = this.createListArray(string, n);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYSamplingData sGSXYSamplingData = null;
        try {
            double[][] dArrayArray = new double[n][];
            for (int i = 0; i < n; ++i) {
                dArrayArray[i] = new double[n2];
                for (int j = 0; j < n2; ++j) {
                    dArrayArray[i][j] = Double.valueOf((String)arrayListArray[i].get(j));
                }
            }
            sGSXYSamplingData = new SGSXYSamplingData(d, (double[][])dArrayArray);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return sGSXYSamplingData;
    }

    private SGDrawingWindow createWindow() {
        int n = this.getCurrentWindowID();
        SGDrawingWindow sGDrawingWindow = this.createWindow(n);
        return sGDrawingWindow;
    }

    private SGDrawingWindow createWindow(int n) {
        SGDrawingWindow sGDrawingWindow = new SGDrawingWindow();
        this.addWindow(n, sGDrawingWindow);
        this.initWindow(sGDrawingWindow);
        return sGDrawingWindow;
    }

    private boolean initWindow(SGDrawingWindow sGDrawingWindow) {
        sGDrawingWindow.addActionListener(this);
        sGDrawingWindow.addWindowListener(this);
        sGDrawingWindow.setDefaultCloseOperation(2);
        DropTarget dropTarget = new DropTarget(sGDrawingWindow, 3, this, true);
        sGDrawingWindow.setDropTarget(dropTarget);
        sGDrawingWindow.setLocation(100, 100);
        return sGDrawingWindow.init();
    }

    private boolean addWindow(SGDrawingWindow sGDrawingWindow) {
        if (sGDrawingWindow == null) {
            return false;
        }
        boolean bl = this.addWindow(this.getCurrentWindowID(), sGDrawingWindow);
        return bl;
    }

    private int getCurrentWindowID() {
        int n = this.mWndMap.size() == 0 ? 1 : (Integer)this.mWndMap.lastKey() + 1;
        return n;
    }

    private boolean addWindow(int n, SGDrawingWindow sGDrawingWindow) {
        sGDrawingWindow.setID(n);
        String string = "Window:" + n;
        sGDrawingWindow.setTitle(string);
        this.mWndMap.put(new Integer(n), sGDrawingWindow);
        return true;
    }

    private int createWindowFromPropertyFile(SGDrawingWindow sGDrawingWindow, InputStream inputStream, InputStreamReader inputStreamReader, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        if (!string.equals("[Window]")) {
            return 1;
        }
        float f = this.mRulerUnit;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "Paper Width");
        if (d == null) {
            return 1;
        }
        float f2 = d.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Paper Height");
        if (d2 == null) {
            return 1;
        }
        float f3 = d2.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Grid Interval");
        if (d3 == null) {
            return 1;
        }
        float f4 = d3.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Grid Line Width");
        if (d4 == null) {
            return 1;
        }
        float f5 = d4.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, "Background Color");
        if (color == null) {
            return 1;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        Color color2 = SGUtilityText.getColorPropertyFromLine(string, "Grid Line Color");
        if (color2 == null) {
            return 1;
        }
        sGDrawingWindow.setPaperSize(f2, f3);
        sGDrawingWindow.setBackgroundColor(color);
        sGDrawingWindow.setGridInterval(f4);
        sGDrawingWindow.setGridLineWidth(f5);
        sGDrawingWindow.setGridLineColor(color2);
        sGDrawingWindow.addPropertiesHistory();
        int n = this.createFiguresFromPropertyFile(bufferedReader, sGDrawingWindow);
        if (n == 4 || n == 1 || n == 6) {
            return n;
        }
        System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u6b8b\u308a\uff1a" + this.mDataFileNameList.size());
        n = this.mDataFileNameList.size() != 0 ? 5 : 0;
        return n;
    }

    public SGDrawingWindow createWindowFromPropertyFile(String string) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.out.println("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        SGDrawingWindow sGDrawingWindow = this.createWindow();
        int n = this.createWindowFromPropertyFile(sGDrawingWindow, fileInputStream, inputStreamReader, bufferedReader);
        String string2 = null;
        if (n == 0) {
            string2 = "\u6b63\u5e38\u7d42\u4e86";
        } else if (n == 4) {
            string2 = "\u30c7\u30fc\u30bf\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
        } else if (n == 5) {
            string2 = "\u30c7\u30fc\u30bf\u6570\u304c\u904e\u5270\u3067\u3059\u3002";
        } else if (n == 6) {
            string2 = "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        } else if (n == 1) {
            string2 = "\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u304c\u4e0d\u6b63\u3067\u3059\u3002";
        } else {
            throw new Error();
        }
        sGDrawingWindow.show();
        if (string2 != "\u6b63\u5e38\u7d42\u4e86") {
            SGUtility.showMessageDialog(sGDrawingWindow, string2, "Property file has read.", 0);
        }
        if (n == 1) {
            sGDrawingWindow.hide();
            this.removeWindow(sGDrawingWindow);
        }
        bufferedReader.close();
        inputStreamReader.close();
        ((InputStream)fileInputStream).close();
        return sGDrawingWindow;
    }

    private int createFiguresFromPropertyFile(BufferedReader bufferedReader, SGDrawingWindow sGDrawingWindow) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = null;
        bufferedReader.mark(256);
        while (true) {
            int n;
            int n2;
            String string2;
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                return 3;
            }
            if (!string.equals("[Figure]")) break;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            String string3 = SGUtilityText.getPropertyFromLine(string, "Class Name");
            if (string3 == null) {
                return 1;
            }
            if (string3.equals("SXY")) {
                string2 = (class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure == null ? Connect.class$("jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure") : class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure).getName();
            } else if (string3.equals("VXY")) {
                string2 = (class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure == null ? Connect.class$("jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure") : class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure).getName();
            } else {
                return 1;
            }
            Class<?> clazz = Class.forName(string2);
            SGFigure sGFigure = (SGFigure)clazz.newInstance();
            sGFigure.setWindow(sGDrawingWindow);
            int n3 = sGDrawingWindow.getCurrentFigureId();
            sGFigure.setID(n3);
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Double d = SGUtilityText.getDoublePropertyFromLine(string, "X");
            if (d == null) {
                return 1;
            }
            float f = d.floatValue() / 0.035277776f;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Y");
            if (d2 == null) {
                return 1;
            }
            float f2 = d2.floatValue() / 0.035277776f;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Width");
            if (d3 == null) {
                return 1;
            }
            float f3 = d3.floatValue() / 0.035277776f;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Height");
            if (d4 == null) {
                return 1;
            }
            float f4 = d4.floatValue() / 0.035277776f;
            sGFigure.setGraphAreaLocation(f, f2);
            sGFigure.setGraphAreaSize(f3, f4);
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Double d5 = SGUtilityText.getDoublePropertyFromLine(string, "Space between Axis Line and Numbers");
            if (d5 == null) {
                return 1;
            }
            float f5 = d5.floatValue() / 0.035277776f;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Double d6 = SGUtilityText.getDoublePropertyFromLine(string, "Space between Numbers and Title");
            if (d6 == null) {
                return 1;
            }
            float f6 = d6.floatValue() / 0.035277776f;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Color color = SGUtilityText.getColorPropertyFromLine(string, "Background Color");
            if (color == null) {
                return 1;
            }
            sGFigure.setBackgroundColor(color);
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Transparency");
            if (bl == null) {
                return 1;
            }
            boolean bl2 = bl;
            sGFigure.setTransparent(bl2);
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return 1;
            } while (string.length() == 0);
            Boolean bl3 = SGUtilityText.getBooleanPropertyFromLine(string, "Legend Visible");
            if (bl3 == null) {
                return 1;
            }
            boolean bl4 = bl3;
            int n4 = this.createAxisElementFromPropertyFile(sGFigure, bufferedReader);
            if (n4 == 1 || n4 == 3) {
                return n4;
            }
            SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
            sGIAxisElement.readProperty(bufferedReader);
            sGIAxisElement.setGraphAreaRect(0.0f, 0.0f, f3, f4);
            sGFigure.setSpaceAxisLineAndNumber(f5);
            sGFigure.setSpaceNumberAndTitle(f6);
            n4 = this.createGraphElementFromPropertyFile(sGFigure, bufferedReader);
            if (n4 == 1 || n4 == 3) {
                return n4;
            }
            SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
            sGIGraphElement.readProperty(bufferedReader);
            n4 = this.createLegendElementFromPropertyFile(sGFigure, bufferedReader);
            if (n4 == 1 || n4 == 3) {
                return n4;
            }
            SGILegendElement sGILegendElement = sGFigure.getLegendElement();
            sGILegendElement.readProperty(bufferedReader);
            sGFigure.setLegendVisible(bl4);
            n4 = this.createStringElementFromPropertyFile(sGFigure, bufferedReader);
            if (n4 == 1 || n4 == 3) {
                return n4;
            }
            SGIStringElement sGIStringElement = sGFigure.getStringElement();
            sGIStringElement.readProperty(bufferedReader);
            sGIGraphElement.setAxisElement(sGIAxisElement);
            sGILegendElement.setGraphElement(sGIGraphElement);
            sGFigure.addPropertiesHistory();
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            for (n2 = 0; n2 < sGIFigureElementArray.length; ++n2) {
                sGIFigureElementArray[n2].addPropertiesHistory();
            }
            n2 = sGDrawingWindow.getCurrentFigureId();
            sGDrawingWindow.addFigure(n2, sGFigure);
            n4 = this.createDataObjectsFromPropertyFile(bufferedReader, sGFigure);
            if (n4 == 1 || n4 == 6 || n4 == 4) {
                return n4;
            }
            sGFigure.notifyFigureElement(sGFigure.getAxisElement());
            sGFigure.notifyFigureElement(sGFigure.getGraphElement());
            SGIFigureElement[] sGIFigureElementArray2 = sGFigure.getIFigureElementArray();
            for (n = 0; n < sGIFigureElementArray2.length; ++n) {
                sGIFigureElementArray2[n].chkBoundsVisible();
            }
            for (n = 0; n < sGIFigureElementArray2.length; ++n) {
                sGIFigureElementArray2[n].addPropertiesHistory();
            }
            bufferedReader.mark(256);
        }
        bufferedReader.reset();
        return 0;
    }

    public boolean createFigureElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int n = this.createAxisElementFromPropertyFile(sGFigure, bufferedReader);
        if (n == 1) {
            return false;
        }
        SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
        n = this.createGraphElementFromPropertyFile(sGFigure, bufferedReader);
        if (n == 1) {
            return false;
        }
        SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
        sGIGraphElement.setAxisElement(sGIAxisElement);
        n = this.createLegendElementFromPropertyFile(sGFigure, bufferedReader);
        if (n == 1) {
            return false;
        }
        SGILegendElement sGILegendElement = sGFigure.getLegendElement();
        sGILegendElement.setGraphElement(sGIGraphElement);
        n = this.createStringElementFromPropertyFile(sGFigure, bufferedReader);
        if (n == 1) {
            return false;
        }
        SGIStringElement sGIStringElement = sGFigure.getStringElement();
        return true;
    }

    public int createStringElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        if (!string.equals("[String]")) {
            return 1;
        }
        Class clazz = this.mClassOfStringElement;
        Object t = clazz.newInstance();
        JComponent jComponent = (JComponent)t;
        jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
        jComponent.setVisible(true);
        jComponent.setOpaque(false);
        sGFigure.add(jComponent);
        sGFigure.setLayer(jComponent, 40);
        SGIStringElement sGIStringElement = (SGIStringElement)t;
        sGFigure.setStringElement(sGIStringElement);
        sGIStringElement.addActionListener(sGFigure);
        sGIStringElement.setDialogOwner(sGFigure.getWindow());
        return 0;
    }

    public int createAxisElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        if (!string.equals("[Axis]")) {
            return 1;
        }
        Class clazz = this.mClassOfAxisElement;
        Object t = clazz.newInstance();
        JComponent jComponent = (JComponent)t;
        jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
        jComponent.setVisible(true);
        jComponent.setOpaque(false);
        sGFigure.add(jComponent);
        sGFigure.setLayer(jComponent, 20);
        SGIAxisElement sGIAxisElement = (SGIAxisElement)t;
        sGFigure.setAxisElement(sGIAxisElement);
        sGIAxisElement.addActionListener(sGFigure);
        sGIAxisElement.setDialogOwner(sGFigure.getWindow());
        return 0;
    }

    public int createGraphElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz;
        Object var3_3 = null;
        if (sGFigure instanceof SGSXYFigure) {
            clazz = this.mClassOfSXYGraphElement;
        } else if (sGFigure instanceof SGVXYFigure) {
            clazz = this.mClassOfVXYGraphElement;
        } else {
            throw new Error();
        }
        Object t = clazz.newInstance();
        JComponent jComponent = (JComponent)t;
        jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
        jComponent.setVisible(true);
        jComponent.setOpaque(false);
        sGFigure.add(jComponent);
        sGFigure.setLayer(jComponent, 10);
        SGIGraphElement sGIGraphElement = (SGIGraphElement)t;
        sGFigure.setGraphElement(sGIGraphElement);
        sGIGraphElement.addActionListener(sGFigure);
        sGIGraphElement.setDialogOwner(sGFigure.getWindow());
        return 0;
    }

    public int createLegendElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        if (!string.equals("[Legend]")) {
            return 1;
        }
        Class clazz = this.mClassOfLegendElement;
        Object t = clazz.newInstance();
        JComponent jComponent = (JComponent)t;
        jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
        jComponent.setVisible(true);
        jComponent.setOpaque(false);
        sGFigure.add(jComponent);
        sGFigure.setLayer(jComponent, 30);
        SGILegendElement sGILegendElement = (SGILegendElement)t;
        sGFigure.setLegendElement(sGILegendElement);
        sGILegendElement.addActionListener(sGFigure);
        sGILegendElement.setDialogOwner(sGFigure.getWindow());
        return 0;
    }

    private int createDataObjectsFromPropertyFile(BufferedReader bufferedReader, SGFigure sGFigure) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = null;
        while (true) {
            Constable constable;
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                return 3;
            }
            if (!string.equals("[Data]")) break;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            String string2 = SGUtilityText.getPropertyFromLine(string, "Class Name");
            if (string2 == null) {
                return 1;
            }
            arrayList.add(string2);
            String string3 = null;
            if (string2.equals("SXY")) {
                string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYData == null ? Connect.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYData).getName();
            } else if (string2.equals("VXY")) {
                string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGVXYData == null ? Connect.class$("jp.riken.brain.ni.samuraigraph.data.SGVXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGVXYData).getName();
            } else if (string2.equals("SXY_MULTIPLE")) {
                string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData == null ? Connect.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData).getName();
            } else if (string2.equals("SXY_SAMPLING")) {
                string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData == null ? Connect.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData).getName();
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return 2;
                }
                constable = SGUtilityText.getDoublePropertyFromLine(string, "Sampling Rate");
                if (constable == null) {
                    return 2;
                }
                arrayList.add(constable);
            } else {
                return 2;
            }
            constable = Class.forName(string3);
            SGData sGData = (SGData)constable.newInstance();
            if (this.mDataFileNameList.size() == 0) {
                return 4;
            }
            String string4 = (String)this.mDataFileNameList.remove(0);
            SGData sGData2 = this.createData(string4, arrayList);
            if (sGData2 == null) {
                System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return 6;
            }
            boolean bl = sGData.setData(sGData2);
            if (!bl) {
                return 2;
            }
            boolean bl2 = sGFigure.createDataObjectFromPropertyFile(bufferedReader, sGData);
            if (!bl2) {
                return 1;
            }
            bufferedReader.mark(256);
        }
        bufferedReader.reset();
        return 0;
    }

    public boolean createNewWindow() {
        SGDrawingWindow sGDrawingWindow = this.createWindow();
        if (sGDrawingWindow == null) {
            return false;
        }
        sGDrawingWindow.show();
        return true;
    }

    private boolean fromWindow(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
        if (string.equals("open a new window")) {
            this.createNewWindow();
        } else if (string.equals("add new data")) {
            this.createAllWizardDialogsForDataAdditionFromToolBar(sGDrawingWindow);
            this.mFigureIDSelectionWizardDialog.show();
        } else if (string.equals("load property")) {
            this.createAllWizardDialogsToLoadPropertyFromToolBar(sGDrawingWindow);
            this.mPropertyFileChooserWizardDilaog.show();
        }
        return true;
    }

    private boolean fromCLorDDWizardDialog(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.mCarryOnWizardFlag = true;
            sGWizardDialog.hide();
        } else if (string.equals("Cancel")) {
            this.mCarryOnWizardFlag = false;
            sGWizardDialog.hide();
        }
        return true;
    }

    private boolean fromToolBarAddData(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (!object.equals(this.mFigureIDSelectionWizardDialog)) {
            if (object.equals(this.mSingleDataFileChooserWizardDilaog)) {
                if (string.equals("Next")) {
                    String string2 = this.mSingleDataFileChooserWizardDilaog.getFileName();
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    ArrayList arrayList3 = new ArrayList();
                    if (!this.getFileTypeCandidateList(string2, arrayList2, arrayList3)) {
                        return false;
                    }
                    if (arrayList2.size() == 0) {
                        System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                        return false;
                    }
                    if (!this.mXYDataTypeSelectionWizardDialog.setEffectiveDataType(arrayList2)) {
                        return false;
                    }
                }
            } else if (object.equals(this.mXYDataTypeSelectionWizardDialog) && string.equals("OK")) {
                int n;
                Object object2;
                SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
                int n2 = sGDrawingWindow.getID();
                int n3 = this.mFigureIDSelectionWizardDialog.getFigureID();
                String string3 = this.mSingleDataFileChooserWizardDilaog.getFileName();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string4 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
                if (string4 == null) {
                    return false;
                }
                arrayList.add(string4);
                if (string4.equals("SXY_SAMPLING")) {
                    object2 = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                    if (object2 == null) {
                        return false;
                    }
                    arrayList.add(object2);
                }
                if (arrayList.size() == 0) {
                    return false;
                }
                object2 = this.createData(string3, arrayList);
                if (object2 == null) {
                    System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    return false;
                }
                SGFigure sGFigure = sGDrawingWindow.getFigure(n3);
                if ((sGFigure == null || sGFigure != null && !sGFigure.isVisible()) && (sGFigure = this.createFigure(n3, sGDrawingWindow, (SGData)object2)) == null) {
                    return false;
                }
                if (!sGFigure.addData((SGData)object2)) {
                    System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
                    return false;
                }
                if (!sGFigure.initGraphAreaLocation()) {
                    return false;
                }
                SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
                for (n = 0; n < sGIFigureElementArray.length; ++n) {
                    sGIFigureElementArray[n].chkBoundsVisible();
                }
                for (n = 0; n < sGIFigureElementArray.length; ++n) {
                    sGIFigureElementArray[n].addPropertiesHistory();
                }
                sGDrawingWindow.addPropertiesHistory();
                TreeMap treeMap = sGDrawingWindow.getFigureMap();
                if (!treeMap.containsValue(sGFigure)) {
                    sGDrawingWindow.addFigure(n3, sGFigure);
                }
                sGDrawingWindow.addPropertiesHistory();
                sGFigure.addPropertiesHistory();
                sGDrawingWindow.show();
                sGWizardDialog.hide();
            }
        }
        return this.commonActionFromWizardDialog(actionEvent);
    }

    private boolean getFileTypeCandidateListFromPropertyFile(String string, ArrayList arrayList) {
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = SGUtilityText.readLine(bufferedReader)) != null) {
                String string3;
                if (!string2.equals("[Data]")) continue;
                while ((string3 = SGUtilityText.getPropertyFromLine(string2 = SGUtilityText.readLine(bufferedReader), "Class Name")) == null) {
                }
                arrayList.add(string3);
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean fromToolBarLoadProperty(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mPropertyFileChooserWizardDilaog)) {
            if (string.equals("Next")) {
                File file = this.mPropertyFileChooserWizardDilaog.getSelectedFile();
                String string2 = SGUtility.getCanonicalPath(file.getPath());
                if (string2 == null) {
                    SGUtility.showMessageDialog(sGWizardDialog, "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002", TITLE_FILE_CHECK, 0);
                    return false;
                }
                ArrayList arrayList = new ArrayList();
                if (!this.getFileTypeCandidateListFromPropertyFile(string2, arrayList)) {
                    SGUtility.showMessageDialog(sGWizardDialog, "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002", TITLE_FILE_CHECK, 0);
                    return false;
                }
                if (arrayList.size() == 0) {
                    SGUtility.showMessageDialog(sGWizardDialog, "\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u304c\u4e0d\u6b63\u3067\u3059\u3002", TITLE_FILE_CHECK, 0);
                    return false;
                }
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                Object[][] objectArray = new String[stringArray.length][];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = new String[2];
                    objectArray[i][0] = stringArray[i];
                    objectArray[i][1] = null;
                }
                Object[] objectArray2 = new Object[]{"Data Type", "File Name"};
                DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
                this.mMultiDataFileChooserWizardDialog.setTableModel(defaultTableModel);
            }
        } else if (object.equals(this.mMultiDataFileChooserWizardDialog) && string.equals("OK")) {
            File[] fileArray = this.mMultiDataFileChooserWizardDialog.getSelectedFiles();
            this.mDataFileNameList.clear();
            for (int i = 0; i < fileArray.length; ++i) {
                this.mDataFileNameList.add(fileArray[i].getAbsolutePath());
            }
            String string3 = this.mPropertyFileChooserWizardDilaog.getSelectedFile().getAbsolutePath();
            try {
                SGDrawingWindow sGDrawingWindow = this.createWindowFromPropertyFile(string3);
                if (sGDrawingWindow == null) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            sGWizardDialog.hide();
        }
        return this.commonActionFromWizardDialog(actionEvent);
    }

    private boolean commonActionFromWizardDialog(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            sGWizardDialog.hide();
        } else if (string.equals("<Previous")) {
            sGWizardDialog.hide();
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getPrevious();
            if (sGWizardDialog2 != null) {
                sGWizardDialog2.show();
            }
        } else if (string.equals("Next")) {
            sGWizardDialog.hide();
            SGWizardDialog sGWizardDialog3 = sGWizardDialog.getNext();
            if (sGWizardDialog3 != null) {
                sGWizardDialog3.show();
            }
        }
        return true;
    }

    private boolean fromWizardDialog(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mXYDataTypeSelectionWizardDialogFromCLorDD)) {
            return this.fromCLorDDWizardDialog(actionEvent);
        }
        if (object.equals(this.mFigureIDSelectionWizardDialog) || object.equals(this.mSingleDataFileChooserWizardDilaog) || object.equals(this.mXYDataTypeSelectionWizardDialog)) {
            return this.fromToolBarAddData(actionEvent);
        }
        if (object.equals(this.mPropertyFileChooserWizardDilaog) || object.equals(this.mMultiDataFileChooserWizardDialog)) {
            return this.fromToolBarLoadProperty(actionEvent);
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof SGDrawingWindow) {
            this.fromWindow(actionEvent);
        } else if (object instanceof SGWizardDialog) {
            this.fromWizardDialog(actionEvent);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof SGDrawingWindow) {
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)windowEvent.getSource();
            this.removeWindow(sGDrawingWindow);
            if (this.mWndMap.size() == 0) {
                System.exit(0);
            }
        }
    }

    public boolean removeWindow(SGDrawingWindow sGDrawingWindow) {
        if (sGDrawingWindow == null) {
            return false;
        }
        int n = sGDrawingWindow.getID();
        this.mWndMap.remove(new Integer(n));
        sGDrawingWindow.removeWindowListener(this);
        sGDrawingWindow.removeActionListener(this);
        return true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
        Component component = dropTarget.getComponent();
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
        dropTargetDropEvent.acceptDrop(3);
        try {
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                Point point = dropTargetDropEvent.getLocation();
                this.addDataToWindow(point.x, point.y, sGDrawingWindow, new ArrayList(list));
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private boolean addDataToWindow(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
        this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setEnabled(false);
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                String string = file.getCanonicalPath();
                SGData sGData = this.createDataFromFile(string);
                if (sGData == null) {
                    System.out.println("\u30c7\u30fc\u30bf\u306f\u8ffd\u52a0\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                    continue;
                }
                Component component = sGDrawingWindow.getComponent(n, n2);
                if (component instanceof SGDrawingWindow) {
                    int n3;
                    int n4 = sGDrawingWindow.getCurrentFigureId();
                    SGFigure sGFigure = sGDrawingWindow.getFigure(n4);
                    if (sGFigure == null && (sGFigure = this.createFigure(n4, sGDrawingWindow, sGData)) == null) {
                        return false;
                    }
                    if (!sGFigure.addData(sGData)) {
                        System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
                        return false;
                    }
                    if (!sGFigure.initGraphAreaLocation()) {
                        return false;
                    }
                    SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
                    for (n3 = 0; n3 < sGIFigureElementArray.length; ++n3) {
                        sGIFigureElementArray[n3].chkBoundsVisible();
                    }
                    for (n3 = 0; n3 < sGIFigureElementArray.length; ++n3) {
                        sGIFigureElementArray[n3].addPropertiesHistory();
                    }
                    sGDrawingWindow.addPropertiesHistory();
                    TreeMap treeMap = sGDrawingWindow.getFigureMap();
                    if (!treeMap.containsValue(sGFigure)) {
                        sGDrawingWindow.addFigure(n4, sGFigure, n, n2);
                    }
                    sGDrawingWindow.addPropertiesHistory();
                    sGFigure.addPropertiesHistory();
                    sGDrawingWindow.show();
                    continue;
                }
                if (component instanceof SGFigure) {
                    SGFigure sGFigure = (SGFigure)component;
                    sGFigure.addData(sGData);
                    continue;
                }
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

