/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;

public abstract class SGElementGroup
implements ActionListener {
    protected ArrayList mDrawingElementList = new ArrayList();
    protected SGElementGroupSet mGroupSet = null;
    protected float mMagnification = 1.0f;
    protected float mRulerUnit = 0.035277776f;
    protected ArrayList mColorList = new ArrayList();
    protected boolean mEnteredFlag = false;
    protected boolean mSelectedFlag = false;
    protected boolean mVisibleFlag = true;
    public static final int POLYLINE_GROUP = 0;
    public static final int SYMBOL_GROUP = 1;
    public static final int RECTANGLE_GROUP = 2;
    public static final int ARROW_GROUP = 3;
    public static final String KEY_VISIBLE = "Visible";
    public static final String KEY_COLOR_LIST = "Colors";

    protected boolean setDialogProperty() {
        return true;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)this.mDrawingElementList.get(i);
            sGDrawingElement.setMagnification(f);
        }
        return true;
    }

    public boolean addColor(Color color) {
        this.mColorList.add(color);
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)this.mDrawingElementList.get(i);
            sGDrawingElement.addColor(color);
        }
        return true;
    }

    public boolean setColor(Color color) {
        this.mColorList.clear();
        this.mColorList.add(color);
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)this.mDrawingElementList.get(i);
            sGDrawingElement.setColor(color);
        }
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        this.mColorList = new ArrayList(arrayList);
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)this.mDrawingElementList.get(i);
            sGDrawingElement.setColorList(arrayList);
        }
        return true;
    }

    public Color getColor(int n) {
        if (this.mColorList == null) {
            return null;
        }
        if (n >= this.mColorList.size()) {
            return null;
        }
        return (Color)this.mColorList.get(n);
    }

    public ArrayList getColorList() {
        return this.mColorList;
    }

    public boolean zoom(int n, int n2, float f) {
        this.mMagnification = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)this.mDrawingElementList.get(i);
            sGDrawingElement.zoom(n, n2, f);
        }
        return true;
    }

    public boolean addDrawingElement(SGDrawingElement sGDrawingElement) {
        this.mDrawingElementList.add(sGDrawingElement);
        return true;
    }

    public ArrayList getDrawingElementList() {
        return this.mDrawingElementList;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean contains(int n, int n2) {
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)this.mDrawingElementList.get(i);
            if (!sGDrawingElement.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean paintElement(Graphics2D var1);

    public abstract SGDrawingElement getDrawingElement();

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        this.setColorList(sGDrawingElement.getColorList());
        return true;
    }

    protected boolean shiftColorList() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (int i = 0; i < this.mColorList.size(); ++i) {
            Color color = (Color)this.mColorList.get(i);
            Color color2 = new Color((color.getRed() + 128) % 256, (color.getGreen() + 128) % 256, (color.getBlue() + 128) % 256);
            arrayList.add(color2);
        }
        this.mColorList = new ArrayList(arrayList);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
    }

    public abstract boolean writePropertyOfData(Writer var1) throws IOException;

    public boolean readProperty(BufferedReader bufferedReader) throws IOException {
        SGProperties sGProperties = this.readProperties(bufferedReader);
        return this.setProperties(sGProperties);
    }

    public abstract SGProperties readProperties(BufferedReader var1) throws IOException;

    public boolean setPropertyWithDialog() {
        return this.setProperties(this.getPropertiesFromDialog());
    }

    public SGProperties getProperties() {
        ElementGroupProperties elementGroupProperties = new ElementGroupProperties();
        this.getProperties(elementGroupProperties);
        return elementGroupProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        elementGroupProperties.setVisible(this.isVisible());
        elementGroupProperties.setColorList(new ArrayList(this.mColorList));
        return true;
    }

    protected ElementGroupProperties getPropertiesFromDialog() {
        return null;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        Boolean bl = elementGroupProperties.isVisible();
        if (bl == null) {
            return false;
        }
        ArrayList arrayList = elementGroupProperties.getColorList();
        if (arrayList == null) {
            return false;
        }
        this.setVisible(bl);
        this.setColorList(arrayList);
        return true;
    }

    public static class ElementGroupProperties
    extends SGProperties {
        public static final String[] keys = new String[]{"Visible", "Colors"};

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupProperties)) {
                return false;
            }
            ElementGroupProperties elementGroupProperties = (ElementGroupProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(elementGroupProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Boolean isVisible() {
            String string = this.getProperty(SGElementGroup.KEY_VISIBLE);
            return SGUtilityText.getBoolean(string);
        }

        public ArrayList getColorList() {
            String string = this.getProperty(SGElementGroup.KEY_COLOR_LIST);
            return SGUtilityText.getColorList(string);
        }

        public boolean setVisible(boolean bl) {
            this.setProperty(SGElementGroup.KEY_VISIBLE, new Boolean(bl).toString());
            return true;
        }

        public boolean setColorList(ArrayList arrayList) {
            if (arrayList == null) {
                return false;
            }
            String string = SGUtilityText.getColorListString(arrayList);
            if (string == null) {
                return false;
            }
            this.setProperty(SGElementGroup.KEY_COLOR_LIST, string);
            return true;
        }
    }
}

