/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;

public abstract class SGElementGroupArrow
extends SGElementGroupVXY {
    protected int mLineType = 1;
    protected float mLineWidth = 5.6692915f;
    protected float mHeadSize = 28.346458f;
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;
    protected float mHeadEdgeLineWidth = 2.8346457f;
    protected Color mHeadEdgeLineColor = Color.BLACK;
    protected int mStartHeadType = -1;
    protected int mEndHeadType = 10;
    protected static final String SOLID_LINE = "Solid line";
    protected static final String BROKEN_LINE = "Broken line";
    protected static final String DOTTED_LINE = "Dotted line";
    protected static final String SYMBOL_CIRCLE = "Circle";
    protected static final String SYMBOL_SQUARE = "Square";
    protected static final String SYMBOL_TRIANGLE = "Triangle";
    protected static final String SYMBOL_CROSS = "Cross";
    protected static final String SYMBOL_TRANSVERSE_LINE = "Transverse line";
    protected static final String SYMBOL_ARROW_HEAD = "Arrow head";
    protected static final String NO_SYMBOL = "No symbol";
    public static final String ARROW_TITLE = "<SGElementGroupArrow>";
    public static final String KEY_LINE_WIDTH = "Line Width";
    public static final String KEY_LINE_TYPE = "Line Type";
    public static final String KEY_HEAD_SIZE = "Head Size";
    public static final String KEY_START_HEAD_TYPE = "Start Head Type";
    public static final String KEY_END_HEAD_TYPE = "End Head Type";
    public static final String KEY_HEAD_LINE_WIDTH = "Head Line Width";
    public static final String KEY_HEAD_LINE_COLOR = "Head Line Color";
    public static final String KEY_HEAD_OPEN_ANGLE = "Head Open Angle";
    public static final String KEY_HEAD_CLOSE_ANGLE = "Head Close Angle";

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public float getHeadEdgeLineWidth() {
        return this.mHeadEdgeLineWidth;
    }

    public Color getHeadEdgeLineColor() {
        return this.mHeadEdgeLineColor;
    }

    public int getStartHeadType() {
        return this.mStartHeadType;
    }

    public int getEndHeadType() {
        return this.mEndHeadType;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setLineType(this.mLineType);
        }
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setLineWidth(this.mLineWidth);
        }
        return true;
    }

    public boolean setHeadSize(float f) {
        this.mHeadSize = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadSize(this.mHeadSize);
        }
        return true;
    }

    public boolean setHeadOpenAngle(float f) {
        this.mHeadOpenAngle = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadOpenAngle(this.mHeadOpenAngle);
        }
        return true;
    }

    public boolean setHeadCloseAngle(float f) {
        this.mHeadCloseAngle = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadCloseAngle(this.mHeadCloseAngle);
        }
        return true;
    }

    public boolean setHeadEdgeLineWidth(float f) {
        this.mHeadEdgeLineWidth = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadEdgeLineWidth(f);
        }
        return true;
    }

    public boolean setHeadEdgeLineColor(Color color) {
        this.mHeadEdgeLineColor = color;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadEdgeLineColor(color);
        }
        return true;
    }

    public boolean setStartHeadType(int n) {
        this.mStartHeadType = n;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setStartHeadType(n);
        }
        return true;
    }

    public boolean setEndHeadType(int n) {
        this.mEndHeadType = n;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setEndHeadType(n);
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementArrow2D sGDrawingElementArrow2D = new SGDrawingElementArrow2D();
        sGDrawingElementArrow2D.setLineType(this.mLineType);
        sGDrawingElementArrow2D.setLineWidth(this.mLineWidth);
        sGDrawingElementArrow2D.setColorList(this.mColorList);
        ((SGDrawingElementArrow)sGDrawingElementArrow2D).setHeadSize(this.mHeadSize);
        sGDrawingElementArrow2D.setHeadOpenAngle(this.mHeadOpenAngle);
        sGDrawingElementArrow2D.setHeadCloseAngle(this.mHeadCloseAngle);
        ((SGDrawingElementArrow)sGDrawingElementArrow2D).setHeadEdgeLineWidth(this.mHeadEdgeLineWidth);
        ((SGDrawingElementArrow)sGDrawingElementArrow2D).setHeadEdgeLineColor(this.mHeadEdgeLineColor);
        sGDrawingElementArrow2D.setStartHeadType(this.mStartHeadType);
        sGDrawingElementArrow2D.setEndHeadType(this.mEndHeadType);
        return sGDrawingElementArrow2D;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementArrow)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElement;
        this.mLineType = sGDrawingElementArrow.getLineType();
        this.mLineWidth = sGDrawingElementArrow.getLineWidth();
        this.mHeadSize = sGDrawingElementArrow.getHeadSize();
        this.mHeadOpenAngle = sGDrawingElementArrow.getHeadOpenAngle();
        this.mHeadCloseAngle = sGDrawingElementArrow.getHeadCloseAngle();
        this.mHeadEdgeLineWidth = sGDrawingElementArrow.getHeadEdgeLineWidth();
        this.mHeadEdgeLineColor = sGDrawingElementArrow.getHeadEdgeLineColor();
        this.mStartHeadType = sGDrawingElementArrow.getStartHeadType();
        this.mEndHeadType = sGDrawingElementArrow.getEndHeadType();
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        Object object;
        Object object2;
        int n;
        ArrayList arrayList = new ArrayList(this.mColorList);
        if (this.mEnteredFlag) {
            ArrayList<Color> arrayList2 = new ArrayList<Color>();
            for (n = 0; n < arrayList.size(); ++n) {
                object2 = (Color)arrayList.get(n);
                object = new Color(((Color)object2).getRed(), ((Color)object2).getGreen(), ((Color)object2).getBlue(), 128);
                arrayList2.add((Color)object);
            }
            this.setColorList(arrayList2);
        }
        if (this.mSelectedFlag) {
            this.shiftColorList();
        }
        float f = this.mMagnification * this.mLineWidth;
        switch (this.mLineType) {
            case 1: {
                graphics2D.setStroke(new BasicStroke(f, 0, 0));
                break;
            }
            case 2: {
                float[] fArray = new float[]{2.0f * f, f};
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f));
                break;
            }
            case 3: {
                float[] fArray = new float[]{f};
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f));
                break;
            }
            default: {
                throw new Error();
            }
        }
        graphics2D.setPaint(this.getColor(0));
        for (n = 0; n < this.mDrawingElementList.size(); ++n) {
            object2 = (SGDrawingElementArrow2D)this.mDrawingElementList.get(n);
            object = ((SGDrawingElementArrow2D)object2).getBodyShape();
            graphics2D.draw((Shape)object);
        }
        float f2 = this.mMagnification * this.mHeadEdgeLineWidth;
        graphics2D.setStroke(new BasicStroke(f2));
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            Shape shape;
            object = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            Shape shape2 = ((SGDrawingElementArrow2D)object).getStartHeadShape();
            if (shape2 != null) {
                graphics2D.setPaint(this.mHeadEdgeLineColor);
                graphics2D.draw(shape2);
                graphics2D.setPaint(this.getColor(0));
                graphics2D.fill(shape2);
            }
            if ((shape = ((SGDrawingElementArrow2D)object).getEndHeadShape()) == null) continue;
            graphics2D.setPaint(this.mHeadEdgeLineColor);
            graphics2D.draw(shape);
            graphics2D.setPaint(this.getColor(0));
            graphics2D.fill(shape);
        }
        this.setColorList(arrayList);
        return true;
    }

    protected boolean shiftColorList() {
        Color color;
        super.shiftColorList();
        Color color2 = this.mHeadEdgeLineColor;
        this.mHeadEdgeLineColor = color = new Color((color2.getRed() + 128) % 256, (color2.getGreen() + 128) % 256, (color2.getBlue() + 128) % 256);
        return true;
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = SYMBOL_CIRCLE;
                break;
            }
            case 1: {
                string = SYMBOL_SQUARE;
                break;
            }
            case 2: {
                string = SYMBOL_TRIANGLE;
                break;
            }
            case 4: {
                string = SYMBOL_CROSS;
                break;
            }
            case 6: {
                string = SYMBOL_TRANSVERSE_LINE;
                break;
            }
            case 10: {
                string = SYMBOL_ARROW_HEAD;
                break;
            }
            case -1: {
                string = NO_SYMBOL;
                break;
            }
        }
        return string;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<SGElementGroupArrow>\n");
        SGUtilityText.writePropertyLine(writer, KEY_LINE_WIDTH, new Float(this.mLineWidth));
        SGUtilityText.writePropertyLine(writer, KEY_LINE_TYPE, new Integer(this.mLineType));
        SGUtilityText.writePropertyLine(writer, KEY_HEAD_SIZE, new Float(this.mHeadSize * this.mRulerUnit));
        SGUtilityText.writePropertyLine(writer, KEY_START_HEAD_TYPE, new Integer(this.mStartHeadType));
        SGUtilityText.writePropertyLine(writer, KEY_END_HEAD_TYPE, new Integer(this.mEndHeadType));
        SGUtilityText.writePropertyLine(writer, KEY_HEAD_LINE_WIDTH, new Float(this.mHeadEdgeLineWidth));
        SGUtilityText.writeColorPropertyLine(writer, KEY_HEAD_LINE_COLOR, this.mHeadEdgeLineColor);
        SGUtilityText.writePropertyLine(writer, KEY_HEAD_OPEN_ANGLE, new Double(this.mHeadOpenAngle));
        SGUtilityText.writePropertyLine(writer, KEY_HEAD_CLOSE_ANGLE, new Double(this.mHeadCloseAngle));
        SGUtilityText.writeColorListPropertyLine(writer, "Colors", this.mColorList);
        return true;
    }

    public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        return null;
    }

    public boolean createDrawingElement(ArrayList arrayList, ArrayList arrayList2) {
        SGTuple2f sGTuple2f;
        SGTuple2f sGTuple2f2;
        int n;
        this.mDrawingElementList.clear();
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        int n2 = arrayList.size();
        ArrayList<SGTuple2f> arrayList3 = new ArrayList<SGTuple2f>();
        ArrayList<SGTuple2f> arrayList4 = new ArrayList<SGTuple2f>();
        for (n = 0; n < n2; ++n) {
            sGTuple2f2 = (SGTuple2f)arrayList.get(n);
            sGTuple2f = (SGTuple2f)arrayList2.get(n);
            arrayList3.add(sGTuple2f2);
            arrayList4.add(sGTuple2f);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            sGTuple2f2 = (SGTuple2f)arrayList3.get(n);
            sGTuple2f = (SGTuple2f)arrayList4.get(n);
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.getDrawingElement();
            sGDrawingElementArrow2D.setTermPoints(sGTuple2f2, sGTuple2f);
            sGDrawingElementArrow2D.setMagnification(this.mMagnification);
            this.addDrawingElement(sGDrawingElementArrow2D);
        }
        return true;
    }

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        this.getProperties(arrowProperties);
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setHeadLineWidth(this.getHeadEdgeLineWidth());
        arrowProperties.setHeadLineColor(this.getHeadEdgeLineColor());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        Float f = arrowProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        Integer n = arrowProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineType(n);
        Float f2 = arrowProperties.getHeadSize();
        if (f2 == null) {
            return false;
        }
        this.setHeadSize(f2.floatValue());
        Float f3 = arrowProperties.getHeadLineWidth();
        if (f3 == null) {
            return false;
        }
        this.setHeadEdgeLineWidth(f3.floatValue());
        Color color = arrowProperties.getHeadLineColor();
        if (color == null) {
            return false;
        }
        this.setHeadEdgeLineColor(color);
        Integer n2 = arrowProperties.getStartHeadType();
        if (n2 == null) {
            return false;
        }
        this.setStartHeadType(n2);
        Integer n3 = arrowProperties.getEndHeadType();
        if (n3 == null) {
            return false;
        }
        this.setEndHeadType(n3);
        Float f4 = arrowProperties.getHeadOpenAngle();
        if (f4 == null) {
            return false;
        }
        this.setHeadOpenAngle(f4.floatValue());
        Float f5 = arrowProperties.getHeadCloseAngle();
        if (f5 == null) {
            return false;
        }
        this.setHeadCloseAngle(f5.floatValue());
        return true;
    }

    public static class ArrowProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"Line Width", "Line Type", "Head Size", "Start Head Type", "End Head Type", "Head Line Width", "Head Line Color", "Head Open Angle", "Head Close Angle"};

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(arrowProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getLineWidth() {
            String string = this.getProperty(SGElementGroupArrow.KEY_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Integer getLineType() {
            String string = this.getProperty(SGElementGroupArrow.KEY_LINE_TYPE);
            return SGUtilityText.getInteger(string);
        }

        public Float getHeadLineWidth() {
            String string = this.getProperty(SGElementGroupArrow.KEY_HEAD_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Float getHeadSize() {
            String string = this.getProperty(SGElementGroupArrow.KEY_HEAD_SIZE);
            return SGUtilityText.getFloat(string);
        }

        public Color getHeadLineColor() {
            String string = this.getProperty(SGElementGroupArrow.KEY_HEAD_LINE_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public Integer getStartHeadType() {
            String string = this.getProperty(SGElementGroupArrow.KEY_START_HEAD_TYPE);
            return SGUtilityText.getInteger(string);
        }

        public Integer getEndHeadType() {
            String string = this.getProperty(SGElementGroupArrow.KEY_END_HEAD_TYPE);
            return SGUtilityText.getInteger(string);
        }

        public Float getHeadOpenAngle() {
            String string = this.getProperty(SGElementGroupArrow.KEY_HEAD_OPEN_ANGLE);
            return SGUtilityText.getFloat(string);
        }

        public Float getHeadCloseAngle() {
            String string = this.getProperty(SGElementGroupArrow.KEY_HEAD_CLOSE_ANGLE);
            return SGUtilityText.getFloat(string);
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupArrow.KEY_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setLineType(int n) {
            this.setProperty(SGElementGroupArrow.KEY_LINE_TYPE, new Integer(n).toString());
            return true;
        }

        public boolean setHeadLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupArrow.KEY_HEAD_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setStartHeadType(int n) {
            this.setProperty(SGElementGroupArrow.KEY_START_HEAD_TYPE, new Integer(n).toString());
            return true;
        }

        public boolean setEndHeadType(int n) {
            this.setProperty(SGElementGroupArrow.KEY_END_HEAD_TYPE, new Integer(n).toString());
            return true;
        }

        public boolean setHeadSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupArrow.KEY_HEAD_SIZE, new Float(f).toString());
            return true;
        }

        public boolean setHeadLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGElementGroupArrow.KEY_HEAD_LINE_COLOR, string);
            return true;
        }

        public boolean setHeadOpenAngle(float f) {
            this.setProperty(SGElementGroupArrow.KEY_HEAD_OPEN_ANGLE, new Float(f).toString());
            return true;
        }

        public boolean setHeadCloseAngle(float f) {
            this.setProperty(SGElementGroupArrow.KEY_HEAD_CLOSE_ANGLE, new Float(f).toString());
            return true;
        }
    }
}

