/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupRectangle;

public abstract class SGElementGroupBar
extends SGElementGroupRectangle {
    protected double mBaselineValue = 0.0;
    public static final String BAR_TITLE = "<Bar>";
    public static final String KEY_BAR_WIDTH = "Width";
    public static final String KEY_EDGE_LINE_WIDTH = "Edge Line Width";
    public static final String KEY_EDGE_LINE_COLOR = "Edge Line Color";
    public static final String KEY_BASELINE_VALUE = "Baseline Value";

    public double getBaseLineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaseLineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaseLineValue(sGDrawingElementBar.getReferenceValue());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        Object object;
        int n;
        ArrayList arrayList = new ArrayList(this.mColorList);
        if (this.mEnteredFlag) {
            ArrayList<Color> arrayList2 = new ArrayList<Color>();
            for (n = 0; n < arrayList.size(); ++n) {
                object = (Color)arrayList.get(n);
                Color color = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), 128);
                arrayList2.add(color);
            }
            this.setColorList(arrayList2);
        }
        if (this.mSelectedFlag) {
            // empty if block
        }
        float f = this.mMagnification * this.mEdgeLineWidth;
        for (n = 0; n < this.mDrawingElementList.size(); ++n) {
            object = (SGDrawingElementBar2D)this.mDrawingElementList.get(n);
            double d = ((SGDrawingElementRectangle)object).getX();
            double d2 = ((SGDrawingElementRectangle)object).getY();
            double d3 = ((SGDrawingElementRectangle)object).getWidth();
            double d4 = ((SGDrawingElementRectangle)object).getHeight();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
            int n2 = this.mColorList.size();
            if (n2 > 1) {
                int n3;
                float f2 = (float)(d + 0.5 * d3);
                float f3 = (float)d4 / (float)n2;
                float f4 = 5.0f;
                Rectangle2D[] rectangle2DArray = new Rectangle2D[n2 + 1];
                rectangle2DArray[0] = new Rectangle2D.Double(d, d2, d3, 0.5 * (double)f3);
                rectangle2DArray[rectangle2DArray.length - 1] = new Rectangle2D.Double(d, d2 + d4 - 0.5 * (double)f3, d3, 0.5 * (double)f3);
                for (int i = 1; i < rectangle2DArray.length - 1; ++i) {
                    double d5 = d2 + 0.5 * (double)f3 + (double)(i - 1) * (double)f3;
                    rectangle2DArray[i] = new Rectangle2D.Double(d, d5, d3, f3);
                }
                float[] fArray = new float[n2 - 1];
                for (n3 = 0; n3 < fArray.length; ++n3) {
                    fArray[n3] = (float)(d2 + (double)((float)(n3 + 1) * f3));
                }
                graphics2D.setPaint((Color)this.getColorList().get(0));
                graphics2D.fill(rectangle2DArray[0]);
                for (n3 = 0; n3 < fArray.length; ++n3) {
                    Color color = (Color)this.mColorList.get(n3);
                    Color color2 = (Color)this.mColorList.get(n3 + 1);
                    float f5 = fArray[n3] - f4;
                    float f6 = fArray[n3] + f4;
                    GradientPaint gradientPaint = new GradientPaint(f2, f5, color, f2, f6, color2);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fill(rectangle2DArray[n3 + 1]);
                }
                graphics2D.setPaint((Color)this.getColorList().get(n2 - 1));
                graphics2D.fill(rectangle2DArray[rectangle2DArray.length - 1]);
            } else {
                graphics2D.setPaint(this.getColor(0));
                graphics2D.fill(double_);
            }
            graphics2D.setStroke(new BasicStroke(f, 0, 0));
            graphics2D.setPaint(this.mEdgeLineColor);
            graphics2D.draw(double_);
        }
        this.setColorList(arrayList);
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementBar2D sGDrawingElementBar2D = new SGDrawingElementBar2D();
        sGDrawingElementBar2D.setWidth(this.mRectangleWidth);
        sGDrawingElementBar2D.setHeight(this.mRectangleHeight);
        sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
        sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
        sGDrawingElementBar2D.setColorList(this.mColorList);
        sGDrawingElementBar2D.setReferenceValue(this.mBaselineValue);
        return sGDrawingElementBar2D;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<Bar>\n");
        SGUtilityText.writePropertyLine(writer, "Visible", new Boolean(this.mVisibleFlag));
        SGUtilityText.writePropertyLine(writer, KEY_BAR_WIDTH, new Float(this.mRectangleWidth * this.mRulerUnit));
        SGUtilityText.writeColorListPropertyLine(writer, "Colors", this.mColorList);
        SGUtilityText.writePropertyLine(writer, KEY_EDGE_LINE_WIDTH, new Float(this.mEdgeLineWidth));
        SGUtilityText.writePropertyLine(writer, KEY_BASELINE_VALUE, new Double(this.mBaselineValue));
        SGUtilityText.writeColorPropertyLine(writer, KEY_EDGE_LINE_COLOR, this.mEdgeLineColor);
        writer.write("\n");
        return true;
    }

    public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        BarProperties barProperties = new BarProperties();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Visible");
        if (bl == null) {
            return null;
        }
        barProperties.setVisible(bl);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, KEY_BAR_WIDTH);
        if (d == null) {
            return null;
        }
        barProperties.setBarWidth(d.floatValue() / 0.035277776f);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getColorListFromLine(string, "Colors");
        if (arrayList == null) {
            return null;
        }
        barProperties.setColorList(arrayList);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, KEY_EDGE_LINE_WIDTH);
        if (d2 == null) {
            return null;
        }
        barProperties.setEdgeLineWidth(d2.floatValue());
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, KEY_BASELINE_VALUE);
        if (d3 == null) {
            return null;
        }
        barProperties.setBaselineValue(d3);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, KEY_EDGE_LINE_COLOR);
        if (color == null) {
            return null;
        }
        barProperties.setEdgeLineColor(color);
        return barProperties;
    }

    public boolean createDrawingElement(ArrayList arrayList) {
        this.mDrawingElementList.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGTuple2f sGTuple2f = (SGTuple2f)arrayList.get(i);
            SGDrawingElementBar2D sGDrawingElementBar2D = new SGDrawingElementBar2D(sGTuple2f.x, sGTuple2f.y, this.mRectangleWidth, this.mRectangleHeight);
            sGDrawingElementBar2D.setColorList(this.mColorList);
            this.addDrawingElement(sGDrawingElementBar2D);
        }
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        this.getProperties(barProperties);
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setBarWidth(this.getRectangleWidth());
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaseLineValue());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        BarProperties barProperties = (BarProperties)sGProperties;
        Float f = barProperties.getBarWidth();
        if (f == null) {
            return false;
        }
        this.setRectangleWidth(f.floatValue());
        Float f2 = barProperties.getEdgeLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setEdgeLineWidth(f2.floatValue());
        Color color = barProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        Double d = barProperties.getBaselineValue();
        if (d == null) {
            return false;
        }
        this.setBaseLineValue(d);
        return true;
    }

    public static class BarProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"Width", "Edge Line Width", "Edge Line Color", "Baseline Value"};

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(barProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getBarWidth() {
            String string = this.getProperty(SGElementGroupBar.KEY_BAR_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Float getEdgeLineWidth() {
            String string = this.getProperty(SGElementGroupBar.KEY_EDGE_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Color getEdgeLineColor() {
            String string = this.getProperty(SGElementGroupBar.KEY_EDGE_LINE_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public Double getBaselineValue() {
            String string = this.getProperty(SGElementGroupBar.KEY_BASELINE_VALUE);
            return SGUtilityText.getDouble(string);
        }

        public boolean setBarWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupBar.KEY_BAR_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setBaselineValue(double d) {
            this.setProperty(SGElementGroupBar.KEY_BASELINE_VALUE, new Double(d).toString());
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupBar.KEY_EDGE_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGElementGroupBar.KEY_EDGE_LINE_COLOR, string);
            return true;
        }
    }
}

