/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;

public abstract class SGElementGroupErrorBar
extends SGElementGroupArrow {
    public static final String ERROR_BAR_TITLE = "<Error Bar>";
    public static final String KEY_ERROR_BAR_STYLE = "Error Bar Style";
    public static final String ERROR_BAR_HEAD_TYPE = "Head Type";
    public static final int ERROR_BAR_FULL = 0;
    public static final int ERROR_BAR_UPPER_ONLY = 1;
    public static final int ERROR_BAR_LOWER_ONLY = 2;
    public static final String SHOW_FULLY = "Bothsides";
    public static final String SHOW_UPPER_ONLY = "Upside";
    public static final String SHOW_LOWER_ONLY = "Downside";
    public int mErrorBarStyle = 0;

    public boolean setColor(Color color) {
        super.setColor(color);
        this.mHeadEdgeLineColor = color;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadEdgeLineColor(color);
        }
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        Color color;
        super.setColorList(arrayList);
        this.mHeadEdgeLineColor = color = (Color)arrayList.get(0);
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementList.get(i);
            sGDrawingElementArrow2D.setHeadEdgeLineColor(color);
        }
        return true;
    }

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public boolean setErrorBarStyle(int n) {
        this.mErrorBarStyle = n;
        return true;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<Error Bar>\n");
        SGUtilityText.writePropertyLine(writer, "Visible", new Boolean(this.mVisibleFlag));
        SGUtilityText.writePropertyLine(writer, KEY_ERROR_BAR_STYLE, SGElementGroupErrorBar.getErrorBarStyleName(this.mErrorBarStyle));
        SGUtilityText.writePropertyLine(writer, "Line Width", new Float(this.mLineWidth));
        SGUtilityText.writePropertyLine(writer, "Head Size", new Float(this.mHeadSize * this.mRulerUnit));
        SGUtilityText.writePropertyLine(writer, "Head Line Width", new Float(this.mLineWidth));
        SGUtilityText.writePropertyLine(writer, ERROR_BAR_HEAD_TYPE, SGDrawingElementSymbol.getSymbolTypeName(this.getHeadType()));
        SGUtilityText.writeColorListPropertyLine(writer, "Colors", this.mColorList);
        writer.write("\n");
        return true;
    }

    public static Integer getErrorBarStyleFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals(SHOW_FULLY)) {
            n = 0;
        } else if (string.equals(SHOW_UPPER_ONLY)) {
            n = 1;
        } else if (string.equals(SHOW_LOWER_ONLY)) {
            n = 2;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getErrorBarStyleName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = SHOW_FULLY;
                break;
            }
            case 1: {
                string = SHOW_UPPER_ONLY;
                break;
            }
            case 2: {
                string = SHOW_LOWER_ONLY;
                break;
            }
        }
        return string;
    }

    public int getHeadType() {
        int n;
        switch (this.mErrorBarStyle) {
            case 0: {
                n = this.mStartHeadType;
                break;
            }
            case 1: {
                n = this.mEndHeadType;
                break;
            }
            case 2: {
                n = this.mStartHeadType;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return n;
    }

    public boolean setHeadType(int n) {
        switch (this.mErrorBarStyle) {
            case 0: {
                this.mStartHeadType = n;
                this.mEndHeadType = n;
                break;
            }
            case 1: {
                this.mEndHeadType = n;
                break;
            }
            case 2: {
                this.mStartHeadType = n;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Visible");
        if (bl == null) {
            return null;
        }
        errorBarProperties.setVisible(bl);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getPropertyFromLine(string, KEY_ERROR_BAR_STYLE);
        if (string2 == null) {
            return null;
        }
        Integer n = SGElementGroupErrorBar.getErrorBarStyleFromName(string2);
        if (n == null) {
            return null;
        }
        errorBarProperties.setErrorBarStyle(n);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "Line Width");
        if (d == null) {
            return null;
        }
        errorBarProperties.setLineWidth(d.floatValue());
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Head Size");
        if (d2 == null) {
            return null;
        }
        errorBarProperties.setHeadSize(d2.floatValue() / 0.035277776f);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Head Line Width");
        if (d3 == null) {
            return null;
        }
        errorBarProperties.setHeadLineWidth(d3.floatValue());
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string3 = SGUtilityText.getPropertyFromLine(string, ERROR_BAR_HEAD_TYPE);
        if (string3 == null) {
            return null;
        }
        Integer n2 = SGDrawingElementSymbol.getSymbolTypeFromName(string3);
        if (n2 == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        errorBarProperties.setStartHeadType(n2);
        errorBarProperties.setEndHeadType(n2);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getColorListFromLine(string, "Colors");
        if (arrayList == null) {
            return null;
        }
        errorBarProperties.setColorList(arrayList);
        errorBarProperties.setLineType(this.mLineType);
        return errorBarProperties;
    }

    public boolean createDrawingElement(ArrayList arrayList, ArrayList arrayList2) {
        this.mDrawingElementList.clear();
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGTuple2f sGTuple2f = (SGTuple2f)arrayList.get(i);
            SGTuple2f sGTuple2f2 = (SGTuple2f)arrayList2.get(i);
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.getDrawingElement();
            sGDrawingElementArrow2D.setTermPoints(sGTuple2f, sGTuple2f2);
            sGDrawingElementArrow2D.setMagnification(this.mMagnification);
            if (this.mErrorBarStyle == 0) {
                sGDrawingElementArrow2D.setStartHeadType(this.mStartHeadType);
                sGDrawingElementArrow2D.setEndHeadType(this.mEndHeadType);
            } else if (this.mErrorBarStyle == 1) {
                sGDrawingElementArrow2D.setStartHeadType(-1);
                sGDrawingElementArrow2D.setEndHeadType(this.mEndHeadType);
            } else if (this.mErrorBarStyle == 2) {
                sGDrawingElementArrow2D.setStartHeadType(this.mStartHeadType);
                sGDrawingElementArrow2D.setEndHeadType(-1);
            }
            this.addDrawingElement(sGDrawingElementArrow2D);
        }
        return true;
    }

    protected String[] getPopupMenuCommandArray() {
        String[] stringArray = new String[]{"Circle", "Transverse line", "No symbol", SHOW_FULLY, SHOW_UPPER_ONLY, SHOW_LOWER_ONLY};
        return stringArray;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        this.getProperties(errorBarProperties);
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        Integer n = errorBarProperties.getErrorBarStyle();
        if (n == null) {
            return false;
        }
        this.mErrorBarStyle = n;
        return true;
    }

    public static class ErrorBarProperties
    extends SGElementGroupArrow.ArrowProperties {
        public static final String[] keys = new String[]{"Error Bar Style"};

        public ErrorBarProperties() {
            this.init();
        }

        private boolean init() {
            this.setLineType(1);
            this.setHeadOpenAngle(0.0f);
            this.setHeadCloseAngle(0.0f);
            return true;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            boolean bl = super.equals(object);
            if (!bl) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(errorBarProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Integer getErrorBarStyle() {
            String string = this.getProperty(SGElementGroupErrorBar.KEY_ERROR_BAR_STYLE);
            return SGUtilityText.getInteger(string);
        }

        public boolean setErrorBarStyle(int n) {
            this.setProperty(SGElementGroupErrorBar.KEY_ERROR_BAR_STYLE, new Integer(n).toString());
            return true;
        }

        public String toString() {
            String string = new String("[");
            string = string + this.getProperty(SGElementGroupErrorBar.KEY_ERROR_BAR_STYLE);
            string = string + new String("]");
            return string;
        }
    }
}

