/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGSignificantDifferenceSymbol
extends SGDrawingElement
implements SGIDrawingElementJava2D {
    protected float mX = 0.0f;
    protected float mY = 0.0f;
    protected float mWidth = 0.0f;
    protected float mLeftHeight = 0.0f;
    protected float mRightHeight = 0.0f;
    protected float mSpace = 0.0f;
    protected SGDrawingElementString2D mStringElement = new SGDrawingElementString2D("*");
    protected float mLineWidth = 3.0f;
    protected float mMagnification = 1.0f;
    protected SGDrawingElementLine2D mLineTop = new SGDrawingElementLine2D();
    protected SGDrawingElementLine2D mLineLeft = new SGDrawingElementLine2D();
    protected SGDrawingElementLine2D mLineRight = new SGDrawingElementLine2D();
    protected boolean mVerticalFlag = true;
    public static final int mMinWidth = 10;
    public static final int mMinHeight = 10;

    public SGSignificantDifferenceSymbol() {
    }

    public SGSignificantDifferenceSymbol(float f, float f2, float f3, float f4, float f5) {
        this.setLocation(f, f2);
        this.setSize(f3, f4, f5);
    }

    public boolean createDrawingElement() {
        SGTuple2f sGTuple2f = new SGTuple2f(this.getX(), this.getY());
        SGTuple2f sGTuple2f2 = new SGTuple2f(this.getX() + this.getWidth(), this.getY());
        SGTuple2f sGTuple2f3 = new SGTuple2f(this.getX(), this.getY() + this.getLeftHeight());
        SGTuple2f sGTuple2f4 = new SGTuple2f(this.getX() + this.getWidth(), this.getY() + this.getRightHeight());
        this.mLineTop.setTermPoints(sGTuple2f, sGTuple2f2);
        this.mLineLeft.setTermPoints(sGTuple2f, sGTuple2f3);
        this.mLineRight.setTermPoints(sGTuple2f2, sGTuple2f4);
        Rectangle2D rectangle2D = this.mStringElement.getElementBounds();
        float f = (float)rectangle2D.getWidth();
        float f2 = (float)rectangle2D.getHeight();
        float f3 = this.getX() + this.getWidth() / 2.0f - f / 2.0f;
        float f4 = this.mVerticalFlag ? this.getY() - this.mSpace * this.mMagnification - f2 : this.getY() + this.mSpace * this.mMagnification;
        this.mStringElement.setLocation(f3, f4);
        return true;
    }

    public ArrayList getDrawingElementList() {
        ArrayList<SGDrawingElementLine2D> arrayList = new ArrayList<SGDrawingElementLine2D>();
        arrayList.add(this.mLineTop);
        arrayList.add(this.mLineLeft);
        arrayList.add(this.mLineRight);
        return arrayList;
    }

    public float getX() {
        return this.mX * this.mMagnification;
    }

    public float getY() {
        return this.mY * this.mMagnification;
    }

    public float getWidth() {
        return this.mWidth * this.mMagnification;
    }

    public float getLeftHeight() {
        return this.mLeftHeight * this.mMagnification;
    }

    public float getRightHeight() {
        return this.mRightHeight * this.mMagnification;
    }

    public float getSpace() {
        return this.mSpace;
    }

    public boolean getVerticalFlag() {
        return this.mVerticalFlag;
    }

    public Point2D getLeftJoint() {
        Point2D.Float float_ = new Point2D.Float(this.getX(), this.getY());
        return float_;
    }

    public Point2D getLeftTerm() {
        float f = this.mVerticalFlag ? this.getLeftHeight() : -this.getLeftHeight();
        Point2D.Float float_ = new Point2D.Float(this.getX(), this.getY() + f);
        return float_;
    }

    public Point2D getRightJoint() {
        Point2D.Float float_ = new Point2D.Float(this.getX() + this.getWidth(), this.getY());
        return float_;
    }

    public Point2D getRightTerm() {
        float f = this.mVerticalFlag ? this.getLeftHeight() : -this.getLeftHeight();
        Point2D.Float float_ = new Point2D.Float(this.getX() + this.getWidth(), this.getY() + f);
        return float_;
    }

    public SGDrawingElementString2D getStringElement() {
        return this.mStringElement;
    }

    public String getText() {
        return this.mStringElement.getString();
    }

    public float getFontSize() {
        return this.mStringElement.getFontSize();
    }

    public int getFontStyle() {
        return this.mStringElement.getFontStyle();
    }

    public String getFontFamilyName() {
        return this.mStringElement.getFontFamilyName();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getColor() {
        return this.getColor(0);
    }

    public boolean setLocation(float f, float f2) {
        this.mX = f;
        this.mY = f2;
        return true;
    }

    public boolean setSize(float f, float f2, float f3) {
        if (f < 0.0f || f2 < 0.0f || f3 < 0.0f) {
            throw new IllegalArgumentException("w<0 || hl<0 || hr<0");
        }
        this.mWidth = f;
        this.mLeftHeight = f2;
        this.mRightHeight = f3;
        return true;
    }

    public boolean setWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("w<0");
        }
        this.mWidth = f / this.mMagnification;
        return true;
    }

    public boolean setLeftHeight(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("h<0");
        }
        this.mLeftHeight = f / this.mMagnification;
        return true;
    }

    public boolean setRightHeight(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("h<0");
        }
        this.mRightHeight = f / this.mMagnification;
        return true;
    }

    public boolean setSpace(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("space<0");
        }
        this.mSpace = f;
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        ArrayList arrayList = this.getDrawingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
            sGDrawingElement.setMagnification(f);
        }
        this.mStringElement.setMagnification(f);
        return true;
    }

    public boolean setText(String string) {
        this.mStringElement.setString(string);
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public boolean setFontSize(float f) {
        this.mStringElement.setFontSize(f);
        return true;
    }

    public boolean setFontStyle(int n) {
        this.mStringElement.setFontStyle(n);
        return true;
    }

    public boolean setFontFamilyName(String string) {
        this.mStringElement.setFontFamilyName(string);
        return true;
    }

    public boolean setVerticalFlag(boolean bl) {
        this.mVerticalFlag = bl;
        return true;
    }

    public boolean contains(int n, int n2) {
        ArrayList arrayList = this.getDrawingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
            if (!sGDrawingElement.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getShapeList() {
        ArrayList arrayList = this.getDrawingElementList();
        ArrayList<Shape> arrayList2 = new ArrayList<Shape>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)arrayList.get(i);
            arrayList2.add(sGDrawingElementLine2D.getShape());
        }
        return arrayList2;
    }

    public Shape getConnectedShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(this.mLineLeft.getShape(), true);
        generalPath.append(this.mLineTop.getShape(), true);
        generalPath.append(this.mLineRight.getShape(), true);
        return generalPath;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        this.createDrawingElement();
        ArrayList arrayList = this.getDrawingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
            sGDrawingElement.setMagnification(f);
        }
        this.mStringElement.setMagnification(f);
        this.createDrawingElement();
        return true;
    }

    public Rectangle2D getElementBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(this.getLineBounds());
        arrayList.add(this.getStringBounds());
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public Rectangle2D getLineBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getDrawingElementList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)arrayList2.get(i);
            arrayList.add(sGDrawingElementLine2D.getShape().getBounds2D());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public Rectangle2D getStringBounds() {
        return this.mStringElement.getElementBounds();
    }
}

