#!/bin/sh
PWD=`dirname $0`
cd $PWD

# broken tag
echo "Now. This is broken script"
exit 1;


DONEFILE1=$PWD/.bulid.dist.done
DONEFILE2=$PWD/.bulid.zip.done
DATE=`date "+%Y%m%d"`
DISTDIRNAME=samurai-graph-$DATE
DISTDIR=$DISTDIRNAME
LIBDIR=$DISTDIR/lib
DOCDIR=$DISTDIR/doc
VGDIR=$LIBDIR
VGDOCDIR=$DOCDIR/vectorgraphics

VGSRCDIR=contrib/vectorgraphics
VGSRCDOCDIR=contrib/vectorgraphics/web/freehep/vectorgraphics
VGSRCJARDIR=$VGSRCDIR/lib

VGJARFILES="base graphics2d graphicsio graphicsio-cgm graphicsio-emf graphicsio-gif graphicsio-java graphicsio-pdf graphicsio-ppm graphicsio-ps graphicsio-svg graphicsio-swf"
VGEXTRAFILES="LGPL.txt LICENSE.txt"
VGRELEASENOTE="ReleaseNotes-1.2.2.xhtml"

EXTRAFILES="COPYING.txt LICENSE.txt samurai-graph.ico"

build_sub () {
  # do compile
  src/build.sh build
}

build_lib () {
  # do compile
  contrib/build.sh build
}

rebuild_sub () {
  # do rebuild
  src/build.sh rebuild
}

rebuild_lib() {
  # do rebuild
  contrib/build.sh rebuild
}

clean_sub () {
  # do clean
  src/build.sh clean
}

clean_lib () {
  # do clean
  contrib/build.sh clean
}

build_dist () {
  if [ ! -f $DONEFILE1 ]; then
    echo -n [samurai-graph] copying distfiles to $DISTDIRNAME ...
    rm -rf $DISTDIR
    # create dist directory
    mkdir -p $DISTDIR
    mkdir -p $LIBDIR
    mkdir -p $VGDIR
    mkdir -p $DOCDIR
    mkdir -p $VGDOCDIR

    # copy allfiles to dist directory
    for i in $VGJARFILES; do
      cp $VGSRCJARDIR/freehep-$i.jar $VGDIR
    done
    for i in $EXTRAFILES; do
      cp $i $DISTDIR
    done
    cp src/samurai-graph.jar $DISTDIR
    cp src/samurai-graph-client.jar $DISTDIR
  
    for i in $VGEXTRAFILES; do
      cp $VGSRCDIR/$i $VGDOCDIR
    done
    cp $VGSRCDOCDIR/$VGRELEASENOTE $VGDOCDIR/ReleaseNotes-1.2.2.html

    cp -r examples $DISTDIR
    rm -rf $DISTDIR/examples/CVS
    rm -rf $DISTDIR/examples/data/CVS
  
    echo '#!/bin/sh' > $DISTDIR/samurai-graph
    echo 'JAVAVM=javavm' >> $DISTDIR/samurai-graph
    echo 'if [ ! -x $JAVAVM ]; then' >> $DISTDIR/samurai-graph
    echo '  JAVAVM=javaw' >> $DISTDIR/samurai-graph
    echo 'fi' >> $DISTDIR/samurai-graph
    echo 'if [ ! -x $JAVAVM ]; then' >> $DISTDIR/samurai-graph
    echo '  JAVAVM=java' >> $DISTDIR/samurai-graph
    echo 'fi' >> $DISTDIR/samurai-graph
    echo 'BASEDIR=`dirname $0`' >> $DISTDIR/samurai-graph
    echo 'exec $JAVAVM -jar $BASEDIR/samurai-graph.jar' >> $DISTDIR/samurai-graph
    chmod 755 $DISTDIR/samurai-graph
    touch $DONEFILE1
    echo 'done'
  fi
}

build_zip () {
  if [ ! -f $DONEFILE2 ]; then
    rm -f $DISTDIRNAME.zip
    echo -n [samurai-graph] archiving $DISTDIRNAME.zip ...  
    zip -r $DISTDIRNAME $DISTDIRNAME >/dev/null 2>&1
    touch $DONEFILE2
    echo done
  fi
}

clean_dist () {
  DIR=`find . -name 'samurai-graph-*' -type d`
  for i in $DIR; do
    echo -n [samurai-graph] deleting distdir `basename $i` ...
    rm -rf $i
    echo done
  done
  rm -f $DONEFILE1
}

clean_zip () {
  DIR=`find . -name 'samurai-graph-*.zip' -type f`
  for i in $DIR; do
    echo -n [samurai-graph] deleting archive `basename $i` ...
    rm -rf $i
    echo done
  done
  rm -f $DONEFILE2
}

case "$1" in
build)
  build_lib
  build_sub
  build_dist
  build_zip
  ;;
rebuild)
  rm -f $DONEFILE1 $DONEFILE2
  rebuild_sub
  build_dist
  build_zip
  ;;
rebuild-all)
  rm -f $DONEFILE1 $DONEFILE2
  rebuild_lib
  rebuild_sub
  build_dist
  build_zip
  ;;
clean)
  clean_sub
  clean_dist
  clean_zip
  ;;
distclean)
  rm -f $DONEFILE1 $DONEFILE2
  clean_lib
  clean_sub
  clean_dist
  clean_zip
  ;;
*)
  echo "Usage: ${0##*/}: { build | rebuild | rebuild-all | clean | distclean }" 2>&1
  exit 65
  ;;
esac
