

package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 * 
 */
public abstract class SGDrawingElementRectangle extends SGDrawingElement
{

	/**
	 * 
	 */
	protected float mX;

	/**
	 * 
	 */
	protected float mY;

	/**
	 * 
	 */
	protected float mWidth;

	/**
	 * 
	 */
	protected float mHeight;


	/**
	 * 
	 */
	protected float mEdgeLineWidth;

	/**
	 * 
	 */
	protected Color mEdgeLineColor;



	/**
	 * 
	 */
	public SGDrawingElementRectangle()
	{
		super();
	}



	/**
	 * 
	 */
	public float getX()
	{
		return mX;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return mY;
	}


	/**
	 * 
	 */
	public float getWidth()
	{
		return mWidth;
	}


	/**
	 * 
	 */
	public float getHeight()
	{
		return mHeight;
	}


	/**
	 * 
	 */
	public float getEdgeLineWidth()
	{
		return mEdgeLineWidth;
	}


	/**
	 * 
	 */
	public Color getEdgeLineColor()
	{
		return mEdgeLineColor;
	}


	/**
	 * 
	 */
	public boolean setEdgeLineWidth( final float width )
	{
		mEdgeLineWidth = width;
		return true;
	}

	/**
	 * 
	 */
	public boolean setEdgeLineColor( final Color color )
	{
		mEdgeLineColor = color;
		return true;
	}


	/**
	 * 
	 */
	public boolean setX( final float x )
	{
		mX = x;
		return true;
	}


	/**
	 * 
	 */
	public boolean setY( final float y )
	{
		mY = y;
		return true;
	}

	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		mWidth = w;
		return true;
	}

	/**
	 * 
	 */
	public boolean setHeight( final float h )
	{
		mHeight = h;
		return true;
	}


	/**
	 * 
	 */
	public boolean setBounds(
		final float x,
		final float y,
		final float w,
		final float h )
	{
		setX( x );
		setY( y );
		setWidth( w );
		setHeight( h );
		
		return true;		
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementRectangle) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementRectangle rect = (SGDrawingElementRectangle)element;
		this.setWidth( rect.getWidth() );
		this.setHeight( rect.getHeight() );
		this.setEdgeLineWidth( rect.getEdgeLineWidth() );
		this.setEdgeLineColor( rect.getEdgeLineColor() );

		return true;
	}


}
