
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * 
 */
public abstract class SGElementGroupArrow extends SGElementGroupVXY
{

	/**
	 *
	 */
	protected int mLineType = SGDrawingElementLine.LINE_TYPE_SOLID;


	/**
	 * {100%̂Ƃ̐
	 */
	protected float mLineWidth = 0.20f/SGConstants.CM_POINT_RATIO;


	/**
	 * Ŝ̒ł̖K̒
	 */
	protected float mHeadSize = 1.0f/SGConstants.CM_POINT_RATIO;


	/**
	 * K̊Jpx
	 */
	protected float mHeadOpenAngle;


	/**
	 * K̕px
	 */
	protected float mHeadCloseAngle;


	/**
	 * 
	 */
	protected float mHeadEdgeLineWidth = 0.10f/SGConstants.CM_POINT_RATIO;


	/**
	 * 
	 */
	protected Color mHeadEdgeLineColor = Color.BLACK;


	/**
	 * 
	 */
	protected int mStartHeadType = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;


	/**
	 * 
	 */
	protected int mEndHeadType = SGDrawingElementArrow2D.SYMBOL_ARROW_HEAD;



	/**
	 * 
	 */
	protected static final String SOLID_LINE = "Solid line";


	/**
	 * 
	 */
	protected static final String BROKEN_LINE = "Broken line";


	/**
	 * 
	 */
	protected static final String DOTTED_LINE = "Dotted line";


	/**
	 * 
	 */
	protected static final String SYMBOL_CIRCLE = "Circle";

	/**
	 * 
	 */
	protected static final String SYMBOL_SQUARE = "Square";

	/**
	 * 
	 */
	protected static final String SYMBOL_TRIANGLE = "Triangle";

	/**
	 * 
	 */
	protected static final String SYMBOL_CROSS = "Cross";

	/**
	 * 
	 */
	protected static final String SYMBOL_TRANSVERSE_LINE = "Transverse line";

	/**
	 * 
	 */
	protected static final String SYMBOL_ARROW_HEAD = "Arrow head";

	/**
	 * 
	 */
	protected static final String NO_SYMBOL = "No symbol";



	/**
	 *
	 */
	public SGElementGroupArrow()
	{
		super();
	}



	/**
	 * 
	 */
	public int getLineType()
	{
		return this.mLineType;
	}
	
	
	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public float getHeadSize()
	{
		return this.mHeadSize;
	}


	/**
	 * 
	 */
	public float getHeadOpenAngle()
	{
		return this.mHeadOpenAngle;
	}


	/**
	 * 
	 */
	public float getHeadCloseAngle()
	{
		return this.mHeadCloseAngle;
	}


	/**
	 * 
	 */
	public float getHeadEdgeLineWidth()
	{
		return this.mHeadEdgeLineWidth;
	}


	/**
	 * 
	 */
	public Color getHeadEdgeLineColor()
	{
		return this.mHeadEdgeLineColor;
	}


	/**
	 * 
	 */
	public int getStartHeadType()
	{
		return this.mStartHeadType;
	}


	/**
	 * 
	 */
	public int getEndHeadType()
	{
		return this.mEndHeadType;
	}


	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		mLineType = type;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setLineType(mLineType);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		mLineWidth = width;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setLineWidth(mLineWidth);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadSize( final float size )
	{
		mHeadSize = size;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setHeadSize(mHeadSize);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadOpenAngle( final float angle )
	{
		mHeadOpenAngle = angle;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setHeadOpenAngle(mHeadOpenAngle);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadCloseAngle( final float angle )
	{
		mHeadCloseAngle = angle;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setHeadCloseAngle(mHeadCloseAngle);
		}
		return true;
	}



	/**
	 * 
	 */
	public boolean setHeadEdgeLineWidth( final float width )
	{
		mHeadEdgeLineWidth = width;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setHeadEdgeLineWidth(width);
		}
		return true;
	}



	/**
	 * 
	 */
	public boolean setHeadEdgeLineColor( final Color color )
	{
		mHeadEdgeLineColor = color;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setHeadEdgeLineColor(color);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setStartHeadType( final int type )
	{
		mStartHeadType = type;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setStartHeadType(type);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setEndHeadType( final int type )
	{
		mEndHeadType = type;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(ii);
			el.setEndHeadType(type);
		}
		return true;
	}


	/**
	 * 
	 */
	public SGDrawingElement getDrawingElement()
	{
		SGDrawingElementArrow arrow = new SGDrawingElementArrow2D();
		arrow.setLineType( mLineType );
		arrow.setLineWidth( mLineWidth );
		arrow.setColorList( mColorList );
		arrow.setHeadSize( mHeadSize );
		arrow.setHeadOpenAngle( mHeadOpenAngle );
		arrow.setHeadCloseAngle( mHeadCloseAngle );
		arrow.setHeadEdgeLineWidth( mHeadEdgeLineWidth );
		arrow.setHeadEdgeLineColor( mHeadEdgeLineColor );
		arrow.setStartHeadType( mStartHeadType );
		arrow.setEndHeadType( mEndHeadType );

		return arrow;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementArrow) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementArrow arrow = (SGDrawingElementArrow)element;

		this.mLineType = arrow.getLineType();
		this.mLineWidth = arrow.getLineWidth();
		this.mHeadSize = arrow.getHeadSize();
		this.mHeadOpenAngle = arrow.getHeadOpenAngle();
		this.mHeadCloseAngle = arrow.getHeadCloseAngle();
		this.mHeadEdgeLineWidth = arrow.getHeadEdgeLineWidth();
		this.mHeadEdgeLineColor = arrow.getHeadEdgeLineColor();
		this.mStartHeadType = arrow.getStartHeadType();
		this.mEndHeadType = arrow.getEndHeadType();

		return true;
	}


  /**
   * 
   */
	public boolean paintElement( final Graphics2D g2d )
	{
//System.out.println("paint");

		ArrayList colorList = new ArrayList(this.mColorList);
		if( this.mEnteredFlag )
		{
			ArrayList colorList_ = new ArrayList();
			for( int ii=0; ii<colorList.size(); ii++ )
			{
				Color colorOld = ((Color)colorList.get(ii));
/*		Color color_ = new Color(
			255 - colorOld.getRed(),
			255 - colorOld.getGreen(),
			255 - colorOld.getBlue()
		);
*/
				Color color_ = new Color(
					colorOld.getRed(),
					colorOld.getGreen(),
					colorOld.getBlue(),
					128
				);
				colorList_.add(color_);
			}
			this.setColorList(colorList_);
		}


		if( this.mSelectedFlag )
		{
			this.shiftColorList();
		}



		// body
		float width = (float)(mMagnification*this.mLineWidth);
//System.out.println("@@@ "+width);
		switch( this.mLineType )
		{
			case SGDrawingElementLine2D.LINE_TYPE_SOLID :
			{
				g2d.setStroke
				(
					new BasicStroke
					(
						width,
						BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER
					)
				);
				break;
			}

			case SGDrawingElementLine2D.LINE_TYPE_BROKEN :
			{
				float dash[] = {2.0f*width,width};
				g2d.setStroke
				(
					new BasicStroke
					(
						width,
						BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER,
						10.0f, dash, 0.0f
					)
				);
				break;
			}

			case SGDrawingElementLine2D.LINE_TYPE_DOT :
			{
				float dash[] = {width};
				g2d.setStroke
				(
					new BasicStroke
					(
						width,
						BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER,
						10.0f, dash, 0.0f
					)
				);
				break;
			}
					
			default :
			{
				throw new Error();					
			}

		}

		g2d.setPaint(this.getColor(0));
		for( int jj=0; jj<this.mDrawingElementList.size(); jj++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(jj);
			Shape shape = el.getBodyShape();

			g2d.draw(shape);
		}



		// head
		final float headLineWidth = (float)(mMagnification*this.mHeadEdgeLineWidth);
		g2d.setStroke( new BasicStroke( headLineWidth ) );
//System.out.println("$$$ "+headLineWidth);
		for( int jj=0; jj<mDrawingElementList.size(); jj++ )
		{
			SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementList.get(jj);

			Shape startShape = el.getStartHeadShape();
			if( startShape != null )
			{
				g2d.setPaint( this.mHeadEdgeLineColor );
				g2d.draw(startShape);

				g2d.setPaint(this.getColor(0));
				g2d.fill(startShape);
			}

			Shape endShape = el.getEndHeadShape();
			if( endShape != null )
			{
				g2d.setPaint( this.mHeadEdgeLineColor );
				g2d.draw(endShape);

				g2d.setPaint(this.getColor(0));
				g2d.fill(endShape);
			}
		}


		this.setColorList(colorList);

//System.out.println();

		return true;
	}




	/**
	 * 
	 */
	protected boolean shiftColorList()
	{

		super.shiftColorList();

		Color colorOld = (Color)this.mHeadEdgeLineColor;
		Color color_ = new Color(
			( colorOld.getRed() + 128 )%256,
			( colorOld.getGreen() + 128 )%256,
			( colorOld.getBlue() + 128 )%256
		);

		this.mHeadEdgeLineColor = color_;

		return true;
	}


	/**
	 * 
	 */
	public static String getSymbolTypeName( final int type )
	{
//System.out.println("type="+type);

		String typeName = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				typeName = SYMBOL_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE :
			{
				typeName = SYMBOL_SQUARE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE :
			{
				typeName = SYMBOL_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CROSS :
			{
				typeName = SYMBOL_CROSS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				typeName = SYMBOL_TRANSVERSE_LINE;
				break;
			}

			case SGDrawingElementArrow.SYMBOL_ARROW_HEAD :
			{
				typeName = SYMBOL_ARROW_HEAD;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				typeName = NO_SYMBOL;
				break;
			}

			default :
			{
				
			}
		}

		return typeName;
	}




	public static final String ARROW_TITLE = "<SGElementGroupArrow>";
	public static final String KEY_LINE_WIDTH = "Line Width";
	public static final String KEY_LINE_TYPE = "Line Type";
	public static final String KEY_HEAD_SIZE = "Head Size";
	public static final String KEY_START_HEAD_TYPE = "Start Head Type";
	public static final String KEY_END_HEAD_TYPE = "End Head Type";
	public static final String KEY_HEAD_LINE_WIDTH = "Head Line Width";
	public static final String KEY_HEAD_LINE_COLOR = "Head Line Color";
	public static final String KEY_HEAD_OPEN_ANGLE = "Head Open Angle";
	public static final String KEY_HEAD_CLOSE_ANGLE = "Head Close Angle";



	/**
	 * 
	 */
	public boolean writePropertyOfData( final Writer writer ) throws IOException
	{

		writer.write( ARROW_TITLE + "\n" );

		SGUtilityText.writePropertyLine( writer, KEY_LINE_WIDTH, new Float( this.mLineWidth ) );
		SGUtilityText.writePropertyLine( writer, KEY_LINE_TYPE, new Integer( this.mLineType ) );
		SGUtilityText.writePropertyLine( writer, KEY_HEAD_SIZE, new Float( this.mHeadSize*this.mRulerUnit ) );
		SGUtilityText.writePropertyLine( writer, KEY_START_HEAD_TYPE, new Integer( this.mStartHeadType ) );
		SGUtilityText.writePropertyLine( writer, KEY_END_HEAD_TYPE, new Integer( this.mEndHeadType ) );
		SGUtilityText.writePropertyLine( writer, KEY_HEAD_LINE_WIDTH, new Float( this.mHeadEdgeLineWidth ) );
		SGUtilityText.writeColorPropertyLine( writer, KEY_HEAD_LINE_COLOR, this.mHeadEdgeLineColor );
		SGUtilityText.writePropertyLine( writer, KEY_HEAD_OPEN_ANGLE, new Double( this.mHeadOpenAngle ) );
		SGUtilityText.writePropertyLine( writer, KEY_HEAD_CLOSE_ANGLE, new Double( this.mHeadCloseAngle ) );
		SGUtilityText.writeColorListPropertyLine( writer, KEY_COLOR_LIST, this.mColorList );


		return true;

	}

	

	/**
	 * 
	 */
	public SGProperties readProperties( final BufferedReader br ) throws IOException
	{
		return null;
	}


	/**
	 * 
	 */
	public boolean createDrawingElement(
		final ArrayList startRatioList,
		final ArrayList endRatioList )
	{

		mDrawingElementList.clear();

		if( startRatioList.size() != endRatioList.size() )
		{
			return false;
		}
		int num = startRatioList.size();


		ArrayList startRatioListNew = new ArrayList();
		ArrayList endRatioListNew = new ArrayList();
		for( int ii=0; ii<num; ii++ )
		{
			SGTuple2f startRatio = (SGTuple2f)startRatioList.get(ii);
			SGTuple2f endRatio = (SGTuple2f)endRatioList.get(ii);
			startRatioListNew.add(startRatio);
			endRatioListNew.add(endRatio);
		}

//System.out.println("startRatioListNew.size()=="+startRatioListNew.size());
//System.out.println("endRatioListNew.size()=="+endRatioListNew.size());
//System.out.println();

		// V{̕`vf쐬
		for( int ii=0; ii<startRatioListNew.size(); ii++ )
		{
			SGTuple2f startRatio = (SGTuple2f)startRatioListNew.get(ii);
			SGTuple2f endRatio = (SGTuple2f)endRatioListNew.get(ii);

//System.out.println( startRatio.x+"  "+startRatio.y+"  "+endRatio.x+"  "+endRatio.y);

			SGDrawingElementArrow2D arrow = (SGDrawingElementArrow2D)this.getDrawingElement();
			arrow.setTermPoints( startRatio, endRatio );
			arrow.setMagnification(mMagnification);

//System.out.println(arrow.getHeadOpenAngle()+"  "+arrow.getHeadCloseAngle());

			this.addDrawingElement( arrow );
		}

//System.out.println("mDrawingElementList.size()=="+mDrawingElementList.size());
//System.out.println();


		return true;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		ArrowProperties p = new ArrowProperties();
		this.getProperties(p);

		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof ArrowProperties ) == false ) return false;

		super.getProperties(p);

		ArrowProperties ap = (ArrowProperties)p;
		ap.setLineWidth( this.getLineWidth() );
		ap.setLineType( this.getLineType() );
		ap.setHeadSize( this.getHeadSize() );
		ap.setHeadLineWidth( this.getHeadEdgeLineWidth() );
		ap.setHeadLineColor( this.getHeadEdgeLineColor() );
		ap.setStartHeadType( this.getStartHeadType() );
		ap.setEndHeadType( this.getEndHeadType() );
		ap.setHeadOpenAngle( this.getHeadOpenAngle() );
		ap.setHeadCloseAngle( this.getHeadCloseAngle() );

		return true;
	}


	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof ArrowProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		ArrowProperties ap = (ArrowProperties)p;

		final Float lineWidth = ap.getLineWidth();
		if( lineWidth==null )
		{
			return false;
		}
		this.setLineWidth( lineWidth.floatValue() );

		final Integer lineType = ap.getLineType();
		if( lineType==null )
		{
			return false;
		}
		this.setLineType( lineType.intValue() );

		final Float headSize = ap.getHeadSize();
		if( headSize==null )
		{
			return false;
		}
		this.setHeadSize( headSize.floatValue() );

		final Float headLineWidth = ap.getHeadLineWidth();
		if( headLineWidth==null )
		{
			return false;
		}
		this.setHeadEdgeLineWidth( headLineWidth.floatValue() );

		Color headLineColor = ap.getHeadLineColor();
		if( headLineColor==null )
		{
			return false;
		}
		this.setHeadEdgeLineColor( headLineColor );

		final Integer startHeadType = ap.getStartHeadType();
		if( startHeadType==null )
		{
			return false;
		}
		this.setStartHeadType( startHeadType.intValue() );

		final Integer endHeadType = ap.getEndHeadType();
		if( endHeadType==null )
		{
			return false;
		}
		this.setEndHeadType( endHeadType.intValue() );

		final Float headOpenAngle = ap.getHeadOpenAngle();
		if( headOpenAngle==null )
		{
			return false;
		}
		this.setHeadOpenAngle( headOpenAngle.floatValue() );

		final Float headCloseAngle = ap.getHeadCloseAngle();
		if( headCloseAngle==null )
		{
			return false;
		}
		this.setHeadCloseAngle( headCloseAngle.floatValue() );

		return true;
	}





	/**
	 * 
	 */
	public static class ArrowProperties extends ElementGroupProperties
	{

/*		float lineWidth;
		int lineType;
		float headSize;
		int startHeadType;
		int endHeadType;
		float headLineWidth;
		Color headLineColor;
		double headOpenAngle;
		double headCloseAngle;
*/

		public static final String[] keys = {
			KEY_LINE_WIDTH,
			KEY_LINE_TYPE,
			KEY_HEAD_SIZE,
			KEY_START_HEAD_TYPE,
			KEY_END_HEAD_TYPE,
			KEY_HEAD_LINE_WIDTH,
			KEY_HEAD_LINE_COLOR,
			KEY_HEAD_OPEN_ANGLE,
			KEY_HEAD_CLOSE_ANGLE
		};



		/**
		 * 
		 *
		 */
		public ArrowProperties()
		{
			super();
		}



		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof ArrowProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

//System.out.println(obj);

			ArrowProperties p = (ArrowProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}



		public Float getLineWidth()
		{
			final String value = this.getProperty(KEY_LINE_WIDTH);
			return SGUtilityText.getFloat(value);
		}

		public Integer getLineType()
		{
			final String value = this.getProperty(KEY_LINE_TYPE);
			return SGUtilityText.getInteger(value);
		}

		public Float getHeadLineWidth()
		{
			final String value = this.getProperty(KEY_HEAD_LINE_WIDTH);
			return SGUtilityText.getFloat(value);
		}

		public Float getHeadSize()
		{
			final String value = this.getProperty(KEY_HEAD_SIZE);
			return SGUtilityText.getFloat(value);
		}

		public Color getHeadLineColor()
		{
			final String value = this.getProperty(KEY_HEAD_LINE_COLOR);
			return SGUtilityText.getColorFromString(value);
		}

		public Integer getStartHeadType()
		{
			final String value = this.getProperty(KEY_START_HEAD_TYPE);
			return SGUtilityText.getInteger(value);
		}

		public Integer getEndHeadType()
		{
			final String value = this.getProperty(KEY_END_HEAD_TYPE);
			return SGUtilityText.getInteger(value);
		}

		public Float getHeadOpenAngle()
		{
			final String value = this.getProperty(KEY_HEAD_OPEN_ANGLE);
			return SGUtilityText.getFloat(value);
		}

		public Float getHeadCloseAngle()
		{
			final String value = this.getProperty(KEY_HEAD_CLOSE_ANGLE);
			return SGUtilityText.getFloat(value);
		}


		public boolean setLineWidth( final float width )
		{
			if( width<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_LINE_WIDTH, new Float(width).toString() );
			return true;
		}

		public boolean setLineType( final int num )
		{
			this.setProperty( KEY_LINE_TYPE, new Integer(num).toString() );
			return true;
		}

		public boolean setHeadLineWidth( final float width )
		{
			if( width<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_HEAD_LINE_WIDTH, new Float(width).toString() );
			return true;
		}

		public boolean setStartHeadType( final int num )
		{
			this.setProperty( KEY_START_HEAD_TYPE, new Integer(num).toString() );
			return true;
		}

		public boolean setEndHeadType( final int num )
		{
			this.setProperty( KEY_END_HEAD_TYPE, new Integer(num).toString() );
			return true;
		}

		public boolean setHeadSize( final float size )
		{
			if( size<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_HEAD_SIZE, new Float(size).toString() );
			return true;
		}

		public boolean setHeadLineColor( final Color cl )
		{
			if( cl==null )
			{
				return false;
			}
			String str = SGUtilityText.getColorString(cl);
			if( str==null )
			{
				return false;
			}
			this.setProperty( KEY_HEAD_LINE_COLOR, str );
			return true;
		}

		public boolean setHeadOpenAngle( final float value )
		{
			this.setProperty( KEY_HEAD_OPEN_ANGLE, new Float(value).toString() );
			return true;
		}

		public boolean setHeadCloseAngle( final float value )
		{
			this.setProperty( KEY_HEAD_CLOSE_ANGLE, new Float(value).toString() );
			return true;
		}


		/**
		 * 
		 */
/*		public String toString()
		{
			String str = new String("[");
			str += new String("visible="+visible+", ");
			str += new String("colorList="+colorList+", ");
			str += new String("lineWidh="+lineWidth+", ");
			str += new String("headSize="+headSize+", ");
			str += new String("startHeadType="+startHeadType+", ");
			str += new String("endHeadType="+endHeadType+", ");
			str += new String("headLineWidth="+headLineWidth+", ");
			str += new String("headLineColor="+headLineColor+", ");
			str += new String("headOpenAngle="+headOpenAngle+", ");
			str += new String("headCloseAngle="+headCloseAngle+", ");
			str += new String("]");

			return str;
		}
*/


	}



}
