
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import javax.swing.plaf.FontUIResource;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


public abstract class SGElementGroupString extends SGElementGroup
{

	/**
	 * 
	 */
	protected String mFontFamilyName = SGConstants.FONT_FAMILY_NAME;


	/**
	 *
	 */
	protected float mFontSize = 1.0f/SGConstants.CM_POINT_RATIO;


	/**
	 *
	 */
	protected int mFontStyle = Font.PLAIN;


	/**
	 * 
	 */
	protected float mAngle = 0.0f;





	/**
	 * 
	 */
	public SGElementGroupString()
	{
		super();
	}



	/**
	 * 
	 */
	public boolean setFontFamilyName( final String name )
	{

		this.mFontFamilyName = name;

		for( int ii=0; ii<this.mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementString el
				= (SGDrawingElementString)this.mDrawingElementList.get(ii);
			el.setFontFamilyName(name);
		}

		return true;
	}
	


	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{

		this.mFontSize = size;

		for( int ii=0; ii<this.mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementString el
				= (SGDrawingElementString)this.mDrawingElementList.get(ii);
			el.setFontSize(size);
		}

		return true;
	}
	
	
	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{

		this.mFontStyle = style;

		for( int ii=0; ii<this.mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementString el
				= (SGDrawingElementString)this.mDrawingElementList.get(ii);
			el.setFontStyle(style);
		}

		return true;
	}
	

	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{

		this.mAngle = angle;

		for( int ii=0; ii<this.mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementString el
				= (SGDrawingElementString)this.mDrawingElementList.get(ii);
			el.setAngle(angle);
		}

		return true;
	}


	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return this.mFontFamilyName;
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.mFontSize;
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.mFontStyle;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return this.mAngle;
	}



	/**
	 * 
	 */
	public boolean paintElement( final Graphics2D g2d )
	{
		for( int ii=0; ii<this.mDrawingElementList.size(); ii++ )
		{
			final SGDrawingElementString2D el
				= (SGDrawingElementString2D)this.mDrawingElementList.get(ii);
			el.drawString(g2d);
		}

		return true;
	}



	/**
	 * 
	 */
	public SGDrawingElement getDrawingElement()
	{
		return null;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementString) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementString el = (SGDrawingElementString)element;
		
		this.setFontFamilyName( el.getFontFamilyName() );
		this.setFontSize( el.getFontSize() );
		this.setFontStyle( el.getFontStyle() );
		this.setAngle( el.getAngle() );

		return true;
	}


	public static final String PF_STRING_TITLE = "<String>";

	public static final String KEY_FONT_SIZE = "Font Size";
	public static final String KEY_FONT_FAMILY_NAME = "Font Family Name";
	public static final String KEY_FONT_STYLE = "Font Style";
	public static final String KEY_STRING_ANGLE = "Angle";


	/**
	 * 
	 */
	public boolean writePropertyOfData( final Writer writer ) throws IOException
	{

		writer.write( PF_STRING_TITLE + "\n" );

		SGUtilityText.writePropertyLine( writer, KEY_FONT_SIZE, new Float( this.mFontSize ) );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_FAMILY_NAME, this.mFontFamilyName );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_STYLE, new Integer( this.mFontStyle ) );
		SGUtilityText.writeColorListPropertyLine( writer, KEY_COLOR_LIST, this.mColorList );
		SGUtilityText.writePropertyLine( writer, KEY_STRING_ANGLE, new Double( - this.mAngle / (Math.PI/180.0) ) );

		writer.write("\n");

		return false;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		StringProperties p = new StringProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof StringProperties ) == false ) return false;

		super.getProperties(p);

		StringProperties sp = (StringProperties)p;
		sp.setFontFamilyName( this.getFontFamilyName() );
		sp.setFontSize( this.getFontSize() );
		sp.setFontStyle( this.getFontStyle() );
		sp.setAngle( this.getAngle() );

		return true;
	}


	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof StringProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;
		
		StringProperties sp = (StringProperties)p;
		this.setFontFamilyName( sp.getFontFamilyName() );

		final Float fontSize = sp.getFontSize();
		if( fontSize==null )
		{
			return false;
		}
		this.setFontSize( fontSize.floatValue() );

		final Integer fontStyle = sp.getFontStyle();
		if( fontStyle==null )
		{
			return false;
		}
		this.setFontStyle( fontStyle.intValue() );

		final Float angle = sp.getAngle();
		if( angle==null )
		{
			return false;
		}
		this.setAngle( angle.floatValue() );

		return true;
	}




	/**
	 * 
	 */
	public static class StringProperties extends ElementGroupProperties
	{
		
//		float fontSize;
//		int fontStyle;
//		String fontFamilyName;
//		double angle;


		public static final String[] keys = {
			KEY_FONT_SIZE, KEY_FONT_STYLE, KEY_FONT_FAMILY_NAME, KEY_STRING_ANGLE
		};



		/**
		 * 
		 *
		 */
		public StringProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof StringProperties ) == false )
			{
				return false;
			}
			
			if( super.equals(obj) == false ) return false;

			StringProperties p = (StringProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}



		public Float getFontSize()
		{
			final String value = this.getProperty(KEY_FONT_SIZE);
			return SGUtilityText.getFloat(value);
		}


		public Integer getFontStyle()
		{
			final String value = this.getProperty(KEY_FONT_STYLE);
			return SGUtilityText.getInteger(value);
		}


		public String getFontFamilyName()
		{
			return this.getProperty(KEY_FONT_FAMILY_NAME);
		}


		public Float getAngle()
		{
			final String value = this.getProperty(KEY_STRING_ANGLE);
			return SGUtilityText.getFloat(value);
		}


		public boolean setFontSize( final float size )
		{
			if( size<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_FONT_SIZE, new Float(size).toString() );
			return true;
		}


		public boolean setFontStyle( final int style )
		{
			this.setProperty( KEY_FONT_STYLE, new Integer(style).toString() );
			return true;
		}


		public boolean setFontFamilyName( final String name )
		{
			if( name==null )
			{
				return false;
			}
			this.setProperty( KEY_FONT_FAMILY_NAME, new String(name) );
			return true;
		}

		public boolean setAngle( final float angle )
		{
			this.setProperty( KEY_STRING_ANGLE, new Float(angle).toString() );
			return true;
		}



		/**
		 * 
		 */
/*		public String toString()
		{
			String str = new String("[");
			str += new String("visible="+visible+", ");
			str += new String("colorList="+colorList+", ");
			str += new String("fontSize="+fontSize+", ");
			str += new String("fontStyle="+fontStyle+", ");
			str += new String("fontFamilyName="+fontFamilyName+", ");
			str += new String("angle="+angle+", ");
			str += new String("]");

			return str;
		}
*/
	}


}

