/*
 * SGPropertyDialogSXYData.java
 *
 * Created on 2004/06/09, 15:05
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 *
 * @author  kuromaru
 */
public class SGPropertyDialogSXYData extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "SXY-Data Dialog";


    /** Creates new form SGPropertyDialogSXYData */
    public SGPropertyDialogSXYData(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();
        mTabbedPane = new javax.swing.JTabbedPane();
        mLinePanel = new javax.swing.JPanel();
        mLineVisibleCheckBox = new javax.swing.JCheckBox();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineColorLabel = new javax.swing.JLabel();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mLineColorButton = new javax.swing.JButton();
        mLineLeftSpaceLabel = new javax.swing.JLabel();
        mLineRightSpaceLabel = new javax.swing.JLabel();
        mSymbolPanel = new javax.swing.JPanel();
        mSymbolVisibleCheckBox = new javax.swing.JCheckBox();
        mSymbolTypeComboBox = new javax.swing.JComboBox();
        mSymbolLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSymbolTypeLabel = new javax.swing.JLabel();
        mSymbolSizeLabel = new javax.swing.JLabel();
        mSymbolLineWidthLabel = new javax.swing.JLabel();
        mSymbolSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSymbolLineColorLabel = new javax.swing.JLabel();
        mSymbolColorLabel = new javax.swing.JLabel();
        mSymbolLineColorButton = new javax.swing.JButton();
        mSymbolColorButton = new javax.swing.JButton();
        mSymbolBodyLabel = new javax.swing.JLabel();
        mSymbolLineLabel = new javax.swing.JLabel();
        mSymbolBodySeparator = new javax.swing.JSeparator();
        mSymbolLineSeparator = new javax.swing.JSeparator();
        mBarPanel = new javax.swing.JPanel();
        mBarVisibleCheckBox = new javax.swing.JCheckBox();
        mBarWidthLabel = new javax.swing.JLabel();
        mBarColorLabel = new javax.swing.JLabel();
        mBarBaseLineValueLabel = new javax.swing.JLabel();
        mBarLineWidthLabel = new javax.swing.JLabel();
        mBarLineColorLabel = new javax.swing.JLabel();
        mBarWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBarLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBarLineColorButton = new javax.swing.JButton();
        mBarBodyLabel = new javax.swing.JLabel();
        mBarLineLabel = new javax.swing.JLabel();
        mBarInnerColorButton = new javax.swing.JButton();
        mBarBodySeparator = new javax.swing.JSeparator();
        mBarLineSeparator = new javax.swing.JSeparator();
        mBarBaseLineTextField = new javax.swing.JTextField();
        mErrorBarPanel = new javax.swing.JPanel();
        mErrorBarVisibleCheckBox = new javax.swing.JCheckBox();
        mErrorBarSymbolSizeLabel = new javax.swing.JLabel();
        mErrorBarSymbolSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mErrorBarLineWidthLabel = new javax.swing.JLabel();
        mErrorBarLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mErrorBarColorLabel = new javax.swing.JLabel();
        mErrorBarTypeLabel = new javax.swing.JLabel();
        mErrorBarTypeComboBox = new javax.swing.JComboBox();
        mErrorBarColorButton = new javax.swing.JButton();
        mErrorBarStyleLabel = new javax.swing.JLabel();
        mErrorBarSymbolLabel = new javax.swing.JLabel();
        mErrorBarUpsideRadioButton = new javax.swing.JRadioButton();
        mErrorBarDownsideRadioButton = new javax.swing.JRadioButton();
        mErrorBarBothsidesRadioButton = new javax.swing.JRadioButton();
        mErrorBarStyleSeparator = new javax.swing.JSeparator();
        mErrorBarSymbolSeparator = new javax.swing.JSeparator();
        mTickLabelPanel = new javax.swing.JPanel();
        mTickLabelFontLabel = new javax.swing.JLabel();
        mTickLabelFontSizeLabel = new javax.swing.JLabel();
        mTickLabelAngleLabel = new javax.swing.JLabel();
        mTickLabelFontFamilyNameComboBox = new javax.swing.JComboBox();
        mTickLabelFontStyleComboBox = new javax.swing.JComboBox();
        mTickLabelHorizontalRadioButton = new javax.swing.JRadioButton();
        mTickLabelSlantRadioButton = new javax.swing.JRadioButton();
        mTickLabelVisibleCheckBox = new javax.swing.JCheckBox();
        mTickLabelFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mTickLabelColorButton = new javax.swing.JButton();
        mTickLabelColorLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mScaleReferenceLabel2.setText("(Data <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        mTabbedPane.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mLinePanel.setLayout(new java.awt.GridBagLayout());

        mLineVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mLinePanel.add(mLineVisibleCheckBox, gridBagConstraints);

        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLinePanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLinePanel.add(mLineTypeLabel, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLinePanel.add(mLineWidthLabel, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLinePanel.add(mLineColorLabel, gridBagConstraints);

        mLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLinePanel.add(mLineTypeComboBox, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLinePanel.add(mLineColorButton, gridBagConstraints);

        mLineLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mLinePanel.add(mLineLeftSpaceLabel, gridBagConstraints);

        mLineRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        mLinePanel.add(mLineRightSpaceLabel, gridBagConstraints);

        mTabbedPane.addTab("Line", mLinePanel);

        mSymbolPanel.setLayout(new java.awt.GridBagLayout());

        mSymbolVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mSymbolPanel.add(mSymbolVisibleCheckBox, gridBagConstraints);

        mSymbolTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolTypeComboBox.setPreferredSize(new java.awt.Dimension(90, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mSymbolPanel.add(mSymbolTypeComboBox, gridBagConstraints);

        mSymbolLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        mSymbolPanel.add(mSymbolLineWidthSpinner, gridBagConstraints);

        mSymbolTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mSymbolPanel.add(mSymbolTypeLabel, gridBagConstraints);

        mSymbolSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mSymbolPanel.add(mSymbolSizeLabel, gridBagConstraints);

        mSymbolLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 15, 5);
        mSymbolPanel.add(mSymbolLineWidthLabel, gridBagConstraints);

        mSymbolSizeSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mSymbolPanel.add(mSymbolSizeSpinner, gridBagConstraints);

        mSymbolLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 15, 5);
        mSymbolPanel.add(mSymbolLineColorLabel, gridBagConstraints);

        mSymbolColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSymbolColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mSymbolPanel.add(mSymbolColorLabel, gridBagConstraints);

        mSymbolLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        mSymbolPanel.add(mSymbolLineColorButton, gridBagConstraints);

        mSymbolColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mSymbolPanel.add(mSymbolColorButton, gridBagConstraints);

        mSymbolBodyLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mSymbolBodyLabel.setText("Body");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mSymbolPanel.add(mSymbolBodyLabel, gridBagConstraints);

        mSymbolLineLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mSymbolLineLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mSymbolPanel.add(mSymbolLineLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 40, 5, 5);
        mSymbolPanel.add(mSymbolBodySeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 40, 5, 5);
        mSymbolPanel.add(mSymbolLineSeparator, gridBagConstraints);

        mTabbedPane.addTab("Symbol", mSymbolPanel);

        mBarPanel.setLayout(new java.awt.GridBagLayout());

        mBarVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mBarVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mBarPanel.add(mBarVisibleCheckBox, gridBagConstraints);

        mBarWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBarWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mBarPanel.add(mBarWidthLabel, gridBagConstraints);

        mBarColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBarColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mBarPanel.add(mBarColorLabel, gridBagConstraints);

        mBarBaseLineValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBarBaseLineValueLabel.setText("Base Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mBarPanel.add(mBarBaseLineValueLabel, gridBagConstraints);

        mBarLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBarLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 15, 5);
        mBarPanel.add(mBarLineWidthLabel, gridBagConstraints);

        mBarLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBarLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 15, 5);
        mBarPanel.add(mBarLineColorLabel, gridBagConstraints);

        mBarWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mBarPanel.add(mBarWidthSpinner, gridBagConstraints);

        mBarLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        mBarPanel.add(mBarLineWidthSpinner, gridBagConstraints);

        mBarLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        mBarPanel.add(mBarLineColorButton, gridBagConstraints);

        mBarBodyLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mBarBodyLabel.setText("Body");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mBarPanel.add(mBarBodyLabel, gridBagConstraints);

        mBarLineLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mBarLineLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mBarPanel.add(mBarLineLabel, gridBagConstraints);

        mBarInnerColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mBarPanel.add(mBarInnerColorButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 40, 5, 5);
        mBarPanel.add(mBarBodySeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 40, 5, 5);
        mBarPanel.add(mBarLineSeparator, gridBagConstraints);

        mBarBaseLineTextField.setHorizontalAlignment(javax.swing.JTextField.LEFT);
        mBarBaseLineTextField.setText("0.0");
        mBarBaseLineTextField.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mBarPanel.add(mBarBaseLineTextField, gridBagConstraints);

        mTabbedPane.addTab("Bar", mBarPanel);

        mErrorBarPanel.setLayout(new java.awt.GridBagLayout());

        mErrorBarVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mErrorBarPanel.add(mErrorBarVisibleCheckBox, gridBagConstraints);

        mErrorBarSymbolSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarSymbolSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mErrorBarPanel.add(mErrorBarSymbolSizeLabel, gridBagConstraints);

        mErrorBarSymbolSizeSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarSymbolSizeSpinner, gridBagConstraints);

        mErrorBarLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarLineWidthLabel, gridBagConstraints);

        mErrorBarLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarLineWidthSpinner, gridBagConstraints);

        mErrorBarColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarColorLabel, gridBagConstraints);

        mErrorBarTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mErrorBarPanel.add(mErrorBarTypeLabel, gridBagConstraints);

        mErrorBarTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarTypeComboBox.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarTypeComboBox, gridBagConstraints);

        mErrorBarColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarColorButton, gridBagConstraints);

        mErrorBarStyleLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mErrorBarStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarStyleLabel, gridBagConstraints);

        mErrorBarSymbolLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mErrorBarSymbolLabel.setText("Symbol ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mErrorBarPanel.add(mErrorBarSymbolLabel, gridBagConstraints);

        mErrorBarUpsideRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarUpsideRadioButton.setText("Upside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mErrorBarPanel.add(mErrorBarUpsideRadioButton, gridBagConstraints);

        mErrorBarDownsideRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarDownsideRadioButton.setText("Downside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mErrorBarPanel.add(mErrorBarDownsideRadioButton, gridBagConstraints);

        mErrorBarBothsidesRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mErrorBarBothsidesRadioButton.setText("Bothsides");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mErrorBarPanel.add(mErrorBarBothsidesRadioButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 40, 5, 5);
        mErrorBarPanel.add(mErrorBarStyleSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 55, 5, 5);
        mErrorBarPanel.add(mErrorBarSymbolSeparator, gridBagConstraints);

        mTabbedPane.addTab("Error Bar", mErrorBarPanel);

        mTickLabelPanel.setLayout(new java.awt.GridBagLayout());

        mTickLabelFontLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelFontLabel.setText("Font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelFontLabel, gridBagConstraints);

        mTickLabelFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelFontSizeLabel, gridBagConstraints);

        mTickLabelAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelAngleLabel, gridBagConstraints);

        mTickLabelFontFamilyNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelFontFamilyNameComboBox, gridBagConstraints);

        mTickLabelFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelFontStyleComboBox, gridBagConstraints);

        mTickLabelHorizontalRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelHorizontalRadioButton, gridBagConstraints);

        mTickLabelSlantRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelSlantRadioButton.setText("Inclined");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelSlantRadioButton, gridBagConstraints);

        mTickLabelVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mTickLabelPanel.add(mTickLabelVisibleCheckBox, gridBagConstraints);

        mTickLabelFontSizeSpinner.setPreferredSize(new java.awt.Dimension(55, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelFontSizeSpinner, gridBagConstraints);

        mTickLabelColorButton.setPreferredSize(new java.awt.Dimension(55, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelColorButton, gridBagConstraints);

        mTickLabelColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTickLabelColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTickLabelPanel.add(mTickLabelColorLabel, gridBagConstraints);

        mTabbedPane.addTab("Tick Label", mTickLabelPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(mTabbedPane, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new SGPropertyDialogSXYData(new javax.swing.JFrame(), true).show();
    }
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JTextField mBarBaseLineTextField;
    private javax.swing.JLabel mBarBaseLineValueLabel;
    private javax.swing.JLabel mBarBodyLabel;
    private javax.swing.JSeparator mBarBodySeparator;
    private javax.swing.JLabel mBarColorLabel;
    private javax.swing.JButton mBarInnerColorButton;
    private javax.swing.JButton mBarLineColorButton;
    private javax.swing.JLabel mBarLineColorLabel;
    private javax.swing.JLabel mBarLineLabel;
    private javax.swing.JSeparator mBarLineSeparator;
    private javax.swing.JLabel mBarLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mBarLineWidthSpinner;
    private javax.swing.JPanel mBarPanel;
    private javax.swing.JCheckBox mBarVisibleCheckBox;
    private javax.swing.JLabel mBarWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mBarWidthSpinner;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JRadioButton mErrorBarBothsidesRadioButton;
    private javax.swing.JButton mErrorBarColorButton;
    private javax.swing.JLabel mErrorBarColorLabel;
    private javax.swing.JRadioButton mErrorBarDownsideRadioButton;
    private javax.swing.JLabel mErrorBarLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mErrorBarLineWidthSpinner;
    private javax.swing.JPanel mErrorBarPanel;
    private javax.swing.JLabel mErrorBarStyleLabel;
    private javax.swing.JSeparator mErrorBarStyleSeparator;
    private javax.swing.JLabel mErrorBarSymbolLabel;
    private javax.swing.JSeparator mErrorBarSymbolSeparator;
    private javax.swing.JLabel mErrorBarSymbolSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mErrorBarSymbolSizeSpinner;
    private javax.swing.JComboBox mErrorBarTypeComboBox;
    private javax.swing.JLabel mErrorBarTypeLabel;
    private javax.swing.JRadioButton mErrorBarUpsideRadioButton;
    private javax.swing.JCheckBox mErrorBarVisibleCheckBox;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JLabel mLineLeftSpaceLabel;
    private javax.swing.JPanel mLinePanel;
    private javax.swing.JLabel mLineRightSpaceLabel;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JCheckBox mLineVisibleCheckBox;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JLabel mSymbolBodyLabel;
    private javax.swing.JSeparator mSymbolBodySeparator;
    private javax.swing.JButton mSymbolColorButton;
    private javax.swing.JLabel mSymbolColorLabel;
    private javax.swing.JButton mSymbolLineColorButton;
    private javax.swing.JLabel mSymbolLineColorLabel;
    private javax.swing.JLabel mSymbolLineLabel;
    private javax.swing.JSeparator mSymbolLineSeparator;
    private javax.swing.JLabel mSymbolLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSymbolLineWidthSpinner;
    private javax.swing.JPanel mSymbolPanel;
    private javax.swing.JLabel mSymbolSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSymbolSizeSpinner;
    private javax.swing.JComboBox mSymbolTypeComboBox;
    private javax.swing.JLabel mSymbolTypeLabel;
    private javax.swing.JCheckBox mSymbolVisibleCheckBox;
    private javax.swing.JTabbedPane mTabbedPane;
    private javax.swing.JLabel mTickLabelAngleLabel;
    private javax.swing.JButton mTickLabelColorButton;
    private javax.swing.JLabel mTickLabelColorLabel;
    private javax.swing.JComboBox mTickLabelFontFamilyNameComboBox;
    private javax.swing.JLabel mTickLabelFontLabel;
    private javax.swing.JLabel mTickLabelFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mTickLabelFontSizeSpinner;
    private javax.swing.JComboBox mTickLabelFontStyleComboBox;
    private javax.swing.JRadioButton mTickLabelHorizontalRadioButton;
    private javax.swing.JPanel mTickLabelPanel;
    private javax.swing.JRadioButton mTickLabelSlantRadioButton;
    private javax.swing.JCheckBox mTickLabelVisibleCheckBox;
    // ϐ錾̏I//GEN-END:variables




	private JRadioButton mNoSelectionButtonAxis = new JRadioButton();
	private JRadioButton mNoSelectionButtonErrorBarStyle = new JRadioButton();
	private JRadioButton mNoSelectionButtonTickLabelAngle = new JRadioButton();



   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGPropertyDialogSXYData.TITLE );


		//
		{
			this.mNoSelectionButtonAxis.setVisible(false);
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mLeftTopRadioButton );
			group.add( this.mLeftBottomRadioButton );
			group.add( this.mRightTopRadioButton );
			group.add( this.mRightBottomRadioButton );
			group.add( this.mNoSelectionButtonAxis );
		}


		//
		{
			final String typeArray[] = {
				SGDrawingElementLine.LINE_NAME_SOLID,
				SGDrawingElementLine.LINE_NAME_BROKEN,
				SGDrawingElementLine.LINE_NAME_DOT
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mLineTypeComboBox.addItem( typeArray[ii] );
			}
		}


		//
		{

			final Object typeArray[] = {
				SGDrawingElementSymbol.SYMBOL_CIRCLE,
				SGDrawingElementSymbol.SYMBOL_SQUARE,
				SGDrawingElementSymbol.SYMBOL_TRIANGLE,
				SGDrawingElementSymbol.SYMBOL_INVERTED_TRIANGLE,
				SGDrawingElementSymbol.SYMBOL_CROSS,
				SGDrawingElementSymbol.SYMBOL_PLUS
			};

/*
final Object typeArray[] = {
	triangleIcon
};
*/
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mSymbolTypeComboBox.addItem( typeArray[ii] );
			}
		}


		//
		{
			final String typeArray[] = {
				SGElementGroupArrow.SYMBOL_CIRCLE,
				SGElementGroupArrow.SYMBOL_TRANSVERSE_LINE,
				SGElementGroupArrow.NO_SYMBOL
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mErrorBarTypeComboBox.addItem( typeArray[ii] );
			}


			//
			{
				this.mNoSelectionButtonErrorBarStyle.setVisible(false);
				final ButtonGroup group = new ButtonGroup();
				group.add( this.mErrorBarBothsidesRadioButton );
				group.add( this.mErrorBarUpsideRadioButton );
				group.add( this.mErrorBarDownsideRadioButton );
				group.add( this.mNoSelectionButtonErrorBarStyle );
			}
			
		}


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontFamilyNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mTickLabelFontFamilyNameComboBox.addItem( fontArray[ii] );
			}

			final String[] styleNameArray = {
				SGConstants.FONT_PLAIN,
				SGConstants.FONT_ITALIC,
				SGConstants.FONT_BOLD,
				SGConstants.FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mTickLabelFontStyleComboBox.addItem( styleNameArray[ii] );
			}


			//
			{
				this.mNoSelectionButtonTickLabelAngle.setVisible(false);
				ButtonGroup group = new ButtonGroup();
				group.add( this.mTickLabelHorizontalRadioButton );
				group.add( this.mTickLabelSlantRadioButton );
				group.add( this.mNoSelectionButtonTickLabelAngle );
			}

		}


		this.pack();



		//
		// Xsi[f̓Kp
		//

		// line
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// bar
		this.mBarWidthSpinner.initProperties(
			new SpinnerNumberModel( 0.1, 0.05, 5.0, 0.01 ),
			SGSpinner.SPINNER_UNIT_CM );

		this.mBarLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// symbol
		this.mSymbolSizeSpinner.initProperties(
			new SpinnerNumberModel( 0.1, 0.05, 2.0, 0.01 ),
			SGSpinner.SPINNER_UNIT_CM );

		this.mSymbolLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// error bar
		this.mErrorBarLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		this.mErrorBarSymbolSizeSpinner.initProperties(
			new SpinnerNumberModel( 0.1, 0.05, 2.0, 0.01 ),
			SGSpinner.SPINNER_UNIT_CM );

		// tick label
		this.mTickLabelFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}


		// FύX{^ɃANVXiǉ
		this.mLineColorButton.addActionListener(this);
		this.mSymbolColorButton.addActionListener(this);
		this.mSymbolLineColorButton.addActionListener(this);
		this.mBarInnerColorButton.addActionListener(this);
		this.mBarLineColorButton.addActionListener(this);
		this.mErrorBarColorButton.addActionListener(this);
		this.mTickLabelColorButton.addActionListener(this);


		// ؂ւ`FbN{bNXɃANVXiǉ
		this.mLineVisibleCheckBox.addActionListener(this);
		this.mSymbolVisibleCheckBox.addActionListener(this);
		this.mBarVisibleCheckBox.addActionListener(this);
		this.mErrorBarVisibleCheckBox.addActionListener(this);
		this.mTickLabelVisibleCheckBox.addActionListener(this);


		//
		this.mTabbedPane.addChangeListener(this);


		return true;

	}



	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{

		// OK,Cancel,Preview
//		this.mOKButton.addActionListener(listener);
//		this.mCancelButton.addActionListener(listener);
//		this.mPreviewButton.addActionListener(listener);

/*
		//
		this.mBarBaseLineTextField.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}
*/
		return true;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );
			this.mBarBaseLineTextField.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public JTabbedPane getTabbedPane()
	{
		return this.mTabbedPane;
	}


	/**
	 * 
	 */
	public JPanel getLinePanel()
	{
		return this.mLinePanel;
	}


	/**
	 * 
	 */
	public JPanel getSymbolPanel()
	{
		return this.mSymbolPanel;
	}


	/**
	 * 
	 */
	public JPanel getBarPanel()
	{
		return this.mBarPanel;
	}
        

	/**
	 * 
	 */
	public JPanel getErrorBarPanel()
	{
		return this.mErrorBarPanel;
	}


	/**
	 * 
	 */
	public JPanel getTickLabelPanel()
	{
		return this.mTickLabelPanel;
	}


	/**
	 * 
	 */
	public boolean isLeftTopSelected()
	{
		return this.mLeftTopRadioButton.isSelected();
	}


	/**
	 * 
	 */
	public boolean isLeftBottomSelected()
	{
		return this.mLeftBottomRadioButton.isSelected();
	}

	/**
	 * 
	 */
	public boolean isRightTopSelected()
	{
		return this.mRightTopRadioButton.isSelected();
	}

	/**
	 * 
	 */
	public boolean isRightBottomSelected()
	{
		return this.mRightBottomRadioButton.isSelected();
	}


	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}





//
// Line
//


	/**
	 * 
	 */
	public boolean getLineVisible()
	{
		return this.mLineVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Integer getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		return num;
	}


	/**
	 * 
	 */
	public ArrayList getLineColorList()
	{
		Color cl = this.mLineColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}


	/**
	 * 
	 */
	public boolean setLineVisible( final boolean flag )
	{
		this.mLineVisibleCheckBox.setSelected( flag );
		this.setLineTabEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final Object obj )
	{
		if( obj==null )
		{
			this.mLineWidthSpinner.setText("");
			return false;
		}
		Float width = null;
		try
		{
			width = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mLineWidthSpinner.setValue( width );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineType( final Object obj )
	{
		if( obj==null )
		{
			this.mLineTypeComboBox.setSelectedItem(null);
			return false;
		}
		Integer type = null;
		try
		{
			type = Integer.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		final String typeName = SGDrawingElementLine.getLineTypeName( type.intValue() );
		this.mLineTypeComboBox.setSelectedItem(typeName);
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineColorList( final ArrayList cList )
	{
		Color cl = null;
		if( cList!=null )
		{
			if( cList.size()!=0 )
			{
				cl = (Color)cList.get(0);
			}
		}
		this.mLineColorButton.setBackground( cl );
		return true;
	}






//
// Symbol
//


	/**
	 * 
	 */
	public boolean getSymbolVisible()
	{
		return this.mSymbolVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getSymbolSize()
	{
		return this.mSymbolSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Integer getSymbolType()
	{
		final String typeName = (String)this.mSymbolTypeComboBox.getSelectedItem();
		final Integer num = SGDrawingElementSymbol.getSymbolTypeFromName( typeName );
		return num;
	}


	/**
	 * 
	 */
	public Number getSymbolLineWidth()
	{
		return this.mSymbolLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public ArrayList getSymbolColorList()
	{
		Color cl = this.mSymbolColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}


	/**
	 * 
	 */
	public Color getSymbolLineColor()
	{
		return this.mSymbolLineColorButton.getBackground();
	}


	/**
	 * 
	 */
	public boolean setSymbolVisible( final boolean flag )
	{
		this.mSymbolVisibleCheckBox.setSelected( flag );
		this.setSymbolTabEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setSymbolType( final Object obj )
	{
		if( obj==null )
		{
			this.mSymbolTypeComboBox.setSelectedItem(null);
			return false;
		}
		Integer type = null;
		try
		{
			type = Integer.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		final String typeName = SGDrawingElementSymbol.getSymbolTypeName( type.intValue() );
		this.mSymbolTypeComboBox.setSelectedItem(typeName);
		return true;
	}


	/**
	 * 
	 */
	public boolean setSymbolSize( final Object obj )
	{
		if( obj==null )
		{
			this.mSymbolSizeSpinner.setText("");
			return false;
		}
		Float size = null;
		try
		{
			size = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		this.mSymbolSizeSpinner.setValue( size );

		return true;
	}



	/**
	 * 
	 */
	public boolean setSymbolLineWidth( final Object obj )
	{
		if( obj==null )
		{
			this.mSymbolLineWidthSpinner.setText("");
			return false;
		}
		Float width = null;
		try
		{
			width = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		this.mSymbolLineWidthSpinner.setValue( width );

		return true;
	}


	/**
	 * 
	 */
	public boolean setSymbolColorList( final ArrayList cList )
	{
		Color cl = null;
		if( cList!=null )
		{
			if( cList.size()!=0 )
			{
				cl = (Color)cList.get(0);
			}
		}
		this.mSymbolColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setSymbolLineColor( final Color cl )
	{
		this.mSymbolLineColorButton.setBackground( cl );
		return true;
	}






//
// Bar
//


	/**
	 * 
	 */
	public boolean getBarVisible()
	{
		return this.mBarVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getBarWidth()
	{
		return this.mBarWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getBarEdgeLineWidth()
	{
		return this.mBarLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getBarBaselineValue()
	{
		String str = this.mBarBaseLineTextField.getText();
		Double num = null;
		try
		{
			num = Double.valueOf(str);
		}
		catch( NumberFormatException ex )
		{

		}
		return num;
	}


	/**
	 * 
	 */
	public Color getBarEdgeLineColor()
	{
		return this.mBarLineColorButton.getBackground();
	}


	/**
	 * 
	 */
	public ArrayList getBarInnerColorList()
	{
		Color cl = this.mBarInnerColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}



	/**
	 * 
	 */
	public boolean setBarVisible( final boolean flag )
	{
		this.mBarVisibleCheckBox.setSelected( flag );
		this.setBarTabEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setBarWidth( final Object obj )
	{
		if( obj==null )
		{
			this.mBarWidthSpinner.setText("");
			return false;
		}
		Float width = null;
		try
		{
			width = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		this.mBarWidthSpinner.setValue( width );
		return true;
	}



	/**
	 * 
	 */
	public boolean setBarEdgeLineWidth( final Object obj )
	{
		if( obj==null )
		{
			this.mBarLineWidthSpinner.setText("");
			return false;
		}
		Float width = null;
		try
		{
			width = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mBarLineWidthSpinner.setValue( width );
		return true;
	}


	/**
	 * 
	 */
	public boolean setBarBaselineValue( final Object obj )
	{
		if( obj==null )
		{
			this.mBarBaseLineTextField.setText("");
			return false;
		}
		Double value = null;
		try
		{
			value = Double.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mBarBaseLineTextField.setText( value.toString() );
		return true;
	}



	/**
	 * 
	 */
	public boolean setBarInnerColorList( final ArrayList cList )
	{
		Color cl = null;
		if( cList!=null )
		{
			if( cList.size()!=0 )
			{
				cl = (Color)cList.get(0);
			}
		}
		this.mBarInnerColorButton.setBackground( cl );
		return true;
	}



	/**
	 * 
	 */
	public boolean setBarEdgeLineColor( final Color cl )
	{
		this.mBarLineColorButton.setBackground( cl );
		return true;
	}





//
// Error Bar
//


	/**
	 * 
	 */
	public boolean getErrorBarVisible()
	{
		return this.mErrorBarVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getErrorBarSymbolSize()
	{
		return this.mErrorBarSymbolSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getErrorBarLineWidth()
	{
		return this.mErrorBarLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public ArrayList getErrorBarColorList()
	{
		Color cl = this.mErrorBarColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}


	/**
	 * 
	 */
	public String getErrorBarTypeName()
	{
		return (String)this.mErrorBarTypeComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public Integer getErrorBarStyle()
	{
		int style = -1;
		if( this.mErrorBarBothsidesRadioButton.isSelected() )
		{
			style = SGElementGroupErrorBar.ERROR_BAR_FULL;
		}
		else if( this.mErrorBarUpsideRadioButton.isSelected() )
		{
			style = SGElementGroupErrorBar.ERROR_BAR_UPPER_ONLY;
		}
		else if( this.mErrorBarDownsideRadioButton.isSelected() )
		{
			style = SGElementGroupErrorBar.ERROR_BAR_LOWER_ONLY;
		}
		else
		{
			return null;
		}

		return new Integer(style);
	}



	/**
	 * 
	 */
	public boolean setErrorBarVisible( final boolean flag )
	{
		this.mErrorBarVisibleCheckBox.setSelected( flag );
		this.setErrorBarTabEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setErrorBarSymbolSize( final Object obj )
	{
		if( obj==null )
		{
			this.mErrorBarSymbolSizeSpinner.setText("");
			return false;
		}
		Float size = null;
		try
		{
			size = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mErrorBarSymbolSizeSpinner.setValue( size );
		return true;
	}


	/**
	 * 
	 */
	public boolean setErrorBarLineWidth( final Object obj )
	{
		if( obj==null )
		{
			this.mErrorBarLineWidthSpinner.setText("");
			return false;
		}
		Float width = null;
		try
		{
			width = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mErrorBarLineWidthSpinner.setValue( width );
		return true;
	}


	/**
	 * 
	 */
	public boolean setErrorBarColorList( final ArrayList cList )
	{
		Color cl = null;
		if( cList!=null )
		{
			if( cList.size()!=0 )
			{
				cl = (Color)cList.get(0);
			}
		}
		this.mErrorBarColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setErrorBarType( final String typeName )
	{
		this.mErrorBarTypeComboBox.setSelectedItem(typeName);
		return true;
	}


	/**
	 * 
	 */
	public boolean setErrorBarStyle( final Object obj )
	{
		if( obj==null )
		{
			this.mNoSelectionButtonErrorBarStyle.setSelected(true);
			return false;
		}
		Integer style = null;
		try
		{
			style = Integer.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		switch( style.intValue() )
		{
			case SGElementGroupErrorBar.ERROR_BAR_FULL :
			{
				this.mErrorBarBothsidesRadioButton.setSelected(true);
				break;
			}

			case SGElementGroupErrorBar.ERROR_BAR_UPPER_ONLY :
			{
				this.mErrorBarUpsideRadioButton.setSelected(true);
				break;
			}

			case SGElementGroupErrorBar.ERROR_BAR_LOWER_ONLY :
			{
				this.mErrorBarDownsideRadioButton.setSelected(true);
				break;
			}
				
			default :
			{
				throw new Error();
			}
		}
	
		return true;
	}





//
// Tick Label
//


	/**
	 * 
	 */
	public boolean getTickLabelVisible()
	{
		return this.mTickLabelVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public String getTickLabelFontFamilyName()
	{
		return (String)this.mTickLabelFontFamilyNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public Number getTickLabelFontSize()
	{
		return this.mTickLabelFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Integer getTickLabelFontStyle()
	{
		final String name = (String)this.mTickLabelFontStyleComboBox.getSelectedItem();
		final int num = SGUtilityText.getFontStyle(name);
		return new Integer(num);
	}


	/**
	 * 
	 */
	public Number getTickLabelAngle()
	{
		float angle = 0.0f;

		if( this.mTickLabelHorizontalRadioButton.isSelected() )
		{
			angle = SGElementGroupTickLabel.ANGLE_HORIZONTAL;
		}
		else if( this.mTickLabelSlantRadioButton.isSelected() )
		{
			angle = SGElementGroupTickLabel.ANGLE_INCLINED;
		}

		return new Float(angle);
	}


	/**
	 * 
	 */
	public ArrayList getTickLabelColorList()
	{
		Color cl = this.mTickLabelColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}



	/**
	 * 
	 */
	public boolean setTickLabelVisible( final boolean flag )
	{
		this.mTickLabelVisibleCheckBox.setSelected( flag );
		this.setTickLabelTabEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTickLabelFontFamilyName( final String name )
	{
		this.mTickLabelFontFamilyNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTickLabelFontSize( final Object obj )
	{
		if( obj==null )
		{
			this.mTickLabelFontSizeSpinner.setText("");
			return false;
		}
		Float size = null;
		try
		{
			size = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		this.mTickLabelFontSizeSpinner.setValue( size );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTickLabelFontStyle( final Object obj )
	{
		if( obj==null )
		{
			this.mTickLabelFontStyleComboBox.setSelectedItem(null);
			return false;
		}
		Integer style = null;
		try
		{
			style = Integer.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mTickLabelFontStyleComboBox.setSelectedItem( SGUtilityText.getFontStyleName( style.intValue() ) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTickLabelAngle( final Object obj )
	{
		if( obj==null )
		{
			this.mNoSelectionButtonTickLabelAngle.setSelected(true);
			return false;
		}
		Float angle = null;
		try
		{
			angle = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}

		final float value = angle.floatValue();
		if( value == SGElementGroupTickLabel.ANGLE_HORIZONTAL )
		{
			this.mTickLabelHorizontalRadioButton.setSelected(true);
		}
		else if( value == SGElementGroupTickLabel.ANGLE_INCLINED )
		{
			this.mTickLabelSlantRadioButton.setSelected(true);
		}
		else
		{
			throw new Error();
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setTickLabelColorList( final ArrayList cList )
	{
		Color cl = null;
		if( cList!=null )
		{
			if( cList.size()!=0 )
			{
				cl = (Color)cList.get(0);
			}
		}
		this.mTickLabelColorButton.setBackground( cl );
		return true;
	}





	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineColorButton );
		list.add( this.mSymbolColorButton );
		list.add( this.mSymbolLineColorButton );
		list.add( this.mBarInnerColorButton );
		list.add( this.mBarLineColorButton );
		list.add( this.mErrorBarColorButton );
		list.add( this.mTickLabelColorButton );

		return list;
	}



	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add(this.mBarBaseLineTextField);
		return list;
	}



	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		list.add( this.mSymbolSizeSpinner );
		list.add( this.mSymbolLineWidthSpinner );
		list.add( this.mBarWidthSpinner );
		list.add( this.mBarLineWidthSpinner );
		list.add( this.mErrorBarLineWidthSpinner );
		list.add( this.mErrorBarSymbolSizeSpinner );
		list.add( this.mTickLabelFontSizeSpinner );

		return list;
	}



	/**
	 * 
	 */
	public boolean setTabEnabled( final Component com, final boolean flag )
	{
		if( com == null )
		{
			return false;
		}
		final int index = this.mTabbedPane.indexOfComponent(com);
		if( index == -1 )
		{
			return false;
		}

		this.mTabbedPane.setEnabledAt(index,flag);

		// set enabled all components on the panel
		this.setComponentsOnPanelEnabled(com,flag);

		return true;
	}



	/**
	 * 
	 * @param com
	 * @return
	 */
	public boolean isTabEnabled( final Component com )
	{
		if( com == null )
		{
			return false;
		}
		final int index = this.mTabbedPane.indexOfComponent(com);
		if( index == -1 )
		{
			return false;
		}
		return this.mTabbedPane.isEnabledAt(index);
	}



	/**
	 * 
	 * @param p
	 * @return
	 */
	protected boolean setComponentsOnPanelEnabled( final Component com, final boolean flag )
	{
		if( com==null )
		{
			return false;
		}

		if( com.equals( this.mLinePanel ) )
		{
			this.mLineVisibleCheckBox.setEnabled(flag);
			this.setLineTabEnabled(flag&this.mLineVisibleCheckBox.isSelected());
		}
		else if( com.equals( this.mSymbolPanel ) )
		{
			this.mSymbolVisibleCheckBox.setEnabled(flag);
			this.setSymbolTabEnabled(flag&this.mSymbolVisibleCheckBox.isSelected());
		}
		else if( com.equals( this.mBarPanel ) )
		{
			this.mBarVisibleCheckBox.setEnabled(flag);
			this.setBarTabEnabled(flag&this.mBarVisibleCheckBox.isSelected());
		}
		else if( com.equals( this.mErrorBarPanel ) )
		{
			this.mErrorBarVisibleCheckBox.setEnabled(flag);
			this.setErrorBarTabEnabled(flag&this.mErrorBarVisibleCheckBox.isSelected());
		}
		else if( com.equals( this.mTickLabelPanel ) )
		{
			this.mTickLabelVisibleCheckBox.setEnabled(flag);
			this.setTickLabelTabEnabled(flag&this.mTickLabelVisibleCheckBox.isSelected());
		}

		return true;
	}




	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{

		super.actionPerformed(e);

		Object source = e.getSource();

		if( source instanceof JCheckBox )
		{
			JCheckBox cb = (JCheckBox)source;
			boolean flag = cb.isSelected();

			JButton btn = null;
			if( source.equals( this.mLineVisibleCheckBox ) )
			{
				this.setLineTabEnabled( flag );
				btn = this.mLineColorButton;
			}
			else if( source.equals( this.mSymbolVisibleCheckBox ) )
			{
				this.setSymbolTabEnabled( flag );
				btn = this.mSymbolColorButton;
			}
			else if( source.equals( this.mBarVisibleCheckBox ) )
			{
				this.setBarTabEnabled( flag );
				btn = this.mBarInnerColorButton;
			}
			else if( source.equals( this.mErrorBarVisibleCheckBox ) )
			{
				this.setErrorBarTabEnabled( flag );
				btn = this.mErrorBarColorButton;
			}
			else if( source.equals( this.mTickLabelVisibleCheckBox ) )
			{
				this.setTickLabelTabEnabled( flag );
				btn = this.mTickLabelColorButton;
			}
			else
			{
				throw new Error();
			}
			
			this.setColorButtonBorder(btn,flag);

		}

		repaint();			

	}




	/**
	 * 
	 */
	private JButton mFocusedLineColorButton = null;
	private JButton mFocusedSymbolColorButton = null;
	private JButton mFocusedBarColorButton = null;
	private JButton mFocusedErrorBarColorButton = null;
	private JButton mFocusedTickLabelColorButton = null;





	/**
	 * 
	 */
	protected boolean setLineTabEnabled( boolean flag )
	{
		this.mLineColorButton.setEnabled(flag);
		this.mLineColorLabel.setEnabled(flag);
		this.mLineTypeLabel.setEnabled(flag);
		this.mLineTypeComboBox.setEnabled(flag);
		this.mLineWidthLabel.setEnabled(flag);
		this.mLineWidthSpinner.setEnabled(flag);

		return true;
	}


	/**
	 * 
	 */
	protected boolean setSymbolTabEnabled( boolean flag )
	{
		this.mSymbolColorButton.setEnabled(flag);
		this.mSymbolColorLabel.setEnabled(flag);
		this.mSymbolLineColorButton.setEnabled(flag);
		this.mSymbolLineColorLabel.setEnabled(flag);
		this.mSymbolLineWidthLabel.setEnabled(flag);
		this.mSymbolLineWidthSpinner.setEnabled(flag);
		this.mSymbolSizeLabel.setEnabled(flag);
		this.mSymbolSizeSpinner.setEnabled(flag);
		this.mSymbolTypeComboBox.setEnabled(flag);
		this.mSymbolTypeLabel.setEnabled(flag);
		this.mSymbolBodyLabel.setEnabled(flag);
		this.mSymbolBodySeparator.setEnabled(flag);
		this.mSymbolLineLabel.setEnabled(flag);
		this.mSymbolLineSeparator.setEnabled(flag);

		return true;
	}


	/**
	 * 
	 */
	protected boolean setBarTabEnabled( boolean flag )
	{
		this.mBarBaseLineValueLabel.setEnabled(flag);
		this.mBarBaseLineTextField.setEnabled(flag);
		this.mBarColorLabel.setEnabled(flag);
		this.mBarInnerColorButton.setEnabled(flag);
		this.mBarLineColorButton.setEnabled(flag);
		this.mBarLineColorLabel.setEnabled(flag);
		this.mBarLineWidthLabel.setEnabled(flag);
		this.mBarLineWidthSpinner.setEnabled(flag);
		this.mBarWidthLabel.setEnabled(flag);
		this.mBarLineWidthSpinner.setEnabled(flag);
		this.mBarWidthSpinner.setEnabled(flag);

		this.mBarBodyLabel.setEnabled(flag);
		this.mBarBodySeparator.setEnabled(flag);
		this.mBarLineLabel.setEnabled(flag);
		this.mBarLineSeparator.setEnabled(flag);

		return true;
	}


	/**
	 * 
	 */
	protected boolean setErrorBarTabEnabled( boolean flag )
	{
		this.mErrorBarBothsidesRadioButton.setEnabled(flag);
		this.mErrorBarColorButton.setEnabled(flag);
		this.mErrorBarColorLabel.setEnabled(flag);
		this.mErrorBarDownsideRadioButton.setEnabled(flag);
		this.mErrorBarLineWidthLabel.setEnabled(flag);
		this.mErrorBarLineWidthSpinner.setEnabled(flag);
		this.mErrorBarSymbolSizeLabel.setEnabled(flag);
		this.mErrorBarSymbolSizeSpinner.setEnabled(flag);
		this.mErrorBarTypeComboBox.setEnabled(flag);
		this.mErrorBarTypeLabel.setEnabled(flag);
		this.mErrorBarUpsideRadioButton.setEnabled(flag);

		this.mErrorBarSymbolLabel.setEnabled(flag);
		this.mErrorBarSymbolSeparator.setEnabled(flag);
		this.mErrorBarStyleLabel.setEnabled(flag);
		this.mErrorBarStyleSeparator.setEnabled(flag);

		return true;
	}


	/**
	 * 
	 */
	protected boolean setTickLabelTabEnabled( boolean flag )
	{
		this.mTickLabelAngleLabel.setEnabled(flag);
		this.mTickLabelFontFamilyNameComboBox.setEnabled(flag);
		this.mTickLabelFontLabel.setEnabled(flag);
		this.mTickLabelFontSizeLabel.setEnabled(flag);
		this.mTickLabelFontSizeSpinner.setEnabled(flag);
		this.mTickLabelFontStyleComboBox.setEnabled(flag);
		this.mTickLabelHorizontalRadioButton.setEnabled(flag);
		this.mTickLabelSlantRadioButton.setEnabled(flag);
		this.mTickLabelColorButton.setEnabled(flag);
		this.mTickLabelColorLabel.setEnabled(flag);

		return true;
	}



	/**
	 * 
	 */
	public void stateChanged( ChangeEvent e )
	{

		super.stateChanged(e);

		Object source = e.getSource();


		// ^ȗIɍs
		if( source.equals(this.mTabbedPane) )
		{
//System.out.println(e);
			int index = this.mTabbedPane.getSelectedIndex();
			this.setColorButtonProperty( index );
		}

	}


	/**
	 * 
	 */
	protected boolean setColorButtonProperty( int tabIndex )
	{

		int lineIndex = this.mTabbedPane.indexOfComponent( this.mLinePanel );
		int symbolIndex = this.mTabbedPane.indexOfComponent( this.mSymbolPanel );
		int barIndex = this.mTabbedPane.indexOfComponent( this.mBarPanel );
		int errBarIndex = this.mTabbedPane.indexOfComponent( this.mErrorBarPanel );
		int tickLabelIndex = this.mTabbedPane.indexOfComponent( this.mTickLabelPanel );

		boolean flag = true;

		JButton btn = null;
		if( tabIndex == lineIndex )
		{
			if( this.mLineVisibleCheckBox.isSelected() )
			{
				btn = this.mLineColorButton;
			}
		}
		else if( tabIndex == symbolIndex )
		{
			if( this.mSymbolVisibleCheckBox.isSelected() )
			{
				btn = this.mSymbolColorButton;
			}
		}
		else if( tabIndex == barIndex )
		{
			if( this.mBarVisibleCheckBox.isSelected() )
			{
				btn = this.mBarInnerColorButton;
			}
		}
		else if( tabIndex == errBarIndex )
		{
			if( this.mErrorBarVisibleCheckBox.isSelected() )
			{
				btn = this.mErrorBarColorButton;
			}
		}
		else if( tabIndex == tickLabelIndex )
		{
			if( this.mTickLabelVisibleCheckBox.isSelected() )
			{
				btn = this.mTickLabelColorButton;
			}
		}
		else
		{
			flag = false;
		}

		if( btn == null )
		{
			return false;
		}


		this.mFocusedColorSetButton = btn;
		this.setColorButtonBorder( flag );


		return true;
	}



	/**
	 * 
	 * @param panel
	 * @return
	 */
	public boolean setSelectedPanel( final JPanel panel )
	{
		Component[] array = this.mTabbedPane.getComponents();
		for( int ii=0; ii<array.length; ii++ )
		{
			if( array[ii].equals(panel) )
			{
				this.mTabbedPane.setSelectedComponent(panel);
				break;
			}
		}

		return true;
	}



	/**
	 * 
	 * @param group
	 * @return
	 */
	public boolean setSelectedPanel( final SGElementGroup group )
	{

		JPanel p = null;
		if( group instanceof SGElementGroupLine )
		{
			p = this.getLinePanel();
		}
		else if( group instanceof SGElementGroupSymbol )
		{
			p = this.getSymbolPanel();
		}
		else if( group instanceof SGElementGroupBar )
		{
			p = this.getBarPanel();
		}
		else if( group instanceof SGElementGroupArrow )
		{
			p = this.getErrorBarPanel();
		}
		else if( group instanceof SGElementGroupString )
		{
			p = this.getTickLabelPanel();
		}

		this.mTabbedPane.setSelectedComponent(p);

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
//System.out.println("<< setDialogProperty >>");

		ArrayList xAxisList = new ArrayList();
		ArrayList yAxisList = new ArrayList();
		ArrayList lineList = new ArrayList();
		ArrayList symbolList = new ArrayList();
		ArrayList barList = new ArrayList();
		ArrayList errorBarList = new ArrayList();
		ArrayList tickLabelList = new ArrayList();
		for( int ii=0; ii<this.mPropertySettingListenerList.size(); ii++ )
		{
			SGIPropertySettingListenerSXYData l
				= (SGIPropertySettingListenerSXYData)this.mPropertySettingListenerList.get(ii);
			xAxisList.add( new Integer( l.getXAxisConfiguration() ) );
			yAxisList.add( new Integer( l.getYAxisConfiguration() ) );
			lineList.addAll( l.getLineGroups() );
			symbolList.addAll( l.getSymbolGroups() );
			barList.addAll( l.getBarGroups() );
			errorBarList.addAll( l.getErrorBarGroups() );
			tickLabelList.addAll( l.getTickLabelGroups() );
		}


		//
		// Axes
		//
		{
			if( setAxesProperties( xAxisList, yAxisList ) == false )
			{
				return false;
			}
		}



		//
		// Drawing Elements
		//

		ArrayList list = null;


		// Line
		list = lineList;
//System.out.println(list);
		{
			SGElementGroupLine group0 = (SGElementGroupLine)list.get(0);
			boolean flag = group0.isVisible();
			for( int ii=0; ii<list.size(); ii++ )
			{
				SGElementGroupLine group = (SGElementGroupLine)list.get(ii);
				flag = flag & group.isVisible();
			}
//System.out.println("line:"+flag);
			this.setTabEnabled( this.getLinePanel(), flag );
			if( flag )
			{
				this.setLineVisible( flag );
				this.setLineProperties( list );
			}
		}
//System.out.println(this.isTabEnabled(this.getLinePanel()));
//System.out.println();


		// Symbol
		list = symbolList;
//System.out.println(list);
		{
			SGElementGroupSymbol group0 = (SGElementGroupSymbol)list.get(0);
			boolean flag = group0.isVisible();
			for( int ii=0; ii<list.size(); ii++ )
			{
				SGElementGroupSymbol group = (SGElementGroupSymbol)list.get(ii);
				flag = flag & group.isVisible();
			}
//System.out.println("symbol:"+flag);
			this.setTabEnabled( this.getSymbolPanel(), flag );
			if( flag )
			{
				this.setSymbolVisible( flag );
				this.setSymbolProperties( list );
			}
		}
//System.out.println(this.isTabEnabled(this.getSymbolPanel()));
//System.out.println();


		// Bar
		list = barList;
//System.out.println(list);
		{
			SGElementGroupBar group0 = (SGElementGroupBar)list.get(0);
			boolean flag = group0.isVisible();
			for( int ii=0; ii<list.size(); ii++ )
			{
				SGElementGroupBar group = (SGElementGroupBar)list.get(ii);
				flag = flag & group.isVisible();
			}
//System.out.println("bar:"+flag);
			this.setTabEnabled( this.getBarPanel(), flag );
			if( flag )
			{
				this.setBarVisible( flag );
				this.setBarProperties( list );
			}
		}
//System.out.println(this.isTabEnabled(this.getBarPanel()));
//System.out.println();


		// Error Bar
		list = errorBarList;
//System.out.println(list);
		if( list.size()==this.mPropertySettingListenerList.size() )
		{
			SGElementGroupErrorBar group0 = (SGElementGroupErrorBar)list.get(0);
			boolean flag = group0.isVisible();
			for( int ii=0; ii<list.size(); ii++ )
			{
				SGElementGroupErrorBar group = (SGElementGroupErrorBar)list.get(ii);
				flag = flag & group.isVisible();
			}
//System.out.println("error bar:"+flag);
			this.setTabEnabled( this.getErrorBarPanel(), flag );
			if( flag )
			{
				this.setErrorBarVisible( flag );
				this.setErrorBarProperties( list );
			}
		}
		else
		{
			this.setTabEnabled( this.getErrorBarPanel(), false );
		}
//System.out.println(this.isTabEnabled(this.getErrorBarPanel()));
//System.out.println();


		// Tick Label
		list = tickLabelList;
//System.out.println(list);
		if( list.size()==this.mPropertySettingListenerList.size() )
		{
			SGElementGroupTickLabel group0 = (SGElementGroupTickLabel)list.get(0);
			boolean flag = group0.isVisible();
			for( int ii=0; ii<list.size(); ii++ )
			{
				SGElementGroupTickLabel group = (SGElementGroupTickLabel)list.get(ii);
				flag = flag & group.isVisible();
			}
//System.out.println("tick label:"+flag);
			this.setTabEnabled( this.getTickLabelPanel(), flag );
			if( flag )
			{
				this.setTickLabelVisible( flag );
				this.setTickLabelProperties( list );
			}
		}
		else
		{
			this.setTabEnabled( this.getTickLabelPanel(), false );
		}
//System.out.println(this.isTabEnabled(this.getTickLabelPanel()));
//System.out.println();


		// set the selected tab
		final JPanel[] panelArray = {
			this.getLinePanel(),
			this.getSymbolPanel(),
			this.getBarPanel(),
			this.getErrorBarPanel(),
			this.getTickLabelPanel()
		};
		int index = 0;
		for( int ii=0; ii<panelArray.length; ii++ )
		{
			if( this.isTabEnabled(panelArray[ii]) )
			{
				index = ii;
				break;
			}
		}
		this.mTabbedPane.setSelectedIndex(index);
		this.setColorButtonProperty(index);


		return true;

	}



	/**
	 * 
	 * @param xAxisList
	 * @param yAxisList
	 * @return
	 */
	private boolean setAxesProperties( final ArrayList xAxisList, final ArrayList yAxisList )
	{
		if( xAxisList.size()!=yAxisList.size() )
		{
			throw new IllegalArgumentException();
		}

		final int num = xAxisList.size();

		if( num==0 )
		{
			return false;
		}

		Integer xAxis0 = (Integer)xAxisList.get(0);
		Integer yAxis0 = (Integer)yAxisList.get(0);
		Integer xAxis = xAxis0;
		Integer yAxis = yAxis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer xAxis1 = (Integer)xAxisList.get(ii);
				if( xAxis0.equals(xAxis1)==false )
				{
					xAxis = null;
					break;
				}
			}
			for( int ii=1; ii<num; ii++ )
			{
				Integer yAxis1 = (Integer)yAxisList.get(ii);
				if( yAxis0.equals(yAxis1)==false )
				{
					yAxis = null;
					break;
				}
			}
		}

		if( xAxis==null || yAxis==null )
		{
			this.mNoSelectionButtonAxis.setSelected(true);
			return false;
		}
		this.setAxisRadioButton( xAxis.intValue(), yAxis.intValue() );


		return true;
	}




	/**
	 * 
	 * @param group
	 * @return
	 */
	private boolean setLineProperties( final ArrayList list )
	{
System.out.println("<< setLineProperties >>");

		if( list==null )
		{
			return false;
		}
		if( list.size()==0 )
		{
			return false;
		}

		SGElementGroupLine g0 = (SGElementGroupLine)list.get(0);
		final float lineWidth0 = g0.getLineWidth();
		final int lineType0 = g0.getLineType();
		final ArrayList colorList0 = g0.getColorList();
		Float width = new Float( lineWidth0 );
		Integer type = new Integer( lineType0 );
		ArrayList colorList = new ArrayList( colorList0 );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupLine g1 = (SGElementGroupLine)list.get(ii);
				final float lineWidth1 = g1.getLineWidth();
				if( lineWidth0!=lineWidth1 )
				{
					width = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupLine g1 = (SGElementGroupLine)list.get(ii);
				final int lineType1 = g1.getLineType();
				if( lineType0!=lineType1 )
				{
					type = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupLine g1 = (SGElementGroupLine)list.get(ii);
				final ArrayList colorList1 = g1.getColorList();
				if( colorList0.equals( colorList1 ) == false )
				{
					colorList = null;
					break;
				}
			}
			
		}

		this.setLineWidth( width );
		this.setLineType( type );
		this.setLineColorList( colorList );

//System.out.println("***");

		return true;
	}



	/**
	 * 
	 * @param group
	 * @return
	 */
	private boolean setSymbolProperties( final ArrayList list )
	{
System.out.println("<< setSymbolProperties >>");

		if( list==null )
		{
			return false;
		}
		if( list.size()==0 )
		{
			return false;
		}

		SGElementGroupSymbol g0 = (SGElementGroupSymbol)list.get(0);
		final float size0 = g0.getSize();
		final float lineWidth0 = g0.getLineWidth();
		final int type0 = g0.getType();
		final ArrayList colorList0 = g0.getColorList();
		final Color lineColor0 = g0.getLineColor();

		Float size = new Float( size0 );
		Float lineWidth = new Float( lineWidth0 );
		Integer type = new Integer( type0 );
		ArrayList colorList = new ArrayList( g0.getColorList() );
		Color lineColor = lineColor0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupSymbol g1 = (SGElementGroupSymbol)list.get(ii);
				final float size1 = g1.getSize();
				if( size0!=size1 )
				{
					size = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupSymbol g1 = (SGElementGroupSymbol)list.get(ii);
				final float lineWidth1 = g1.getLineWidth();
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupSymbol g1 = (SGElementGroupSymbol)list.get(ii);
				final int type1 = g1.getType();
				if( type0!=type1 )
				{
					type = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupSymbol g1 = (SGElementGroupSymbol)list.get(ii);
				final ArrayList colorList1 = g1.getColorList();
				if( colorList0.equals( colorList1 ) == false )
				{
					colorList = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupSymbol g1 = (SGElementGroupSymbol)list.get(ii);
				final Color lineColor1 = g1.getLineColor();
				if( lineColor0.equals( lineColor1 ) == false )
				{
					lineColor = null;
					break;
				}
			}
			
		}


		//
		if( size!=null )
		{
			size = new Float( size.floatValue()*SGConstants.CM_POINT_RATIO );
		}


		//
		this.setSymbolSize( size );
		this.setSymbolLineWidth( lineWidth );
		this.setSymbolType( type );
		this.setSymbolColorList( colorList );
		this.setSymbolLineColor( lineColor );

System.out.println("@@@");

		return true;
	}



	/**
	 * 
	 * @param group
	 * @return
	 */
	private boolean setBarProperties( final ArrayList list )
	{

		if( list==null )
		{
			return false;
		}
		if( list.size()==0 )
		{
			return false;
		}

		SGElementGroupBar g0 = (SGElementGroupBar)list.get(0);
		final float width0 = g0.getRectangleWidth();
		final float edgeLineWidth0 = g0.getEdgeLineWidth();
		final double baseline0 = g0.getBaseLineValue();
		final ArrayList colorList0 = g0.getColorList();
		final Color edgeLineColor0 = g0.getEdgeLineColor();

		Float width = new Float( width0 );
		Float edgeLineWidth = new Float( edgeLineWidth0 );
		Double baseline = new Double( baseline0 );
		ArrayList colorList = new ArrayList( g0.getColorList() );
		Color lineColor = edgeLineColor0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupBar g1 = (SGElementGroupBar)list.get(ii);
				final float width1 = g1.getRectangleWidth();
				if( width0!=width1 )
				{
					width = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupBar g1 = (SGElementGroupBar)list.get(ii);
				final float edgeLineWidth1 = g1.getEdgeLineWidth();
				if( edgeLineWidth0!=edgeLineWidth1 )
				{
					edgeLineWidth = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupBar g1 = (SGElementGroupBar)list.get(ii);
				final double baseline1 = g1.getBaseLineValue();
				if( baseline0!=baseline1 )
				{
					baseline = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupBar g1 = (SGElementGroupBar)list.get(ii);
				final ArrayList colorList1 = g1.getColorList();
				if( colorList0.equals( colorList1 ) == false )
				{
					colorList = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupBar g1 = (SGElementGroupBar)list.get(ii);
				final Color edgeLineColor1 = g1.getEdgeLineColor();
				if( edgeLineColor0.equals( edgeLineColor1 ) == false )
				{
					lineColor = null;
					break;
				}
			}
			
		}


		//
		if( width!=null )
		{
			width = new Float( width.floatValue()*SGConstants.CM_POINT_RATIO );
		}


		//
		this.setBarWidth( width );
		this.setBarEdgeLineWidth( edgeLineWidth );
		this.setBarBaselineValue( baseline );
		this.setBarInnerColorList( colorList );
		this.setBarEdgeLineColor( lineColor );

		return true;
	}



	/**
	 * 
	 * @param group
	 * @return
	 */
	private boolean setErrorBarProperties( final ArrayList list )
	{

		if( list==null )
		{
			return false;
		}
		if( list.size()==0 )
		{
			return false;
		}

		SGElementGroupErrorBar g0 = (SGElementGroupErrorBar)list.get(0);
		final float lineWidth0 = g0.getLineWidth();
		final float headSize0 = g0.getHeadSize();
		final int style0 = g0.getErrorBarStyle();
		final int type0 = g0.getHeadType();
		final ArrayList colorList0 = g0.getColorList();

		Float lineWidth = new Float( lineWidth0 );
		Float headSize = new Float( headSize0 );
		Integer style = new Integer( style0 );
		Integer type = new Integer( type0 );
		ArrayList colorList = new ArrayList( g0.getColorList() );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupErrorBar g1 = (SGElementGroupErrorBar)list.get(ii);
				final float lineWidth1 = g1.getLineWidth();
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupErrorBar g1 = (SGElementGroupErrorBar)list.get(ii);
				final float headSize1 = g1.getHeadSize();
				if( headSize0!=headSize1 )
				{
					headSize = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupErrorBar g1 = (SGElementGroupErrorBar)list.get(ii);
				final int style1 = g1.getErrorBarStyle();
				if( style0!=style1 )
				{
					style = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupErrorBar g1 = (SGElementGroupErrorBar)list.get(ii);
				final int type1 = g1.getHeadType();
				if( type0!=type1 )
				{
					type = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupErrorBar g1 = (SGElementGroupErrorBar)list.get(ii);
				final ArrayList colorList1 = g1.getColorList();
				if( colorList0.equals( colorList1 ) == false )
				{
					colorList = null;
					break;
				}
			}
		}


		//
		if( headSize!=null )
		{
			headSize = new Float( headSize.floatValue()*SGConstants.CM_POINT_RATIO );
		}
		String typeName = null;
		if( type!=null )
		{
			typeName = SGElementGroupErrorBar.getSymbolTypeName( type.intValue() );
		}

		//
		this.setErrorBarLineWidth( lineWidth );
		this.setErrorBarSymbolSize( headSize );
		this.setErrorBarStyle( style );
		this.setErrorBarType( typeName );
		this.setErrorBarColorList( colorList );

		return true;
	}



	/**
	 * 
	 * @param group
	 * @return
	 */
	private boolean setTickLabelProperties( final ArrayList list )
	{

		if( list==null )
		{
			return false;
		}
		if( list.size()==0 )
		{
			return false;
		}

		SGElementGroupTickLabel g0 = (SGElementGroupTickLabel)list.get(0);
		final float fontSize0 = g0.getFontSize();
		final int style0 = g0.getFontStyle();
		final String name0 = g0.getFontFamilyName();
		final float angle0 = g0.getAngle();
		final ArrayList colorList0 = g0.getColorList();

		Float fontSize = new Float( fontSize0 );
		Integer style = new Integer( style0 );
		String name = new String( name0 );
		Float angle = new Float( angle0 );
		ArrayList colorList = new ArrayList( g0.getColorList() );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupTickLabel g1 = (SGElementGroupTickLabel)list.get(ii);
				final float fontSize1 = g1.getFontSize();
				if( fontSize0!=fontSize1 )
				{
					fontSize = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupTickLabel g1 = (SGElementGroupTickLabel)list.get(ii);
				final int style1 = g1.getFontStyle();
				if( style0!=style1 )
				{
					style = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupTickLabel g1 = (SGElementGroupTickLabel)list.get(ii);
				final String name1 = g1.getFontFamilyName();
				if( name0.equals(name1)==false )
				{
					name = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupTickLabel g1 = (SGElementGroupTickLabel)list.get(ii);
				final float angle1 = g1.getAngle();
				if( angle0!=angle1 )
				{
					angle = null;
					break;
				}
			}
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGElementGroupTickLabel g1 = (SGElementGroupTickLabel)list.get(ii);
				final ArrayList colorList1 = g1.getColorList();
				if( colorList0.equals( colorList1 ) == false )
				{
					colorList = null;
					break;
				}
			}
		}


		this.setTickLabelFontSize( fontSize );
		this.setTickLabelFontStyle( style );
		this.setTickLabelFontFamilyName( name );
		this.setTickLabelAngle( angle );
		this.setTickLabelColorList( colorList );

		return true;
	}



	/**
	 * 
	 * @param group
	 * @return
	 */
	public boolean setLineProperties( SGElementGroupLine group )
	{
		SGProperties p = this.getLineProperties();
		if( group.setProperties(p) == false )
		{
			return false;	
		}
		return true;
	}


	/**
	 * 
	 * @param group
	 * @return
	 */
	public boolean setSymbolProperties( SGElementGroupSymbol group )
	{
		SGProperties p = this.getSymbolProperties();
		if( group.setProperties(p) == false )
		{
			return false;	
		}
		return true;
	}


	/**
	 * 
	 * @param group
	 * @return
	 */
	public boolean setBarProperties( SGElementGroupBar group )
	{
		SGProperties p = this.getBarProperties();
		if( group.setProperties(p) == false )
		{
			return false;	
		}
		return true;
	}


	/**
	 * 
	 * @param group
	 * @return
	 */
	public boolean setErrorBarProperties( SGElementGroupErrorBar group )
	{
		SGProperties p = this.getErrorBarProperties();
		if( group.setProperties(p) == false )
		{
			return false;	
		}
		return true;
	}


	/**
	 * 
	 * @param group
	 * @return
	 */
	public boolean setTickLabelProperties( SGElementGroupTickLabel group )
	{
		SGProperties p = this.getTickLabelProperties();
		if( group.setProperties(p) == false )
		{
			return false;	
		}
		return true;
	}


	/**
	 * 
	 * @param list
	 * @param p
	 * @return
	 */
	private boolean setProperties( ArrayList list, SGProperties p )
	{
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGElementGroup group = (SGElementGroup)list.get(ii);
			if( group.setProperties(p) == false )
			{
				return false;
			}
		}
		return true;
	}



	/**
	 * 
	 */
	public SGElementGroupLine.LineProperties getLineProperties()
	{

		SGElementGroupLine.LineProperties p
			= new SGElementGroupLine.LineProperties();

		p.setVisible( this.getLineVisible() );

		final Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLineWidth( lineWidth.floatValue() );
		}

		final Integer type = this.getLineType();
		if( type==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLineType( type.intValue() );
		}

		p.setColorList( this.getLineColorList() );

		return p;
	}



	/**
	 * 
	 */
	public SGElementGroupSymbol.SymbolProperties getSymbolProperties()
	{

		SGElementGroupSymbol.SymbolProperties p
			= new SGElementGroupSymbol.SymbolProperties();

		p.setVisible( this.getSymbolVisible() );

		final Number size = this.getSymbolSize();
		if( size==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setSize( size.floatValue()/SGConstants.CM_POINT_RATIO );

		final Integer type = this.getSymbolType();
		if( type==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setSymbolType( type.intValue() );

		p.setColorList( this.getSymbolColorList() );

		final Number lineWidth = this.getSymbolLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setLineWidth( lineWidth.floatValue() );

		p.setLineColor( this.getSymbolLineColor() );

		return p;
	}


	/**
	 * 
	 */
	public SGElementGroupBar.BarProperties getBarProperties()
	{
		SGElementGroupBar.BarProperties p = new SGElementGroupBar.BarProperties();

		p.setVisible( this.getBarVisible() );
		p.setColorList( this.getBarInnerColorList() );

		Number barWidth = this.getBarWidth();
		if( barWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setBarWidth( barWidth.floatValue()/SGConstants.CM_POINT_RATIO );

		Number edgeLineWidth = this.getBarEdgeLineWidth();
		if( edgeLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setEdgeLineWidth( edgeLineWidth.floatValue() );

		p.setEdgeLineColor( this.getBarEdgeLineColor() );

		Number value = this.getBarBaselineValue();
		if( value==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setBaselineValue( value.doubleValue() );

		return p;
	}



	/**
	 * 
	 */
	public SGElementGroupErrorBar.ErrorBarProperties getErrorBarProperties()
	{
		SGElementGroupErrorBar.ErrorBarProperties p
		  = new SGElementGroupErrorBar.ErrorBarProperties();

		p.setVisible( this.getErrorBarVisible() );
		p.setColorList( this.getErrorBarColorList() );
		p.setHeadLineColor( (Color)(p.getColorList().get(0)) );

		final Number lineWidth = this.getErrorBarLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setLineWidth( lineWidth.floatValue() );
		p.setHeadLineWidth( lineWidth.floatValue() );

		final Number headSize = this.getErrorBarSymbolSize();
		if( headSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setHeadSize( headSize.floatValue()/SGConstants.CM_POINT_RATIO );

		final Integer style = this.getErrorBarStyle();
		if( style==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setErrorBarStyle( style.intValue() );

		final String headSymbolTypeName = this.getErrorBarTypeName();
		int symbolType;
		if( headSymbolTypeName.equals( SGElementGroupArrow.SYMBOL_CIRCLE) )
		{
			symbolType = SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE;
		}
		else if( headSymbolTypeName.equals( SGElementGroupArrow.SYMBOL_TRANSVERSE_LINE ) )
		{
			symbolType = SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE;
		}
		else if( headSymbolTypeName.equals( SGElementGroupArrow.NO_SYMBOL ) )
		{
			symbolType = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
		}
		else
		{
			throw new Error();
		}

		// head type
		switch( style.intValue() )
		{
			case SGElementGroupErrorBar.ERROR_BAR_FULL :
			{
				p.setStartHeadType( symbolType );
				p.setEndHeadType( symbolType );
				break;
			}
				
			case SGElementGroupErrorBar.ERROR_BAR_UPPER_ONLY :
			{
				p.setStartHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
				p.setEndHeadType( symbolType );
				break;
			}

			case SGElementGroupErrorBar.ERROR_BAR_LOWER_ONLY :
			{
				p.setStartHeadType( symbolType );
				p.setEndHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
				break;
			}

			default :
			{

			}
		}

		return p;

	}


	/**
	 * 
	 */
	public SGElementGroupTickLabel.TickLabelProperties getTickLabelProperties()
	{
		SGElementGroupTickLabel.TickLabelProperties p
			= new SGElementGroupTickLabel.TickLabelProperties();

		p.setVisible( this.getTickLabelVisible() );
		p.setColorList( this.getTickLabelColorList() );
		p.setFontFamilyName( this.getTickLabelFontFamilyName() );


		final Number fontSize = this.getTickLabelFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setFontSize( fontSize.floatValue() );

		final Integer fontStyle = this.getTickLabelFontStyle();
		if( fontStyle==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setFontStyle( fontStyle.intValue() );

		final Number angle = this.getTickLabelAngle();
		if( angle==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		p.setAngle( angle.floatValue() );

		return p;
	}





}
