
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * 2xNg^f[^̃Ot̃NX
 */
public class SGVXYGraphElement extends SGGraphElement
{

	/**
	 *
	 */
	protected final int ARROW_GRAPH = 0;


	/**
	 * RXgN^
	 */
	public SGVXYGraphElement()
	{
		super();
	}



	/**
	 *
	 */
	public boolean addData( final SGData data )
	{
		// f[^̃`FbN
		if( !(data instanceof SGVXYData) )
		{
			return false;
		}
		SGVXYData dataVXY = (SGVXYData)data;


		// Xgɒǉ
		mDataList.add(data);


		// get axes list
		final SGAxis bAxis = mAxisElement.getAxisInPlane( SGAxisElement.AXIS_HORIZONTAL_1 );
		final SGAxis tAxis = mAxisElement.getAxisInPlane( SGAxisElement.AXIS_HORIZONTAL_2 );
		final SGAxis lAxis = mAxisElement.getAxisInPlane( SGAxisElement.AXIS_PERPENDICULAR_1 );
		final SGAxis rAxis = mAxisElement.getAxisInPlane( SGAxisElement.AXIS_PERPENDICULAR_2 );
		SGAxis axisX = null;
		SGAxis axisY = null;
		if( SGDefaultValues.SCALE_REFERENCE.equals("Left-Bottom") )
		{
			axisX = bAxis;
			axisY = lAxis;
		}
		else if( SGDefaultValues.SCALE_REFERENCE.equals("Left-Top") )
		{
			axisX = tAxis;
			axisY = lAxis;
		}
		else if( SGDefaultValues.SCALE_REFERENCE.equals("Right-Bottom") )
		{
			axisX = bAxis;
			axisY = rAxis;
		}
		else if( SGDefaultValues.SCALE_REFERENCE.equals("Right-Top") )
		{
			axisX = tAxis;
			axisY = rAxis;
		}
		else
		{
			return false;
		}



		//
		// VKf[^쐬
		//

		ElementGroupSetInVXYGraph groupSet = new ElementGroupSetInVXYGraph();

		// O
		String name = "data"+(this.mGroupSetList.size()+1);
		groupSet.setName(name);

		// 
		groupSet.setXAxis(axisX);
		groupSet.setYAxis(axisY);

		// {
		groupSet.setMagnification( this.mMagnification );


		// Xgɒǉ
		this.mGroupSetList.add( groupSet );



		//
		// VK`vf̍쐬
		// ftHgł͐̕`vf쐬
		//

		groupSet.addDrawingElementGroup( ARROW_GRAPH );


		repaint();

		return true;
	}




	/**
	 * 
	 */
	public boolean synchronizeToLegendElement( final SGILegendElement lElement )
	{

		boolean flag = super.synchronizeToLegendElement(lElement);
		if( !flag )
		{
			return flag;
		}


		for( int ii=0; ii<mDataList.size(); ii++ )
		{
			ElementGroupSetInVXYGraph groupSet
				= (ElementGroupSetInVXYGraph)this.mGroupSetList.get(ii);
			ArrayList groupList = groupSet.mDrawingElementGroupList;
			groupList.clear();

			SGData data = (SGData)mDataList.get(ii);

			// name of the data
			String name = lElement.getDataName(data);
			groupSet.setName(name);

			// properties of the data
			ArrayList dElementList = lElement.getDrawingElementList(data);
			for( int jj=0; jj<dElementList.size(); jj++ )
			{
				SGDrawingElement dElement = (SGDrawingElement)dElementList.get(jj);
				groupSet.addDrawingElementGroup(dElement);
			}

		}

		this.createAllDrawingElements();


		return flag;
	}



	/**
	 * vpeB_CAO̍쐬
	 */
	protected boolean createDataDialog()
	{
		return true;
	}




	/**
	 * 
	 */
	public boolean createAllDrawingElements()
	{

		for( int ii=0; ii<this.mGroupSetList.size(); ii++ )
		{
			ElementGroupSetInGraph groupSet = (ElementGroupSetInGraph)this.mGroupSetList.get(ii);

			SGVXYData dataVXY = (SGVXYData)this.mDataList.get(ii);

			ArrayList startRatioList = new ArrayList();
			ArrayList endRatioList = new ArrayList();
			calcLocationOfVXYData(
				dataVXY.getStartArray(), dataVXY.getEndArray(),
				groupSet.mXAxis,groupSet.mYAxis,startRatioList,endRatioList);

			ArrayList groupList = groupSet.mDrawingElementGroupList;
		
			for( int jj=0; jj<groupList.size(); jj++ )
			{
				SGElementGroupVXY group = (SGElementGroupVXY)groupList.get(jj);

				// O[vɕ`vf쐬
				group.createDrawingElement( startRatioList, endRatioList );
			}
		}


		// ^C~Ovf
		for( int ii=0; ii<this.mTimingElementGroupSetList.size(); ii++ )
		{
			TimingElementGroupSetInGraph groupSet
				= (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(ii);
			this.createTimingElements( groupSet );
		}


		return true;
	}



	/**
	 * 
	 */
	public void paintGraphics2D( final Graphics2D g2d )
	{

		super.paintGraphics2D(g2d);


		// `̈̃NbsO
		this.clipGraphArea(g2d);


		// Ot̕`
		for( int ii=0; ii<this.mGroupSetList.size(); ii++ )
		{
			ElementGroupSetInVXYGraph groupSet = (ElementGroupSetInVXYGraph)this.mGroupSetList.get(ii);

			ArrayList groupList = groupSet.mDrawingElementGroupList;

			for( int jj=0; jj<groupList.size(); jj++ )
			{
				SGElementGroup group = (SGElementGroup)groupList.get(jj);
				group.paintElement( g2d );
			}

		}


		// ^C~O̕`
		this.drawTimingElements(g2d);

	}




	/**
	 * 
	 */
	public boolean createDataObject( final BufferedReader br, final SGData data ) throws IOException
	{

		if( !(data instanceof SGVXYData) )
		{
			return false;
		}


		super.createDataObject( br, data );


		String line = null;


		// name of data
		if( (line = br.readLine() ) == null )
		{
			return false;
		}
System.out.println(line);
		if( line.startsWith("name ") )
		{
			line = line.substring("name ".length());
		}
		else
		{
			return false;
		}
		String name = line;


		// configuration of X-axis
		if( (line = br.readLine() ) == null )
		{
			return false;
		}
System.out.println(line);
		if( line.startsWith("configX ") )
		{
			line = line.substring("configX ".length());
		}
		else
		{
			return false;
		}
		int configX = Integer.valueOf(line).intValue();


		// configuration of Y-axis
		if( (line = br.readLine() ) == null )
		{
			return false;
		}
System.out.println(line);
		if( line.startsWith("configY ") )
		{
			line = line.substring("configY ".length());
		}
		else
		{
			return false;
		}
		int configY = Integer.valueOf(line).intValue();


		// construct a SGElementGroupSet object
		ElementGroupSetInVXYGraph groupSet = new ElementGroupSetInVXYGraph();


		// set the name
//		String name = "data"+(this.mGroupSetList.size()+1);
		groupSet.setName(name);


		//
		this.mGroupSetList.add( groupSet );



		// set x- and y-axis
		groupSet.mXAxis = this.mAxisElement.getAxisInCube( configX );
		groupSet.mYAxis = this.mAxisElement.getAxisInCube( configY );


//System.out.println(groupSet.mXAxis);
//System.out.println(groupSet.mYAxis);



		//
		while( true )
		{

			SGElementGroup group = null;
	
			if( (line = br.readLine() ) == null )
			{
				return false;
			}
System.out.println(line);
			if( line.equals("<SGElementGroupArrow>") )
			{
				group = new ElementGroupArrow();
			}
			else if( line.equals("data end") )
			{
				break;
			}
			else
			{
				return false;
			}

			group.mGroupSet = groupSet;
			group.readProperty(br);
			groupSet.mDrawingElementGroupList.add( group );
			group.setMagnification( this.mMagnification );

		}


		return true;
	}




	/**
	 * 
	 */
	class ElementGroupSetInVXYGraph extends ElementGroupSetInGraph
	{

		/**
		 * 
		 */
		protected ElementGroupSetInVXYGraph()
		{
			super();
		}


		/**
		 * 
		 */
		protected boolean createDrawingElements()
		{
			return true;
		}


		/**
		 * 
		 */
		public boolean addDrawingElementGroup( final int type )
		{

			SGElementGroupVXY group = null;
			if( type == ARROW_GRAPH )
			{
				group = new ElementGroupArrow();
			}
			else
			{
				throw new Error("");
			}

			group.setMagnification(this.mMagnification);

			this.addDrawingElementGroup(group);

			return true;
		}



		/**
		 * 
		 */
		public boolean addDrawingElementGroup( final SGDrawingElement element )
		{

			SGElementGroupVXY group = null;
			if( element instanceof SGDrawingElementArrow )
			{
				group = new ElementGroupArrow();
			}
			else
			{
				throw new Error("");
			}

			group.setProperty( element );
			group.setMagnification(this.mMagnification);

			this.addDrawingElementGroup(group);

			return true;
		}



		/**
		 * 
		 */
		private boolean addDrawingElementGroup( final SGElementGroupVXY group )
		{

			group.mGroupSet = this;

			// get the list of positions of datas
			ArrayList startRatioList = new ArrayList();
			ArrayList endRatioList = new ArrayList();
			calcLocationOfVXYData(
				((SGVXYData)getData(this)).getStartArray(),
				((SGVXYData)getData(this)).getEndArray(),
				this.mXAxis,
				this.mYAxis,
				startRatioList,
				endRatioList
			);

			// `vf̍쐬
			group.createDrawingElement(startRatioList,endRatioList);


			// {
			group.setMagnification( mMagnification );


			// O[vf[^̃Xgɒǉ
			this.mDrawingElementGroupList.add( group );


			return true;
		}


		/**
		 * 
		 */
		public void paintGraphics2D( final Graphics2D g2d )
		{
			
		}



		/**
		 * 
		 */
		public boolean createTemporaryPropertyObject()
		{
			return true;
		}



		/**
		 * 
		 */
		protected boolean clickDrawingElements( final MouseEvent e )
		{
			return false;
		}



		/**
		 * 
		 */
		public boolean writePropertyOfData( final Writer writer ) throws IOException
		{

			super.writePropertyOfData(writer);


			// ̔zȕo
			int configX = mAxisElement.getConfigurationInCube( this.mXAxis );
			int configY = mAxisElement.getConfigurationInCube( this.mYAxis );
			
			writer.write("configX "+configX+"\n" );
			writer.write("configY "+configY+"\n" );


			// ef[^`vfQɃvpeBo͂
			for( int ii=0; ii<this.mDrawingElementGroupList.size(); ii++ )
			{
				SGElementGroup group = (SGElementGroup)this.mDrawingElementGroupList.get(ii);
				group.writePropertyOfData(writer);
			}


			return true;
		}


	}


	/**
	 *
	 */
	class ElementGroupArrow extends SGElementGroupArrow
	{

		/**
		 *
		 */
		protected ElementGroupArrow()
		{
			super();
		}



		/**
		 * 
		 */
		protected boolean setDialogProperty()
		{
			super.setDialogProperty();

			return true;
		}



		/**
		 * 
		 */
		public void actionPerformed(final ActionEvent e)
		{
			super.actionPerformed(e);
		}

	}






}
