/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.application.SGFileChooserWizardDialog;

public class SGSingleDataFileChooserWizardDialog
extends SGFileChooserWizardDialog
implements CaretListener {
    public static final String TITLE = "Choose a data file.";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JTextField mDataFileNameTextField;
    private JButton mNextButton;
    private JPanel mPanel;
    private JButton mPreviousButton;
    private JButton mShowFileChooserButton;

    public SGSingleDataFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mDataFileNameTextField = new JTextField();
        this.mShowFileChooserButton = new JButton();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mDataFileNameTextField.setPreferredSize(new Dimension(250, 21));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mDataFileNameTextField, gridBagConstraints);
        this.mShowFileChooserButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mShowFileChooserButton.setText("Choose");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)this.mShowFileChooserButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mPreviousButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviousButton.setText("<Previous");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    public static void main(String[] stringArray) {
        new SGSingleDataFileChooserWizardDialog((Frame)new JFrame(), true).show();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.setResizable(false);
        this.mCancelButton.addActionListener(this);
        this.mPreviousButton.addActionListener(this);
        this.mNextButton.addActionListener(this);
        this.mNextButton.setEnabled(false);
        this.mShowFileChooserButton.addActionListener(this);
        this.mDataFileNameTextField.addCaretListener(this);
        return true;
    }

    public String getFileName() {
        return this.mDataFileNameTextField.getText();
    }

    public boolean setFileName(String string) {
        this.mDataFileNameTextField.setText(string);
        return true;
    }

    public File getSelectedFile() {
        File file = new File(this.getFileName());
        return file;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mCancelButton)) {
            this.onCanceled();
        } else if (object.equals(this.mPreviousButton)) {
            this.onPrevious();
        } else if (object.equals(this.mNextButton)) {
            this.onNext();
        } else if (object.equals(this.mShowFileChooserButton)) {
            this.showFileChooser();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)object;
            String string = jTextComponent.getText();
            if (string.length() == 0) {
                this.mNextButton.setEnabled(false);
            } else {
                this.mNextButton.setEnabled(true);
            }
        }
    }

    private boolean showFileChooser() {
        ArrayList arrayList = this.openFileChooser();
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() != 1) {
            return true;
        }
        File file = (File)arrayList.get(0);
        boolean bl = this.setFileName(file.getPath());
        this.mNextButton.setEnabled(true);
        PATH_NAME = file.getAbsolutePath();
        return bl;
    }
}

