/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SGUtilityNumber {
    public static final String cm = "cm";
    public static final String mm = "mm";
    public static final String pt = "pt";
    public static final String inch = "inch";
    public static final String degree = "\u00b0";

    public static int getOrder(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("d < 0.0");
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        int n = 0;
        int n2 = 0;
        if (d > 1.0) {
            while (!(bigDecimal.doubleValue() < 1.0)) {
                bigDecimal = bigDecimal.movePointLeft(1);
                ++n;
            }
            n2 = n - 1;
        } else {
            while (!(bigDecimal.doubleValue() >= 1.0)) {
                bigDecimal = bigDecimal.movePointRight(1);
                ++n;
            }
            n2 = -n;
        }
        return n2;
    }

    public static double getPowersOfTen(int n) {
        BigDecimal bigDecimal = SGUtilityNumber.getBigDecimalPowersOfTen(n);
        return bigDecimal.doubleValue();
    }

    public static BigDecimal getBigDecimalPowersOfTen(int n) {
        BigDecimal bigDecimal = new BigDecimal(1.0);
        bigDecimal = bigDecimal.movePointRight(n);
        return bigDecimal;
    }

    public static double truncateNumber(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointLeft(n);
        int n2 = (int)bigDecimal.doubleValue();
        bigDecimal = new BigDecimal((double)n2);
        bigDecimal = bigDecimal.movePointRight(n);
        return bigDecimal.doubleValue();
    }

    public static double roundOffNumber(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointLeft(n + 1);
        double d2 = Math.rint(bigDecimal.doubleValue());
        bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.movePointRight(n + 1);
        return bigDecimal.doubleValue();
    }

    public static double roundOutNumber(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointLeft(n + 1);
        double d2 = Math.ceil(bigDecimal.doubleValue());
        bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.movePointRight(n + 1);
        return bigDecimal.doubleValue();
    }

    public static float convert(float f, String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = SGUtilityNumber.getUnitsArrayOfLength();
        float[] fArray = new float[]{1.0f, 0.1f, 0.035277776f, 2.54f};
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        if (string.equals(string2)) {
            return f;
        }
        float f2 = fArray[n2] / fArray[n];
        return f * f2;
    }

    public static String convertString(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = SGUtilityNumber.getUnitsArrayOfLength();
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            string3 = stringArray[i];
            break;
        }
        if (string3 == null) {
            return null;
        }
        String string4 = SGUtilityNumber.removeUnit(string, string3);
        if (string4 == null) {
            return null;
        }
        float f = Float.valueOf(string4).floatValue();
        float f2 = SGUtilityNumber.convert(f, string3, string2);
        String string5 = new Float(f2).toString();
        return string5;
    }

    public static String removeUnit(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        if (!string.endsWith(string2)) {
            return null;
        }
        int n2 = -1;
        while ((n = string.indexOf(string2, n2 + 1)) != -1) {
            n2 = n;
        }
        String string3 = string.substring(0, n2);
        if (string3.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() != 1) {
            return null;
        }
        String string4 = (String)arrayList.get(0);
        float f = 0.0f;
        try {
            f = Float.valueOf(string4).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return string4;
    }

    public static String[] getUnitsArrayOfLength() {
        String[] stringArray = new String[]{cm, mm, pt, inch};
        return stringArray;
    }

    public static boolean isLengthUnit(String string) {
        String[] stringArray = SGUtilityNumber.getUnitsArrayOfLength();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isOverlapping(double d, double d2, double d3, double d4) {
        double d5 = SGUtilityNumber.getOverlap(d, d2, d3, d4);
        return d5 != 0.0;
    }

    public static double getOverlap(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d < d2 ? d : d2;
        double d7 = d < d2 ? d2 : d;
        double d8 = d3 < d4 ? d3 : d4;
        double d9 = d5 = d3 < d4 ? d4 : d3;
        if (!(d6 < d5) && !(d8 < d7)) {
            return 0.0;
        }
        double d10 = d6 < d8 ? d7 - d8 : d5 - d6;
        return d10;
    }

    public static boolean contains(double d, double d2, double d3) {
        double d4;
        double d5;
        if (d <= d2) {
            d5 = d;
            d4 = d2;
        } else {
            d5 = d2;
            d4 = d;
        }
        return d5 <= d3 && d3 <= d4;
    }

    public static boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d < d2 ? d : d2;
        double d6 = d < d2 ? d2 : d;
        double d7 = d3 < d4 ? d3 : d4;
        double d8 = d3 < d4 ? d4 : d3;
        boolean bl = d5 <= d7 && d8 <= d6;
        return bl;
    }
}

