/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;

public abstract class SGElementGroupLine
extends SGElementGroupSXY {
    protected float mLineWidth;
    protected int mLineType;
    protected int mCap = 0;
    protected int mJoin = 1;
    protected float mMiterLimit = 1.0f;
    protected float mDashPhase = 0.0f;
    protected final ArrayList mConnectedPathList = new ArrayList();
    public static final String PF_LINE_TITLE = "<Line>";
    public static final String KEY_LINE_WIDTH = "Width";
    public static final String KEY_LINE_TYPE = "Type";
    public static final String PF_LINE_COLOR_LIST = "Color List";

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width<0.0f");
        }
        this.mLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.mDrawingElementArray[i];
                sGDrawingElementLine2D.setLineWidth(this.mLineWidth);
            }
        }
        return true;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.mDrawingElementArray[i];
                sGDrawingElementLine2D.setType(this.mLineType);
            }
        }
        return true;
    }

    public boolean setBasicStrokeProperty(int n, int n2, float f, float f2) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (n2 != 2 && n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (f < 1.0f && n2 == 0) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        this.mCap = n;
        this.mJoin = n2;
        this.mMiterLimit = f;
        this.mDashPhase = f2;
        return true;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public int getCap() {
        return this.mCap;
    }

    public int getJoin() {
        return this.mJoin;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementLine2D sGDrawingElementLine2D = new SGDrawingElementLine2D();
        sGDrawingElementLine2D.setVisible(this.mVisibleFlag);
        sGDrawingElementLine2D.setLineWidth(this.mLineWidth);
        sGDrawingElementLine2D.setType(this.mLineType);
        sGDrawingElementLine2D.setColorList(this.mColorList);
        return sGDrawingElementLine2D;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElement;
        this.setLineType(sGDrawingElementLine.getLineType());
        this.setLineWidth(sGDrawingElementLine.getLineWidth());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.getColor(0));
        float f = this.mMagnification * this.mLineWidth;
        switch (this.mLineType) {
            case 1: {
                graphics2D.setStroke(new BasicStroke(f, this.mCap, this.mJoin));
                break;
            }
            case 2: {
                float[] fArray = new float[]{2.0f * f, f};
                graphics2D.setStroke(new BasicStroke(f, this.mCap, this.mJoin, this.mMiterLimit, fArray, this.mDashPhase));
                break;
            }
            case 3: {
                float[] fArray = new float[]{f};
                graphics2D.setStroke(new BasicStroke(f, this.mCap, this.mJoin, this.mMiterLimit, fArray, this.mDashPhase));
                break;
            }
        }
        for (int i = 0; i < this.mConnectedPathList.size(); ++i) {
            GeneralPath generalPath = (GeneralPath)this.mConnectedPathList.get(i);
            graphics2D.draw(generalPath);
        }
        return true;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<Line>\n");
        SGUtilityText.writePropertyLine(writer, "Visible", new Boolean(this.mVisibleFlag));
        SGUtilityText.writePropertyLine(writer, KEY_LINE_WIDTH, new Float(this.mLineWidth));
        SGUtilityText.writePropertyLine(writer, KEY_LINE_TYPE, SGDrawingElementLine.getLineTypeName(this.mLineType));
        SGUtilityText.writeColorListPropertyLine(writer, PF_LINE_COLOR_LIST, this.mColorList);
        writer.write("\n");
        return true;
    }

    public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        LineProperties lineProperties = new LineProperties();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Visible");
        if (bl == null) {
            return null;
        }
        lineProperties.setVisible(bl);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, KEY_LINE_WIDTH);
        if (d == null) {
            return null;
        }
        lineProperties.setLineWidth(d.floatValue());
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getPropertyFromLine(string, KEY_LINE_TYPE);
        if (string2 == null) {
            return null;
        }
        Integer n = SGDrawingElementLine.getLineTypeFromName(string2);
        if (n == null) {
            return null;
        }
        lineProperties.setLineType(n);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        lineProperties.setColorList(SGUtilityText.getColorListFromLine(string, PF_LINE_COLOR_LIST));
        return lineProperties;
    }

    protected boolean initDrawingElement(int n) {
        int n2 = n - 1;
        SGDrawingElementLine[] sGDrawingElementLineArray = new SGDrawingElementLine[n2];
        for (int i = 0; i < n2; ++i) {
            sGDrawingElementLineArray[i] = new SGDrawingElementLine2D();
        }
        this.mDrawingElementArray = sGDrawingElementLineArray;
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length - 1;
        SGDrawingElementLine[] sGDrawingElementLineArray = new SGDrawingElementLine[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementLineArray[i] = new SGDrawingElementLine2D();
            sGDrawingElementLineArray[i].setTermPoints(sGTuple2fArray[i], sGTuple2fArray[i + 1]);
        }
        this.mDrawingElementArray = sGDrawingElementLineArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length - 1 != this.mDrawingElementArray.length) {
            throw new Error("pointArray.length != this.mDrawingElementArray.length + 1");
        }
        this.mConnectedPathList.clear();
        boolean bl = true;
        boolean[] blArray = new boolean[sGTuple2fArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            boolean bl2 = blArray[i] = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            if (blArray[i]) continue;
            bl = false;
        }
        if (bl) {
            GeneralPath generalPath = new GeneralPath();
            Line2D.Float float_ = new Line2D.Float(sGTuple2fArray[0].x, sGTuple2fArray[0].y, sGTuple2fArray[1].x, sGTuple2fArray[1].y);
            generalPath.append(float_, true);
            if (sGTuple2fArray.length > 2) {
                for (int i = 2; i < sGTuple2fArray.length; ++i) {
                    generalPath.lineTo(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
                }
            }
            this.mConnectedPathList.add(generalPath);
        } else {
            Object object;
            int n;
            ArrayList arrayList = new ArrayList();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (n = 0; n < sGTuple2fArray.length - 1; ++n) {
                object = (SGDrawingElementLine)this.mDrawingElementArray[n];
                boolean bl3 = blArray[n] && blArray[n + 1];
                ((SGDrawingElement)object).setVisible(bl3);
                if (bl3) {
                    arrayList2.add(object);
                    continue;
                }
                if (arrayList2.size() == 0) continue;
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList();
            }
            if (arrayList2.size() != 0) {
                arrayList.add(arrayList2);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                object = (ArrayList)arrayList.get(n);
                GeneralPath generalPath = new GeneralPath();
                SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)((ArrayList)object).get(0);
                Line2D line2D = SGDrawingElementLine2D.getLine(sGDrawingElementLine);
                generalPath.append(line2D, true);
                if (((ArrayList)object).size() > 2) {
                    for (int i = 1; i < ((ArrayList)object).size(); ++i) {
                        sGDrawingElementLine = (SGDrawingElementLine)((ArrayList)object).get(i);
                        SGTuple2f sGTuple2f = sGDrawingElementLine.getEnd();
                        generalPath.lineTo(sGTuple2f.x, sGTuple2f.y);
                    }
                }
                this.mConnectedPathList.add(generalPath);
            }
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)this.mDrawingElementArray[i];
            sGDrawingElementLine.setType(this.mLineType);
            sGDrawingElementLine.setColorList(this.mColorList);
            sGDrawingElementLine.setLineWidth(this.mLineWidth);
            sGDrawingElementLine.setMagnification(this.mMagnification);
        }
        return true;
    }

    public SGProperties getProperties() {
        LineProperties lineProperties = new LineProperties();
        this.getProperties(lineProperties);
        return lineProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        LineProperties lineProperties = (LineProperties)sGProperties;
        lineProperties.setLineWidth(this.getLineWidth());
        lineProperties.setLineType(this.getLineType());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        return true;
    }

    public static class LineProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"Width", "Type"};

        public boolean equals(Object object) {
            if (!(object instanceof LineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LineProperties lineProperties = (LineProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(lineProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getLineWidth() {
            String string = this.getProperty(SGElementGroupLine.KEY_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Integer getLineType() {
            String string = this.getProperty(SGElementGroupLine.KEY_LINE_TYPE);
            return SGUtilityText.getInteger(string);
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupLine.KEY_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setLineType(int n) {
            this.setProperty(SGElementGroupLine.KEY_LINE_TYPE, new Integer(n).toString());
            return true;
        }
    }
}

