
package jp.riken.brain.ni.samuraigraph.base;

import java.util.*;
import java.awt.*;
import java.io.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;


/**
 * A figure.
 */

public abstract class SGFigure extends JLayeredPane
	implements ActionListener, ComponentListener, WindowListener, SGIUndoable
{


	/**
	 * ID-number of this figure.
	 */
	protected int mID;


	/**
	 * A drawing window which this figure belongs to.
	 */
	protected SGDrawingWindow mWnd = null;


	/**
	 * List of SGData objects.
	 */
	protected ArrayList mDataList = new ArrayList();


	/**
	 * A SGIGraphElement object on this figure.
	 */
	protected SGIGraphElement mGraphElement = null;


	/**
	 * A SGILegendElement object on this figure.
	 */
	protected SGILegendElement mLegendElement = null;


	/**
	 * A SGIStringElement object on this figure.
	 */
	protected SGIStringElement mStringElement = null;


	/**
	 * A SGIAxisElement object on this figure.
	 */
	protected SGIAxisElement mAxisElement = null;


	/**
	 * {100%̂Ƃ́ANCAg̈ɂOt`̈XW
	 */
	protected float mGraphAreaX = 0.0f;


	/**
	 * {100%̂Ƃ́ANCAg̈ɂOt`̈YW
	 */
	protected float mGraphAreaY = 0.0f;


	/**
	 * {100%̂Ƃ́AOt`̈̕
	 */
	protected float mGraphAreaWidth = 0.0f;


	/**
	 * {100%̂Ƃ́AOt`̈̍
	 */
	protected float mGraphAreaHeight = 0.0f;



	/**
	 * {
	 */
	protected float mMagnification = 1.0f;


	/**
	 * A pop-up menu.
	 */
	protected JPopupMenu mPopupMenu = new JPopupMenu();


	/**
	 * A dialog.
	 */
	protected JDialog mDialog = null;


	/**
	 * 
	 */
	protected SGIFigureElement mPressedElement = null;


	/**
	 * 
	 */
	protected Point mPressedPoint = new Point();


	/**
	 * 
	 */
	protected final Rectangle2D mTempFigureRect = new Rectangle2D.Float();


	/**
	 * 
	 */
	protected Rectangle2D mViewBounds = null;


	/**
	 * 
	 */
	protected Color mBackgroundColor;


	/**
	 * 
	 */
	protected final Rectangle2D mRectangleOnDragging = new Rectangle2D.Float();


	/**
	 * 
	 */
	public static boolean mDrawRectangleOnDraggingFlag = false;


	/**
	 * location of mouse pointer
	 */
	protected int mMouseLocation = 0;


	/**
	 * 
	 */
	protected float mMinWidth = 50.0f;



	/**
	 * 
	 */
	protected float mMinHeight = 50.0f;


	/**
	 * 
	 */
	private static boolean mBoundingBoxVisibleFlag = false;


	/**
	 * 
	 */
	protected boolean mUpperFitFlag = false;


	/**
	 * 
	 */
	protected boolean mLowerFitFlag = false;


	/**
	 * 
	 */
	protected boolean mLeftFitFlag = false;


	/**
	 * 
	 */
	protected boolean mRightFitFlag = false;


	/**
	 * 
	 */
	protected SGProperties mTemporaryProperties = null;


	/**
	 * ꎞIɕۑĂf[^̃Xg
	 */
	protected ArrayList mTemporaryDataList = null;



	/**
	 * 
	 */
	private float mSpaceAxisLineAndNumber = SGDefaultValues.SPACE_AXIS_LINE_AND_NUMBER;


	/**
	 * 
	 */
	private float mSpaceNumberAndTitle = SGDefaultValues.SPACE_NUMBER_AND_TITLE;



	/**
	 * 
	 */
	private boolean mTransparentFlag = false;



	/**
	 * 
	 */
	public static final int LAYER_GRAPH = 10;


	/**
	 * 
	 */
	public static final int LAYER_AXIS = 20;


	/**
	 * 
	 */
	public static final int LAYER_LEGEND = 30;


	/**
	 * 
	 */
	public static final int LAYER_STRING = 40;


	/**
	 * 
	 */
	protected final int OTHER = 0;


	/**
	 * 
	 */
	protected final int NORTH = 1;


	/**
	 * 
	 */
	protected final int SOUTH = 2;


	/**
	 * 
	 */
	protected final int WEST = 3;


	/**
	 * 
	 */
	protected final int EAST = 4;


	/**
	 * 
	 */
	protected final int NORTH_WEST = 5;


	/**
	 * 
	 */
	protected final int NORTH_EAST = 6;


	/**
	 * 
	 */
	protected final int SOUTH_WEST = 7;


	/**
	 * 
	 */
	protected final int SOUTH_EAST = 8;



	/**
	 * 
	 */
	public static final int NOTIFY_CHANGE = 0;


	/**
	 * 
	 */
	public static final int UPDATE_HISTORY = 1;


	/**
	 * 
	 */
	public static final int ADD_LATEST_HISTORY = 2;


	/**
	 * 
	 */
	public static final int SET_PROPERTY_OF_SELECTED_DATA = 3;



	/**
	 * 
	 */
	protected final String SHOW_FRAME = "show/hide frame lines";


	/**
	 * 
	 */
	protected final String ADD_STRING = "add a string";


	/**
	 * 
	 */
	protected final String REMOVE_FIGURE = "Remove Selected Figures";


	/**
	 * 
	 */
	public final String ERRMSG_FAILED_TO_CREATE_DRAWING_ELEMENTS
		= "`vf̍쐬Ɏs܂B";




	/**
	 * 
	 */
	public SGFigure()
	{
		super();
		this.create();
	}



	/**
	 * Constructor.
	 * @param figureID the ID-number of this figure
	 * @param wnd ths drawing window this figure belongs
	 */
	public SGFigure( final SGDrawingWindow wnd )
	{
		super();
		this.setWindow(wnd);
		this.create();
	}



	/**
	 * 
	 * @return
	 */
	public String toString()
	{
		return new String("SGFigure:"+this.getID());
	}



	/**
	 * 
	 * @return
	 */
	private boolean create()
	{
		this.createDialog();
		this.createPopupMenu();

		// initialize properties
		this.setBackgroundColor( SGDefaultValues.FIGURE_BACKGROUND_COLOR );
		this.setVisible(true);
		this.setOpaque(false);

		return true;
	}



	/**
	 * 
	 */
	protected boolean isFocusedFigure()
	{
		final ArrayList fList = this.mWnd.mFocusedFigureList;
		final boolean flag = fList.contains(this);

		return flag;
	}






//
// set/get\bh
//


	/**
	 *
	 */
	public int getID()
	{
		return mID;
	}


	/**
	 * 
	 */
	public boolean setID( final int id )
	{
		this.mID = id;
		return true;
	}



	/**
	 * 
	 */
	public boolean setBackgroundColor( final Color color )
	{
		this.mBackgroundColor = color;
		return true;
	}


	/**
	 * 
	 */
	public Color getBackgroundColor()
	{
		return this.mBackgroundColor;
	}


	/**
	 * 
	 */
	public boolean isTransparent()
	{
		return this.mTransparentFlag;
	}


	/**
	 * 
	 */
	public SGDrawingWindow getWindow()
	{
		return this.mWnd;
	}





	/**
	 * 
	 * @return
	 */
	public boolean setSpaceAxisLineAndNumber( final float space )
	{
		this.mSpaceAxisLineAndNumber = space/this.mMagnification;
		this.mAxisElement.setSpaceAxisLineAndNumber( space );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean setSpaceNumberAndTitle( final float space )
	{
		this.mSpaceNumberAndTitle = space/this.mMagnification;
		this.mAxisElement.setSpaceNumberAndTitle( space );
		return true;
	}



	/**
	 * 
	 */
	public boolean setLegendVisible( boolean flag )
	{
		this.mLegendElement.setLegendVisible( flag );

		return true;
	}



	/**
	 * 
	 */
	public boolean setTransparent( boolean flag )
	{
		this.mTransparentFlag = flag;
		return true;
	}



	/**
	 * 
	 * @param wnd
	 * @return
	 */
	public boolean setWindow( final SGDrawingWindow wnd )
	{
		this.mWnd = wnd;

		return true;
	}


	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean setGraphElement( final SGIGraphElement element )
	{
		mGraphElement = element;
		return true;
	}


	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean setLegendElement( final SGILegendElement element )
	{
		mLegendElement = element;
		return true;
	}


	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean setStringElement( final SGIStringElement element )
	{
		mStringElement = element;
		return true;
	}


	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean setAxisElement( final SGIAxisElement element )
	{
		mAxisElement = element;
		return true;
	}


	/**
	 * 
	 */
	public SGIGraphElement getGraphElement()
	{
		return this.mGraphElement;
	}

	/**
	 * 
	 */
	public SGIAxisElement getAxisElement()
	{
		return this.mAxisElement;
	}

	/**
	 * 
	 */
	public SGILegendElement getLegendElement()
	{
		return this.mLegendElement;
	}

	/**
	 * 
	 */
	public SGIStringElement getStringElement()
	{
		return this.mStringElement;
	}



	/**
	 * 
	 */
	public SGIFigureElement[] getIFigureElementArray()
	{
		SGIFigureElement[] array = new SGIFigureElement[4];

		array[0] = this.mAxisElement;
		array[1] = this.mGraphElement;
		array[2] = this.mLegendElement;
		array[3] = this.mStringElement;

		return array;
	}


	/**
	 * 
	 */
	protected Rectangle2D getViewBounds()
	{
		return this.mViewBounds;
	}



	/**
	 * 
	 */
	public boolean isGraphAreaContains( Point2D point )
	{
		final Rectangle2D rect = this.getGraphAreaRect();
		return rect.contains(point);
	}



	/**
	 * 
	 */
	public Rectangle2D getGraphAreaRect()
	{
		final Rectangle2D rect = new Rectangle2D.Float(
			this.getGraphAreaX(),
			this.getGraphAreaY(),
			this.getGraphAreaWidth(),
			this.getGraphAreaHeight() );

		return rect;
	}



	/**
	 * 
	 * @return
	 */
	public float getGraphAreaX()
	{
		final Rectangle2D cRect = this.mWnd.getClientRect();
		return (float)cRect.getX() + this.mMagnification*this.mGraphAreaX;
	}



	/**
	 * 
	 * @return
	 */
	public float getGraphAreaY()
	{
		final Rectangle2D cRect = this.mWnd.getClientRect();
		return (float)cRect.getY() + this.mMagnification*this.mGraphAreaY;
	}



	/**
	 * 
	 * @return
	 */
	public float getGraphAreaWidth()
	{
		return this.mMagnification*this.mGraphAreaWidth;
	}



	/**
	 * 
	 * @return
	 */
	public float getGraphAreaHeight()
	{
		return this.mMagnification*this.mGraphAreaHeight;
	}




	/**
	 * ̓sNZPʂ̍Wl
	 */
	public boolean setGraphAreaLocation(
		final float x, final float y )
	{
		this.setGraphAreaLocation2(x,y);
		this.setGraphAreaRectToFigureElement();
		return true;
	}



	/**
	 * ̓sNZPʂ̍Wl
	 */
	private boolean setGraphAreaLocation2(
		final float x, final float y )
	{
		final Rectangle2D cRect = this.mWnd.getClientRect();
		this.mGraphAreaX = ( x - (float)cRect.getX() )/this.mMagnification;
		this.mGraphAreaY = ( y - (float)cRect.getY() )/this.mMagnification;

//this.setGraphAreaLocationRoundingOut(x,y);
		return true;
	}



	/**
	 * 
	 * @param widthPt
	 * @param heightPt
	 * @return
	 */
	protected boolean setGraphAreaLocationRoundingOut(
		final float xPt, final float yPt )
	{
		final Rectangle2D cRect = this.mWnd.getClientRect();

		final float xCM = ( xPt - (float)cRect.getX() )*SGConstants.CM_POINT_RATIO/this.mMagnification;
		final float yCM = ( yPt - (float)cRect.getY() )*SGConstants.CM_POINT_RATIO/this.mMagnification;

		// round out the size
		final float dXCM = (float)SGUtilityNumber.roundOutNumber( xCM, -2 );
		final float dYCM = (float)SGUtilityNumber.roundOutNumber( yCM, -2 );

		// length in units of pixel
		final float x = dXCM/SGConstants.CM_POINT_RATIO;
		final float y = dYCM/SGConstants.CM_POINT_RATIO;

		//
		this.mGraphAreaX = x;
		this.mGraphAreaY = y;

		return true;
	}



	/**
	 * 
	 */
	public boolean setGraphAreaSize(
		final float w,
		final float h )
	{
		this.setGraphAreaSize2(w,h);
		this.setGraphAreaRectToFigureElement();
		return true;
	}


	/**
	 * 
	 */
	private boolean setGraphAreaSize2(
		final float w,
		final float h )
	{
		this.mGraphAreaWidth = w/this.mMagnification;
		this.mGraphAreaHeight = h/this.mMagnification;
//this.setGraphAreaSizeRoundingOut( w, h );
		return true;
	}



	/**
	 * 
	 * @param widthPt
	 * @param heightPt
	 * @return
	 */
	protected boolean setGraphAreaSizeRoundingOut(
		final float widthPt, final float heightPt )
	{

		final float widthCM = widthPt*SGConstants.CM_POINT_RATIO/this.mMagnification;
		final float heightCM = heightPt*SGConstants.CM_POINT_RATIO/this.mMagnification;

		// round out the size
		final float dWidthCM = (float)SGUtilityNumber.roundOutNumber( widthCM, -2 );
		final float dHeightCM = (float)SGUtilityNumber.roundOutNumber( heightCM, -2 );

		// length in units of pixel
		final float width = dWidthCM/SGConstants.CM_POINT_RATIO;
		final float height = dHeightCM/SGConstants.CM_POINT_RATIO;


		//
		this.mGraphAreaWidth = width;
		this.mGraphAreaHeight = height;

		return true;
	}



	/**
	 * 
	 * @param x
	 * @param y
	 * @param w
	 * @param h
	 * @return
	 */
	public boolean setGraphAreaRect(
		final float x, final float y, final float w, final float h )
	{
		this.setGraphAreaLocation2(x,y);
		this.setGraphAreaSize2(w,h);
		this.setGraphAreaRectToFigureElement();
		return true;
	}



	/**
	 * 
	 * @return
	 */
	protected boolean setGraphAreaRectToFigureElement()
	{
		Rectangle2D cRect = this.mWnd.getClientRectZoomed();

		// SGIFigureElementɂݒ
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			if( array[ii]==null )
			{
				continue;
			}
		
			array[ii].setGraphAreaRect(
				this.getGraphAreaX(),
				this.getGraphAreaY(),
				this.getGraphAreaWidth(),
				this.getGraphAreaHeight()
			);
		}
		return true;
	}










	/**
	 * Add a new data.
	 * @param data the new data added
	 * @return true:secceeded, false:failed
	 */
	public boolean addData( final SGData data )
	{
		mDataList.add( data );

		mAxisElement.addData( data );
		mGraphElement.addData( data );
		mLegendElement.addData( data );
		mStringElement.addData( data );

		return true;
	}



	/**
	 * r[|[g̋Eݒ
	 */
	protected boolean setViewBounds()
	{
		final Rectangle2D rectView = this.mWnd.getViewportBounds();
		this.setViewBounds( rectView );
		return true;
	}




	/**
	 * 
	 */
	protected boolean setViewBounds( final Rectangle2D rectView )
	{
//System.out.println(rectView);

		// ɐݒ
		this.mViewBounds = rectView;

		// SGIFigureElementɐݒ
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setViewBounds( rectView );
		}

		return true;
	}



	/**
	 * 
	 */
	public boolean setSize( final SGTuple2f size )
	{
		this.setSize(
			(int)size.x, (int)size.y
		);
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int jj=0; jj<array.length; jj++ )
		{
			array[jj].setISize( new SGTuple2f( size ) );
		}

//		this.setViewBounds();

		return true;
	}



	/**
	 * ͕ω
	 */
	public boolean resize( final float ratioX, final float ratioY )
	{

		this.mGraphAreaX *= ratioX;
		this.mGraphAreaY *= ratioY;
		this.mGraphAreaWidth *= ratioX;
		this.mGraphAreaHeight *= ratioY;

		//
		this.setGraphAreaRectToFigureElement();

		//
		this.setViewBounds();

		return true;

	}



	/**
	 * Zoom in/out this component.
	 * @return true:secceeded, false:failed
	 */
	public boolean zoom( final float mag )
	{
//System.out.println("figure zoom");

		// {𑮐ɐݒ
		this.mMagnification = mag;


		// SGIFigureElementɔ{ݒ肷		
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].zoom( mag );
		}
		if( this.setGraphAreaRectToFigureElement() == false )
		{
			return false;
		}


		// if the dragging rectanlgle is visible,
		// set it to be equal to the graph area rectangle
		if( SGFigure.mDrawRectangleOnDraggingFlag )
		{
			this.setDraggingRect();
		}

		return true;
	}




	/**
	 * 
	 */
	private boolean setFitFlag()
	{
/*
		//
		Rectangle2D cRect = mWnd.getClientRect();


		// grid lines
		double[] vGridRatioArray = this.mWnd.getVerticalGridRatioArray();
		double[] hGridRatioArray = this.mWnd.getHorizontalGridRatioArray();

		int[] vGridArray = new int[vGridRatioArray.length];
		int[] hGridArray = new int[hGridRatioArray.length];

//System.out.println("<v>");
		for( int ii=0; ii<vGridArray.length; ii++ )
		{
			vGridArray[ii] = (int)(vGridRatioArray[ii]*cRect.getWidth());
//System.out.println(vGridArray[ii]);
		}
//System.out.println();

//System.out.println("<h>");
		for( int ii=0; ii<hGridArray.length; ii++ )
		{
			hGridArray[ii] = (int)(hGridRatioArray[ii]*cRect.getHeight());
//System.out.println(hGridArray[ii]);
		}
//System.out.println();


		// tBMA̋EObhɈvĂꍇ̏
		int x = this.getX();
		int y = this.getY();
		int w = this.getWidth();
		int h = this.getHeight();

//System.out.println(x+"  "+y+"  "+(x+w)+"  "+(y+h));
//System.out.println();

		this.mUpperFitFlag = false;
		this.mLowerFitFlag = false;
		this.mLeftFitFlag = false;
		this.mRightFitFlag = false;

		for( int ii=0; ii<vGridArray.length; ii++ )
		{
			if( x == vGridArray[ii] )
			{
				this.mLeftFitFlag = true;
//System.out.println("x:"+x);
				break;
			}
		}

		for( int ii=0; ii<vGridArray.length; ii++ )
		{
			if( x + w == vGridArray[ii] )
			{
				this.mRightFitFlag = true;
//System.out.println("x+w:"+(x+w));
				break;
			}
		}

		for( int ii=0; ii<hGridArray.length; ii++ )
		{
			if( y == hGridArray[ii] )
			{
				this.mUpperFitFlag = true;
//System.out.println("y:"+y);
				break;
			}
		}

		for( int ii=0; ii<hGridArray.length; ii++ )
		{
			if( y + h == hGridArray[ii] )
			{
				this.mLowerFitFlag = true;
//System.out.println("y+h:"+(y+h));
				break;
			}
		}

*/
		return true;
	}










//
// Cxg֘A
//



	/**
	 * 
	 * @param e
	 * @return
	 */
	protected boolean move( final MouseEvent e )
	{

		final int x = e.getX();
		final int y = e.getY();

		// }EXʒuɉă}EXJ[\ύX
		this.setMouseLocation( x, y );
		this.changeCursor();

		// tBMA̕`vfɑ΂鏈
		this.onDrawingElement(x,y);

		return true;
	}



	/**
	 * 
	 * @param e
	 * @return
	 */
	protected boolean onToggleSelected( MouseEvent e )
	{
		//
		// gO{^ĂƂ̏
		//

		// 
		final boolean addStringFlag
			= this.mWnd.mAddStringButton.isSelected();
		if( addStringFlag )
		{
//System.out.println("addString");
			this.mStringElement.addString( e.getX(), e.getY() );
//			this.mWnd.mAddStringButton.setSelected(false);

			// J[\ftHg̏Ԃɖ߂
			this.mWnd.setDefaultCursor();

			// gO{^̉
			this.mWnd.setInsertToggleButtonsSelected(false);

			return true;
		}


		// ^C~O`vf
		final boolean addTimingElementFlag
			= this.mWnd.mAddTimingElementButton.isSelected();
		if( addTimingElementFlag )
		{
//System.out.println("addTimingLine");
			this.mAxisElement.addTimingLine( e.getX(), e.getY() );
//			this.mWnd.mAddTimingElementButton.setSelected(false);

			// J[\ftHg̏Ԃɖ߂
			this.mWnd.setDefaultCursor();

			// gO{^̉
			this.mWnd.setInsertToggleButtonsSelected(false);

			return true;
		}


		// symbol of siginificant difference
		final boolean addSignificantFlag
			= this.mWnd.mAddSignificantSymbolButton.isSelected();
		if( addSignificantFlag )
		{
//System.out.println("addSignificant");
			this.mGraphElement.addSignificantDifferenceSymbol( e.getX(), e.getY() );
//			this.mWnd.mAddSignificantSymbolButton.setSelected(false);

			// J[\ftHg̏Ԃɖ߂
			this.mWnd.setDefaultCursor();

			// gO{^̉
			this.mWnd.setInsertToggleButtonsSelected(false);

			return true;
		}

		return true;
	}




	/**
	 * 
	 * @param e
	 * @return true:LȏꏊNbNꂽ
	 */
	protected boolean click( MouseEvent e )
	{
//System.out.println("click:"+this.mID);

		//
		// SGIFigureElementɖ₢킹
		//

		boolean flag = this.onFigureElementClicked(e);
//System.out.println("I:"+flag);
		if( flag )
		{
			this.afterClicked(e);
			return true;
		}


		// NbNꂽ_Ot`̈̏ꍇɂ́AtBMANbNꂽƂ݂Ȃ
		if( this.isGraphAreaContains( e.getPoint() ) )
		{

			this.afterClicked(e);

			// }EXE{^NbNŃ|bvAbvj[o
			if( (SwingUtilities.isRightMouseButton(e) )
				&& ( e.getClickCount() == 1 ) )
			{
				mPopupMenu.show( this, e.getX(), e.getY());
			}

			// }EX{^_uNbNŃ_CAOo
			if( (SwingUtilities.isLeftMouseButton(e) )
				&& ( e.getClickCount() == 2 ) )
			{
				this.getDialog().show();
			}

			return true;

		}

		return false;

	}


	/**
	 * 
	 */
	private boolean afterClicked( MouseEvent e )
	{

		// gőOʂɏoAEChEɈ˗
		this.mWnd.mLayeredPane.moveToFront(this);

//		this.repaint();


		return true;
	}


	/**
	 * 
	 */
	private boolean onFigureElementClicked( MouseEvent e )
	{

		boolean flag;

		flag = mStringElement.onMouseClicked(e);
		if( flag )
		{
//System.out.println("String");
			return true;
		}

		flag = mLegendElement.onMouseClicked(e);
		if( flag )
		{
//System.out.println("Legend");
			return true;
		}

		flag = mAxisElement.onMouseClicked(e);
		if( flag )
		{
//System.out.println("Axis");
			return true;
		}

		flag = mGraphElement.onMouseClicked(e);
		if( flag )
		{
//System.out.println("Graph");
			return true;
		}

//System.out.println("Figure");


		return false;
	}



	/**
	 * 
	 * @param e
	 * @return true:LȏꏊvXꂽ
	 */
	protected boolean press( final MouseEvent e )
	{
//System.out.println("press:"+this.getID());

		boolean flag;

		// SGIFigureElementɖ₢킹
		flag = this.onFigureElementPressed(e);
		if( flag )
		{
//System.out.println("1");
			this.afterPressed(e);
			this.setFocusedFigureList(e);
			return true;
		}


		//
		// Lȓ_vXꂽ
		//

		flag = false;
		if( this.isGraphAreaContains( e.getPoint() ) )
		{
			flag = true;
		}
		if( this.mMouseLocation != OTHER )
		{
			flag = true;
		}

//System.out.println(flag);
//System.out.println();

		if( flag )
		{
//System.out.println("2");
			this.afterPressed(e);
			this.setFocusedFigureList(e);
			return true;
		}

		return false;
	}



	/**
	 * 
	 */
	private boolean afterPressed( MouseEvent e )
	{
//System.out.println("<< afterPressed >>");
//System.out.println();

		//
//		this.setFocusedFigureList(e);


		// hbŐ`̏ݒ
		this.mWnd.setDraggingRectOfFocusedFigures();


		// Change the cursor.
		if( this.mWnd.getCursor().equals( Cursor.getDefaultCursor() ) )
		{
			this.changeCursor();
			if( this.mMouseLocation == OTHER )
			{
				this.mWnd.setCursor( new Cursor( Cursor.MOVE_CURSOR ) );
			}
		}


		// gőOʂɏoAEChEɈ˗
		this.mWnd.mLayeredPane.moveToFront(this);


		// }EX{^_
		this.mPressedPoint.setLocation( e.getPoint() );

//System.out.println("mPressedPoint:"+mPressedPoint);
//System.out.println();

		// }EX̃tBMÄʒuL^
		this.updateFigureRect();

//System.out.println();


		// ObhƂ̃tBbg𒲂ׂ
//		this.setFitFlag();


		//
//		this.repaint();


		return true;

	}




	/**
	 * 
	 * @return
	 */
	protected boolean setFocusedFigureList( final MouseEvent e )
	{

		//
		// EChÉAtH[JXꂽtBMÃXgɑ΂鏈
		//

		final ArrayList fList = this.mWnd.mFocusedFigureList;

		// CTRLL[SHIFTL[̂ĂȂꍇ
		if( ( (e.getModifiers()&MouseEvent.CTRL_MASK) == 0 )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) == 0 ) )
		{
//System.out.println("ĂȂ");

			// ̃tBMAɃXgɑ݂Ăꍇ
			if( fList.contains(this) )
			{
				// Ȃ
			}
			else
			{
				this.mWnd.clearFocusedFigures();
				fList.add(this);
			}

		}
		// Ăꍇ
		else
		{
			// ̃tBMAɃXgɑ݂Ăꍇ
			if( fList.contains(this) )
			{
				// lɂꍇ͏
				if( this.mMouseLocation!=NORTH_WEST
					&& this.mMouseLocation!=NORTH_EAST
					&& this.mMouseLocation!=SOUTH_EAST
					&& this.mMouseLocation!=SOUTH_WEST )
				{
					// if no figure element is pressed, remove this figure
					// from the list of the selected figure
					if( this.mPressedElement==null )
					{
						fList.remove(this);
					}
				}
			}
			else
			{
				fList.add(this);
			}
		}


		return true;
	}




	/**
	 * 
	 * @return
	 */
	protected boolean updateFigureRect()
	{
		this.mTempFigureRect.setRect( this.getGraphAreaRect() );
		return true;
	}



	/**
	 * hbŐ`ݒ
	 */
	protected boolean setDraggingRect()
	{
//System.out.println("<< SGFigure::setDraggingRect >>");

		this.mRectangleOnDragging.setRect(
			this.getGraphAreaX(),
			this.getGraphAreaY(),
			this.getGraphAreaWidth(),
			this.getGraphAreaHeight()
		);

//System.out.println(this.mRectangleOnDragging);

		return true;
	}



	/**
	 * 
	 */
	private boolean onFigureElementPressed( MouseEvent e )
	{
//System.out.println("<< onFigureElementPressed >>");
//System.out.println("id="+this.getID());

		boolean flag;

		flag = mStringElement.onMousePressed(e);
		if( flag )
		{
			mPressedElement = mStringElement;
//System.out.println("String");
			return true;
		}

		flag = mLegendElement.onMousePressed(e);
		if( flag )
		{
			mPressedElement = mLegendElement;
//System.out.println("Legend");
			return true;
		}

		flag = mAxisElement.onMousePressed(e);
		if( flag )
		{
			mPressedElement = mAxisElement;
//System.out.println("Axis");
			return true;
		}

		flag = mGraphElement.onMousePressed(e);
		if( flag )
		{
			mPressedElement = mGraphElement;
//System.out.println("Graph");
			return true;
		}


		return false;
	}


//static int cnt=0;
//static long time = 0;




	/**
	 * 
	 */
	protected boolean drag(final MouseEvent e)
	{
//System.out.println();
//System.out.println("<< drag >>");
//System.out.println("id="+this.getID());


		// ʒu񃉃xւ̐ݒ
		mWnd.notifyPosition( this, e.getX(), e.getY() );

//System.out.println(e);


		// other points
		if( mMouseLocation == OTHER )
		{
			final boolean flag = this.dragOtherPoint(e);
			return flag;
		}


		// Ot`̈̕ύXȌ
		Rectangle2D dRect = this.getRectangleOnDragging();
		final float xOld = (float)dRect.getX();
		final float yOld = (float)dRect.getY();
		final float wOld = (float)dRect.getWidth();
		final float hOld = (float)dRect.getHeight();



		// ʒuL^
		this.updateFigureRect();


		Rectangle2D cRect = this.mWnd.getClientRectZoomed();
		final int diffX = e.getX() - mPressedPoint.x;
		final int diffY = e.getY() - mPressedPoint.y;

//System.out.println("event: "+e.getPoint());
//System.out.println("pressed point: "+this.mPressedPoint);
//System.out.println("Old: "+this.mRectangleOnDragging);
//System.out.println(this.getGraphAreaRect());
//System.out.println("diff: "+diffX+"  "+diffY);


		final float sizeOldX = wOld;
		final float sizeOldY = hOld;

		float sizeNewX = 0.0f;
		float sizeNewY = 0.0f;


		// ȉ̏ōXV
		// ̂܂܃Ot`̈̋`ɂȂ
		float x = xOld;
		float y = yOld;
		float w = wOld;
		float h = hOld;



		//
		// hbOĂ_ɉďꍇ
		//
		// 

		if( mMouseLocation == NORTH )
		{
//System.out.println("NORTH");
			mPressedPoint.setLocation(
				mPressedPoint.getX(),
				mPressedPoint.getY() + diffY
			);
			sizeNewY = sizeOldY - diffY;
			y = yOld + sizeOldY - sizeNewY;
			h = sizeNewY;
		}
		else if( mMouseLocation == SOUTH )
		{
//System.out.println("SOUTH");
			mPressedPoint.setLocation(
				mPressedPoint.getX(),
				mPressedPoint.getY() + diffY
			);
			sizeNewY = sizeOldY + diffY;
			h = sizeNewY;
		}
		else if( mMouseLocation == WEST )
		{
//System.out.println("WEST");
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);
			sizeNewX = sizeOldX - diffX;
			x = xOld + sizeOldX - sizeNewX;
			w = sizeNewX;
		}
		else if( mMouseLocation == EAST )
		{
//System.out.println("EAST");
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY()
			);
			sizeNewX = sizeOldX + diffX;
			w = sizeNewX;
		}
		else if( mMouseLocation == NORTH_WEST )
		{
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);
			sizeNewX = sizeOldX - diffX;

			// ShiftL[Ăc͕ςȂ
			if( (e.getModifiers()&MouseEvent.SHIFT_MASK) != 0 )
			{
				sizeNewY = sizeNewX*( sizeOldY/sizeOldX );
			}
			else
			{
				sizeNewY = sizeOldY - diffY;
			}
			x = xOld + sizeOldX - sizeNewX;
			y = yOld + sizeOldY - sizeNewY;
			w = sizeNewX;
			h = sizeNewY;
//System.out.println(sizeOldY+"  "+sizeNewY);
		}
		else if(
			( mMouseLocation == NORTH_EAST )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) == 0 )
		)
		{
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);

			// ShiftL[ĂȂ̂ŏc͉
			sizeNewX = sizeOldX + diffX;
			sizeNewY = sizeOldY - diffY;

			y = yOld + sizeOldY - sizeNewY;
			w = sizeNewX;
			h = sizeNewY;
		}
		else if(
			( mMouseLocation == NORTH_EAST )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) != 0 )
		)
		{
			mPressedPoint.setLocation(
				mPressedPoint.getX(),
				mPressedPoint.getY() + diffY
			);

			// ShiftL[Ă̂ŏc͕s
			sizeNewY = sizeOldY - diffY;
			sizeNewX = sizeNewY*( sizeOldX/sizeOldY );

			y = yOld + sizeOldY - sizeNewY;
			w = sizeNewX;
			h = sizeNewY;
		}
		else if(
			( mMouseLocation == SOUTH_WEST )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) == 0 )
		)
		{

			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);

			// ShiftL[ĂȂ̂ŏc͉
			sizeNewX = sizeOldX - diffX;
			sizeNewY = sizeOldY + diffY;

			x = xOld + sizeOldX - sizeNewX;
			w = sizeNewX;
			h = sizeNewY;
		}
		else if(
			( mMouseLocation == SOUTH_WEST )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) != 0 )
		)
		{
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);

			// ShiftL[Ă̂ŏc͕s
			sizeNewX = sizeOldX - diffX;
			sizeNewY = sizeNewX*( sizeOldY/sizeOldX );

			x = xOld + sizeOldX - sizeNewX;
			w = sizeNewX;
			h = sizeNewY;
		}
		else if(
			( mMouseLocation == SOUTH_EAST )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) == 0 )
		)
		{
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);

			// ShiftL[ĂȂ̂ŏc͉
			sizeNewX = sizeOldX + diffX;
			sizeNewY = sizeOldY + diffY;

			w = sizeNewX;
			h = sizeNewY;
		}
		else if(
			( mMouseLocation == SOUTH_EAST )
			&& ( (e.getModifiers()&MouseEvent.SHIFT_MASK) != 0 )
		)
		{
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY()
			);

			// ShiftL[Ă̂ŏc͕s
			sizeNewX = sizeOldX + diffX;
			sizeNewY = sizeNewX*( sizeOldY/sizeOldX );

			w = sizeNewX;
			h = sizeNewY;
		}


		// Ȃ肷return
		if( w<mMinWidth || h<mMinHeight )
		{
//System.out.println("w<mMinWidth || h<mMinHeight");
			return true;
		}


		// `XV
		this.mRectangleOnDragging.setRect( x, y, w, h );
//System.out.println(this.mRectangleOnDragging);


		// hbO̐`悵Ȃꍇɂ́AɃtBMAɕύX𔽉f
		if( SGFigure.mDrawRectangleOnDraggingFlag == false )
		{
			// `ƂɃtBMAEXV
			final boolean flag = this.setGraphAreaRectOnDragging();
			if( !flag )
			{
//System.out.println("++++++++++++++++++++++++++++++++++");
//System.out.println(w+"  "+wOld);
				// `ɖ߂
				this.mRectangleOnDragging.setRect( xOld, yOld, wOld, hOld );
			}
		}


		// repaint
//		this.repaint();

//System.out.println();

		return true;

	}



	/**
	 * 
	 */
	private boolean dragOtherPoint( final MouseEvent e )
	{
//System.out.println("<< dragOtherPoint >>");
//System.out.println("id="+this.getID());
//System.out.println(this.mPressedElement);


		// NbNꂽSGIFigureElementΖ₢킹
		if( mPressedElement!=null )
		{
			// tBMAGgɒm点
			final boolean flag = mPressedElement.onMouseDragged(e);
//System.out.println( this.mPressedElement );
//System.out.println();

			this.setCursorToWindow( mPressedElement );

			return flag;
		}


		// parallel displacement
		if( this.isGraphAreaContains( mPressedPoint ) )
		{
//System.out.println("parallel");
//System.out.println();

			final int dx = e.getX() - mPressedPoint.x;
			final int dy = e.getY() - mPressedPoint.y;

//System.out.println(e.getPoint());
//System.out.println(this.mPressedPoint);
//System.out.println(dx*SGConstants.CM_POINT_RATIO+"  "+dy*SGConstants.CM_POINT_RATIO);

			// IĂSẴtBMA𕽍sړ
			ArrayList list = this.mWnd.mFocusedFigureList;
//System.out.println("list:"+list);
			for( int ii=0; ii<list.size(); ii++ )
			{
//System.out.println("ii="+ii);

				final SGFigure figure = (SGFigure)list.get(ii);

//System.out.println("id="+figure.getID());
//System.out.println("before:"+figure.getRectangleOnDragging().getBounds());

				// set the location of the rectangle for dragging
				figure.getRectangleOnDragging().setRect(
					figure.getGraphAreaX() + dx,
					figure.getGraphAreaY() + dy,
					figure.getGraphAreaWidth(),
					figure.getGraphAreaHeight()
				);

//System.out.println("after:"+figure.getRectangleOnDragging().getBounds());


				// if the rectangle for dragging is invisible,
				// set the graph area rectangle immediately
				if( SGFigure.mDrawRectangleOnDraggingFlag == false )
				{
					figure.mPressedPoint.setLocation(
						figure.mPressedPoint.x + dx,
						figure.mPressedPoint.y + dy
					);

					figure.setGraphAreaRectOnDragging();
				}

			}

//			this.repaint();
		}

//System.out.println();

		return true;

	}



	/**
	 * 
	 */
	protected boolean setGraphAreaRectOnDragging()
	{
		Rectangle2D rect = this.getRectangleOnDragging();

		final float x = (float)rect.getX();
		final float y = (float)rect.getY();
		final float w = (float)rect.getWidth();
		final float h = (float)rect.getHeight();

		this.setGraphAreaRect(x,y,w,h);

		return true;
	}



	/**
	 * 
	 * @return
	 */
	protected boolean release( final MouseEvent e )
	{
//System.out.println("release:"+this.getID());
//System.out.println("mPressedElement="+this.mPressedElement);
//System.out.println();

		final int x = e.getX();
		final int y = e.getY();


		// set the mouse cursor
		this.setMouseLocation(x,y);
		this.changeCursor();


		// set the rectangle of the graph area
		if( SGFigure.mDrawRectangleOnDraggingFlag )
		{
			this.setGraphAreaRectOnDragging();
		}


		// SGIFigureElementւ̏
		if( mPressedElement != null )
		{
			mPressedElement.onMouseReleased(e);
		}
		mPressedElement = null;


		// }EX̃vXƃ[XƂŃtBMÄʒuςȂꍇɂ́A
		// ȍ~͕̏svȂ̂ŁÂ܂܏I
		if( this.isFigureMoved() == false )
		{
			return true;
		}



		// After drawing back legend and string elements,
		// check whether the bounds line shoukd be written.
		this.mStringElement.chkBoundsVisible();
		this.mLegendElement.chkBoundsVisible();


		return true;
	}




	/**
	 * 
	 */
	protected boolean isFigureMoved()
	{
//System.out.println("###");
//System.out.println(this.mTempFigureRect);
//System.out.println(this.mGraphAreaX+"  "+this.mGraphAreaY+"  "+this.mGraphAreaWidth+"  "+this.mGraphAreaHeight);
//System.out.println();

		final boolean flag = !( this.mTempFigureRect.equals( this.getGraphAreaRect() ) );


/*
		final boolean flag = !(
			(this.mGraphAreaX==this.mTempFigureRect.getX())
			&&
			(this.mGraphAreaY==this.mTempFigureRect.getY())
			&&
			(this.mGraphAreaWidth==this.mTempFigureRect.getWidth())
			&&
			(this.mGraphAreaHeight==this.mTempFigureRect.getHeight())
		 );
*/
		
		return flag;

	}



	/**
	 * 
	 * @return
	 */
	protected boolean drawbackFigure()
	{
		final Rectangle2D cRect = this.mWnd.getClientRect();

		final Rectangle2D bbRect = this.getBoundingBox();
		final Rectangle2D pRect = this.mWnd.getPaperRect();

		final Rectangle2D rect = new Rectangle2D.Float();
		rect.setRect( bbRect );

		if( bbRect.getX() < cRect.getX() )
		{
			rect.setRect(
				0.0,
				rect.getY(),
				rect.getWidth(),
				rect.getHeight()
			);
		}

		if( bbRect.getY() < cRect.getY() )
		{
			rect.setRect(
				rect.getX(),
				0.0,
				rect.getWidth(),
				rect.getHeight()
			);
		}


		if( bbRect.getX() + bbRect.getWidth() > pRect.getX() + pRect.getWidth() )
		{
			rect.setRect(
				pRect.getX() + pRect.getWidth() - bbRect.getWidth(),
				rect.getY(),
				rect.getWidth(),
				rect.getHeight()
			);
		}
		
		
		if( bbRect.getY() + bbRect.getHeight() > pRect.getY() + pRect.getHeight() )
		{
			rect.setRect(
				rect.getX(),
				pRect.getY() + pRect.getHeight() - bbRect.getHeight(),
				rect.getWidth(),
				rect.getHeight()
			);
		}
		


		if( this.setBoundingBox( rect ) == false )
		{
			return false;
		}


		// set the dragging rectangle
		this.setDraggingRect();

//System.out.println(this.mRectangleOnDragging);
//System.out.println(this.getGraphAreaRect());
//System.out.println();

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean clearSelectedElements()
	{
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].clearSelectedElements();
		}
		return true;
	}





	/**
	 * 
	 */
	public void componentHidden(final ComponentEvent e){}



	/**
	 * 
	 */
	public void componentResized(final ComponentEvent e){}



	/**
	 * 
	 */
	public void componentShown(final ComponentEvent e){}



	/**
	 * 
	 */
	public void componentMoved(final ComponentEvent e){}



	/**
	 * 
	 */
	protected boolean onKeyPressed( final KeyEvent e )
	{
		
		this.mAxisElement.onKeyPressed(e);
		this.mLegendElement.onKeyPressed(e);
		this.mGraphElement.onKeyPressed(e);
		this.mStringElement.onKeyPressed(e);
		
		return true;
	}


	/**
	 * 
	 */
	protected boolean onKeyReleased( final KeyEvent e )
	{

		this.mAxisElement.onKeyReleased(e);
		this.mLegendElement.onKeyReleased(e);
		this.mGraphElement.onKeyReleased(e);
		this.mStringElement.onKeyReleased(e);

		return true;
	}


	/**
	 * 
	 */
	protected boolean onKeyTyped( final KeyEvent e )
	{

//		this.typed(e);

		this.mAxisElement.onKeyTyped(e);
		this.mLegendElement.onKeyTyped(e);
		this.mGraphElement.onKeyTyped(e);
		this.mStringElement.onKeyTyped(e);

		return true;
	}



	/**
	 * 
	 */
	private boolean typed( final KeyEvent e )
	{

/*
		if( this.isFocusedFigure() )
		{

			final char c = e.getKeyChar();
			final int code = e.getKeyCode();


//System.out.println("+++");
//System.out.println(c);
//System.out.println(code);
//System.out.println("***");
//System.out.println();


			switch( c )
			{

				case 'k' :
				{
					this.translate( 0.0, -1.0 );
					break;
				}

				case 'j' :
				{
					this.translate( 0.0, 1.0 );
					break;
				}

				case 'h' :
				{
					this.translate( -1.0, 0.0 );
					break;
				}

				case 'l' :
				{
					this.translate( 1.0, 0.0 );
					break;
				}

				default :
				{
					
				}
			}

		}

		this.repaint();
*/

		return true;
	}




	/**
	 * 
	 */
	public void windowActivated(final WindowEvent e)
	{
/*
		Object obj = e.getSource();

		// tBMAEChE
		if( obj.equals( this.mWnd ) )
		{
System.out.println("windowActivated");

			if( this.mDialog.isShowing() )
			{
//				this.mDialog.toFront();
			}

		}
*/
	}


	/**
	 * 
	 */
	public void windowDeactivated(final WindowEvent e)
	{
//System.out.println("windowDeactivated");
	}


	/**
	 * 
	 */
	public void windowIconified(final WindowEvent e)
	{
//System.out.println("windowIconified");
	}


	/**
	 * 
	 */
	public void windowDeiconified(final WindowEvent e)
	{
//System.out.println("windowDeiconified");
	}


	/**
	 * 
	 */
	public void windowOpened(final WindowEvent e)
	{
//System.out.println("windowOpened");
	}


	/**
	 * 
	 */
	public void windowClosed(final WindowEvent e)
	{
//System.out.println("windowClosed");
	}


	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
//System.out.println("windowClosing");

		Object obj = e.getSource();


		// tBMÃvpeBݒp_CAO
		if( obj.equals( this.mDialog ) )
		{
			this.onCanceled();
//this.onOK();
		}

	}



	/**
	 * 
	 * @return
	 */
	public boolean undo()
	{
//System.out.println("undo "+this);

		this.mFigureStateCounter--;

		FigureProperties p = (FigureProperties)this.mFigurePropertyHistoryList.get(this.mFigureStateCounter);
		this.setProperties(p);

//System.out.println(this.mFigureStateCounter);
//System.out.println();

		this.setGraphAreaRectToFigureElement();


//		this.calcElementBounds();
//		this.setViewBounds();
//		this.repaint();

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean redo()
	{
//System.out.println("redo "+this);

	this.mFigureStateCounter++;

		FigureProperties p = (FigureProperties)this.mFigurePropertyHistoryList.get(this.mFigureStateCounter);
		this.setProperties(p);

//System.out.println(this.mFigureStateCounter);
//System.out.println();

		this.setGraphAreaRectToFigureElement();

//		this.calcElementBounds();
//		this.setViewBounds();
//		this.repaint();

		return true;

	}



	/**
	 * 
	 */
	protected Rectangle2D getRectangleOnDragging()
	{
		return this.mRectangleOnDragging;
	}



	/**
	 * }EXʒu𑮐ɐݒ
	 */
	private boolean setMouseLocation( final int x, final int y )
	{

		final double radius = 1.5*this.mWnd.mAnchorSize;

		final Rectangle2D rect = this.getGraphAreaRect();


		// 
		if( ( Math.abs(x-rect.getX()) < radius ) && ( Math.abs(y-rect.getY()) < radius ) )
		{
			mMouseLocation = NORTH_WEST;
			return true;
		}
		// E
		else if( ( Math.abs( x-(rect.getX()+rect.getWidth() ) ) < radius )
			&& ( ( Math.abs( y-(rect.getY()+rect.getHeight() ) ) < radius ) ) )
		{
			mMouseLocation = SOUTH_EAST;
			return true;
		}
		// E
		else if( ( Math.abs(x-(rect.getX()+rect.getWidth())) < radius )
			&& ( Math.abs(y-rect.getY()) < radius ) )
		{
			mMouseLocation = NORTH_EAST;
			return true;
		}
		// 
		else if( ( Math.abs(x-rect.getX()) < radius )
			&& ( ( Math.abs(y-(rect.getY()+rect.getHeight())) < radius ) ) )
		{
			mMouseLocation = SOUTH_WEST;
			return true;
		}
		// [
		else if( ( Math.abs(x-rect.getX()) < radius )
			&& ( Math.abs(y-(rect.getY()+rect.getHeight()/2)) < radius ) )
		{
			mMouseLocation = WEST;
			return true;
		}
		// E[
		else if( ( Math.abs(x-(rect.getX()+rect.getWidth())) < radius )
			&& ( Math.abs(y-(rect.getY()+rect.getHeight()/2)) < radius ) )
		{
			mMouseLocation = EAST;
			return true;
		}
		// [
		else if( ( Math.abs(y-rect.getY()) < radius )
			&& ( Math.abs(x-(rect.getX()+rect.getWidth()/2)) < radius ) )
		{
			mMouseLocation = NORTH;
			return true;
		}
		// [
		else if( ( Math.abs(y-(rect.getY()+rect.getHeight())) < radius )
			&& ( Math.abs(x-(rect.getX()+rect.getWidth()/2)) < radius ) )
		{
			mMouseLocation = SOUTH;
			return true;
		}
		else
		{
			mMouseLocation = OTHER;
			return true;
		}

//System.out.println(mMouseLocation);
	}



	/**
	 * 
	 */
	private boolean changeCursor()
	{

		// }EẌʒuɉăJ[\ύX
		Cursor cur = null;
		switch( mMouseLocation )
		{
			case WEST:
			{
				cur = new Cursor( Cursor.W_RESIZE_CURSOR );
				break;
			}
			case EAST:
			{
				cur = new Cursor( Cursor.E_RESIZE_CURSOR );
				break;
			}
			case NORTH:
			{
				cur = new Cursor( Cursor.N_RESIZE_CURSOR );
				break;
			}
			case SOUTH:
			{
				cur = new Cursor( Cursor.S_RESIZE_CURSOR );
				break;
			}
			case NORTH_WEST:
			{
				cur = new Cursor( Cursor.NW_RESIZE_CURSOR );
				break;
			}
			case SOUTH_EAST:
			{
				cur = new Cursor( Cursor.SE_RESIZE_CURSOR );
				break;
			}
			case NORTH_EAST:
			{
				cur = new Cursor( Cursor.NE_RESIZE_CURSOR );
				break;
			}
			case SOUTH_WEST:
			{
				cur = new Cursor( Cursor.SW_RESIZE_CURSOR );
				break;
			}
			default:
			{
				cur = Cursor.getDefaultCursor();
			}
		}


		// J[\AEChEɃZbg
		// tBMAɃZbgƕ\ȂiAnchorPanel̂߁j
		if( mWnd.mFocusedFigureList.contains(this) )
		{
			this.mWnd.setCursor( cur );
		}


		return true;
	}




	/**
	 * 
	 */
	private boolean onDrawingElement( final int x, final int y )
	{
		boolean flag;

		flag = mStringElement.onDrawingElement(x,y);
		if( flag )
		{
//System.out.println("String");
			return true;
		}

		flag = mLegendElement.onDrawingElement(x,y);
		if( flag )
		{
//System.out.println("Legend");
			return true;
		}

		flag = mAxisElement.onDrawingElement(x,y);
		if( flag )
		{
//System.out.println("Axis");
			return true;
		}

		flag = mGraphElement.onDrawingElement(x,y);
		if( flag )
		{
//System.out.println("Graph");
			this.setCursorToWindow( this.mGraphElement );
			return true;
		}

		return false;
	}


	/**
	 * 
	 * @return
	 */
	protected boolean setCursorToWindow( final SGIFigureElement el )
	{
		Cursor cur = el.getFigureElementCursor();
		if( cur!=null )
		{
			this.mWnd.setCursor(cur);
//			repaint();
//System.out.println(cur.getType());
//System.out.println();
		}
		return true;
	}



	/**
	 * 
	 */
	protected final String DRAW_DRAGGING_RECTANGLE = "Draw Dragging Rectangle";


	/**
	 * 
	 */
	protected final String SAVE_PROPERTY = "Save the Property";


	/**
	 * 
	 */
	private boolean createPopupMenu()
	{
		mPopupMenu.setBounds( 0, 0, 100, 100 );


		final String[] commandArray = {
			DRAW_DRAGGING_RECTANGLE,
			SAVE_PROPERTY,
			REMOVE_FIGURE
		};


		final String[] commandArray2 = {
			SHOW_FRAME
		};


		for( int ii=0; ii<commandArray.length; ii++ )
		{
			final JMenuItem item = new JMenuItem(commandArray[ii]);
			item.addActionListener(this);
			this.mPopupMenu.add(item);
		}

		this.mPopupMenu.addSeparator();

		for( int ii=0; ii<commandArray2.length; ii++ )
		{
			final JMenuItem item = new JMenuItem(commandArray2[ii]);
			item.addActionListener(this);
			this.mPopupMenu.add(item);
		}


		return true;
	}




	/**
	 * 
	 */
	private JDialog getDialog()
	{

		final SGFigureDialog dg = (SGFigureDialog)this.mDialog;

		// set the location
		dg.setLocation( this.mWnd.getLocation() );


		// {^ɑ
		dg.setColorButtonBorder(true);


		// _CAOɐݒ
		this.setDialogProperty();


		// e|EIuWFNg쐬
		this.mTemporaryProperties = this.getProperties();


		return this.mDialog;

	}



	/**
	 * 
	 */
	private boolean setDialogProperty()
	{

//System.out.println("setDialogProperty");

		final SGFigureDialog dg = (SGFigureDialog)this.mDialog;

//System.out.println(this.mGraphAreaX);
//System.out.println(this.mGraphAreaX*SGConstants.CM_POINT_RATIO+" cm");

		// SGFigure
		dg.setFigureX( this.mGraphAreaX*SGConstants.CM_POINT_RATIO );
		dg.setFigureY( this.mGraphAreaY*SGConstants.CM_POINT_RATIO );
		dg.setFigureWidth( this.mGraphAreaWidth*SGConstants.CM_POINT_RATIO );
		dg.setFigureHeight( this.mGraphAreaHeight*SGConstants.CM_POINT_RATIO );

		dg.setFigureBackgroundColor( this.mBackgroundColor );

		dg.setFigureTransparentFlag( this.mTransparentFlag );

/*
System.out.println("mX="+mX+",  "+this.mX*SGConstants.CM_POINT_RATIO);
System.out.println("mY="+mY+",  "+this.mY*SGConstants.CM_POINT_RATIO);
System.out.println("mWidth="+mWidth+",  "+this.mWidth*SGConstants.CM_POINT_RATIO);
System.out.println("mHeight="+mHeight+",  "+this.mHeight*SGConstants.CM_POINT_RATIO);
System.out.println();
*/

		dg.setFigureSpaceLineAndNumber( this.mSpaceAxisLineAndNumber*SGConstants.CM_POINT_RATIO );
		dg.setFigureSpaceNumberAndTitle( this.mSpaceNumberAndTitle*SGConstants.CM_POINT_RATIO );



		// Added the ID-number to the title of the dialog.
		String title = SGFigureDialog.TITLE;
		title += ":" + new Integer( this.getID() ).toString();
		this.mDialog.setTitle(title);



		// SGILegendElement
		dg.setFigureLegendVisible( this.mLegendElement.isLegendVisible() );


		return true;
	}



	/**
	 * 
	 */
	private boolean createDialog()
	{

		final SGFigureDialog dg = new SGFigureDialog( this.mWnd, true );


		// add action listener of OK,Cancel,Preview buttons
		// add window listener
		dg.setListener(this);

		this.mDialog = dg;


		return true;

	}


	/**
	 * 
	 */
	private boolean setPropertyWithDialog()
	{
//System.out.println("Figure: setPropertyWithDialog");

		// get the properties from dialog
		FigureProperties p = this.getPropertyFromDialog();

		this.setProperties(p);

		this.setGraphAreaRectToFigureElement();

//		this.repaint();

		return true;

	}




	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		final FigureProperties p = new FigureProperties();

		// location
		p.x = this.mGraphAreaX;
		p.y = this.mGraphAreaY;

		// size
		p.width = this.mGraphAreaWidth;
		p.height = this.mGraphAreaHeight;

		// space
		p.spaceLineAndNumber = this.mSpaceAxisLineAndNumber;
		p.spaceNumberAndTitle = this.mSpaceNumberAndTitle;

		// legend
		p.legendVisible = this.mLegendElement.isLegendVisible();

		// background color
		p.bgColor = this.mBackgroundColor;

		// transparency
		p.transparent = this.mTransparentFlag;

		return p;
	}






	/**
	 * 
	 */
	private FigureProperties getPropertyFromDialog()
	{
		final SGFigureDialog dg = (SGFigureDialog)this.mDialog;
		final FigureProperties p = dg.getProperties();
		return p;
	}



	/**
	 * 
	 */
	private boolean setBackgroundColorWidhDialog()
	{
		SGFigureDialog dg = (SGFigureDialog)this.mDialog;
		this.mBackgroundColor = dg.getFigureBackgroundColor();
		
		return true;
	}



	/**
	 * ANVƌĂяo܂B
	 */
	public void actionPerformed(final ActionEvent e)
	{
//System.out.println("<< SGFigure::actionPerformed >>");
//System.out.println("id="+e.getID());
//System.out.println();

		final String command = e.getActionCommand();
		final Object source = e.getSource();


		//
		// popup menu
		//

		if( command.equals(SHOW_FRAME) )
		{
			mBoundingBoxVisibleFlag = !mBoundingBoxVisibleFlag;
		}
		else if( command.equals(DRAW_DRAGGING_RECTANGLE) )
		{
			SGFigure.mDrawRectangleOnDraggingFlag = !SGFigure.mDrawRectangleOnDraggingFlag;
		}
		else if( command.equals(REMOVE_FIGURE) )
		{
			this.mWnd.hideSelectedFigures();
		}
		else if( command.equals(SAVE_PROPERTY) )
		{
			this.mWnd.createPropertyFileForFocusedFigures();
		}


		//
		// dialog
		//

		SGFigureDialog dg = (SGFigureDialog)this.mDialog;
		ArrayList comList = dg.getActiveComponentList();

		if( command.equals("OK") || comList.contains(source) )
		{
			this.onOK();
		}
		else if( command.equals("Cancel") )
		{
			this.onCanceled();
		}
		else if( command.equals("Preview") )
		{
			this.onPreviewed();
		}


		//
		// SGIFIgureElement̃Cxgւ̑Ή
		//

		if( source instanceof SGIFigureElement )
		{
			this.fromFigureElement(e);
		}


		return;

	}


	/**
	 * f[^̓
	 */
	private boolean mergeDatas( final SGIFigureElement element )
	{
//System.out.println("mergeDatas");

		// SGIFigureElementIuWFNgĂf[^XgƁA
		// SGFigureĂf[^Xg̍
		final ArrayList elementDataList = element.getDataList();
		final ArrayList differenceDataList = new ArrayList();

		for( int ii=0; ii<this.mDataList.size(); ii++ )
		{
			final SGData data = (SGData)this.mDataList.get(ii);
			if( !elementDataList.contains(data) )
			{
				differenceDataList.add(data);
			}
		}

//System.out.println(this.mDataList);
//System.out.println(differenceDataList);
//System.out.println();

		for( int ii=0; ii<differenceDataList.size(); ii++ )
		{
			final SGData data = (SGData)differenceDataList.get(ii);
			this.removeData( data );
		}

		return true;

	}



	/**
	 * 
	 */
	private boolean fromFigureElement( final ActionEvent e )
	{
//System.out.println("<< SGFigure::fromFigureElement >>");
//System.out.println(e);
//System.out.println(e.getID());
//System.out.println();


		// Cxg𓊂SGIFigureElementIuWFNg̎擾
		final SGIFigureElement element = (SGIFigureElement)e.getSource();

		final int id = e.getID();

		switch( id )
		{

			// SGIFigureElement̕ύX`ꍇ
			case SGFigure.NOTIFY_CHANGE :
			{

				// f[^̓
				this.mergeDatas( element );


				// broadcastē
				this.notifyFigureElement( element );


				break;

			}


			// XVꍇ
			case SGFigure.UPDATE_HISTORY :
			{
				// Figure̗XV
				this.updateHistory( element );

				break;
			}


			// Add to the last of history list
			case SGFigure.ADD_LATEST_HISTORY :
			{
				this.addToLatestHistory( element );

System.out.println(this.mUndoableObjectHistoryList);
System.out.println();

				break;
			}


			// ʃvpeCݒ
			case SGFigure.SET_PROPERTY_OF_SELECTED_DATA :
			{
				//
				this.mWnd.setPropertyOfSelectedObjects();

				break;
			}


			default :
			{
				
			}

		}


		return true;

	}



	/**
	 * 
	 * @return
	 */
	public boolean notifyFigureElement( SGIFigureElement element )
	{
		this.broadcast(element);
//		this.calcElementBounds();

		this.repaint();

		return true;
	}



	/**
	 * 
	 * @return
	 */
	private ArrayList mFigurePropertyHistoryList = new ArrayList();



	/**
	 * 
	 * @return
	 */
	private int mFigureStateCounter = 0;



	/**
	 * 
	 */
	public boolean initPropertiesHistory()
	{
		this.addFigurePropertyHistory( (FigureProperties)this.getProperties() );
		return true;
	}



	/**
	 * 
	 * @return
	 */
	private boolean addFigurePropertyHistory( FigureProperties p )
	{

//System.out.println("<< addFigurePropertyHistory >>");
//System.out.println(this.mFigureStateCounter);

		ArrayList list = new ArrayList();
		for( int ii=0; ii<this.mFigureStateCounter; ii++ )
		{
			list.add( this.mFigurePropertyHistoryList.get(ii) );
		}
		list.add(p);

		this.mFigurePropertyHistoryList = list;

//System.out.println(this.mFigurePropertyHistoryList);
//System.out.println("x="+p.x+"  y="+p.y);
//System.out.println("w="+p.width+"  h="+p.height);
//System.out.println();

		return true;
	}




	/**
	 * AhDΏۃIuWFNg̗Xg
	 */
	protected ArrayList mUndoableObjectHistoryList = new ArrayList();



	/**
	 * AhD̎s
	 */
	public boolean onUndo()
	{

//System.out.println("<< SGFigure : onUndo >>");


		// L^ĂundoΏۃIuWFNg̎擾
		if( this.mCurrentStateCounter == 0 )
		{
//System.out.println("return false");
			return false;
		}

		ArrayList objList = (ArrayList)this.mUndoableObjectHistoryList.get(
			this.mCurrentStateCounter - 1 );
		for( int ii=0; ii<objList.size(); ii++ )
		{
			SGIUndoable obj = (SGIUndoable)objList.get(ii);
			// AhD̎s̈˗
			boolean flag;
			if( obj.equals(this) )
			{
				flag = this.undo();
			}
			else
			{
				flag = obj.onUndo();
			}
		
			if( !flag )
			{
//System.out.println("return false");
				return false;
			}
		}


		// decrement
		this.mCurrentStateCounter--;


//System.out.println("-- history --");
//System.out.println(this.mUndoableObjectHistoryList);
//System.out.println(this.mFigurePropertyHistoryList);
//System.out.println("cnt="+this.mCurrentStateCounter);
//System.out.println();


		return true;

	}


	/**
	 * 
	 */
	public boolean onRedo()
	{

//System.out.println("<< onRedo >>");

		// L^ĂundoΏۃIuWFNg̎擾
		if( this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size() )
		{
			return false;
		}


		ArrayList objList = (ArrayList)this.mUndoableObjectHistoryList.get( this.mCurrentStateCounter );
		for( int ii=0; ii<objList.size(); ii++ )
		{
			SGIUndoable obj = (SGIUndoable)objList.get(ii);
			// hD̎s̈˗
			boolean flag;
			if( obj.equals(this) )
			{
				flag = this.redo();
			}
			else
			{
				flag = obj.onRedo();
			}

			if( !flag )
			{
//System.out.println("return false");
				return false;
			}
		}


		// increment
		this.mCurrentStateCounter++;


		return true;

	}



	/**
	 * 
	 */
	protected boolean onOK()
	{
//System.out.println("onOK");

		boolean flag;

		// _CAOvpeB擾Đݒ
		flag = this.setPropertyWithDialog();
		if( !flag )
		{
			return false;
		}


		// _CAOoOŃvpeBύXĂꍇ̂݁A
		// XV
		SGProperties pTemp = this.mTemporaryProperties;
		SGProperties pPresent = this.getProperties();
//System.out.println("pTemp:"+pTemp);
//System.out.println("pPresent:"+pPresent);
//System.out.println(pTemp.equals(pPresent));
//System.out.println();
		if( pTemp.equals(pPresent) == false )
		{
			// IuWFNgXV
			this.updateHistory();
		}


		this.mTemporaryProperties = null;
		this.mDialog.hide();
		this.repaint();


		return true;

	}



	/**
	 * 
	 */
	public boolean updateHistory()
	{

//System.out.println("SGFigure : updateHistory()");
//System.out.println();

		// EChẼIuWFNgXV
		this.updateParentHistory();


		this.updateThisObjectHistory();


		return true;

	}


	/**
	 * 
	 * @return
	 */
	public boolean updateThisObjectHistory()
	{
		// IuWFNgXV
		this.updateObjectHistory(this);


		// tBMÃvpeBXV
		this.mFigureStateCounter++;
		this.addFigurePropertyHistory( (FigureProperties)this.getProperties() );


		return true;
	}




	/**
	 * 
	 */
	public boolean updateParentHistory()
	{
		this.mWnd.updateObjectHistory(this);
		return true;
	}



	/**
	 * 
	 * @return
	 */
	protected boolean addToLatestHistory( SGIFigureElement el )
	{
		ArrayList list = this.mUndoableObjectHistoryList;
		ArrayList objList = (ArrayList)list.get( list.size() - 1 );
		objList.add(el);
		return true;
	}


	/**
	 * 
	 */
	protected boolean updateHistory( SGIFigureElement el )
	{
//System.out.println("updateHistory");
//System.out.println(el);
//System.out.println();

		// EChẼIuWFNgXV
		this.updateParentHistory();

		// IuWFNgXV
		this.updateObjectHistory(el);


		return true;

	}



	/**
	 * IuWFNg̗XV
	 * @return
	 */
	public boolean updateObjectHistory( final SGIUndoable obj )
	{

		ArrayList objList = new ArrayList();
		objList.add(obj);
		boolean flag = this.updateObjectHistory(objList);
		if( !flag )
		{
			return false;
		}

		return true;

	}



	/**
	 * IuWFNg̗XV
	 */
	public boolean updateObjectHistory( final ArrayList objList )
	{

		ArrayList list = new ArrayList();
		for( int ii=0; ii<this.mCurrentStateCounter; ii++ )
		{
			Object obj = this.mUndoableObjectHistoryList.get(ii);
			list.add(obj);
		}
		list.add( new ArrayList(objList) );

		this.mUndoableObjectHistoryList = list;
		this.mCurrentStateCounter++;

		return true;
	}





	/**
	 * 
	 */
	protected boolean onCanceled()
	{

		if( this.setProperties( this.mTemporaryProperties ) == false )
		{
			return false;
		}

		this.setGraphAreaRectToFigureElement();

		this.mTemporaryProperties = null;
		this.mDialog.hide();
		this.repaint();

		return true;
	}


	/**
	 * 
	 */
	protected boolean onPreviewed()
	{
		this.setPropertyWithDialog();
		this.repaint();

		return true;
	}



	/**
	 * ݁AԂ̂ǂ̈ʒuɂ̂JE^
	 * gƁASGIFigureElement̏ԕύXɂĕύX
	 */
	private int mCurrentStateCounter = 0;



	/**
	 * 
	 * @return
	 */
	public boolean initGraphAreaLocation()
	{
//System.out.println("<< SGFigure : initGraphAreaLocation >>");


		SGTuple2f topAndBottom = new SGTuple2f();
		SGTuple2f leftAndRight = new SGTuple2f();
		if( this.calcMargin( topAndBottom, leftAndRight ) == false )
		{
			return false;
		}


		// vZʂɌ
		float topMax = topAndBottom.x;
		float bottomMax = topAndBottom.y;
		float leftMax = leftAndRight.x;
		float rightMax = leftAndRight.y;


		// SGFigureɐݒ
		this.mGraphAreaX = leftMax;
		this.mGraphAreaY = topMax;


		// ̑SĂSGIFigureElementɒlݒ肵A
		// `vf蒼
		final SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setGraphAreaLocation( this.mGraphAreaX, this.mGraphAreaY );
			array[ii].setGraphAreaSize( this.mGraphAreaWidth, this.mGraphAreaHeight );
		}

		return true;
	}



	/**
	 * 
	 * @param topAndBottom
	 * @param leftAndRight
	 * @return
	 */
	public boolean calcMargin( final SGTuple2f topAndBottom, final SGTuple2f leftAndRight )
	{

		// SGIFIgureElementɑ΂āAOt`̈̌_
		// R|[lg̃TCYvZ
		final SGIFigureElement[] array = this.getIFigureElementArray();

		final SGTuple2f[] tbArray = new SGTuple2f[array.length];
		final SGTuple2f[] lrArray = new SGTuple2f[array.length];

		for( int ii=0; ii<array.length; ii++ )
		{
			tbArray[ii] = new SGTuple2f();
			lrArray[ii] = new SGTuple2f();
			final boolean flag = array[ii].getMarginAroundGraphAreaRect(
				tbArray[ii], lrArray[ii] );
			if( !flag )
			{
				return false;
			}
//System.out.println(ii+"  "+tbArray[ii]+"  "+lrArray[ii]);
		}
//System.out.println();


		// vZʂɌ
		float topMax = 0.0f;
		float bottomMax = 0.0f;
		float leftMax = 0.0f;
		float rightMax = 0.0f;
		for( int ii=0; ii<array.length; ii++ )
		{
//System.out.println("ii="+ii);

			final float top = tbArray[ii].x;
			final float bottom = tbArray[ii].y;
			final float left = lrArray[ii].x;
			final float right = lrArray[ii].y;

//System.out.println(top+"  "+bottom+"  "+left+"  "+right);

			if( top > topMax )
			{
				topMax = top;
			}
			if( bottom > bottomMax )
			{
				bottomMax = bottom;
			}
			if( left > leftMax )
			{
				leftMax = left;
			}
			if( right > rightMax )
			{
				rightMax = right;
			}
		}
//System.out.println();


		topAndBottom.x = topMax;
		topAndBottom.y = bottomMax;
		leftAndRight.x = leftMax;
		leftAndRight.y = rightMax;

		return true;
	}




	/**
	 * 
	 * @return
	 */
	public Rectangle2D getBoundingBox()
	{
		final Rectangle2D graphAreaRect = this.getGraphAreaRect();

		SGTuple2f tb = new SGTuple2f();
		SGTuple2f lr = new SGTuple2f();
		if( this.calcMargin( tb, lr ) == false )
		{
			return null;
		}

		Rectangle2D rect = new Rectangle2D.Float(
			(float)graphAreaRect.getX() - lr.x,
			(float)graphAreaRect.getY() - tb.x,
			(float)graphAreaRect.getWidth() + lr.x + lr.y,
			(float)graphAreaRect.getHeight() + tb.x + tb.y
		);

		return rect;
	}




	/**
	 * 
	 * @return
	 */
	public boolean setBoundingBox( final Rectangle2D bbRect )
	{
		if( bbRect==null )
		{
			return false;
		}

		SGTuple2f tb = new SGTuple2f();
		SGTuple2f lr = new SGTuple2f();
		if( this.calcMargin(tb,lr) == false )
		{
			return false;
		}

		final float x = (float)bbRect.getX() + lr.x;
		final float y = (float)bbRect.getY() + tb.x;
		final float w = (float)bbRect.getWidth() - ( lr.x + lr.y );
		final float h = (float)bbRect.getHeight() - ( tb.x + tb.y );

		this.setGraphAreaRect( x, y, w, h );

		return true;
	}



	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean setCenter( final float cx, final float cy )
	{
		Rectangle2D bbRect = this.getBoundingBox();
		final float w = (float)bbRect.getWidth();
		final float h = (float)bbRect.getHeight();

		final float x = cx - w/2.0f;
		final float y = cy - h/2.0f;

		Rectangle2D rect = new Rectangle2D.Float(x,y,w,h);
		if( this.setBoundingBox(rect) == false )
		{
			return false;
		}

		return true;
	}



	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean setGraphAreaLocationByLeftBottom( final float x, final float y )
	{
		Rectangle2D gRect = this.getGraphAreaRect();
		this.setGraphAreaLocation( x, y - (float)gRect.getHeight() );
		return true;
	}



	/**
	 * 
	 */
	private boolean broadcast( final SGIFigureElement element )
	{

		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].synchronize(element);
		}

		return true;
	}



	/**
	 * 
	 */
	public boolean removeData( final SGData data )
	{
//System.out.println("*** "+this+" ***");	

		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=this.mDataList.size()-1; ii>=0; ii-- )
		{
			final SGData data_ = (SGData)this.mDataList.get(ii);
			if( data_.equals(data) )
			{
				this.mDataList.remove(ii);

//System.out.println(this.mDataList);

				for( int jj=0; jj<array.length; jj++ )
				{
					array[jj].removeData(data);
//System.out.println(jj+"   "+array[jj].getDataList());
				}

//System.out.println();

				return true;
			}
		}

		return true;
	}


	/**
	 * `惁\bh
	 */
	public void paintComponent(final Graphics g)
	{
		super.paintComponent(g);
		final Graphics2D g2d = (Graphics2D) g;
		this.paintGraphics2D(g2d);
	}


/*
static long time = 0;
	public void paint( Graphics g )
	{
		super.paint(g);
//		Graphics2D g2d = (Graphics2D)g;


final long s = System.currentTimeMillis();
System.out.println(s-time);
time = s;
//System.out.println();
	}
*/


	/**
	 * 
	 * @param g2d
	 */
	public void paintGraphics2D( final Graphics2D g2d )
	{

		final Rectangle2D graphAreaRect = this.getGraphAreaRect();
		if( this.mTransparentFlag == false )
		{
			g2d.setPaint(this.mBackgroundColor);
			g2d.fill(graphAreaRect);
		}


if( mBoundingBoxVisibleFlag )
{
	Rectangle2D rect = this.getBoundingBox();
	if( rect!=null )
	{
		g2d.setPaint( Color.BLUE );
		g2d.setStroke( new BasicStroke(3) );
		g2d.draw( rect );
	}
}


	}



	/**
	 * t[̐쐬
	 */
	private void drawFrameLines( final Graphics2D g2d )
	{

		g2d.setPaint( Color.RED );
		g2d.setStroke( new BasicStroke(5) );
		g2d.draw( new Rectangle( 0, 0, this.getWidth(), this.getHeight() ) );

	}



	/**
	 * 
	 * @return
	 * @throws IOException
	 */
	public boolean createPropertyFileAll( final Writer writer ) throws IOException
	{

		// tBMÃvpeB
		this.writeProperty(writer);


		// SGIFigureElement̃vpeB
		// SGIFigureElement̃vpeB
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].writeProperty(writer);
		}


		// f[^̃vpeB
		this.mGraphElement.writePropertyOfData( writer );

		writer.write("\n");

		return true;
	}



	/**
	 * 
	 * @return
	 * @throws IOException
	 */
	public boolean createPropertyFileAllOnFocused( final Writer writer ) throws IOException
	{
//System.out.println("createPropertyFileAllOnFocused");

		// tBMÃvpeB
		this.writePropertyOnFocused(writer);


		// SGIFigureElement̃vpeB
		SGIFigureElement[] array = this.getIFigureElementArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].writeProperty(writer);
		}


		// f[^̃vpeB
		this.mGraphElement.writePropertyOfData( writer );

		writer.write("\n");

		return true;
	}




	/**
	 * 
	 * @return
	 * @throws IOException
	 */
	public boolean createPropertyFile( final Writer writer ) throws IOException
	{

		// tBMÃvpeB
		this.writeProperty(writer);

		return true;

	}



	public static final String PF_FIGURE_TITLE = "[Figure]";
	public static final String PF_CLASS_NAME = "Class Name";
	public static final String PF_FIGURE_ID = "ID";
	public static final String PF_FIGURE_X_IN_CLIENT = "X";
	public static final String PF_FIGURE_Y_IN_CLIENT = "Y";
	public static final String PF_WIDTH = "Width";
	public static final String PF_HEIGHT = "Height";
	public static final String PF_SPACE_AXIS_LINE_AND_NUMBER = "Space between Axis Line and Numbers";
	public static final String PF_SPACE_NUMBER_AND_TITLE = "Space between Numbers and Title";
	public static final String PF_BACKGROUND_COLOR = "Background Color";
	public static final String PF_TRANSPARENCY = "Transparency";
	public static final String PF_LEGEND_VISIBLE = "Legend Visible";


	/**
	 * 
	 */
	public boolean writeProperty( final Writer writer ) throws IOException
	{
		writer.write( PF_FIGURE_TITLE + "\n" );
		final float x = this.mGraphAreaX;
		final float y = this.mGraphAreaY;
		this.writeProperty_( writer, x, y );
		writer.write("\n\n");

		return true;
	}


	/**
	 * 
	 */
	public boolean writePropertyOnFocused( final Writer writer ) throws IOException
	{

/*
		writer.write( PF_FIGURE_TITLE + "\n" );

		final Rectangle2D bb = this.mWnd.getBoundingBoxOfFigures( this.mWnd.mFocusedFigureList );
		final float x
			= (float)( this.getX() - bb.getX() )/this.mMagnification
				+ this.mGraphAreaX;
		final float y
			= (float)( this.getY() - bb.getY() )/this.mMagnification
				+ this.mGraphAreaY;


//System.out.println(bb);
//System.out.println(this.getX()+"  "+this.getY());
//System.out.println(this.mGraphAreaX+"  "+this.mGraphAreaY);
//System.out.println();


		this.writeProperty_( writer, x, y );


		writer.write("\n");
*/
		return true;
	}



	/**
	 * 
	 */
	public abstract String getClassType();



	/**
	 * 
	 * @return
	 * @throws IOException
	 */
	private boolean writeProperty_( final Writer writer, final float x, final float y )
		throws IOException
	{

		SGUtilityText.writePropertyLine( writer, PF_CLASS_NAME, this.getClassType() );
//		SGUtilityForPropertyFile.writePropertyLine( writer, PF_CLASS_NAME, this.getClass().getName() );
		SGUtilityText.writePropertyLine( writer, PF_FIGURE_X_IN_CLIENT, new Float( x*SGConstants.CM_POINT_RATIO ) );
		SGUtilityText.writePropertyLine( writer, PF_FIGURE_Y_IN_CLIENT, new Float( y*SGConstants.CM_POINT_RATIO ) );
		SGUtilityText.writePropertyLine( writer, PF_WIDTH, new Float( this.mGraphAreaWidth*SGConstants.CM_POINT_RATIO ) );
		SGUtilityText.writePropertyLine( writer, PF_HEIGHT, new Float( this.mGraphAreaHeight*SGConstants.CM_POINT_RATIO ) );
		SGUtilityText.writePropertyLine( writer, PF_SPACE_AXIS_LINE_AND_NUMBER, new Float( this.mSpaceAxisLineAndNumber*SGConstants.CM_POINT_RATIO ) );
		SGUtilityText.writePropertyLine( writer, PF_SPACE_NUMBER_AND_TITLE, new Float( this.mSpaceNumberAndTitle*SGConstants.CM_POINT_RATIO ) );
		SGUtilityText.writeColorPropertyLine( writer, PF_BACKGROUND_COLOR, this.mBackgroundColor );
		SGUtilityText.writePropertyLine( writer, PF_TRANSPARENCY, new Boolean( this.mTransparentFlag ) );
		SGUtilityText.writePropertyLine( writer, PF_LEGEND_VISIBLE, new Boolean( this.mLegendElement.isLegendVisible() ) );

		return true;
	}



	/**
	 * 
	 */
	private FigureProperties readProperties(
		final BufferedReader br )
		throws IOException, ClassNotFoundException,
			InstantiationException, IllegalAccessException
	{

//System.out.println("readProperty");

		FigureProperties p = new FigureProperties();


		String line = null;
		float unit = SGConstants.CM_POINT_RATIO;


		// title
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		if( line.equals( PF_FIGURE_TITLE ) == false )
		{
			return null;
		}


		// class name
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}



		//
		// bounds of the figure
		//

		// x
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dX = SGUtilityText.getDoublePropertyFromLine( line, SGFigure.PF_FIGURE_X_IN_CLIENT );
		if( dX == null )
		{
			return null;
		}
		float x = dX.floatValue()/unit;
//System.out.println(x);


		// y
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dY = SGUtilityText.getDoublePropertyFromLine( line, SGFigure.PF_FIGURE_Y_IN_CLIENT );
		if( dY == null )
		{
			return null;
		}
		float y = dY.floatValue()/unit;
//System.out.println(y);


		// width
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dW = SGUtilityText.getDoublePropertyFromLine( line, SGFigure.PF_WIDTH );
		if( dW == null )
		{
			return null;
		}
		float w = dW.floatValue()/unit;
//System.out.println(w);


		// height
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dH = SGUtilityText.getDoublePropertyFromLine( line, SGFigure.PF_HEIGHT );
		if( dH == null )
		{
			return null;
		}
		float h = dH.floatValue()/unit;
//System.out.println(h);


		p.x = x;
		p.y = y;
		p.width = w;
		p.height = h;



		//
		// space
		//

		// line and numbers
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dSpaceLN = SGUtilityText.getDoublePropertyFromLine( line, SGFigure.PF_SPACE_AXIS_LINE_AND_NUMBER );
		if( dSpaceLN == null )
		{
			return null;
		}
		float spaceLN = dSpaceLN.floatValue()/unit;
//System.out.println(spaceLN);


		// numbers and title
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dSpaceNT = SGUtilityText.getDoublePropertyFromLine( line, SGFigure.PF_SPACE_NUMBER_AND_TITLE );
		if( dSpaceNT == null )
		{
			return null;
		}
		float spaceNT = dSpaceNT.floatValue()/unit;
//System.out.println(spaceNT);


		p.spaceLineAndNumber = spaceLN;
		p.spaceNumberAndTitle = spaceNT;



		//
		// BackgroundColor
		//
		
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Color bgColor = SGUtilityText.getColorPropertyFromLine( line, SGFigure.PF_BACKGROUND_COLOR );
		if( bgColor == null )
		{
			return null;
		}

		p.bgColor = bgColor;
//System.out.println(bgColor);



		//
		// Transparency
		//
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Boolean bTransparency = SGUtilityText.getBooleanPropertyFromLine( line, SGFigure.PF_TRANSPARENCY );
		if( bTransparency == null )
		{
			return null;
		}
		boolean transparency = bTransparency.booleanValue();

		p.transparent = transparency;



		//
		// Legend Visible
		//
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Boolean bLegendVisible = SGUtilityText.getBooleanPropertyFromLine( line, SGFigure.PF_LEGEND_VISIBLE );
		if( bLegendVisible == null )
		{
			return null;
		}
		boolean legendVisible = bLegendVisible.booleanValue();

		p.legendVisible = legendVisible;
//System.out.println("read:"+legendVisible);


		return p;

	}



	/**
	 * 
	 */
	public static final int MINIMAL_LENGTH_ORDER = -1;


	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof FigureProperties ) == false ) return false;

		FigureProperties fp = (FigureProperties)p;

		// if the difference of the coordinate or size is larger than the minimal length,
		// set the property
		final float diffX = Math.abs( this.mGraphAreaX - fp.x )*SGConstants.CM_POINT_RATIO;
		final float diffY = Math.abs( this.mGraphAreaY - fp.y )*SGConstants.CM_POINT_RATIO;
		final float diffW = Math.abs( this.mGraphAreaWidth - fp.width )*SGConstants.CM_POINT_RATIO;
		final float diffH = Math.abs( this.mGraphAreaHeight - fp.height )*SGConstants.CM_POINT_RATIO;
		final float eps = (float)SGUtilityNumber.getPowersOfTen(MINIMAL_LENGTH_ORDER);
		if( diffX > eps )
		{
			this.mGraphAreaX = fp.x;
		}
		if( diffY > eps )
		{
			this.mGraphAreaY = fp.y;
		}
		if( diffW > eps )
		{
			this.mGraphAreaWidth = fp.width;
		}
		if( diffH > eps )
		{
			this.mGraphAreaHeight = fp.height;
		}

//		this.mSpaceAxisLineAndNumber = fp.spaceLineAndNumber;
//		this.mSpaceNumberAndTitle = fp.spaceNumberAndTitle;

this.setSpaceAxisLineAndNumber( fp.spaceLineAndNumber*this.mMagnification );
this.setSpaceNumberAndTitle( fp.spaceNumberAndTitle*this.mMagnification );

		this.setBackgroundColor(fp.bgColor);
		this.setTransparent(fp.transparent);
		this.setLegendVisible(fp.legendVisible);

		return true;
	}



	/**
	 * 
	 */
	public static class FigureProperties extends SGProperties
	{
		float x;
		float y;
		float width;
		float height;
		float spaceLineAndNumber;
		float spaceNumberAndTitle;
		Color bgColor;
		boolean transparent;
		boolean legendVisible;

		public FigureProperties()
		{
			super();
		}

		public String toString()
		{
			String str = new String("[");
			str += new String("x="+x+", ");
			str += new String("y="+y+", ");
			str += new String("width="+width+", ");
			str += new String("height="+height+", ");
			str += new String("spaceLineAndNumber="+spaceLineAndNumber+", ");
			str += new String("spaceNumberAndTitle="+spaceNumberAndTitle+", ");
			str += new String("background color="+bgColor+", ");
			str += new String("transparent="+transparent+", ");
			str += new String("legend visible="+legendVisible+", ");
			str += new String("]");

			return str;
		}

		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof FigureProperties ) == false )
			{
				return false;
			}

			FigureProperties p = (FigureProperties)obj;

			if( p.x!=this.x ) return false;
			if( p.y!=this.y ) return false;
			if( p.width!=this.width ) return false;
			if( p.height!=this.height ) return false;
			if( p.spaceLineAndNumber!=this.spaceLineAndNumber ) return false;
			if( p.spaceNumberAndTitle!=this.spaceNumberAndTitle ) return false;
			if( p.bgColor.equals(this.bgColor) == false) return false;
			if( p.transparent!=this.transparent ) return false;
			if( p.legendVisible!=this.legendVisible ) return false;

			return true;

		}


	}



	/**
	 *
	 */
	public boolean createDataObjectFromPropertyFile(
		final BufferedReader br, final SGData data )
		throws IOException, ClassNotFoundException,
			InstantiationException, IllegalAccessException
	{

//System.out.println();
//System.out.println("<< createDataObjectFromPropertyFile >>");
//System.out.println(data);
//System.out.println();

		// f[^Xgɒǉ
		this.mDataList.add( data );


		// SGIFigureElementɃf[^BufferedReadern
		// f[^ɑΉIuWFNg쐬
		boolean fFlag;
		fFlag = this.mGraphElement.createDataObject( br, data );
		if( !fFlag )
		{
			return false;
		}
//System.out.println("graph");

		fFlag = this.mLegendElement.createDataObject( br, data );
		if( !fFlag )
		{
			return false;
		}
//System.out.println("legend");

		fFlag = this.mStringElement.createDataObject( br, data );
		if( !fFlag )
		{
			return false;
		}
//System.out.println("string");

		fFlag = this.mAxisElement.createDataObject( br, data );
		if( !fFlag )
		{
			return false;
		}
//System.out.println("axis");

		return true;

	}



}
