
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * `vf̃O[v̊{NX
 * `vf(SGDrawingElement)̃Xg
 */
public abstract class SGElementGroup
{

	/**
	 * `vf(SGDrawingElement)̔z
	 */
	protected SGDrawingElement[] mDrawingElementArray = null;



	/**
	 * ElementGroupSetւ̎Q
	 */
	protected SGElementGroupSet mGroupSet = null;



	/**
	 * 
	 */
	protected float mMagnification = 1.0f;



	/**
	 * 
	 */
	protected ArrayList mColorList = new ArrayList();


	/**
	 * 
	 */
	protected boolean mEnteredFlag = false;


	/**
	 * 
	 */
	protected boolean mSelectedFlag = false;


	/**
	 * 
	 */
	protected boolean mVisibleFlag = true;



	/**
	 *
	 */
	public static final int POLYLINE_GROUP = 0;


	/**
	 *
	 */
	public static final int SYMBOL_GROUP = 1;


	/**
	 *
	 */
	public static final int RECTANGLE_GROUP = 2;


	/**
	 *
	 */
	public static final int ARROW_GROUP = 3;



	/**
	 * 
	 */
	public static final String KEY_VISIBLE = "Visible";


	public static final String KEY_COLOR_LIST = "Colors";



	/**
	 * 
	 * @return
	 */
	public SGElementGroup()
	{
	}



	/**
	 * 
	 * @return
	 */
	protected boolean initDrawingElement( final int num )
	{
		return true;
	}


	/**
	 * 
	 * @return
	 */
	protected boolean initDrawingElement( final SGTuple2f[] array )
	{
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean setPropertiesOfDrawingElements()
	{
		return true;
	}


	/**
	 * 
	 */
	protected boolean setDialogProperty()
	{
		return true;
	}



	/**
	 * 
	 */
	public boolean setMagnification( final float ratio )
	{
		if( ratio < 0.0 )
		{
			throw new IllegalArgumentException("ratio < 0.0");
		}
		mMagnification = ratio;
		
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				this.mDrawingElementArray[ii].setMagnification(ratio);
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean addColor( final Color color )
	{
		if( color==null )
		{
			throw new IllegalArgumentException("color==null");
		}
		mColorList.add(color);

		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				this.mDrawingElementArray[ii].addColor( color );
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		if( color==null )
		{
			throw new IllegalArgumentException("color==null");
		}

		mColorList.clear();
		mColorList.add(color);
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				this.mDrawingElementArray[ii].setColor( color );
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setColorList( final ArrayList colorList )
	{
		if( colorList==null )
		{
			throw new IllegalArgumentException("colorList==null");
		}
		if( colorList.size()==0 )
		{
			throw new IllegalArgumentException("colorList.size()==0");
		}

		mColorList = new ArrayList(colorList);
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				this.mDrawingElementArray[ii].setColorList( colorList );
			}
		}
		
		return true;
	}


	/**
	 * 
	 */
	public Color getColor( final int index )
	{
		if( mColorList == null )
		{
			return null;
		}

		if( index >= mColorList.size() )
		{
			new ArrayIndexOutOfBoundsException("index >= mColorList.size()");
		}

		return (Color)mColorList.get(index);
	}


	/**
	 * 
	 */
	public ArrayList getColorList()
	{
		return mColorList;
	}



	/**
	 * 
	 */
	public boolean zoom( float ratio )
	{
		this.mMagnification = ratio;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				this.mDrawingElementArray[ii].zoom(ratio);
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public void setVisible( final boolean flag )
	{
		this.mVisibleFlag = flag;
	}


	/**
	 * 
	 */
	public boolean isVisible()
	{
		return this.mVisibleFlag;
	}


	/**
	 * 
	 * @param b
	 */
	public void setSelected( final boolean b )
	{
		this.mSelectedFlag = b;
	}


	/**
	 * 
	 * @return
	 */
	public boolean isSelected()
	{
		return this.mSelectedFlag;
	}


	/**
	 * 
	 */
	public boolean contains( final int x, final int y )
	{
//System.out.println("<< SGElementGroup::contains >>");
//System.out.println(this);
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
//System.out.println("ii="+ii);
				if( this.mDrawingElementArray[ii].isVisible() == false )
				{
					continue;
				}
				if( this.mDrawingElementArray[ii].contains(x,y) )
				{
//System.out.println("return true");
					return true;
				}
			}
		}
		return false;
	}



	/**
	 * 
	 */
	public abstract boolean paintElement( final Graphics2D g2d );


	/**
	 * 
	 */
	public abstract SGDrawingElement getDrawingElement();


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		this.setVisible( element.isVisible() );
		this.setColorList( element.getColorList() );

		return true;
	}



	/**
	 * 
	 */
	public abstract boolean writePropertyOfData( final Writer writer ) throws IOException;



	/**
	 * 
	 */
	public boolean readProperty( final BufferedReader br ) throws IOException
	{
		SGProperties p = this.readProperties( br );
		if( this.setProperties(p) == false ) return false;
		return true;
	}


	/**
	 * 
	 */
	public abstract SGProperties readProperties( final BufferedReader br ) throws IOException;


	/**
	 * 
	 */
	public boolean setPropertyWithDialog()
	{
		if( this.setProperties( this.getPropertiesFromDialog() ) == false ) return false;

		return true;

	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		ElementGroupProperties p = new ElementGroupProperties();
		this.getProperties(p);

		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof ElementGroupProperties ) == false ) return false;

		ElementGroupProperties ep = (ElementGroupProperties)p;

		ep.setVisible( this.isVisible() );
		ep.setColorList( new ArrayList( this.mColorList ) );

		return true;
	}


	/**
	 * 
	 */
	protected ElementGroupProperties getPropertiesFromDialog()
	{
		return null;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{

		if( ( p instanceof ElementGroupProperties ) == false ) return false;

		ElementGroupProperties ep = (ElementGroupProperties)p;

		final Boolean b = ep.isVisible();
		if( b==null )
		{
			return false;
		}

		final ArrayList cList = ep.getColorList();
		if( cList==null )
		{
			return false;
		}

		this.setVisible( b.booleanValue() );
		this.setColorList( cList );

		return true;		
	}


	/**
	 * 
	 */
	public static class ElementGroupProperties extends SGProperties
	{
//		boolean visible;
//		ArrayList colorList = new ArrayList();

		public static final String[] keys = {
			KEY_VISIBLE, KEY_COLOR_LIST
		};


		/**
		 * 
		 */
		public ElementGroupProperties()
		{
			super();
		}

		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof ElementGroupProperties ) == false )
			{
				return false;
			}

			ElementGroupProperties p = (ElementGroupProperties)obj;
			
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}


		public Boolean isVisible()
		{
			final String value = this.getProperty(KEY_VISIBLE);
			return SGUtilityText.getBoolean(value);
		}

		public ArrayList getColorList()
		{
			final String value = this.getProperty(KEY_COLOR_LIST);
			return SGUtilityText.getColorList(value);
		}

		public boolean setVisible( final boolean b )
		{
			this.setProperty( KEY_VISIBLE, new Boolean(b).toString() );
			return true;
		}

		public boolean setColorList( final ArrayList list )
		{
			if( list==null )
			{
				return false;
			}

			String str = SGUtilityText.getColorListString( list );
			if( str==null )
			{
				return false;
			}
			this.setProperty( KEY_COLOR_LIST, str );
			return true;
		}


	}



}

