/*
 * SGAboutDialog.java
 *
 * Created on 2004/09/14, 11:04
 */

package jp.riken.brain.ni.samuraigraph.base;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


/**
 *
 * @author  kuromaru
 */
public class SGAboutDialog extends JDialog
	implements ActionListener, HyperlinkListener
{

   	/**
	 * 
	 *
	 */
	public SGAboutDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


	/**
	 * 
	 * @param owner
	 * @param modal
	 */
	public SGAboutDialog( Frame owner, boolean modal )
	{
		super( owner, modal );
		initComponents();
		this.initProperty();
	}


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mImagePanel = new jp.riken.brain.ni.samuraigraph.base.SGImagePanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mMiddleSpaceLabel = new javax.swing.JLabel();
        mTopSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mBottomSpaceLabel = new javax.swing.JLabel();
        mMiddleSpaceLabel2 = new javax.swing.JLabel();
        mEditorPane = new javax.swing.JEditorPane();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mImagePanel.setPreferredSize(new java.awt.Dimension(50, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mImagePanel, gridBagConstraints);

        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mLeftSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mLeftSpaceLabel, gridBagConstraints);

        mMiddleSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mMiddleSpaceLabel, gridBagConstraints);

        mTopSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        getContentPane().add(mTopSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mRightSpaceLabel, gridBagConstraints);

        mBottomSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        getContentPane().add(mBottomSpaceLabel, gridBagConstraints);

        mMiddleSpaceLabel2.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        getContentPane().add(mMiddleSpaceLabel2, gridBagConstraints);

        mEditorPane.setEditable(false);
        mEditorPane.setPreferredSize(new java.awt.Dimension(300, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mEditorPane, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mBottomSpaceLabel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JEditorPane mEditorPane;
    private jp.riken.brain.ni.samuraigraph.base.SGImagePanel mImagePanel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mMiddleSpaceLabel;
    private javax.swing.JLabel mMiddleSpaceLabel2;
    private javax.swing.JButton mOKButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mTopSpaceLabel;
    // ϐ錾̏I//GEN-END:variables


	/**
	 * Title of this dialog.
	 */
	public static final String TITLE = "About Samurai Graph";


	/**
	 * 
	 */
	private boolean initProperty()
	{
		this.setTitle(TITLE);
		this.setVisible(false);
		this.setResizable(false);
		this.mEditorPane.setBackground( this.getContentPane().getBackground() );

		//
		this.mOKButton.addActionListener(this);

		//
		this.mEditorPane.addHyperlinkListener(this);


		// set the image and the text
		Class inClass = getClass();
		String name = null;
		URL url = null;

		name = SGConstants.RESOURCES_DIRNAME+"Samurai.gif";
		url = inClass.getResource(name);
		Image image = Toolkit.getDefaultToolkit().getImage( url );
		this.mImagePanel.setImage( image );

		name = SGConstants.RESOURCES_DIRNAME+"About.html";
		url = inClass.getResource(name);
		try
		{
			this.mEditorPane.setPage( url );
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
		}


		return true;

	}



	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{
		Object source = e.getSource();
		if( source.equals( this.mOKButton ) )
		{
			this.hide();
		}
	}



	/**
	 * 
	 */
	public void hyperlinkUpdate( HyperlinkEvent e )
	{
//System.out.println("hyperlinkUpdate");

		if( e.getEventType().equals( HyperlinkEvent.EventType.ACTIVATED ) )
		{
			String url = e.getURL().toString();
//System.out.println(url);
			try
			{
				SGBrowserLauncher.openURL( url );
			}
			catch( IOException ex )
			{
				ex.printStackTrace();
			}
		}

	}


}

