
package jp.riken.brain.ni.samuraigraph.base;

/**
 * A generic 2 element tuple that is represented by double precision floating point x,y coordinates.
 */

public class SGTuple2d
{
	/**
	 * The x coordinate.
	 */
	public double x;

	/**
	 * The y coordinate.
	 */
	public double y;


	/**
	 * 
	 */
	public SGTuple2d(){}


	/**
	 * Constructs and initializes a SGTuple2d from the specified xy coordinates.
	 * @param x the x coordinate
	 * @param y the y coordinate
	 */
	public SGTuple2d( final double x, final double y )
	{
		this.x = x;
		this.y = y;
	}


	/**
	 * 
	 */
	public SGTuple2d( final SGTuple2d tuple )
	{
		x = tuple.x;
		y = tuple.y;
	}


	/**
	 * 
	 */
	public void setValues( final double x, final double y )
	{
		this.x = x;
		this.y = y;
	}


	/**
	 * 
	 */
	public String toString()
	{
		final String str = new String("("+x+","+y+")");
		return str;
	}


	/**
	 * 
	 *
	 */
	public void clear()
	{
		this.x = 0.0;
		this.y = 0.0;
	}

}
