/*
 * 쐬: 2004/05/08
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import javax.swing.*;


/**
 * @author LANDAU
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class SGUtility
{


	/**
	 * 
	 */
	public static String[] getAvailableFontFamilyNames()
	{
		final String fontArray[]
			= GraphicsEnvironment.getLocalGraphicsEnvironment().
			  getAvailableFontFamilyNames();

		return fontArray;
	}


	/**
	 * Get the canonical path.
	 */
	public static String getCanonicalPath( final String str )
	{

		File file = new File( str );
//		if( file.canRead() == false )
//		{
//			return null;
//		}

		try
		{
			FileInputStream fis = null;
			try
			{
				fis = new FileInputStream( str );
			}
			catch( FileNotFoundException ex )
			{
				System.out.println("t@C̓ǂݍ݂Ɏs܂B");
				return null;
			}

			fis.close();
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
			return null;
		}


		String pathName = null;
		try
		{
			pathName = file.getCanonicalPath();
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
			return null;
		}

		return pathName;

	}



	/**
	 * 
	 */
	public static Rectangle2D createUnion(
		final ArrayList rectList )
	{

		if( rectList==null )
		{
			throw new IllegalArgumentException("rectList==null");
		}

		Rectangle2D rectAll = null;
		for( int ii=0; ii<rectList.size(); ii++ )
		{
			Rectangle2D rect = (Rectangle2D)rectList.get(ii);
			if( rect==null )
			{
				throw new IllegalArgumentException("rect==null");
			}

			if( rectAll == null )
			{
				rectAll = rect;
				continue;
			}

			rectAll = rect.createUnion(rectAll);
		}

		return rectAll;		
	}



	/**
	 * 
	 * @param rect
	 * @param direction
	 * @return
	 */
	public static double getRectStart(
		final Rectangle2D rect,
		final boolean direction )
	{
		if( direction )
		{
			return rect.getX();
		}
		else
		{
			return rect.getY();
		}
	}



	/**
	 * 
	 * @param rect
	 * @param direction
	 * @return
	 */
	public static double getRectSize(
		final Rectangle2D rect,
		final boolean direction )
	{
		if( direction )
		{
			return rect.getWidth();
		}
		else
		{
			return rect.getHeight();
		}
	}



	/**
	 * 
	 * @param rect
	 * @param direction
	 * @return
	 */
	public static double getRectEnd(
		final Rectangle2D rect,
		final boolean direction )
	{
		return getRectStart(rect,direction) + getRectSize(rect,direction);
	}



	/**
	 * 
	 * @param rect
	 * @param value
	 * @param direction
	 * @return
	 */
	public static boolean setRectStart(
		final Rectangle2D rect,
		final double value,
		final boolean direction )
	{

		if( direction )
		{
			rect.setRect(
				value,
				rect.getY(),
				rect.getWidth(),
				rect.getHeight()
			);
		}
		else
		{
			rect.setRect(
				rect.getX(),
				value,
				rect.getWidth(),
				rect.getHeight()
			);
		}

		return true;
	}



	/**
	 * 
	 * @param rect
	 * @param value
	 * @param direction
	 * @return
	 */
	public static boolean setRectEnd(
		final Rectangle2D rect,
		final double value,
		final boolean direction )
	{

		if( direction )
		{
			rect.setRect(
				value - rect.getWidth(),
				rect.getY(),
				rect.getWidth(),
				rect.getHeight()
			);
		}
		else
		{
			rect.setRect(
				rect.getX(),
				value - rect.getHeight(),
				rect.getWidth(),
				rect.getHeight()
			);
		}

		return true;
	}



	/**
	 * 
	 * @param rect
	 * @param value
	 * @param direction
	 * @return
	 */
	public static boolean setRectSize(
		final Rectangle2D rect,
		final double value,
		final boolean direction )
	{

		if( direction )
		{
			rect.setRect(
				rect.getX(),
				rect.getY(),
				value,
				rect.getHeight()
			);
		}
		else
		{
			rect.setRect(
				rect.getX(),
				rect.getY(),
				rect.getWidth(),
				value
			);
		}

		return true;
	}



	/**
	 * 
	 * @param rect
	 * @param value
	 * @param direction
	 * @return
	 */
	public static boolean isRectContains(
		final Rectangle2D rect,
		final double value,
		final boolean direction )
	{
		return SGUtilityNumber.contains(
			getRectStart(rect,direction), getRectEnd(rect,direction), value );
	}



	/**
	 * 
	 * @param rect1
	 * @param rect2
	 * @param direction
	 * @return
	 */
	public static boolean isRectContains(
		final Rectangle2D rect1,
		final Rectangle2D rect2,
		final boolean direction )
	{
		return SGUtilityNumber.contains(
			getRectStart(rect1,direction), getRectEnd(rect1,direction),
			getRectStart(rect2,direction), getRectEnd(rect2,direction) );
	}



	/**
	 * 
	 * @param rect1
	 * @param rect2
	 * @param direction
	 * @return
	 */
	public static double getOverlapping(
		final Rectangle2D rect1,
		final Rectangle2D rect2,
		final boolean direction )
	{
		return SGUtilityNumber.getOverlap(
			getRectStart(rect1,direction), getRectEnd(rect1,direction),
			getRectStart(rect2,direction), getRectEnd(rect2,direction) );
	}



	/**
	 * 
	 */
	public static boolean showMessageDialog( Component parentComponent, Object message, String title, int messageType )
	{
		JOptionPane.showMessageDialog(
			parentComponent, message, title, messageType
		);
		return true;
	}



	/**
	 * 
	 * @param parentComponent
	 * @return
	 */
	public static boolean showIllegalInputErrorMessageDialog( Component parentComponent )
	{
		Toolkit.getDefaultToolkit().beep();
		SGUtility.showMessageDialog(
			parentComponent,
			"sȓ͂łB",
			"Illegal input", 
			JOptionPane.ERROR_MESSAGE );
		return true;
	}



	/**
	 * 
	 * @param parentComponent
	 * @return
	 */
	public static boolean showFileNotFoundMessageDialog( Component parentComponent )
	{
		SGUtility.showMessageDialog(
			parentComponent,
			"Failed to open the file denoted by a specified pathname.",
			"File not found", 
			JOptionPane.PLAIN_MESSAGE );
		return true;
	}



public static boolean showNotImplementedMessageDialog( Component parentComponent )
{
	SGUtility.showMessageDialog(
		parentComponent,
		"Sorry, not yet implemented.",
		"Not yet implemented", 
		JOptionPane.PLAIN_MESSAGE );
	return true;
}






}
