/*
 * 쐬: 2004/09/25
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 * 
 * @author LANDAU
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public abstract class SGAxisBreakingSymbol extends SGDrawingElement
{

	public static final String KEY_TITLE = "[Axis Break]";
	public static final String KEY_X = "X";
	public static final String KEY_Y = "Y";
	public static final String KEY_LENGTH = "Length";
	public static final String KEY_INTERVAL = "Interval";
	public static final String KEY_DISTORTION = "Distortion";
	public static final String KEY_ANGLE = "Angle";
	public static final String KEY_HORIZONTAL = "Horizontal";
	public static final String KEY_LINE_WIDTH = "Line Width";
	public static final String KEY_INNER_COLOR = "Inner Color";
	public static final String KEY_LINE_COLOR = "Line Color";



	/**
	 * 
	 */
	protected SGTuple2f mLocation = new SGTuple2f();


	/**
	 * 
	 */
	protected float mLength;


	/**
	 * 
	 */
	protected float mInterval;


	/**
	 * 
	 */
	protected float mLineWidth;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * Value in the range [-1,1]
	 */
	protected float mDistortion;


	/**
	 * 
	 */	
	protected Color mLineColor;


	/**
	 * 
	 */
	protected boolean mForHorizontalAxisFlag;


	/**
	 * 
	 *
	 */
	public SGAxisBreakingSymbol()
	{
		super();
	}


	/**
	 * 
	 */
	protected SGAxisBreakingSymbol(
		final float length,
		final float interval,
		final float dist,
		final float angle,
		final boolean horizontal )
	{
		this.setLength(length);
		this.setInterval(interval);
		this.setDistortion(dist);
		this.setAngle(angle);
		this.setForHorizontalAxisFlag(horizontal);
	}


	/**
	 * 
	 * @return
	 */
	public SGTuple2f getLocation()
	{
		return this.mLocation;
	}


	/**
	 *
	 */
	public float getX()
	{
		return this.getLocation().x;
	}


	/**
	 *
	 */
	public float getY()
	{
		return this.getLocation().y;
	}


	/**
	 * 
	 * @return
	 */
	public float getLength()
	{
		return this.mLength*this.mMagnification;
	}


	/**
	 * 
	 * @return
	 */
	public float getInterval()
	{
		return this.mInterval*this.mMagnification;
	}


	/**
	 * 
	 * @return
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 * @return
	 */
	public float getAngle()
	{
		return this.mAngle;
	}


	/**
	 * 
	 * @return
	 */
	public float getDistortion()
	{
		return this.mDistortion;
	}


	/**
	 * 
	 * @return
	 */
	public Color getLineColor()
	{
		return this.mLineColor;
	}


	/**
	 * 
	 * @return
	 */
	public boolean isForHorizontalAxis()
	{
		return this.mForHorizontalAxisFlag;
	}



	/**
	 * 
	 * @param x
	 * @param y
	 */
	public void setLocation( final float x, final float y )
	{
		this.mLocation.setValues(x,y);
	}


	/**
	 * 
	 * @param pos
	 */
	public void setLocation( final SGTuple2f pos )
	{
		this.mLocation = pos;
	}



	/**
	 * 
	 * @param length
	 * @param interval
	 * @param dist
	 * @param angle
	 * @param horizontal
	 */
	public void setForm(
		final float length,
		final float interval,
		final float dist,
		final float angle,
		final boolean horizontal )
	{
		this.setLength( length );
		this.setInterval( interval );
		this.setDistortion( dist );
		this.setAngle( angle );
		this.setForHorizontalAxisFlag( horizontal );
	}



	/**
	 * 
	 * @param value
	 */
	public void setLength( final float value )
	{
		if( value<0.0f )
		{
			new IllegalArgumentException("value<0.0f");
		}
		this.mLength = value/this.mMagnification;
	}


	/**
	 * 
	 * @param value
	 */
	public void setInterval( final float value )
	{
		if( value<0.0f )
		{
			new IllegalArgumentException("value<0.0f");
		}
		this.mInterval = value/this.mMagnification;
	}


	/**
	 * 
	 * @param value
	 */
	public void setLineWidth( final float value )
	{
		if( value<0.0f )
		{
			new IllegalArgumentException("value<0.0f");
		}
		this.mLineWidth = value;
	}


	/**
	 * 
	 */
	public static final float ANGLE_ABS_MAX = (float)(Math.PI*(1.0/3.0));



	/**
	 * 
	 * @param angle
	 */
	public void setAngle( final float angle )
	{
		float a = angle;
		if( a<-ANGLE_ABS_MAX )
		{
			a = - ANGLE_ABS_MAX;
		}
		if( ANGLE_ABS_MAX<a )
		{
			a = ANGLE_ABS_MAX;
		}

		this.mAngle = a;
	}


	/**
	 * 
	 * @param value
	 */	
	public void setDistortion( final float value )
	{
		this.mDistortion = value;
	}


	/**
	 * 
	 * @param color
	 */
	public void setLineColor( final Color color )
	{
		if( color==null )
		{
			new IllegalArgumentException("color==null");
		}
		this.mLineColor = color;
	}


	/**
	 * 
	 * @param flag
	 */
	public void setForHorizontalAxisFlag( final boolean flag )
	{
		this.mForHorizontalAxisFlag = flag;
	}




	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		
		if( ( element instanceof SGAxisBreakingSymbol ) == false ) return false;

		super.setProperty( element );
		
		SGAxisBreakingSymbol abs = (SGAxisBreakingSymbol)element;

		this.setLocation( abs.getX(), abs.getY() );
		this.setLength( abs.getLength() );
		this.setInterval( abs.getInterval() );
		this.setDistortion( abs.getDistortion() );
		this.setAngle( abs.getAngle() );
		this.setForHorizontalAxisFlag( abs.isForHorizontalAxis() );
		this.setLineWidth( abs.getLineWidth() );
		this.setLineColor( abs.getLineColor() );

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
//System.out.println("setProperties");

		if( ( p instanceof AxisBreakSymbolProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		AxisBreakSymbolProperties ap = (AxisBreakSymbolProperties)p;

		final Float x = ap.getX();
		if( x==null )
		{
			return false;
		}
		final Float y = ap.getY();
		if( y==null )
		{
			return false;
		}
		this.mLocation = new SGTuple2f( x.floatValue(), y.floatValue() );


		final Float len = ap.getLength();
		if( len==null )
		{
			return false;
		}
		this.mLength = len.floatValue();
		
		
		final Float interval = ap.getInterval();
		if( interval==null )
		{
			return false;
		}
		this.mInterval = interval.floatValue();
		
		
		final Float dist = ap.getDistortion();
		if( dist==null )
		{
			return false;
		}
		this.mDistortion = dist.floatValue();


		final Float angle = ap.getAngle();
		if( angle==null )
		{
			return false;
		}
		this.mAngle = angle.floatValue();


		final Boolean horizontal = ap.isHorizontal();
		if( horizontal==null )
		{
			return false;
		}
		this.mForHorizontalAxisFlag = horizontal.booleanValue();


		final Float lw = ap.getLineWidth();
		if( lw==null )
		{
			return false;
		}
		this.mLineWidth = lw.floatValue();
		
		
		final Color lc = ap.getLineColor();
		if( lc==null )
		{
			return false;
		}
		this.mLineColor = lc;


		return true;

	}



	/**
	 * 
	 * @return
	 */
	public SGProperties getProperties()
	{
		final AxisBreakSymbolProperties p = new AxisBreakSymbolProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}


	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( final SGProperties p )
	{
		if( ( p instanceof AxisBreakSymbolProperties ) == false )
		{
			return false;
		}

		if( super.getProperties(p) == false )
		{
			return false;
		}

		final AxisBreakSymbolProperties dp = (AxisBreakSymbolProperties)p;
		dp.setX( this.mLocation.x );
		dp.setY( this.mLocation.y );
		dp.setLength( this.mLength );
		dp.setInterval( this.mInterval );
		dp.setDistortion( this.mDistortion );
		dp.setAngle( this.mAngle );
		dp.setHorizontal( this.mForHorizontalAxisFlag );
		dp.setLineWidth( this.mLineWidth );
		dp.setLineColor( this.mLineColor );

		return true;
	}




	/**
	 * Property of Axis Break Symbol.
	 */
	public static class AxisBreakSymbolProperties extends SGDrawingElement.DrawingElementProperties
	{

		public static final String[] keys = {
			KEY_X, KEY_Y,
			KEY_LENGTH, KEY_INTERVAL, KEY_DISTORTION,
			KEY_ANGLE, KEY_LINE_WIDTH, KEY_LINE_COLOR
		};


		/**
		 * 
		 */
		public AxisBreakSymbolProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof AxisBreakSymbolProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;


			AxisBreakSymbolProperties p = (AxisBreakSymbolProperties)obj;

			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}


		public Float getX()
		{
			final String value = this.getProperty(KEY_X);
			return SGUtilityText.getFloat(value);
		}

		public Float getY()
		{
			final String value = this.getProperty(KEY_Y);
			return SGUtilityText.getFloat(value);
		}

		public Float getLength()
		{
			final String value = this.getProperty(KEY_LENGTH);
			return SGUtilityText.getFloat(value);
		}

		public Float getInterval()
		{
			final String value = this.getProperty(KEY_INTERVAL);
			return SGUtilityText.getFloat(value);
		}

		public Float getDistortion()
		{
			final String value = this.getProperty(KEY_DISTORTION);
			return SGUtilityText.getFloat(value);
		}

		public Float getAngle()
		{
			final String value = this.getProperty(KEY_ANGLE);
			return SGUtilityText.getFloat(value);
		}

		public Boolean isHorizontal()
		{
			final String value = this.getProperty(KEY_HORIZONTAL);
			return SGUtilityText.getBoolean(value);
		}

		public Float getLineWidth()
		{
			final String value = this.getProperty(KEY_LINE_WIDTH);
			return SGUtilityText.getFloat(value);
		}

		public Color getLineColor()
		{
			final String value = this.getProperty(KEY_LINE_COLOR);
			return SGUtilityText.getColorFromString(value);
		}


		public boolean setX( final float x )
		{
			this.setProperty( KEY_X, new Float(x).toString() );
			return true;
		}

		public boolean setY( final float y )
		{
			this.setProperty( KEY_Y, new Float(y).toString() );
			return true;
		}

		public boolean setLength( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.setProperty( KEY_LENGTH, new Float(value).toString() );
			return true;
		}

		public boolean setInterval( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.setProperty( KEY_INTERVAL, new Float(value).toString() );
			return true;
		}

		public boolean setDistortion( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.setProperty( KEY_DISTORTION, new Float(value).toString() );
			return true;
		}

		public boolean setAngle( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.setProperty( KEY_ANGLE, new Float(value).toString() );
			return true;
		}

		public boolean setHorizontal( final boolean b )
		{
			this.setProperty( KEY_HORIZONTAL, new Boolean(b).toString() );
			return true;
		}

		public boolean setLineWidth( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.setProperty( KEY_LINE_WIDTH, new Float(value).toString() );
			return true;
		}

		public boolean setLineColor( final Color cl )
		{
			if( cl==null )
			{
				new IllegalArgumentException("cl==null");
			}
			String str = SGUtilityText.getColorString(cl);
			if( str==null )
			{
				new IllegalArgumentException("str==null");
			}
			this.setProperty( KEY_LINE_COLOR, str );
			return true;
		}

	}



}
