/*
 * Created on 2004/08/06
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGElementGroupTickLabel extends SGElementGroupString
{


	/**
	 * 
	 */
	public static final float ANGLE_HORIZONTAL = 0.0f;


	/**
	 * 
	 */
	public static final float ANGLE_INCLINED = (float)Math.PI/6.0f;


	/**
	 * 
	 */
	public static final String HORIZONTAL = "Horizontal";


	/**
	 * 
	 */
	public static final String INCLINED = "Inclined";



	/**
	 * 
	 */
	public static final String PF_TICK_LABEL_TITLE = "<Tick Labels>";



	/**
	 * 
	 *
	 */
	public SGElementGroupTickLabel()
	{
		super();
	}



	/**
	 * 
	 */
	public static Float getTickLabelAngleFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}

		Float angle = null;
		if( name.equals( SGElementGroupTickLabel.HORIZONTAL ) )
		{
			angle = new Float( SGElementGroupTickLabel.ANGLE_HORIZONTAL );
		}
		else if( name.equals( SGElementGroupTickLabel.INCLINED ) )
		{
			angle = new Float( SGElementGroupTickLabel.ANGLE_INCLINED );
		}
		
		return angle;
	}



	/**
	 * 
	 */
	public static String getTickLabelAngleName( final double angle )
	{
		String name = null;

		// angle
		if( angle == SGElementGroupTickLabel.ANGLE_HORIZONTAL )
		{
			name = SGElementGroupTickLabel.HORIZONTAL;
		}
		else if( angle == SGElementGroupTickLabel.ANGLE_INCLINED )
		{
			name = SGElementGroupTickLabel.INCLINED;
		}
		else
		{
			throw new Error();
		}

		return name;
	}



	/**
	 * 
	 */
	public boolean writePropertyOfData( final Writer writer ) throws IOException
	{

		writer.write( PF_TICK_LABEL_TITLE + "\n" );

		SGUtilityText.writePropertyLine( writer, KEY_VISIBLE, new Boolean( this.mVisibleFlag ) );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_SIZE, new Float( this.mFontSize ) );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_FAMILY_NAME, this.mFontFamilyName );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_STYLE, SGUtilityText.getFontStyleName( this.mFontStyle ) );
		SGUtilityText.writeColorListPropertyLine( writer, KEY_COLOR_LIST, this.mColorList );

		String strAngle = getTickLabelAngleName( this.mAngle );
		SGUtilityText.writePropertyLine( writer, KEY_STRING_ANGLE, strAngle );

		writer.write("\n");


		return false;
	}



	/**
	 * 
	 */
	public SGProperties readProperties( final BufferedReader br ) throws IOException
	{

		StringProperties p = new StringProperties();


		String line = null;


		// visible
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Boolean bVisible = SGUtilityText.getBooleanPropertyFromLine(line,KEY_VISIBLE);
		if( bVisible == null )
		{
			return null;
		}
		p.setVisible( bVisible.booleanValue() );


		// set font size
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Double dFontSize = SGUtilityText.getDoublePropertyFromLine(line,KEY_FONT_SIZE);
		if( dFontSize == null )
		{
			return null;
		}
		p.setFontSize( dFontSize.floatValue() );


		// set font family name
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		String name = SGUtilityText.getPropertyFromLine(line,KEY_FONT_FAMILY_NAME);
		if( name == null )
		{
			return null;
		}
		p.setFontFamilyName( name );


		// set font style
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		Integer nFontStyle = SGUtilityText.getFontStyleFromLine(line,KEY_FONT_STYLE);
		if( nFontStyle == null )
		{
			return null;
		}
		p.setFontStyle( nFontStyle.intValue() );


		// color
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		ArrayList colorList = SGUtilityText.getColorListFromLine(line,KEY_COLOR_LIST);
		if( colorList == null )
		{
			return null;
		}
		p.setColorList( colorList );


		// angle
		if( ( line = SGUtilityText.readLine(br) ) == null )
		{
			return null;
		}
		String strAngle = SGUtilityText.getPropertyFromLine(line,KEY_STRING_ANGLE);
		if( strAngle == null )
		{
			return null;
		}
		Float angle = getTickLabelAngleFromName(strAngle);
		if( angle == null )
		{
			return null;
		}
		p.setAngle( angle.floatValue() );

		return p;

	}


	/**
	 * 
	 */
	public static class TickLabelProperties extends StringProperties
	{

		public TickLabelProperties()
		{
			super();
		}

	}

}

