/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.constant.Constable;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.riken.brain.ni.samuraigraph.application.SGChangeLogDialog;
import jp.riken.brain.ni.samuraigraph.application.SGFigureIDSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGMultiDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGProgressMonitorDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGScrollPaneDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.application.SGStartupFigurePropertySettingDialog;
import jp.riken.brain.ni.samuraigraph.application.SGStartupUsePropertyDialog;
import jp.riken.brain.ni.samuraigraph.application.SGStartupWelcomeDialog;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeConfirmDialog;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeDialog;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGXYDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SGDrawingServer {
    public static final int MAJOR_VERSION_NUMBER = 0;
    public static final int MINOR_VERSION_NUMBER = 2;
    public static final int MICRO_VERSION_NUMBER = 0;
    public static int PORT_NUMBER = -1;
    public static final String COM_WOPEN = "wopen";
    public static final String COM_ADD_DATE = "addData";
    public static final String COM_READ_PROPERTY = "readProperty";
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGVXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData;

    public static void main(String[] stringArray) {
        SGDrawingServer.interpretCommands(stringArray);
        try {
            if (PORT_NUMBER == -1) {
                Connect connect = new Connect();
            } else {
                ServerSocket serverSocket = new ServerSocket(PORT_NUMBER);
                Connect connect = new Connect(serverSocket);
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(null, "Failed to start up application.", "Error", -1, 2, null, null, null);
        }
    }

    private static void interpretCommands(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-p") || i + 1 >= stringArray.length) continue;
            try {
                Integer n = Integer.valueOf(stringArray[i + 1]);
                if (n == null) continue;
                PORT_NUMBER = n;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Connect
    extends Thread
    implements ActionListener,
    WindowListener,
    DropTargetListener {
        private Class mClassOfAxisElement = null;
        private Class mClassOfSXYGraphElement = null;
        private Class mClassOfVXYGraphElement = null;
        private Class mClassOfLegendElement = null;
        private Class mClassOfStringElement = null;
        public final String PROPERTY_FILE_READ_MSG_DIALOG_TITLE = "Property file has read.";
        public static final String MSG_SUCCESSFUL_COMPLETION = "\u6b63\u5e38\u7d42\u4e86";
        public static final String ERRMSG_PROPERTY_FILE_INCORRECT = "\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u304c\u4e0d\u6b63\u3067\u3059\u3002";
        public static final String ERRMSG_DATA_TYPE_INCORRECT = "\u30c7\u30fc\u30bf\u306e\u30bf\u30a4\u30d7\u304c\u9055\u3044\u307e\u3059\u3002";
        public static final String ERRMSG_DATA_NUMBER_SHORTAGE = "\u30c7\u30fc\u30bf\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
        public static final String ERRMSG_DATA_NUMBER_EXCESS = "\u30c7\u30fc\u30bf\u6570\u304c\u904e\u5270\u3067\u3059\u3002";
        public static final String ERRMSG_FILE_OPEN_FAILURE = "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        private ServerSocket mServerSocket = null;
        private TreeMap mWndMap = new TreeMap();
        private ArrayList mDataList = new ArrayList();
        private ArrayList mDataFileNameList = new ArrayList();
        public static final String PREF_KEY_DATE = "Date";
        public static final String PREF_KEY_UPGRADE_CYCLE = "Upgrade Cycle";
        public static final String PREF_KEY_MAJOR_VERSION_NUMBER = "Major Version";
        public static final String PREF_KEY_MINOR_VERSION_NUMBER = "Minor Version";
        public static final String PREF_KEY_MICRO_VERSION_NUMBER = "Micro Version";
        public static final int NO_UPGRADE = 0;
        public static final int UPGRADE_EVERY_TIME = 1;
        public static final int UPGRADE_EVERY_DAY = 2;
        public static final int UPGRADE_EVERY_WEEK = 3;
        public static final int UPGRADE_EVERY_MONTH = 4;
        public static final int DEFAULT_UPGRADE_CYCLE = 1;
        public static final String URL_OF_PRODUCT_XML = "http://samurai-graph.sourceforge.jp/product.xml";
        private String mDirectoryName = null;
        public static final String DEFAULT_CLASS_NAME_OF_AXIS_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisElement";
        public static final String DEFAULT_CLASS_NAME_OF_SXY_GRAPH_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGSXYGraphElement";
        public static final String DEFAULT_CLASS_NAME_OF_VXY_GRAPH_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGVXYGraphElement";
        public static final String DEFAULT_CLASS_NAME_OF_STRING_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElement";
        public static final String DEFAULT_CLASS_NAME_OF_LEGEND_ELEMENT = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendElement";
        public static final int MAX_WINDOW_ID = 256;
        private SGFigureIDSelectionWizardDialog mFigureIDSelectionWizardDialog = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialog = null;
        private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
        private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialog = null;
        private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialogFromCLorDD = null;
        private SGPropertyFileChooserWizardDialog mPropertyFileChooserWizardDilaog = null;
        private String mTempDataFileType = null;
        private SGUpgradeDialog mUpgradeDialog = null;
        private SGChangeLogDialog mChangeLogDialog = null;
        public static final String TITLE_FILE_CHECK = "\u30d5\u30a1\u30a4\u30eb\u306e\u30c1\u30a7\u30c3\u30af";
        private boolean mCarryOnWizardFlag = true;
        private DropTargetDropEvent mDropTargetDropEvent = null;
        private ArrayList mDroppedFileList = null;
        private ThreadForDropEvent mThread = null;
        private SGStartupWelcomeDialog mStartupWelcomeDialog;
        private SGStartupUsePropertyDialog mStartupUsePropertyDialog;
        private SGPropertyFileChooserWizardDialog mStartupPropertyFileChooserDialog;
        private SGMultiDataFileChooserWizardDialog mStartupMultiDataFileChooserWizardDialog;
        private SGSingleDataFileChooserWizardDialog mStartupSingleDataFileChooserWizardDialog;
        private SGXYDataTypeSelectionWizardDialog mStartupXYDataTypeSelectionDialog;
        private SGStartupFigurePropertySettingDialog mStartupFigurePropertySettingDialog;

        public Connect() {
            this.start();
        }

        public Connect(ServerSocket serverSocket) {
            this.mServerSocket = serverSocket;
            this.start();
        }

        public void run() {
            SGSplashWindow sGSplashWindow = this.createSplashWindow();
            if (sGSplashWindow == null) {
                return;
            }
            sGSplashWindow.setVisible(true);
            try {
                if (!this.setFigureElementClass()) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Failed to create instances of SGFigureElement classes.");
                return;
            }
            SGDrawingWindow sGDrawingWindow = this.createWindow();
            if (sGDrawingWindow == null) {
                JOptionPane.showMessageDialog(null, "Failed to create a window");
                return;
            }
            sGSplashWindow.setVisible(false);
            sGDrawingWindow.setVisible(true);
            this.updatePreferences();
            if (this.checkDate() && !this.upgradeOnStartup(sGDrawingWindow)) {
                return;
            }
            if (this.mServerSocket != null) {
                while (true) {
                    try {
                        while (true) {
                            String string;
                            Socket socket = this.mServerSocket.accept();
                            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            ArrayList<String> arrayList = new ArrayList<String>();
                            while ((string = bufferedReader.readLine()) != null) {
                                arrayList.add(new String(string));
                            }
                            if (arrayList.size() == 0) {
                                System.out.println("\u5165\u529b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                                continue;
                            }
                            String[] stringArray = new String[arrayList.size()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = (String)arrayList.get(i);
                            }
                            if (!this.executeCommand(stringArray)) continue;
                            bufferedReader.close();
                            printWriter.close();
                            socket.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }

        private void printNode(Element element, StringBuffer stringBuffer) {
            this.printNodeRecursively(element, stringBuffer, -1);
        }

        private void printNodeRecursively(Element element, StringBuffer stringBuffer, int n) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    String string = element2.getTagName();
                    if (string.equals("item")) {
                        NodeList nodeList2 = element2.getChildNodes();
                        int n2 = nodeList2.getLength();
                        if (n2 == 1) {
                            this.printFirstChild(element2, stringBuffer, n);
                            continue;
                        }
                        if (n2 <= 1) continue;
                        this.printFirstChild(element2, stringBuffer, n);
                        for (int j = 0; j < n2; ++j) {
                            Node node2 = nodeList2.item(j);
                            if (!(node2 instanceof Element)) continue;
                            Element element3 = (Element)node2;
                            this.printNodeRecursively(element3, stringBuffer, n + 1);
                        }
                        continue;
                    }
                    if (!string.equals("itemize")) continue;
                    this.printNodeRecursively(element2, stringBuffer, n + 1);
                    continue;
                }
                if (!(node instanceof Text)) continue;
                this.printText(node, stringBuffer, n);
            }
        }

        private void printFirstChild(Node node, StringBuffer stringBuffer, int n) {
            Node node2 = node.getFirstChild();
            this.printText(node2, stringBuffer, n);
        }

        private void printText(Node node, StringBuffer stringBuffer, int n) {
            String string = node.toString();
            String string2 = this.tokenize(string);
            if (string2.length() != 0) {
                String string3 = "";
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + "   ";
                }
                String string4 = "";
                if (n == 0) {
                    string4 = "  ";
                }
                if (n > 0) {
                    string4 = "- ";
                }
                string2 = string3 + string4 + string2 + "\n";
                stringBuffer.append(string2);
            }
        }

        private String tokenize(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String string2 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                string2 = string2 + string3;
                if (i == arrayList.size() - 1) continue;
                string2 = string2 + " ";
            }
            return string2;
        }

        private boolean upgradeOnStartup(Window window) {
            return this.upgrade(window, true);
        }

        private boolean upgradeByCommand(Window window) {
            return this.upgrade(window, false);
        }

        private Document createProductDocument() {
            return SGUtilityText.getDocument(URL_OF_PRODUCT_XML);
        }

        private boolean upgrade(Window window, boolean bl) {
            Document document = this.createProductDocument();
            if (document == null) {
                JOptionPane.showMessageDialog(window, "Failed to get information of the latest version.");
                return false;
            }
            Element element = document.getDocumentElement();
            if (this.compareVersion(element)) {
                if (!this.installLatestVersion(element, window, bl)) {
                    return false;
                }
            } else if (!bl) {
                String string = "The latest version is already installed.";
                JOptionPane.showMessageDialog(window, string);
            }
            return true;
        }

        private void updatePreferences() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt(PREF_KEY_UPGRADE_CYCLE, -1);
            if (n == -1) {
                preferences.putInt(PREF_KEY_UPGRADE_CYCLE, 1);
            }
            String string = preferences.get(PREF_KEY_DATE, null);
            int n2 = preferences.getInt(PREF_KEY_MAJOR_VERSION_NUMBER, -1);
            int n3 = preferences.getInt(PREF_KEY_MINOR_VERSION_NUMBER, -1);
            int n4 = preferences.getInt(PREF_KEY_MICRO_VERSION_NUMBER, -1);
            boolean bl = false;
            bl = string == null || n2 == -1 || n3 == -1 || n4 == -1 ? true : this.compareVersion(n2, n3, n4, 0, 2, 0);
            if (bl) {
                preferences.putLong(PREF_KEY_DATE, System.currentTimeMillis());
                preferences.putInt(PREF_KEY_MAJOR_VERSION_NUMBER, 0);
                preferences.putInt(PREF_KEY_MINOR_VERSION_NUMBER, 2);
                preferences.putInt(PREF_KEY_MICRO_VERSION_NUMBER, 0);
            }
        }

        private boolean compareVersion(int n, int n2, int n3, int n4, int n5, int n6) {
            boolean bl = n < n4 ? true : (n == n4 ? (n2 < n5 ? true : (n2 == n5 ? n3 < n6 : false)) : false);
            return bl;
        }

        private boolean checkDate() {
            boolean bl;
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            long l = preferences.getLong(PREF_KEY_DATE, 0L);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            int n = preferences.getInt(PREF_KEY_UPGRADE_CYCLE, 1);
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = l3 > 86400000L;
                    break;
                }
                case 3: {
                    bl = l3 > 604800000L;
                    break;
                }
                case 4: {
                    bl = l3 > 2592000000L;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private boolean compareVersion(Element element) {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt(PREF_KEY_MAJOR_VERSION_NUMBER, -1);
            int n2 = preferences.getInt(PREF_KEY_MINOR_VERSION_NUMBER, -1);
            int n3 = preferences.getInt(PREF_KEY_MICRO_VERSION_NUMBER, -1);
            int n4 = this.getVersion(element, "majorver");
            int n5 = this.getVersion(element, "minorver");
            int n6 = this.getVersion(element, "microver");
            boolean bl = this.compareVersion(n, n2, n3, n4, n5, n6);
            return bl;
        }

        private int getVersion(Element element, String string) {
            Element element2 = (Element)element.getElementsByTagName(string).item(0);
            String string2 = element2.getFirstChild().getNodeValue();
            int n = Integer.parseInt(string2);
            return n;
        }

        private boolean installLatestVersion(Element element, Window window, boolean bl) {
            int n;
            NodeList nodeList = element.getElementsByTagName("release");
            Element element2 = null;
            for (n = 0; n < nodeList.getLength(); ++n) {
                Element element3 = (Element)nodeList.item(n);
                String string = element3.getAttribute("latest");
                if (!Boolean.TRUE.toString().equals(string)) continue;
                element2 = element3;
                break;
            }
            if (element2 == null) {
                JOptionPane.showMessageDialog(window, "Statement in the XML file is wrong.");
                return false;
            }
            n = this.getVersion(element2, "majorver");
            int n2 = this.getVersion(element2, "minorver");
            int n3 = this.getVersion(element2, "microver");
            String string = new Integer(n).toString();
            String string2 = new Integer(n2).toString();
            String string3 = new Integer(n3).toString();
            String string4 = "Samurai Graph Ver." + string + "." + string2 + "." + string3 + " is found.\n" + "Upgrade now?\n";
            NodeList nodeList2 = element2.getElementsByTagName("releaseinfo");
            Element element4 = (Element)nodeList2.item(0);
            NodeList nodeList3 = element4.getElementsByTagName("changelog");
            Element element5 = (Element)nodeList3.item(0);
            StringBuffer stringBuffer = new StringBuffer();
            this.printNode(element5, stringBuffer);
            StringBuffer stringBuffer2 = new StringBuffer("-- New Features --\n");
            stringBuffer2.append(stringBuffer);
            SGScrollPaneDialog sGScrollPaneDialog = null;
            if (window instanceof Frame) {
                sGScrollPaneDialog = new SGUpgradeConfirmDialog((Frame)window, true);
            } else if (window instanceof Dialog) {
                sGScrollPaneDialog = new SGUpgradeConfirmDialog((Dialog)window, true);
            }
            sGScrollPaneDialog.setMessage(string4);
            sGScrollPaneDialog.setDetailText(new String(stringBuffer2));
            sGScrollPaneDialog.pack();
            sGScrollPaneDialog.setCenter(window);
            sGScrollPaneDialog.setVisible(true);
            if (sGScrollPaneDialog.isCanceled()) {
                return true;
            }
            String string5 = null;
            String string6 = System.getProperty("os.name").toLowerCase();
            string5 = string6.startsWith("windows") ? "win32" : (string6.startsWith("mac os x") ? "macosx" : "other");
            NodeList nodeList4 = element2.getElementsByTagName("package");
            for (int i = 0; i < nodeList4.getLength(); ++i) {
                Element element6 = (Element)nodeList4.item(i);
                String string7 = element6.getAttribute("category");
                if (string7.equals("win32")) {
                    if (!string5.equals("win32")) continue;
                    if (this.forWin32(element6, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (string7.equals("macosx")) {
                    if (!string5.equals("macosx")) continue;
                    if (this.forMacOSX(element6, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (string7.equals("bin")) {
                    if (!string5.equals("other")) continue;
                    if (this.forOtherPlatform(element6, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (!string7.equals("src")) continue;
            }
            return true;
        }

        private boolean forWin32(Element element, String string, String string2, String string3, Window window, boolean bl) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n;
            if (!(bl || (n = JOptionPane.showOptionDialog(window, object5 = "This application will be terminated.\nPresent work will be lost.", (String)(object4 = "Warning"), -1, 2, null, (Object[])(object3 = new Object[]{"OK", "Cancel"}), object3[0])) != 1 && n != -1)) {
                return true;
            }
            object5 = null;
            try {
                object5 = File.createTempFile("tmp_", ".exe");
            }
            catch (IOException iOException) {
                return false;
            }
            ((File)object5).deleteOnExit();
            if (!this.download(element, window, (File)object5)) {
                return false;
            }
            try {
                object4 = new String[]{((File)object5).getAbsolutePath(), "/S"};
                object3 = Runtime.getRuntime().exec((String[])object4);
                try {
                    ((Process)object3).waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, "Failed to install the new version.");
                return false;
            }
            JOptionPane.showMessageDialog(window, "Successfully installed the new version.");
            object4 = System.getProperty("user.dir");
            object3 = SGUtility.getUpperDirectory((String)object4);
            System.setProperty("user.dir", (String)object3);
            String string4 = (String)object4 + "\\Uninstall.exe";
            File file = new File(string4);
            if (!file.exists()) {
                JOptionPane.showMessageDialog(window, "Uninstaller not found.\nFailed to uninstall the old version.");
                return false;
            }
            try {
                object2 = new String[]{string4, "/S"};
                object = Runtime.getRuntime().exec((String[])object2);
                try {
                    ((Process)object).waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, "Failed to uninstall the old version.");
                return false;
            }
            JOptionPane.showMessageDialog(window, "Successfully uninstalled the old version.");
            try {
                object2 = System.getProperty("java.home") + "\\bin\\javaw.exe";
                object = (String)object3 + "\\Samurai-Graph-" + string + "." + string2 + "." + string3 + "\\samurai-graph.jar";
                String[] stringArray = new String[]{object2, "-Xmx128M", "-jar", object};
                Process process = Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, "Failed to start the new version.");
                return false;
            }
            System.exit(0);
            return true;
        }

        private boolean forOtherPlatform(Element element, String string, String string2, String string3, Window window, boolean bl) {
            return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-bin", "zip");
        }

        private boolean forMacOSX(Element element, String string, String string2, String string3, Window window, boolean bl) {
            return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-mac", "dmg.gz");
        }

        private boolean downloadWithFileChooser(Element element, String string, String string2, String string3, Window window, boolean bl, String string4, String string5) {
            File file;
            SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
            sGExtensionFileFilter.setDescription(string5);
            sGExtensionFileFilter.addExtension(string5);
            if (this.mDirectoryName == null) {
                this.mDirectoryName = System.getProperty("user.home");
            }
            JFileChooser jFileChooser = new JFileChooser(this.mDirectoryName);
            jFileChooser.setFileFilter(sGExtensionFileFilter);
            String string6 = string4 + "-" + string + "." + string2 + "." + string3 + "." + string5;
            jFileChooser.setSelectedFile(new File(string6));
            int n = jFileChooser.showSaveDialog(window);
            File file2 = null;
            switch (n) {
                case 0: {
                    file2 = jFileChooser.getSelectedFile();
                    break;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    throw new Error();
                }
            }
            String string7 = file2.getAbsolutePath();
            if (!string7.endsWith(string5) && !string7.endsWith(string5.toUpperCase())) {
                string7 = string7 + "." + string5;
            }
            return this.download(element, window, file = new File(string7));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean download(Element element, Window window, File file) {
            boolean bl;
            SGProgressMonitorDialog sGProgressMonitorDialog;
            InputStream inputStream;
            BufferedOutputStream bufferedOutputStream;
            FileOutputStream fileOutputStream;
            block38: {
                boolean bl2;
                block36: {
                    block37: {
                        fileOutputStream = null;
                        bufferedOutputStream = null;
                        inputStream = null;
                        sGProgressMonitorDialog = null;
                        bl = false;
                        try {
                            try {
                                fileOutputStream = new FileOutputStream(file);
                                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                                NodeList nodeList = element.getElementsByTagName("url");
                                for (int i = 0; i < nodeList.getLength(); ++i) {
                                    Element element2 = (Element)nodeList.item(i);
                                    String string = element2.getFirstChild().getNodeValue();
                                    URL uRL = null;
                                    try {
                                        uRL = new URL(string);
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        continue;
                                    }
                                    URLConnection uRLConnection = null;
                                    try {
                                        uRLConnection = uRL.openConnection();
                                        inputStream = uRLConnection.getInputStream();
                                    }
                                    catch (IOException iOException) {
                                        continue;
                                    }
                                    String string2 = file.getAbsolutePath();
                                    int n = uRLConnection.getContentLength();
                                    boolean bl3 = true;
                                    if (window instanceof Dialog) {
                                        sGProgressMonitorDialog = new SGProgressMonitorDialog((Dialog)window, bl3);
                                    } else if (window instanceof JFrame) {
                                        sGProgressMonitorDialog = new SGProgressMonitorDialog((Frame)window, bl3);
                                    }
                                    JProgressBar jProgressBar = sGProgressMonitorDialog.getProgressBar();
                                    jProgressBar.setMinimum(0);
                                    jProgressBar.setMaximum(n);
                                    jProgressBar.setStringPainted(true);
                                    sGProgressMonitorDialog.setInputSize(n);
                                    sGProgressMonitorDialog.setInputStream(inputStream);
                                    sGProgressMonitorDialog.setOutputStream(bufferedOutputStream);
                                    sGProgressMonitorDialog.setLabel(string2);
                                    sGProgressMonitorDialog.pack();
                                    sGProgressMonitorDialog.setCenter(window);
                                    window.setCursor(Cursor.getPredefinedCursor(3));
                                    Thread thread = new Thread(sGProgressMonitorDialog);
                                    thread.start();
                                    sGProgressMonitorDialog.setVisible(true);
                                    if (sGProgressMonitorDialog.isCanceled()) {
                                        bl2 = false;
                                        Object var22_25 = null;
                                        window.setCursor(Cursor.getDefaultCursor());
                                        sGProgressMonitorDialog.setInputStream(null);
                                        sGProgressMonitorDialog.setOutputStream(null);
                                        if (inputStream == null) break block36;
                                        break block37;
                                    }
                                    bl = true;
                                    break block38;
                                }
                                break block38;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                JOptionPane.showMessageDialog(window, "Local file is missing.");
                                boolean bl4 = false;
                                Object var22_27 = null;
                                window.setCursor(Cursor.getDefaultCursor());
                                sGProgressMonitorDialog.setInputStream(null);
                                sGProgressMonitorDialog.setOutputStream(null);
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        JOptionPane.showMessageDialog(window, "Failed to close the input stream.");
                                        return false;
                                    }
                                }
                                if (bufferedOutputStream != null) {
                                    try {
                                        bufferedOutputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                                        return false;
                                    }
                                }
                                if (fileOutputStream == null) return bl4;
                                try {
                                    fileOutputStream.close();
                                    return bl4;
                                }
                                catch (IOException iOException) {
                                    JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                                    return false;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var22_28 = null;
                            window.setCursor(Cursor.getDefaultCursor());
                            sGProgressMonitorDialog.setInputStream(null);
                            sGProgressMonitorDialog.setOutputStream(null);
                            if (inputStream != null) {
                                try {}
                                catch (IOException iOException) {
                                    JOptionPane.showMessageDialog(window, "Failed to close the input stream.");
                                    return false;
                                }
                                inputStream.close();
                            }
                            if (bufferedOutputStream != null) {
                                try {}
                                catch (IOException iOException) {
                                    JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                                    return false;
                                }
                                bufferedOutputStream.close();
                            }
                            if (fileOutputStream == null) throw throwable;
                            try {}
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                                return false;
                            }
                            fileOutputStream.close();
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(window, "Failed to close the input stream.");
                        return false;
                    }
                    inputStream.close();
                }
                if (bufferedOutputStream != null) {
                    try {}
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                        return false;
                    }
                    bufferedOutputStream.close();
                }
                if (fileOutputStream == null) return bl2;
                try {}
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                    return false;
                }
                fileOutputStream.close();
                return bl2;
            }
            Object var22_26 = null;
            window.setCursor(Cursor.getDefaultCursor());
            sGProgressMonitorDialog.setInputStream(null);
            sGProgressMonitorDialog.setOutputStream(null);
            if (inputStream != null) {
                try {}
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(window, "Failed to close the input stream.");
                    return false;
                }
                inputStream.close();
            }
            if (bufferedOutputStream != null) {
                try {}
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                    return false;
                }
                bufferedOutputStream.close();
            }
            if (fileOutputStream != null) {
                try {}
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(window, "Failed to close the output stream.");
                    return false;
                }
                fileOutputStream.close();
            }
            if (bl) return true;
            JOptionPane.showMessageDialog(window, "Connection failed.");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setFigureElementClass() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream("ListOfFigureElement.txt");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mClassOfAxisElement = Class.forName(DEFAULT_CLASS_NAME_OF_AXIS_ELEMENT);
                this.mClassOfSXYGraphElement = Class.forName(DEFAULT_CLASS_NAME_OF_SXY_GRAPH_ELEMENT);
                this.mClassOfVXYGraphElement = Class.forName(DEFAULT_CLASS_NAME_OF_VXY_GRAPH_ELEMENT);
                this.mClassOfStringElement = Class.forName(DEFAULT_CLASS_NAME_OF_STRING_ELEMENT);
                this.mClassOfLegendElement = Class.forName(DEFAULT_CLASS_NAME_OF_LEGEND_ELEMENT);
                return true;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String string = null;
                Class<?> clazz = null;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((string = SGUtilityText.getPropertyFromLine(string, "SGAxisElement")) == null) {
                    boolean bl = false;
                    return bl;
                }
                clazz = Class.forName(string);
                if (!(clazz.newInstance() instanceof SGIAxisElement)) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfAxisElement = clazz;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((string = SGUtilityText.getPropertyFromLine(string, "SGSXYGraphElement")) == null) {
                    boolean bl = false;
                    return bl;
                }
                clazz = Class.forName(string);
                if (!(clazz.newInstance() instanceof SGIGraphElement)) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfSXYGraphElement = clazz;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((string = SGUtilityText.getPropertyFromLine(string, "SGVXYGraphElement")) == null) {
                    boolean bl = false;
                    return bl;
                }
                clazz = Class.forName(string);
                if (!(clazz.newInstance() instanceof SGIGraphElement)) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfVXYGraphElement = clazz;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((string = SGUtilityText.getPropertyFromLine(string, "SGLegendElement")) == null) {
                    boolean bl = false;
                    return bl;
                }
                clazz = Class.forName(string);
                if (!(clazz.newInstance() instanceof SGILegendElement)) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfLegendElement = clazz;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((string = SGUtilityText.getPropertyFromLine(string, "SGStringElement")) == null) {
                    boolean bl = false;
                    return bl;
                }
                clazz = Class.forName(string);
                if (!(clazz.newInstance() instanceof SGIStringElement)) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfStringElement = clazz;
            }
            finally {
                bufferedReader.close();
                inputStreamReader.close();
                fileInputStream.close();
            }
            return true;
        }

        private boolean executeCommand(String[] stringArray) {
            boolean bl = true;
            if (SGDrawingServer.COM_WOPEN.equals(stringArray[0])) {
                bl = this.wopen(stringArray);
            } else if (SGDrawingServer.COM_ADD_DATE.equals(stringArray[0])) {
                bl = this.addDataByCommandLine(stringArray);
            } else if (SGDrawingServer.COM_READ_PROPERTY.equals(stringArray[0])) {
                bl = this.readWindowProperty(stringArray);
            } else {
                System.out.println("\u30b3\u30de\u30f3\u30c9\u540d\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
            return bl;
        }

        private boolean wopen(String[] stringArray) {
            int n;
            Object object;
            if (stringArray.length < 1) {
                return false;
            }
            if (stringArray.length > 1) {
                object = stringArray[1];
                Integer n2 = this.getWindowIDFromString((String)object);
                if (n2 == null) {
                    return false;
                }
                n = n2;
            } else {
                n = this.getCurrentWindowID();
            }
            object = this.getWindow(n);
            if (object != null) {
                System.out.println("\u305d\u306e\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002");
                return false;
            }
            object = this.createWindow(n);
            if (object == null) {
                return false;
            }
            ((Window)object).setVisible(true);
            return true;
        }

        private SGDrawingWindow getWindowForCommand(int n) {
            SGDrawingWindow sGDrawingWindow = this.getWindow(n);
            if (sGDrawingWindow == null) {
                System.out.println("\u6307\u5b9a\u3055\u308c\u305f\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u3092\u65b0\u898f\u4f5c\u6210\u3057\u307e\u3059\u3002");
                sGDrawingWindow = this.createWindow(n);
                if (sGDrawingWindow == null) {
                    System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    return null;
                }
            }
            return sGDrawingWindow;
        }

        private Integer getWindowIDFromString(String string) {
            Integer n;
            try {
                n = Integer.valueOf(string);
            }
            catch (Exception exception) {
                System.out.println("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return null;
            }
            int n2 = n;
            if (n2 < 1) {
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u756a\u53f7\u306f\u6b63\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
                return null;
            }
            if (n2 > 256) {
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u756a\u53f7\u304c\u5927\u304d\u904e\u304e\u307e\u3059\u3002");
                return null;
            }
            return n;
        }

        private boolean addDataByCommandLine(String[] stringArray) {
            int n;
            Object object;
            int n2;
            Object object2;
            if (stringArray.length < 2) {
                System.out.println("\u30b3\u30de\u30f3\u30c9\u5f15\u6570\u304c\u8db3\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            String string = stringArray[1];
            if (stringArray.length > 2) {
                object2 = stringArray[2];
                Integer n3 = this.getWindowIDFromString((String)object2);
                if (n3 == null) {
                    return false;
                }
                n2 = n3;
            } else {
                n2 = this.getCurrentWindowID();
            }
            object2 = this.getWindowForCommand(n2);
            if (object2 == null) {
                return false;
            }
            if (stringArray.length > 3) {
                object = stringArray[3];
                n = Integer.valueOf((String)object);
            } else {
                n = ((SGDrawingWindow)object2).getCurrentFigureId();
            }
            this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)object2, true);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setEnabled(false);
            object = this.createDataFromFile(string);
            if (object == null) {
                System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return false;
            }
            SGFigure sGFigure = ((SGDrawingWindow)object2).getFigure(n);
            if (sGFigure == null || sGFigure != null && !sGFigure.isVisible()) {
                if (this.createNewFigure((SGDrawingWindow)object2, n, (SGData)object, new Point()) == null) {
                    return false;
                }
            } else if (!sGFigure.addData((SGData)object)) {
                System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
            return true;
        }

        private boolean readWindowProperty(String[] stringArray) {
            if (stringArray.length < 3) {
                System.out.println("\u5f15\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002");
                return false;
            }
            String string = stringArray[1];
            this.mDataFileNameList.clear();
            for (int i = 2; i < stringArray.length; ++i) {
                this.mDataFileNameList.add(stringArray[i]);
            }
            SGDrawingWindow sGDrawingWindow = null;
            try {
                sGDrawingWindow = this.createWindowFromPropertyFile(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (sGDrawingWindow == null) {
                System.out.println("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            return true;
        }

        private boolean readFigureProperty(String[] stringArray) {
            if (stringArray.length < 3) {
                System.out.println("\u5f15\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002");
                return false;
            }
            int n = -1;
            try {
                n = Integer.valueOf(stringArray[1]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            SGDrawingWindow sGDrawingWindow = this.getWindow(n);
            if (sGDrawingWindow == null) {
                System.out.println("\u6307\u5b9a\u3055\u308c\u305f\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            this.mDataFileNameList.clear();
            for (int i = 2; i < stringArray.length; ++i) {
                this.mDataFileNameList.add(stringArray[i]);
            }
            return true;
        }

        private boolean setWindowLocation(SGDrawingWindow sGDrawingWindow) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)(dimension.getWidth() - (double)sGDrawingWindow.getWidth()) / 2;
            int n2 = (int)(dimension.getHeight() - (double)sGDrawingWindow.getHeight()) / 2;
            sGDrawingWindow.setLocation(n, n2);
            return true;
        }

        public SGDrawingWindow getWindow(int n) {
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)this.mWndMap.get(new Integer(n));
            if (sGDrawingWindow == null) {
                return null;
            }
            return sGDrawingWindow;
        }

        private SGFigure createFigure(int n, SGDrawingWindow sGDrawingWindow, SGData sGData) {
            SGFigure sGFigure = null;
            if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
                sGFigure = new SGSXYFigure(sGDrawingWindow);
            } else if (sGData instanceof SGVXYData) {
                sGFigure = new SGVXYFigure(sGDrawingWindow);
            } else {
                System.out.println("\u5bfe\u5fdc\u3059\u308b\u30c7\u30fc\u30bf\u578b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                return null;
            }
            sGFigure.setID(n);
            if (!this.createFigureElements(sGFigure, sGData)) {
                return null;
            }
            float f = 425.19687f;
            float f2 = f / SGIConstants.GOLDEN_RATIO;
            sGFigure.setGraphAreaSize(f, f2);
            return sGFigure;
        }

        private boolean createFigureElements(SGFigure sGFigure, SGData sGData) {
            try {
                SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                Object t = this.mClassOfAxisElement.newInstance();
                JComponent jComponent = (JComponent)t;
                jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
                jComponent.setVisible(true);
                jComponent.setOpaque(false);
                sGFigure.add(jComponent);
                sGFigure.setLayer(jComponent, 20);
                SGIAxisElement sGIAxisElement = (SGIAxisElement)t;
                sGFigure.setAxisElement(sGIAxisElement);
                sGIAxisElement.addActionListener(sGFigure);
                sGIAxisElement.setDialogOwner(sGDrawingWindow);
                Object var7_8 = null;
                if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
                    var7_8 = this.mClassOfSXYGraphElement.newInstance();
                } else if (sGData instanceof SGVXYData) {
                    var7_8 = this.mClassOfVXYGraphElement.newInstance();
                } else {
                    System.out.println("\u5bfe\u5fdc\u3059\u308b\u30c7\u30fc\u30bf\u578b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                    return false;
                }
                JComponent jComponent2 = var7_8;
                jComponent2.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
                jComponent2.setVisible(true);
                jComponent2.setOpaque(false);
                sGFigure.add(jComponent2);
                sGFigure.setLayer(jComponent2, 10);
                SGIGraphElement sGIGraphElement = var7_8;
                sGFigure.setGraphElement(sGIGraphElement);
                sGIGraphElement.addActionListener(sGFigure);
                sGIGraphElement.setDialogOwner(sGDrawingWindow);
                Object t2 = this.mClassOfLegendElement.newInstance();
                JComponent jComponent3 = (JComponent)t2;
                jComponent3.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
                jComponent3.setVisible(true);
                jComponent3.setOpaque(false);
                sGFigure.add(jComponent3);
                sGFigure.setLayer(jComponent3, 30);
                SGILegendElement sGILegendElement = (SGILegendElement)t2;
                sGFigure.setLegendElement(sGILegendElement);
                sGILegendElement.addActionListener(sGFigure);
                sGILegendElement.setDialogOwner(sGDrawingWindow);
                Object t3 = this.mClassOfStringElement.newInstance();
                JComponent jComponent4 = (JComponent)t3;
                jComponent4.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
                jComponent4.setVisible(true);
                jComponent4.setOpaque(false);
                sGFigure.add(jComponent4);
                sGFigure.setLayer(jComponent4, 40);
                SGIStringElement sGIStringElement = (SGIStringElement)t3;
                sGFigure.setStringElement(sGIStringElement);
                sGIStringElement.addActionListener(sGFigure);
                sGIStringElement.setDialogOwner(sGDrawingWindow);
                sGIGraphElement.setAxisElement(sGIAxisElement);
                sGILegendElement.setGraphElement(sGIGraphElement);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }

        private SGData createDataFromFile(String string) {
            ArrayList arrayList = new ArrayList();
            boolean bl = this.readFile(string, arrayList);
            if (!bl) {
                return null;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            SGData sGData = this.createData(string, arrayList);
            return sGData;
        }

        private boolean createAllWizardDialogsForDataAdditionFromToolBar(SGDrawingWindow sGDrawingWindow) {
            int n = sGDrawingWindow.getID();
            this.mFigureIDSelectionWizardDialog = new SGFigureIDSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mFigureIDSelectionWizardDialog.getOKButton().setVisible(false);
            this.mFigureIDSelectionWizardDialog.getPreviousButton().setVisible(false);
            this.mFigureIDSelectionWizardDialog.pack();
            this.mSingleDataFileChooserWizardDilaog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mSingleDataFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mSingleDataFileChooserWizardDilaog.pack();
            this.mXYDataTypeSelectionWizardDialog = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mXYDataTypeSelectionWizardDialog.getNextButton().setVisible(false);
            this.mXYDataTypeSelectionWizardDialog.pack();
            this.mFigureIDSelectionWizardDialog.setNext(this.mSingleDataFileChooserWizardDilaog);
            this.mSingleDataFileChooserWizardDilaog.setPrevious(this.mFigureIDSelectionWizardDialog);
            this.mSingleDataFileChooserWizardDilaog.setNext(this.mXYDataTypeSelectionWizardDialog);
            this.mXYDataTypeSelectionWizardDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
            this.mFigureIDSelectionWizardDialog.addActionListener(this);
            this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialog.addActionListener(this);
            return true;
        }

        private boolean createAllWizardDialogsToLoadPropertyFromToolBar(SGDrawingWindow sGDrawingWindow) {
            this.mPropertyFileChooserWizardDilaog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mPropertyFileChooserWizardDilaog.getPreviousButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.pack();
            this.mMultiDataFileChooserWizardDialog = new SGMultiDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            this.mMultiDataFileChooserWizardDialog.pack();
            this.mPropertyFileChooserWizardDilaog.setNext(this.mMultiDataFileChooserWizardDialog);
            this.mMultiDataFileChooserWizardDialog.setPrevious(this.mPropertyFileChooserWizardDilaog);
            this.mPropertyFileChooserWizardDilaog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialog.addActionListener(this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean getFileTypeCandidateList(Window window, String string, ArrayList arrayList, ArrayList arrayList2) {
            block55: {
                IOException iOException422;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                FileInputStream fileInputStream;
                block50: {
                    int n;
                    ArrayList arrayList3;
                    block46: {
                        IOException iOException2222;
                        boolean bl;
                        block47: {
                            String string2;
                            block42: {
                                IOException iOException3222;
                                boolean bl2;
                                block43: {
                                    fileInputStream = null;
                                    inputStreamReader = null;
                                    bufferedReader = null;
                                    fileInputStream = new FileInputStream(string);
                                    inputStreamReader = new InputStreamReader(fileInputStream);
                                    bufferedReader = new BufferedReader(inputStreamReader);
                                    string2 = SGUtilityText.readLine(bufferedReader);
                                    if (string2 != null) break block42;
                                    bl2 = false;
                                    Object var13_13 = null;
                                    if (bufferedReader == null) break block43;
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (IOException iOException3222) {
                                        // empty catch block
                                    }
                                }
                                if (inputStreamReader != null) {
                                    try {
                                        inputStreamReader.close();
                                    }
                                    catch (IOException iOException3222) {
                                        // empty catch block
                                    }
                                }
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException3222) {
                                        // empty catch block
                                    }
                                }
                                return bl2;
                            }
                            arrayList3 = new ArrayList();
                            SGUtilityText.tokenize(string2, arrayList3);
                            n = arrayList3.size();
                            if (n != 0) break block46;
                            bl = false;
                            Object var13_14 = null;
                            if (bufferedReader == null) break block47;
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    if (n == 2 || n == 3 || n == 5) {
                        if (this.evaluateDataTypeSXY(arrayList3)) {
                            arrayList.add("SXY");
                        }
                    } else if (n == 4 && this.evaluateDataTypeSXY(arrayList3)) {
                        arrayList.add("SXY");
                    }
                    if (n >= 2 && this.evaluateDataTypeSXYMultiple(arrayList3)) {
                        arrayList.add("SXY_MULTIPLE");
                    }
                    if (n >= 1 && this.evaluateDataTypeSXYMultiple(arrayList3)) {
                        arrayList.add("SXY_SAMPLING");
                    }
                    arrayList2.add(new Integer(n));
                    Object var13_15 = null;
                    if (bufferedReader == null) break block50;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException422) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException422) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException422) {}
                }
                break block55;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        IOException iOException5222;
                        SGUtility.showFileNotFoundMessageDialog(window);
                        boolean bl = false;
                        Object var13_16 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException5222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException5222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException5222) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException6222;
                    Object var13_17 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException6222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException6222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException6222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return true;
        }

        private boolean evaluateDataTypeSXY(ArrayList arrayList) {
            int n = 0;
            if (arrayList.size() == 2 || arrayList.size() == 4) {
                n = arrayList.size();
            } else if (arrayList.size() == 3) {
                n = 2;
            } else if (arrayList.size() == 5) {
                n = 4;
            }
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                try {
                    Double d = Double.valueOf(string);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }

        private boolean evaluateDataTypeSXYMultiple(ArrayList arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                try {
                    Double d = Double.valueOf(string);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }

        private boolean readFile(String string, ArrayList arrayList) {
            ArrayList arrayList2;
            ArrayList arrayList3;
            Window window = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getOwner();
            if (!this.getFileTypeCandidateList(window, string, arrayList3 = new ArrayList(), arrayList2 = new ArrayList())) {
                return false;
            }
            if (arrayList3.size() == 0) {
                System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
            String string2 = null;
            if (!this.mXYDataTypeSelectionWizardDialogFromCLorDD.setEffectiveDataType(arrayList3)) {
                return false;
            }
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.setCenter(window);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.setVisible(true);
            if (!this.mCarryOnWizardFlag) {
                return false;
            }
            string2 = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSelectedDataType();
            if (string2 == null) {
                return false;
            }
            arrayList.add(string2);
            if (string2.equals("SXY_SAMPLING")) {
                Double d = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSamplingRate();
                if (d == null) {
                    return false;
                }
                arrayList.add(d);
            }
            return true;
        }

        private boolean readFile2(String string, ArrayList arrayList) {
            String string2 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
            if (string2 == null) {
                return false;
            }
            arrayList.add(string2);
            if (string2.equals("SXY_SAMPLING")) {
                Double d = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                if (d == null) {
                    return false;
                }
                arrayList.add(d);
            }
            return true;
        }

        private SGData createData(String string, ArrayList arrayList) {
            if (string == null || arrayList == null) {
                return null;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            SGData sGData = null;
            String string2 = (String)arrayList.get(0);
            if (string2.equals("SXY")) {
                sGData = this.createSXYData(string);
            } else if (!string2.equals("VXY")) {
                if (string2.equals("SXY_MULTIPLE")) {
                    sGData = this.createSXYMultipleData(string);
                } else if (string2.equals("SXY_SAMPLING")) {
                    if (arrayList.size() <= 1) {
                        return null;
                    }
                    double d = (Double)arrayList.get(1);
                    sGData = this.createSXYSamplingData(string, d);
                }
            }
            return sGData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private int getColumnNumber(String string) {
            int n;
            block39: {
                IOException iOException322;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                FileInputStream fileInputStream;
                block34: {
                    String string2;
                    block30: {
                        IOException iOException2222;
                        int n2;
                        block31: {
                            n = -1;
                            fileInputStream = null;
                            inputStreamReader = null;
                            bufferedReader = null;
                            fileInputStream = new FileInputStream(string);
                            inputStreamReader = new InputStreamReader(fileInputStream);
                            bufferedReader = new BufferedReader(inputStreamReader);
                            string2 = SGUtilityText.readLine(bufferedReader);
                            if (string2 != null) break block30;
                            n2 = n;
                            Object var10_11 = null;
                            if (bufferedReader == null) break block31;
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        return n2;
                    }
                    ArrayList arrayList = new ArrayList();
                    SGUtilityText.tokenize(string2, arrayList);
                    n = arrayList.size();
                    Object var10_12 = null;
                    if (bufferedReader == null) break block34;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException322) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException322) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException322) {}
                }
                break block39;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        IOException iOException4222;
                        Window window = this.mXYDataTypeSelectionWizardDialog.getOwner();
                        SGUtility.showFileNotFoundMessageDialog(window);
                        int n3 = n;
                        Object var10_13 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException4222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException4222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException4222) {
                                // empty catch block
                            }
                        }
                        return n3;
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException5222;
                    Object var10_14 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException5222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException5222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException5222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ArrayList[] createListArray(String var1_1, int var2_2) {
            block40: {
                block39: {
                    block33: {
                        block38: {
                            block31: {
                                block32: {
                                    var3_3 = new ArrayList[var2_2];
                                    for (var4_4 = 0; var4_4 < var3_3.length; ++var4_4) {
                                        var3_3[var4_4] = new ArrayList<E>();
                                    }
                                    var4_5 = null;
                                    var5_6 = null;
                                    var6_7 = null;
                                    try {
                                        try {
                                            var4_5 = new FileInputStream(var1_1);
                                            var5_6 = new InputStreamReader(var4_5);
                                            var6_7 = new BufferedReader(var5_6);
                                            var7_8 = null;
                                            while ((var7_8 = SGUtilityText.readLine(var6_7)) != null) {
                                                var8_10 = new ArrayList<E>();
                                                SGUtilityText.tokenize(var7_8, var8_10);
                                                if (var8_10.size() != var2_2) {
                                                    var9_12 = null;
                                                    var13_16 = null;
                                                    if (var6_7 == null) break block31;
                                                    break block32;
                                                }
                                                var9_12 = new String[var2_2];
                                                for (var10_14 = 0; var10_14 < var2_2; ++var10_14) {
                                                    var11_15 = (String)var8_10.get(var10_14);
                                                    var3_3[var10_14].add(var11_15);
                                                }
                                            }
                                            break block33;
                                        }
                                        catch (FileNotFoundException var7_9) {
                                            var8_11 = this.mXYDataTypeSelectionWizardDialog.getOwner();
                                            SGUtility.showFileNotFoundMessageDialog(var8_11);
                                            var9_13 = null;
                                            var13_18 = null;
                                            if (var6_7 != null) {
                                                try {
                                                    var6_7.close();
                                                }
                                                catch (IOException var14_22) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var5_6 != null) {
                                                try {
                                                    var5_6.close();
                                                }
                                                catch (IOException var14_22) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var4_5 == null) return var9_13;
                                            try {
                                                var4_5.close();
                                                return var9_13;
                                            }
                                            catch (IOException var14_22) {
                                                // empty catch block
                                            }
                                            return var9_13;
                                        }
                                    }
                                    catch (Throwable var12_24) {
                                        block37: {
                                            block36: {
                                                var13_19 = null;
                                                if (var6_7 != null) {
                                                    ** try [egrp 2[TRYBLOCK] [6 : 216->224)] { 
lbl65:
                                                    // 1 sources

                                                    var6_7.close();
                                                    break block36;
lbl67:
                                                    // 1 sources

                                                    catch (IOException var14_23) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (var5_6 != null) {
                                                ** try [egrp 3[TRYBLOCK] [7 : 231->239)] { 
lbl72:
                                                // 1 sources

                                                var5_6.close();
                                                break block37;
lbl74:
                                                // 1 sources

                                                catch (IOException var14_23) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var4_5 == null) throw var12_24;
                                        ** try [egrp 4[TRYBLOCK] [8 : 246->254)] { 
lbl79:
                                        // 1 sources

                                        var4_5.close();
                                        throw var12_24;
lbl81:
                                        // 1 sources

                                        catch (IOException var14_23) {
                                            // empty catch block
                                        }
                                        throw var12_24;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [6 : 216->224)] { 
lbl86:
                                // 1 sources

                                var6_7.close();
                                break block31;
lbl88:
                                // 1 sources

                                catch (IOException var14_20) {
                                    // empty catch block
                                }
                            }
                            if (var5_6 != null) {
                                ** try [egrp 3[TRYBLOCK] [7 : 231->239)] { 
lbl93:
                                // 1 sources

                                var5_6.close();
                                break block38;
lbl95:
                                // 1 sources

                                catch (IOException var14_20) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var4_5 == null) return var9_12;
                        ** try [egrp 4[TRYBLOCK] [8 : 246->254)] { 
lbl100:
                        // 1 sources

                        var4_5.close();
                        return var9_12;
lbl102:
                        // 1 sources

                        catch (IOException var14_20) {
                            // empty catch block
                        }
                        return var9_12;
                    }
                    var13_17 = null;
                    if (var6_7 != null) {
                        ** try [egrp 2[TRYBLOCK] [6 : 216->224)] { 
lbl109:
                        // 1 sources

                        var6_7.close();
                        break block39;
lbl111:
                        // 1 sources

                        catch (IOException var14_21) {
                            // empty catch block
                        }
                    }
                }
                if (var5_6 != null) {
                    ** try [egrp 3[TRYBLOCK] [7 : 231->239)] { 
lbl116:
                    // 1 sources

                    var5_6.close();
                    break block40;
lbl118:
                    // 1 sources

                    catch (IOException var14_21) {
                        // empty catch block
                    }
                }
            }
            if (var4_5 == null) return var3_3;
            try {}
            catch (IOException var14_21) {}
            var4_5.close();
            return var3_3;
            return var3_3;
        }

        private SGSXYData createSXYData(String string) {
            int n = this.getColumnNumber(string);
            if (n == -1) {
                return null;
            }
            if (n < 2) {
                return null;
            }
            ArrayList[] arrayListArray = this.createListArray(string, n);
            if (arrayListArray == null) {
                return null;
            }
            int n2 = arrayListArray[0].size();
            for (int i = 1; i < arrayListArray.length; ++i) {
                if (arrayListArray[i].size() == n2) continue;
                return null;
            }
            SGSXYData sGSXYData = null;
            try {
                double[] dArray = new double[n2];
                double[] dArray2 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = Double.valueOf((String)arrayListArray[0].get(i));
                    dArray2[i] = Double.valueOf((String)arrayListArray[1].get(i));
                }
                double[] dArray3 = null;
                double[] dArray4 = null;
                String[] stringArray = null;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        dArray3 = new double[n2];
                        dArray4 = new double[n2];
                        for (int i = 0; i < n2; ++i) {
                            dArray3[i] = Double.valueOf((String)arrayListArray[2].get(i));
                            dArray4[i] = Double.valueOf((String)arrayListArray[3].get(i));
                        }
                        break;
                    }
                    case 3: {
                        stringArray = new String[n2];
                        for (int i = 0; i < n2; ++i) {
                            stringArray[i] = (String)arrayListArray[2].get(i);
                        }
                        break;
                    }
                    case 5: {
                        dArray3 = new double[n2];
                        dArray4 = new double[n2];
                        stringArray = new String[n2];
                        for (int i = 0; i < n2; ++i) {
                            dArray3[i] = Double.valueOf((String)arrayListArray[2].get(i));
                            dArray4[i] = Double.valueOf((String)arrayListArray[3].get(i));
                            stringArray[i] = (String)arrayListArray[4].get(i);
                        }
                        break;
                    }
                }
                sGSXYData = new SGSXYData(dArray, dArray2, dArray3, dArray4, stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return sGSXYData;
        }

        private SGSXYMultipleData createSXYMultipleData(String string) {
            int n = this.getColumnNumber(string);
            if (n == -1) {
                return null;
            }
            if (n < 2) {
                return null;
            }
            ArrayList[] arrayListArray = this.createListArray(string, n);
            if (arrayListArray == null) {
                return null;
            }
            int n2 = arrayListArray[0].size();
            for (int i = 1; i < arrayListArray.length; ++i) {
                if (arrayListArray[i].size() == n2) continue;
                return null;
            }
            SGSXYMultipleData sGSXYMultipleData = null;
            try {
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = Double.valueOf((String)arrayListArray[0].get(i));
                }
                double[][] dArrayArray = new double[n - 1][];
                for (int i = 0; i < n - 1; ++i) {
                    dArrayArray[i] = new double[n2];
                    for (int j = 0; j < n2; ++j) {
                        dArrayArray[i][j] = Double.valueOf((String)arrayListArray[i + 1].get(j));
                    }
                }
                sGSXYMultipleData = new SGSXYMultipleData(dArray, dArrayArray);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return sGSXYMultipleData;
        }

        private SGSXYMultipleData createSXYSamplingData(String string, double d) {
            int n = this.getColumnNumber(string);
            if (n == -1) {
                return null;
            }
            if (n < 1) {
                return null;
            }
            ArrayList[] arrayListArray = this.createListArray(string, n);
            if (arrayListArray == null) {
                return null;
            }
            int n2 = arrayListArray[0].size();
            for (int i = 1; i < arrayListArray.length; ++i) {
                if (arrayListArray[i].size() == n2) continue;
                return null;
            }
            SGSXYSamplingData sGSXYSamplingData = null;
            try {
                double[][] dArrayArray = new double[n][];
                for (int i = 0; i < n; ++i) {
                    dArrayArray[i] = new double[n2];
                    for (int j = 0; j < n2; ++j) {
                        dArrayArray[i][j] = Double.valueOf((String)arrayListArray[i].get(j));
                    }
                }
                sGSXYSamplingData = new SGSXYSamplingData(d, (double[][])dArrayArray);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return sGSXYSamplingData;
        }

        private SGDrawingWindow createWindow() {
            int n = this.getCurrentWindowID();
            SGDrawingWindow sGDrawingWindow = this.createWindow(n);
            return sGDrawingWindow;
        }

        private SGDrawingWindow createWindow(int n) {
            SGDrawingWindow sGDrawingWindow = new SGDrawingWindow();
            this.addWindow(n, sGDrawingWindow);
            this.initWindow(sGDrawingWindow);
            return sGDrawingWindow;
        }

        private boolean initWindow(SGDrawingWindow sGDrawingWindow) {
            sGDrawingWindow.addActionListener(this);
            sGDrawingWindow.addWindowListener(this);
            sGDrawingWindow.setDefaultCloseOperation(2);
            DropTarget dropTarget = new DropTarget(sGDrawingWindow, 3, this, true);
            sGDrawingWindow.setDropTarget(dropTarget);
            sGDrawingWindow.setLocation(100, 100);
            return sGDrawingWindow.init();
        }

        private boolean addWindow(SGDrawingWindow sGDrawingWindow) {
            if (sGDrawingWindow == null) {
                return false;
            }
            boolean bl = this.addWindow(this.getCurrentWindowID(), sGDrawingWindow);
            return bl;
        }

        private int getCurrentWindowID() {
            int n = this.mWndMap.size() == 0 ? 1 : (Integer)this.mWndMap.lastKey() + 1;
            return n;
        }

        private boolean addWindow(int n, SGDrawingWindow sGDrawingWindow) {
            sGDrawingWindow.setID(n);
            String string = "Window:" + n;
            sGDrawingWindow.setTitle(string);
            this.mWndMap.put(new Integer(n), sGDrawingWindow);
            return true;
        }

        private int createWindowFromPropertyFile(SGDrawingWindow sGDrawingWindow, InputStream inputStream, InputStreamReader inputStreamReader, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            if (!string.equals("[Window]")) {
                return 1;
            }
            float f = 0.035277776f;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            Double d = SGUtilityText.getDoublePropertyFromLine(string, "Paper Width");
            if (d == null) {
                return 1;
            }
            float f2 = d.floatValue() / f;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Paper Height");
            if (d2 == null) {
                return 1;
            }
            float f3 = d2.floatValue() / f;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Grid Interval");
            if (d3 == null) {
                return 1;
            }
            float f4 = d3.floatValue() / f;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Grid Line Width");
            if (d4 == null) {
                return 1;
            }
            float f5 = d4.floatValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            Color color = SGUtilityText.getColorPropertyFromLine(string, "Background Color");
            if (color == null) {
                return 1;
            }
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            Color color2 = SGUtilityText.getColorPropertyFromLine(string, "Grid Line Color");
            if (color2 == null) {
                return 1;
            }
            sGDrawingWindow.setPaperSize(f2, f3);
            sGDrawingWindow.setBackgroundColor(color);
            sGDrawingWindow.setGridInterval(f4);
            sGDrawingWindow.setGridLineWidth(f5);
            sGDrawingWindow.setGridLineColor(color2);
            sGDrawingWindow.initPropertiesHistory();
            int n = this.createFiguresFromPropertyFile(bufferedReader, sGDrawingWindow);
            if (n == 4 || n == 1 || n == 6) {
                return n;
            }
            n = this.mDataFileNameList.size() != 0 ? 5 : 0;
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public SGDrawingWindow createWindowFromPropertyFile(String string) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            SGDrawingWindow sGDrawingWindow;
            block53: {
                IOException iOException3222;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                FileInputStream fileInputStream;
                block48: {
                    block47: {
                        sGDrawingWindow = null;
                        fileInputStream = null;
                        inputStreamReader = null;
                        bufferedReader = null;
                        try {
                            fileInputStream = new FileInputStream(string);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            IOException iOException22222;
                            Window window = this.mPropertyFileChooserWizardDilaog.getOwner();
                            SGUtility.showFileNotFoundMessageDialog(window);
                            SGDrawingWindow sGDrawingWindow2 = null;
                            Object var10_13 = null;
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (IOException iOException22222) {
                                    // empty catch block
                                }
                            }
                            if (inputStreamReader != null) {
                                try {
                                    inputStreamReader.close();
                                }
                                catch (IOException iOException22222) {
                                    // empty catch block
                                }
                            }
                            if (fileInputStream != null) {
                                try {
                                    ((InputStream)fileInputStream).close();
                                }
                                catch (IOException iOException22222) {
                                    // empty catch block
                                }
                            }
                            return sGDrawingWindow2;
                        }
                        inputStreamReader = new InputStreamReader(fileInputStream);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        sGDrawingWindow = this.createWindow();
                        int n = this.createWindowFromPropertyFile(sGDrawingWindow, fileInputStream, inputStreamReader, bufferedReader);
                        String string2 = null;
                        if (n == 0) {
                            string2 = MSG_SUCCESSFUL_COMPLETION;
                        } else if (n == 4) {
                            string2 = ERRMSG_DATA_NUMBER_SHORTAGE;
                        } else if (n == 5) {
                            string2 = ERRMSG_DATA_NUMBER_EXCESS;
                        } else if (n == 6) {
                            string2 = ERRMSG_FILE_OPEN_FAILURE;
                        } else if (n == 1) {
                            string2 = ERRMSG_PROPERTY_FILE_INCORRECT;
                        } else {
                            throw new Error();
                        }
                        sGDrawingWindow.setVisible(true);
                        if (string2 != MSG_SUCCESSFUL_COMPLETION) {
                            SGUtility.showMessageDialog(sGDrawingWindow, string2, "Property file has read.", 0);
                        }
                        if (n != 1) break block47;
                        sGDrawingWindow.setVisible(false);
                        this.removeWindow(sGDrawingWindow);
                    }
                    Object var10_14 = null;
                    if (bufferedReader == null) break block48;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException3222) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException3222) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException3222) {}
                }
                break block53;
                {
                    catch (Exception exception) {
                        IOException iOException42222;
                        SGDrawingWindow sGDrawingWindow3 = null;
                        Object var10_15 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException42222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException42222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException42222) {
                                // empty catch block
                            }
                        }
                        return sGDrawingWindow3;
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException52222;
                    Object var10_16 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return sGDrawingWindow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public SGDrawingWindow createWindowFromPropertyFile(SGDrawingWindow sGDrawingWindow, String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            block43: {
                IOException iOException2222;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                FileInputStream fileInputStream;
                block38: {
                    block37: {
                        if (sGDrawingWindow == null) {
                            new IllegalArgumentException("wnd==null");
                        }
                        fileInputStream = null;
                        inputStreamReader = null;
                        bufferedReader = null;
                        try {
                            fileInputStream = new FileInputStream(string);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Window window = this.mPropertyFileChooserWizardDilaog.getOwner();
                            SGUtility.showFileNotFoundMessageDialog(window);
                            return null;
                        }
                        inputStreamReader = new InputStreamReader(fileInputStream);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        int n = this.createWindowFromPropertyFile(sGDrawingWindow, fileInputStream, inputStreamReader, bufferedReader);
                        String string2 = null;
                        if (n == 0) {
                            string2 = MSG_SUCCESSFUL_COMPLETION;
                        } else if (n == 4) {
                            string2 = ERRMSG_DATA_NUMBER_SHORTAGE;
                        } else if (n == 5) {
                            string2 = ERRMSG_DATA_NUMBER_EXCESS;
                        } else if (n == 6) {
                            string2 = ERRMSG_FILE_OPEN_FAILURE;
                        } else if (n == 1) {
                            string2 = ERRMSG_PROPERTY_FILE_INCORRECT;
                        } else {
                            throw new Exception();
                        }
                        if (string2 == MSG_SUCCESSFUL_COMPLETION) break block37;
                        SGUtility.showMessageDialog(sGDrawingWindow, string2, "Property file has read.", 0);
                    }
                    Object var9_12 = null;
                    if (bufferedReader == null) break block38;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block43;
                {
                    catch (Exception exception) {
                        IOException iOException32222;
                        SGDrawingWindow sGDrawingWindow2 = null;
                        Object var9_13 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        return sGDrawingWindow2;
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException42222;
                    Object var9_14 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return sGDrawingWindow;
        }

        private int createFiguresFromPropertyFile(BufferedReader bufferedReader, SGDrawingWindow sGDrawingWindow) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string = null;
            bufferedReader.mark(256);
            while (true) {
                int n;
                int n2;
                String string2;
                if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                    return 3;
                }
                if (!string.equals("[Figure]")) break;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return 1;
                }
                String string3 = SGUtilityText.getPropertyFromLine(string, "Class Name");
                if (string3 == null) {
                    return 1;
                }
                if (string3.equals("SXY")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure") : class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure).getName();
                } else if (string3.equals("VXY")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure") : class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure).getName();
                } else {
                    return 1;
                }
                Class<?> clazz = Class.forName(string2);
                SGFigure sGFigure = (SGFigure)clazz.newInstance();
                sGFigure.setWindow(sGDrawingWindow);
                int n3 = sGDrawingWindow.getCurrentFigureId();
                sGFigure.setID(n3);
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Double d = SGUtilityText.getDoublePropertyFromLine(string, "X");
                if (d == null) {
                    return 1;
                }
                float f = d.floatValue() / 0.035277776f;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Y");
                if (d2 == null) {
                    return 1;
                }
                float f2 = d2.floatValue() / 0.035277776f;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Width");
                if (d3 == null) {
                    return 1;
                }
                float f3 = d3.floatValue() / 0.035277776f;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Height");
                if (d4 == null) {
                    return 1;
                }
                float f4 = d4.floatValue() / 0.035277776f;
                sGFigure.setGraphAreaLocation(f, f2);
                sGFigure.setGraphAreaSize(f3, f4);
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Double d5 = SGUtilityText.getDoublePropertyFromLine(string, "Space between Axis Line and Numbers");
                if (d5 == null) {
                    return 1;
                }
                float f5 = d5.floatValue() / 0.035277776f;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Double d6 = SGUtilityText.getDoublePropertyFromLine(string, "Space between Numbers and Title");
                if (d6 == null) {
                    return 1;
                }
                float f6 = d6.floatValue() / 0.035277776f;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Color color = SGUtilityText.getColorPropertyFromLine(string, "Background Color");
                if (color == null) {
                    return 1;
                }
                sGFigure.setBackgroundColor(color);
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Transparency");
                if (bl == null) {
                    return 1;
                }
                boolean bl2 = bl;
                sGFigure.setTransparent(bl2);
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    return 1;
                } while (string.length() == 0);
                Boolean bl3 = SGUtilityText.getBooleanPropertyFromLine(string, "Legend Visible");
                if (bl3 == null) {
                    return 1;
                }
                boolean bl4 = bl3;
                int n4 = this.createAxisElementFromPropertyFile(sGFigure, bufferedReader);
                if (n4 == 1 || n4 == 3) {
                    return n4;
                }
                SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
                sGIAxisElement.readProperty(bufferedReader);
                sGIAxisElement.setGraphAreaRect(0.0f, 0.0f, f3, f4);
                sGFigure.setSpaceAxisLineAndNumber(f5);
                sGFigure.setSpaceNumberAndTitle(f6);
                n4 = this.createGraphElementFromPropertyFile(sGFigure, bufferedReader);
                if (n4 == 1 || n4 == 3) {
                    return n4;
                }
                SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
                sGIGraphElement.readProperty(bufferedReader);
                n4 = this.createLegendElementFromPropertyFile(sGFigure, bufferedReader);
                if (n4 == 1 || n4 == 3) {
                    return n4;
                }
                SGILegendElement sGILegendElement = sGFigure.getLegendElement();
                sGILegendElement.readProperty(bufferedReader);
                sGFigure.setLegendVisible(bl4);
                n4 = this.createStringElementFromPropertyFile(sGFigure, bufferedReader);
                if (n4 == 1 || n4 == 3) {
                    return n4;
                }
                SGIStringElement sGIStringElement = sGFigure.getStringElement();
                sGIStringElement.readProperty(bufferedReader);
                sGIGraphElement.setAxisElement(sGIAxisElement);
                sGILegendElement.setGraphElement(sGIGraphElement);
                sGFigure.initPropertiesHistory();
                SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
                for (n2 = 0; n2 < sGIFigureElementArray.length; ++n2) {
                    sGIFigureElementArray[n2].initPropertiesHistory();
                }
                n2 = sGDrawingWindow.getCurrentFigureId();
                sGDrawingWindow.addFigure(n2, sGFigure);
                n4 = this.createDataObjectsFromPropertyFile(bufferedReader, sGFigure);
                if (n4 == 1 || n4 == 6 || n4 == 4) {
                    return n4;
                }
                sGFigure.notifyFigureElement(sGFigure.getAxisElement());
                sGFigure.notifyFigureElement(sGFigure.getGraphElement());
                SGIFigureElement[] sGIFigureElementArray2 = sGFigure.getIFigureElementArray();
                for (n = 0; n < sGIFigureElementArray2.length; ++n) {
                    sGIFigureElementArray2[n].chkBoundsVisible();
                }
                for (n = 0; n < sGIFigureElementArray2.length; ++n) {
                    sGIFigureElementArray2[n].initPropertiesHistory();
                }
                bufferedReader.mark(256);
            }
            bufferedReader.reset();
            return 0;
        }

        public boolean createFigureElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            int n = this.createAxisElementFromPropertyFile(sGFigure, bufferedReader);
            if (n == 1) {
                return false;
            }
            SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
            n = this.createGraphElementFromPropertyFile(sGFigure, bufferedReader);
            if (n == 1) {
                return false;
            }
            SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
            sGIGraphElement.setAxisElement(sGIAxisElement);
            n = this.createLegendElementFromPropertyFile(sGFigure, bufferedReader);
            if (n == 1) {
                return false;
            }
            SGILegendElement sGILegendElement = sGFigure.getLegendElement();
            sGILegendElement.setGraphElement(sGIGraphElement);
            n = this.createStringElementFromPropertyFile(sGFigure, bufferedReader);
            if (n == 1) {
                return false;
            }
            SGIStringElement sGIStringElement = sGFigure.getStringElement();
            return true;
        }

        public int createStringElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            if (!string.equals("[String]")) {
                return 1;
            }
            Class clazz = this.mClassOfStringElement;
            Object t = clazz.newInstance();
            JComponent jComponent = (JComponent)t;
            jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent.setVisible(true);
            jComponent.setOpaque(false);
            sGFigure.add(jComponent);
            sGFigure.setLayer(jComponent, 40);
            SGIStringElement sGIStringElement = (SGIStringElement)t;
            sGFigure.setStringElement(sGIStringElement);
            sGIStringElement.addActionListener(sGFigure);
            sGIStringElement.setDialogOwner(sGFigure.getWindow());
            return 0;
        }

        public int createAxisElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            if (!string.equals("[Axis]")) {
                return 1;
            }
            Class clazz = this.mClassOfAxisElement;
            Object t = clazz.newInstance();
            JComponent jComponent = (JComponent)t;
            jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent.setVisible(true);
            jComponent.setOpaque(false);
            sGFigure.add(jComponent);
            sGFigure.setLayer(jComponent, 20);
            SGIAxisElement sGIAxisElement = (SGIAxisElement)t;
            sGFigure.setAxisElement(sGIAxisElement);
            sGIAxisElement.addActionListener(sGFigure);
            sGIAxisElement.setDialogOwner(sGFigure.getWindow());
            return 0;
        }

        public int createGraphElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            Class clazz;
            Object var3_3 = null;
            if (sGFigure instanceof SGSXYFigure) {
                clazz = this.mClassOfSXYGraphElement;
            } else if (sGFigure instanceof SGVXYFigure) {
                clazz = this.mClassOfVXYGraphElement;
            } else {
                throw new Error();
            }
            Object t = clazz.newInstance();
            JComponent jComponent = (JComponent)t;
            jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent.setVisible(true);
            jComponent.setOpaque(false);
            sGFigure.add(jComponent);
            sGFigure.setLayer(jComponent, 10);
            SGIGraphElement sGIGraphElement = (SGIGraphElement)t;
            sGFigure.setGraphElement(sGIGraphElement);
            sGIGraphElement.addActionListener(sGFigure);
            sGIGraphElement.setDialogOwner(sGFigure.getWindow());
            return 0;
        }

        public int createLegendElementFromPropertyFile(SGFigure sGFigure, BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return 1;
            }
            if (!string.equals("[Legend]")) {
                return 1;
            }
            Class clazz = this.mClassOfLegendElement;
            Object t = clazz.newInstance();
            JComponent jComponent = (JComponent)t;
            jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent.setVisible(true);
            jComponent.setOpaque(false);
            sGFigure.add(jComponent);
            sGFigure.setLayer(jComponent, 30);
            SGILegendElement sGILegendElement = (SGILegendElement)t;
            sGFigure.setLegendElement(sGILegendElement);
            sGILegendElement.addActionListener(sGFigure);
            sGILegendElement.setDialogOwner(sGFigure.getWindow());
            return 0;
        }

        private int createDataObjectsFromPropertyFile(BufferedReader bufferedReader, SGFigure sGFigure) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string = null;
            while (true) {
                Constable constable;
                if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                    return 3;
                }
                if (!string.equals("[Data]")) break;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return 1;
                }
                String string2 = SGUtilityText.getPropertyFromLine(string, "Class Name");
                if (string2 == null) {
                    return 1;
                }
                arrayList.add(string2);
                String string3 = null;
                if (string2.equals("SXY")) {
                    string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYData).getName();
                } else if (string2.equals("VXY")) {
                    string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGVXYData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGVXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGVXYData).getName();
                } else if (string2.equals("SXY_MULTIPLE")) {
                    string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData).getName();
                } else if (string2.equals("SXY_SAMPLING")) {
                    string3 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData).getName();
                    string = SGUtilityText.readLine(bufferedReader);
                    if (string == null) {
                        return 2;
                    }
                    constable = SGUtilityText.getDoublePropertyFromLine(string, "Sampling Rate");
                    if (constable == null) {
                        return 2;
                    }
                    arrayList.add(constable);
                } else {
                    return 2;
                }
                constable = Class.forName(string3);
                SGData sGData = (SGData)constable.newInstance();
                if (this.mDataFileNameList.size() == 0) {
                    return 4;
                }
                String string4 = (String)this.mDataFileNameList.remove(0);
                SGData sGData2 = this.createData(string4, arrayList);
                if (sGData2 == null) {
                    System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    return 6;
                }
                boolean bl = sGData.setData(sGData2);
                if (!bl) {
                    return 2;
                }
                boolean bl2 = sGFigure.createDataObjectFromPropertyFile(bufferedReader, sGData);
                if (!bl2) {
                    return 1;
                }
                bufferedReader.mark(256);
            }
            bufferedReader.reset();
            return 0;
        }

        private boolean fromWindow(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
            if (string.equals("open a new window")) {
                SGDrawingWindow sGDrawingWindow2 = this.createWindow();
                sGDrawingWindow2.setVisible(true);
            } else if (string.equals("add new data")) {
                this.createAllWizardDialogsForDataAdditionFromToolBar(sGDrawingWindow);
                this.mFigureIDSelectionWizardDialog.setCenter(sGDrawingWindow);
                this.mFigureIDSelectionWizardDialog.setVisible(true);
            } else if (string.equals("load property")) {
                this.createAllWizardDialogsToLoadPropertyFromToolBar(sGDrawingWindow);
                this.mPropertyFileChooserWizardDilaog.setCenter(sGDrawingWindow);
                this.mPropertyFileChooserWizardDilaog.setVisible(true);
            } else {
                if (string.equals("upgrade the latest version")) {
                    return this.showUpgradeDialog(sGDrawingWindow);
                }
                if (string.equals("show the change log")) {
                    return this.showChangeLogDialog(sGDrawingWindow);
                }
            }
            return true;
        }

        private boolean showUpgradeDialog(Frame frame) {
            this.mUpgradeDialog = new SGUpgradeDialog(frame, true);
            this.mUpgradeDialog.addActionListener(this);
            this.mUpgradeDialog.setCenter(frame);
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt(PREF_KEY_UPGRADE_CYCLE, 0);
            String string = null;
            switch (n) {
                case 0: {
                    string = "No Upgrade";
                    break;
                }
                case 1: {
                    string = "Every Time";
                    break;
                }
                case 2: {
                    string = "Every Day";
                    break;
                }
                case 3: {
                    string = "Every Week";
                    break;
                }
                case 4: {
                    string = "Every Month";
                    break;
                }
                default: {
                    string = "No Upgrade";
                }
            }
            this.mUpgradeDialog.setUpgradeCycle(string);
            this.mUpgradeDialog.setVisible(true);
            return true;
        }

        private boolean showChangeLogDialog(Frame frame) {
            Object object;
            this.mChangeLogDialog = new SGChangeLogDialog(frame, true);
            this.mChangeLogDialog.addActionListener(this);
            this.mChangeLogDialog.setCenter(frame);
            Document document = this.createProductDocument();
            if (document == null) {
                JOptionPane.showMessageDialog(frame, "Failed to get log information.");
                return false;
            }
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("release");
            ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = nodeList.item(i);
                if (!(object instanceof Element)) continue;
                Element element2 = (Element)object;
                NodeList nodeList2 = element2.getElementsByTagName("releaseinfo");
                Element element3 = (Element)nodeList2.item(0);
                NodeList nodeList3 = element3.getElementsByTagName("changelog");
                Element element4 = (Element)nodeList3.item(0);
                NodeList nodeList4 = element3.getElementsByTagName("releasedesc");
                Element element5 = (Element)nodeList4.item(0);
                String string = "<< " + element5.getFirstChild().toString() + " >>\n";
                NodeList nodeList5 = element3.getElementsByTagName("releasedate");
                Element element6 = (Element)nodeList5.item(0);
                String string2 = "Released at " + element6.getFirstChild().toString() + ".\n";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                stringBuffer.append(string2);
                this.printNode(element4, stringBuffer);
                if (i != n - 1) {
                    stringBuffer.append("\n");
                }
                arrayList.add(stringBuffer);
            }
            String string = "Change Log of Samurai Graph.";
            this.mChangeLogDialog.setMessage(string);
            object = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                ((StringBuffer)object).append((StringBuffer)arrayList.get(i));
            }
            this.mChangeLogDialog.setDetailText(new String((StringBuffer)object));
            this.mChangeLogDialog.pack();
            this.mChangeLogDialog.setVisible(true);
            return true;
        }

        private boolean fromCLorDDWizardDialog(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.mCarryOnWizardFlag = true;
            } else if (string.equals("Cancel")) {
                this.mCarryOnWizardFlag = false;
            }
            return true;
        }

        private boolean addDataByToolBar(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            if (!object.equals(this.mFigureIDSelectionWizardDialog)) {
                if (object.equals(this.mSingleDataFileChooserWizardDilaog)) {
                    if (string.equals("Next>")) {
                        String string2 = this.mSingleDataFileChooserWizardDilaog.getFileName();
                        Window window = this.mSingleDataFileChooserWizardDilaog.getOwner();
                        ArrayList arrayList = new ArrayList();
                        ArrayList arrayList2 = new ArrayList();
                        ArrayList arrayList3 = new ArrayList();
                        if (!this.getFileTypeCandidateList(window, string2, arrayList2, arrayList3)) {
                            return false;
                        }
                        if (arrayList2.size() == 0) {
                            System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                            return false;
                        }
                        if (!this.mXYDataTypeSelectionWizardDialog.setEffectiveDataType(arrayList2)) {
                            return false;
                        }
                    }
                } else if (object.equals(this.mXYDataTypeSelectionWizardDialog) && string.equals("OK")) {
                    Object object2;
                    SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
                    int n = sGDrawingWindow.getID();
                    int n2 = this.mFigureIDSelectionWizardDialog.getFigureID();
                    String string3 = this.mSingleDataFileChooserWizardDilaog.getFileName();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    String string4 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
                    if (string4 == null) {
                        return false;
                    }
                    arrayList.add(string4);
                    if (string4.equals("SXY_SAMPLING")) {
                        object2 = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                        if (object2 == null) {
                            return false;
                        }
                        arrayList.add(object2);
                    }
                    if (arrayList.size() == 0) {
                        return false;
                    }
                    object2 = this.createData(string3, arrayList);
                    if (object2 == null) {
                        System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return false;
                    }
                    SGFigure sGFigure = sGDrawingWindow.getFigure(n2);
                    if (sGFigure == null || sGFigure != null && !sGFigure.isVisible()) {
                        if (this.createNewFigure(sGDrawingWindow, n2, (SGData)object2, new Point()) == null) {
                            return false;
                        }
                    } else if (!sGFigure.addData((SGData)object2)) {
                        System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
                        return false;
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean getFileTypeCandidateListFromPropertyFile(String string, ArrayList arrayList) {
            block31: {
                IOException iOException2222;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                FileInputStream fileInputStream;
                block26: {
                    fileInputStream = null;
                    inputStreamReader = null;
                    bufferedReader = null;
                    fileInputStream = new FileInputStream(string);
                    inputStreamReader = new InputStreamReader(fileInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String string2 = null;
                    while ((string2 = SGUtilityText.readLine(bufferedReader)) != null) {
                        String string3;
                        if (!string2.equals("[Data]")) continue;
                        while ((string3 = SGUtilityText.getPropertyFromLine(string2 = SGUtilityText.readLine(bufferedReader), "Class Name")) == null) {
                        }
                        arrayList.add(string3);
                    }
                    Object var10_10 = null;
                    if (bufferedReader == null) break block26;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block31;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        IOException iOException32222;
                        Window window = this.mXYDataTypeSelectionWizardDialog.getOwner();
                        SGUtility.showFileNotFoundMessageDialog(window);
                        boolean bl = false;
                        Object var10_11 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException42222;
                    Object var10_12 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return true;
        }

        private boolean loadProperty(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            if (object instanceof SGPropertyFileChooserWizardDialog) {
                this.fromPropertyFileChooserDialog(actionEvent, sGWizardDialog);
            } else if (object instanceof SGMultiDataFileChooserWizardDialog) {
                this.fromMultiDataFileChooser(actionEvent);
            }
            return true;
        }

        private boolean fromPropertyFileChooserDialog(ActionEvent actionEvent, SGWizardDialog sGWizardDialog) {
            String string = actionEvent.getActionCommand();
            Window window = sGWizardDialog.getOwner();
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getNext();
            if (!(sGWizardDialog instanceof SGPropertyFileChooserWizardDialog)) {
                return false;
            }
            if (!(sGWizardDialog2 instanceof SGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog2;
            if (string.equals("Next>")) {
                Object object;
                int n;
                File file = sGPropertyFileChooserWizardDialog.getSelectedFile();
                String string2 = SGUtility.getCanonicalPath(file.getPath());
                if (string2 == null) {
                    SGUtility.showMessageDialog(sGWizardDialog, ERRMSG_FILE_OPEN_FAILURE, TITLE_FILE_CHECK, 0);
                    return false;
                }
                ArrayList arrayList = new ArrayList();
                if (!this.getFileTypeCandidateListFromPropertyFile(string2, arrayList)) {
                    SGUtility.showMessageDialog(sGWizardDialog, ERRMSG_FILE_OPEN_FAILURE, TITLE_FILE_CHECK, 0);
                    return false;
                }
                int n2 = arrayList.size();
                sGMultiDataFileChooserWizardDialog.setFileNumber(n2);
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                DefaultTableModel defaultTableModel = (DefaultTableModel)sGMultiDataFileChooserWizardDialog.getTableModel();
                int n3 = defaultTableModel.getRowCount();
                int n4 = defaultTableModel.getColumnCount();
                boolean bl = true;
                block1: for (int i = 0; i < n3; ++i) {
                    for (n = 0; n < n4; ++n) {
                        object = defaultTableModel.getValueAt(i, n);
                        if (object == null) continue;
                        bl = false;
                        continue block1;
                    }
                }
                if (bl) {
                    Object[][] objectArray = new String[stringArray.length][];
                    for (n = 0; n < objectArray.length; ++n) {
                        objectArray[n] = new String[2];
                        objectArray[n][0] = stringArray[n];
                        objectArray[n][1] = null;
                    }
                    Object[] objectArray2 = new Object[]{"Data Type", "File Name"};
                    object = new DefaultTableModel(objectArray, objectArray2);
                    sGMultiDataFileChooserWizardDialog.setTableModel((TableModel)object);
                }
            }
            return true;
        }

        private boolean fromMultiDataFileChooser(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
            SGWizardDialog sGWizardDialog2 = sGMultiDataFileChooserWizardDialog.getPrevious();
            if (!(sGWizardDialog2 instanceof SGPropertyFileChooserWizardDialog)) {
                return false;
            }
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog2;
            if (string.equals("OK")) {
                File[] fileArray = sGMultiDataFileChooserWizardDialog.getSelectedFiles();
                this.mDataFileNameList.clear();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.mDataFileNameList.add(fileArray[i].getAbsolutePath());
                }
                String string2 = sGPropertyFileChooserWizardDialog.getSelectedFile().getAbsolutePath();
                try {
                    SGDrawingWindow sGDrawingWindow;
                    if (sGMultiDataFileChooserWizardDialog.equals(this.mMultiDataFileChooserWizardDialog)) {
                        sGDrawingWindow = this.createWindowFromPropertyFile(string2);
                    } else if (sGMultiDataFileChooserWizardDialog.equals(this.mStartupMultiDataFileChooserWizardDialog)) {
                        sGDrawingWindow = this.getWindow(1);
                        this.createWindowFromPropertyFile(sGDrawingWindow, string2);
                    } else {
                        return false;
                    }
                    if (sGDrawingWindow == null) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        private boolean fromWizardDialog(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            if (object.equals(this.mStartupUsePropertyDialog)) {
                if (string.equals("Yes, I do.")) {
                    return this.setStartupWizardUseProperty(true);
                }
                if (string.equals("No, I don't.")) {
                    return this.setStartupWizardUseProperty(false);
                }
            }
            if (object.equals(this.mStartupPropertyFileChooserDialog) || object.equals(this.mStartupMultiDataFileChooserWizardDialog)) {
                return this.loadProperty(actionEvent);
            }
            if (object.equals(this.mXYDataTypeSelectionWizardDialogFromCLorDD)) {
                return this.fromCLorDDWizardDialog(actionEvent);
            }
            if (object.equals(this.mFigureIDSelectionWizardDialog) || object.equals(this.mSingleDataFileChooserWizardDilaog) || object.equals(this.mXYDataTypeSelectionWizardDialog)) {
                return this.addDataByToolBar(actionEvent);
            }
            if (object.equals(this.mPropertyFileChooserWizardDilaog) || object.equals(this.mMultiDataFileChooserWizardDialog)) {
                return this.loadProperty(actionEvent);
            }
            return true;
        }

        private boolean fromUpgradeDialog(ActionEvent actionEvent) {
            SGUpgradeDialog sGUpgradeDialog;
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                int n;
                String string2 = this.mUpgradeDialog.getUpgradeCycle();
                if (string2.equals("No Upgrade")) {
                    n = 0;
                } else if (string2.equals("Every Time")) {
                    n = 1;
                } else if (string2.equals("Every Day")) {
                    n = 2;
                } else if (string2.equals("Every Week")) {
                    n = 3;
                } else if (string2.equals("Every Month")) {
                    n = 4;
                } else {
                    throw new Error();
                }
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putInt(PREF_KEY_UPGRADE_CYCLE, n);
            } else if (string.equals("Upgrade Now") && !this.upgradeByCommand(sGUpgradeDialog = (SGUpgradeDialog)object)) {
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object instanceof SGDrawingWindow) {
                this.fromWindow(actionEvent);
            } else if (object instanceof SGWizardDialog) {
                this.fromWizardDialog(actionEvent);
            } else if (object instanceof SGUpgradeDialog) {
                this.fromUpgradeDialog(actionEvent);
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof SGDrawingWindow) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)windowEvent.getSource();
                this.removeWindow(sGDrawingWindow);
                if (this.mWndMap.size() == 0) {
                    System.exit(0);
                }
            }
        }

        public boolean removeWindow(SGDrawingWindow sGDrawingWindow) {
            if (sGDrawingWindow == null) {
                return false;
            }
            int n = sGDrawingWindow.getID();
            this.mWndMap.remove(new Integer(n));
            sGDrawingWindow.removeWindowListener(this);
            sGDrawingWindow.removeActionListener(this);
            return true;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            dropTargetDropEvent.acceptDrop(3);
            try {
                if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    this.mDropTargetDropEvent = dropTargetDropEvent;
                    this.mDroppedFileList = new ArrayList(list);
                    this.mThread = new ThreadForDropEvent();
                    this.mThread.start();
                } else {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        private boolean addDataByDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setVisible(false);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mNextButton.setVisible(false);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.pack();
            for (int i = 0; i < arrayList.size(); ++i) {
                File file = (File)arrayList.get(i);
                try {
                    String string = file.getCanonicalPath();
                    SGData sGData = this.createDataFromFile(string);
                    if (sGData == null) continue;
                    Component component = sGDrawingWindow.getComponent(n, n2);
                    if (component instanceof SGDrawingWindow) {
                        Point point;
                        int n3 = sGDrawingWindow.getCurrentFigureId();
                        SGFigure sGFigure = sGDrawingWindow.getFigure(n3);
                        if (!(sGFigure == null ? (sGFigure = this.createNewFigure(sGDrawingWindow, n3, sGData, point = new Point(n, n2))) == null : !sGFigure.addData(sGData))) continue;
                        return false;
                    }
                    if (component instanceof SGFigure) {
                        SGFigure sGFigure = (SGFigure)component;
                        sGFigure.addData(sGData);
                        continue;
                    }
                    return false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        private SGFigure createNewFigure(SGDrawingWindow sGDrawingWindow, int n, SGData sGData, Point point) {
            SGFigure sGFigure = this.createFigure(n, sGDrawingWindow, sGData);
            if (sGFigure == null) {
                return null;
            }
            if (!sGFigure.getGraphElement().initPropertiesHistory()) {
                return null;
            }
            TreeMap treeMap = sGDrawingWindow.getFigureMap();
            if (!treeMap.containsValue(sGFigure)) {
                sGDrawingWindow.addFigure(n, sGFigure, point);
            }
            sGDrawingWindow.updateHistory();
            sGDrawingWindow.notifyToRoot();
            if (!sGFigure.addData(sGData)) {
                System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
                return null;
            }
            if (!sGFigure.getAxisElement().initPropertiesHistory()) {
                return null;
            }
            if (!sGFigure.getLegendElement().initPropertiesHistory()) {
                return null;
            }
            if (!sGFigure.getStringElement().initPropertiesHistory()) {
                return null;
            }
            sGDrawingWindow.drawBackFigure(sGFigure);
            sGFigure.initPropertiesHistory();
            sGDrawingWindow.setVisible(true);
            return sGFigure;
        }

        private SGWizardDialog createStartupWizardDialogs(SGDrawingWindow sGDrawingWindow) {
            SGStartupFigurePropertySettingDialog sGStartupFigurePropertySettingDialog;
            SGXYDataTypeSelectionWizardDialog sGXYDataTypeSelectionWizardDialog;
            SGSingleDataFileChooserWizardDialog sGSingleDataFileChooserWizardDialog;
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog;
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog;
            SGStartupUsePropertyDialog sGStartupUsePropertyDialog;
            this.mStartupUsePropertyDialog = sGStartupUsePropertyDialog = new SGStartupUsePropertyDialog((Frame)sGDrawingWindow, true);
            sGStartupUsePropertyDialog.addActionListener(this);
            sGStartupUsePropertyDialog.getOKButton().setVisible(false);
            sGStartupUsePropertyDialog.getPreviousButton().setVisible(false);
            sGStartupUsePropertyDialog.pack();
            this.mStartupPropertyFileChooserDialog = sGPropertyFileChooserWizardDialog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            sGPropertyFileChooserWizardDialog.addActionListener(this);
            sGPropertyFileChooserWizardDialog.getOKButton().setVisible(false);
            sGPropertyFileChooserWizardDialog.pack();
            this.mStartupMultiDataFileChooserWizardDialog = sGMultiDataFileChooserWizardDialog = new SGMultiDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            sGMultiDataFileChooserWizardDialog.addActionListener(this);
            sGMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.pack();
            this.mStartupSingleDataFileChooserWizardDialog = sGSingleDataFileChooserWizardDialog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            sGSingleDataFileChooserWizardDialog.addActionListener(this);
            sGSingleDataFileChooserWizardDialog.getOKButton().setVisible(false);
            sGSingleDataFileChooserWizardDialog.pack();
            this.mStartupXYDataTypeSelectionDialog = sGXYDataTypeSelectionWizardDialog = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            sGXYDataTypeSelectionWizardDialog.addActionListener(this);
            this.mStartupFigurePropertySettingDialog = sGStartupFigurePropertySettingDialog = new SGStartupFigurePropertySettingDialog((Frame)sGDrawingWindow, true);
            sGStartupFigurePropertySettingDialog.addActionListener(this);
            this.setFigureDialogProperties();
            SGStartupUsePropertyDialog sGStartupUsePropertyDialog2 = sGStartupUsePropertyDialog;
            sGStartupUsePropertyDialog2.setCenter(sGDrawingWindow);
            this.mStartupUsePropertyDialog.setUsePropertyFile(false);
            this.setStartupWizardUseProperty(false);
            return sGStartupUsePropertyDialog2;
        }

        private boolean setStartupWizardUseProperty(boolean bl) {
            SGStartupUsePropertyDialog sGStartupUsePropertyDialog = this.mStartupUsePropertyDialog;
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = this.mStartupPropertyFileChooserDialog;
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = this.mStartupMultiDataFileChooserWizardDialog;
            SGSingleDataFileChooserWizardDialog sGSingleDataFileChooserWizardDialog = this.mStartupSingleDataFileChooserWizardDialog;
            SGXYDataTypeSelectionWizardDialog sGXYDataTypeSelectionWizardDialog = this.mStartupXYDataTypeSelectionDialog;
            SGStartupFigurePropertySettingDialog sGStartupFigurePropertySettingDialog = this.mStartupFigurePropertySettingDialog;
            if (bl) {
                sGStartupUsePropertyDialog.setNext(sGPropertyFileChooserWizardDialog);
                sGPropertyFileChooserWizardDialog.setPrevious(sGStartupUsePropertyDialog);
                sGPropertyFileChooserWizardDialog.setNext(sGMultiDataFileChooserWizardDialog);
                sGMultiDataFileChooserWizardDialog.setPrevious(sGPropertyFileChooserWizardDialog);
            } else {
                sGStartupUsePropertyDialog.setNext(sGSingleDataFileChooserWizardDialog);
                sGSingleDataFileChooserWizardDialog.setPrevious(sGStartupUsePropertyDialog);
                sGSingleDataFileChooserWizardDialog.setNext(sGXYDataTypeSelectionWizardDialog);
                sGXYDataTypeSelectionWizardDialog.setPrevious(sGSingleDataFileChooserWizardDialog);
                sGXYDataTypeSelectionWizardDialog.setNext(sGStartupFigurePropertySettingDialog);
                sGStartupFigurePropertySettingDialog.setPrevious(sGXYDataTypeSelectionWizardDialog);
            }
            return true;
        }

        private SGSplashWindow createSplashWindow() {
            Class<?> clazz = this.getClass();
            String string = "/resources/Splash.png";
            URL uRL = clazz.getResource(string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            SGSplashWindow sGSplashWindow = new SGSplashWindow(image);
            return sGSplashWindow;
        }

        private boolean setFigureDialogProperties() {
            SGStartupFigurePropertySettingDialog sGStartupFigurePropertySettingDialog = this.mStartupFigurePropertySettingDialog;
            sGStartupFigurePropertySettingDialog.setFigureX(0.0f);
            sGStartupFigurePropertySettingDialog.setFigureY(0.0f);
            sGStartupFigurePropertySettingDialog.setFigureWidth(15.0f);
            sGStartupFigurePropertySettingDialog.setFigureHeight(15.0f / SGIConstants.GOLDEN_RATIO);
            sGStartupFigurePropertySettingDialog.setFigureBackgroundColor(SGDefaultValues.FIGURE_BACKGROUND_COLOR);
            sGStartupFigurePropertySettingDialog.setFigureTransparentFlag(false);
            sGStartupFigurePropertySettingDialog.setFigureSpaceLineAndNumber(0.2f);
            sGStartupFigurePropertySettingDialog.setFigureSpaceNumberAndTitle(0.2f);
            sGStartupFigurePropertySettingDialog.setFigureLegendVisible(true);
            return true;
        }

        class ThreadForDropEvent
        extends Thread {
            ThreadForDropEvent() {
            }

            public void run() {
                DropTargetDropEvent dropTargetDropEvent = Connect.this.mDropTargetDropEvent;
                DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
                Component component = dropTarget.getComponent();
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
                Point point = dropTargetDropEvent.getLocation();
                Connect.this.addDataByDragAndDrop(point.x, point.y, sGDrawingWindow, Connect.this.mDroppedFileList);
                sGDrawingWindow.getContentPane().repaint();
                Connect.this.mDropTargetDropEvent = null;
                Connect.this.mDroppedFileList = null;
                Connect.this.mThread = null;
            }
        }
    }
}

