/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;

public class SGFigureIDSelectionWizardDialog
extends SGWizardDialog
implements CaretListener {
    public static final String TITLE = "Input the figure ID.";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mFigureIDLabel;
    protected JTextField mFigureIDTextField;
    private JButton mNextButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviousButton;

    public SGFigureIDSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGFigureIDSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mFigureIDLabel = new JLabel();
        this.mFigureIDTextField = new JTextField();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new EtchedBorder());
        this.mFigureIDLabel.setText("Figure ID");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFigureIDLabel, gridBagConstraints);
        this.mFigureIDTextField.setText("1");
        this.mFigureIDTextField.setPreferredSize(new Dimension(55, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFigureIDTextField, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mPreviousButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mFigureIDTextField.addCaretListener(this);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    public int getFigureID() {
        String string = this.getFigureIDString();
        Integer n = Integer.valueOf(string);
        int n2 = n;
        return n2;
    }

    public String getFigureIDString() {
        return this.mFigureIDTextField.getText();
    }

    public boolean setFigureID(int n) {
        this.mFigureIDTextField.setText(new Integer(n).toString());
        return true;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object.equals(this.mFigureIDTextField)) {
            JTextComponent jTextComponent = (JTextComponent)object;
            String string = jTextComponent.getText();
            try {
                Integer n = Integer.valueOf(string);
                this.mNextButton.setEnabled(true);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("\u6574\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
                this.mNextButton.setEnabled(false);
            }
        }
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }
}

