/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.riken.brain.ni.samuraigraph.application.SGFileChooserWizardDialog;

public class SGMultiDataFileChooserWizardDialog
extends SGFileChooserWizardDialog {
    public static final String TITLE = "Choose data files.";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    protected JButton mFileChooserButton;
    private JButton mNextButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviousButton;
    private JScrollPane mScrollPane;
    protected JTable mTable;
    private int mFileNumber;

    public SGMultiDataFileChooserWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGMultiDataFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mScrollPane = new JScrollPane();
        this.mTable = new JTable();
        this.mFileChooserButton = new JButton();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new EtchedBorder());
        this.mScrollPane.setPreferredSize(new Dimension(454, 200));
        this.mTable.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}}, new String[]{"File Name"}));
        this.mScrollPane.setViewportView(this.mTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.mPanel.add((Component)this.mScrollPane, gridBagConstraints);
        this.mFileChooserButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mFileChooserButton.setText("Choose");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.mPanel.add((Component)this.mFileChooserButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mPreviousButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mOKButton.setEnabled(false);
        this.mFileChooserButton.addActionListener(this);
        this.mFileChooser.setMultiSelectionEnabled(true);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mFileChooserButton)) {
            if (!this.showFileChooser()) {
                throw new Error();
            }
            if (this.getSelectedFiles().length == this.mFileNumber) {
                this.mOKButton.setEnabled(true);
            }
        }
    }

    public JTable getTable() {
        return this.mTable;
    }

    public boolean setTable(JTable jTable) {
        this.mTable = jTable;
        return true;
    }

    public TableModel getTableModel() {
        return this.mTable.getModel();
    }

    public boolean setTableModel(TableModel tableModel) {
        this.mTable.setModel(tableModel);
        return true;
    }

    private boolean showFileChooser() {
        int n;
        ArrayList arrayList = this.openFileChooser();
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return true;
        }
        File[] fileArray = new File[arrayList.size()];
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n] = (File)arrayList.get(n);
        }
        n = this.setSelectedFiles(fileArray) ? 1 : 0;
        return n != 0;
    }

    public File[] getSelectedFiles() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.mTable.getRowCount(); ++i) {
            Object object = this.mTable.getValueAt(i, 1);
            if (object == null) continue;
            arrayList.add(object);
        }
        File[] fileArray = new File[arrayList.size()];
        for (int i = 0; i < fileArray.length; ++i) {
            String string = (String)arrayList.get(i);
            fileArray[i] = new File(string);
        }
        return fileArray;
    }

    public boolean setSelectedFiles(File[] fileArray) {
        int n;
        for (n = 0; n < this.mTable.getRowCount(); ++n) {
            this.mTable.setValueAt(null, n, 1);
        }
        for (n = 0; n < fileArray.length; ++n) {
            String string = fileArray[n].getPath();
            this.mTable.setValueAt(string, n, 1);
        }
        return true;
    }

    public int getFileNumber() {
        return this.mFileNumber;
    }

    public void setFileNumber(int n) {
        if (n < 0) {
            new IllegalArgumentException("num<0");
        }
        this.mFileNumber = n;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            boolean bl2 = this.mFileNumber == 0;
            this.mFileChooserButton.setEnabled(!bl2);
        }
        super.setVisible(bl);
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }
}

