/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public class SGUpgradeDialog
extends SGDialog {
    public static final String TITLE = "Upgrade";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JPanel mUpdateButtonPanel;
    private JButton mUpgradeButton;
    private JComboBox mUpgradeCycleComboBox;
    private JPanel mUpgradeCyclePanel;
    public static final String NO_UPGRADE = "No Upgrade";
    public static final String EVERY_TIME = "Every Time";
    public static final String EVERY_DAY = "Every Day";
    public static final String EVERY_WEEK = "Every Week";
    public static final String EVERY_MONTH = "Every Month";
    public static final String UPGRADE_NOW = "Upgrade Now";
    private String mUpgrade = null;

    public SGUpgradeDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGUpgradeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mUpgradeCyclePanel = new JPanel();
        this.mUpgradeCycleComboBox = new JComboBox();
        this.mUpdateButtonPanel = new JPanel();
        this.mUpgradeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(9, 6, 4, 6);
        this.mPanel.add((Component)this.mButtonPanel, gridBagConstraints);
        this.mUpgradeCyclePanel.setLayout(new GridBagLayout());
        this.mUpgradeCyclePanel.setBorder(new TitledBorder(null, "Upgrade Cycle", 0, 0, new Font("Dialog", 3, 12)));
        this.mUpgradeCycleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.mUpgradeCyclePanel.add((Component)this.mUpgradeCycleComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.mPanel.add((Component)this.mUpgradeCyclePanel, gridBagConstraints);
        this.mUpdateButtonPanel.setLayout(new GridBagLayout());
        this.mUpdateButtonPanel.setBorder(new TitledBorder(null, "Get the Latest Version", 0, 0, new Font("Dialog", 3, 12)));
        this.mUpgradeButton.setFont(new Font("Dialog", 0, 12));
        this.mUpgradeButton.setText(UPGRADE_NOW);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 14, 6, 14);
        this.mUpdateButtonPanel.add((Component)this.mUpgradeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mPanel.add((Component)this.mUpdateButtonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = new String[]{NO_UPGRADE, EVERY_TIME, EVERY_DAY, EVERY_WEEK, EVERY_MONTH};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mUpgradeCycleComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mUpgradeButton.addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals(UPGRADE_NOW)) {
            this.notifyToListener(string);
        }
    }

    public String getUpgradeCycle() {
        return this.mUpgrade;
    }

    public void setUpgradeCycle(String string) {
        this.mUpgrade = string;
    }

    public void setVisible(boolean bl) {
        this.mUpgradeCycleComboBox.setSelectedItem(this.mUpgrade);
        super.setVisible(bl);
    }

    protected boolean onOK() {
        this.mUpgrade = (String)this.mUpgradeCycleComboBox.getSelectedItem();
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }
}

