/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;

public class SGSXYMultipleData
extends SGData
implements SGITwoDimensionalData {
    private double[] mXValueArray = null;
    private double[][] mYValueArray = null;

    public SGSXYMultipleData() {
    }

    public SGSXYMultipleData(double[] dArray, double[][] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (dArray2.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = dArray.length;
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i].length == n) continue;
            throw new IllegalArgumentException();
        }
        this.mXValueArray = dArray;
        this.mYValueArray = dArray2;
    }

    public int getDataNumber() {
        return this.mYValueArray.length;
    }

    public int getDataLength() {
        return this.mYValueArray[0].length;
    }

    public int getPointsNumber() {
        return this.getDataLength();
    }

    public double[] getXValueArray() {
        return this.mXValueArray;
    }

    public double[][] getYValueArray() {
        return this.mYValueArray;
    }

    public SGSXYData[] getSXYDataArray() {
        double[] dArray = this.getXValueArray();
        SGSXYData[] sGSXYDataArray = new SGSXYData[this.mYValueArray.length];
        for (int i = 0; i < sGSXYDataArray.length; ++i) {
            sGSXYDataArray[i] = new SGSXYData(dArray, this.mYValueArray[i]);
        }
        return sGSXYDataArray;
    }

    public double getMinValueX() {
        double[] dArray = this.getXValueArray();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueX() {
        double[] dArray = this.getXValueArray();
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMinValueY() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.mYValueArray.length; ++i) {
            for (int j = 0; j < this.mYValueArray[i].length; ++j) {
                double d2 = this.mYValueArray[i][j];
                if (!(d2 < d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public double getMaxValueY() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.mYValueArray.length; ++i) {
            for (int j = 0; j < this.mYValueArray[i].length; ++j) {
                double d2 = this.mYValueArray[i][j];
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
        this.mXValueArray = sGSXYMultipleData.getXValueArray();
        this.mYValueArray = sGSXYMultipleData.getYValueArray();
        return true;
    }

    protected boolean setXValueArray(double[] dArray) {
        this.mXValueArray = dArray;
        return true;
    }

    protected boolean setYValueArray(double[][] dArray) {
        this.mYValueArray = dArray;
        return true;
    }
}

