/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;

public abstract class SGSignificantDifferenceSymbol
extends SGDrawingElement {
    public static final int OTHER = 0;
    public static final int HORIZONTAL_MIDDLE = 1;
    public static final int LEFT_MIDDLE = 2;
    public static final int RIGHT_MIDDLE = 3;
    public static final int LEFT_TERM = 4;
    public static final int LEFT_JOINT = 5;
    public static final int RIGHT_TERM = 6;
    public static final int RIGHT_JOINT = 7;
    public static final int ON_STRING = 8;
    protected float mX;
    protected float mY;
    protected float mWidth;
    protected float mPerpendicularHeight1;
    protected float mPerpendicularHeight2;
    protected float mSpace;
    protected float mLineWidth;

    public SGSignificantDifferenceSymbol() {
    }

    public SGSignificantDifferenceSymbol(float f, float f2, float f3, float f4, float f5) {
        this.setLocation(f, f2);
        this.setSize(f3, f4, f5);
    }

    public abstract float getX();

    public abstract float getY();

    public float getWidth() {
        return this.mWidth * this.mMagnification;
    }

    public float getPerpendicularHeight1() {
        return this.mPerpendicularHeight1 * this.mMagnification;
    }

    public float getPerpendicularHeight2() {
        return this.mPerpendicularHeight2 * this.mMagnification;
    }

    public float getSpace() {
        return this.mSpace * this.mMagnification;
    }

    public abstract SGDrawingElementString getStringElement();

    public String getText() {
        return this.getStringElement().getString();
    }

    public float getFontSize() {
        return this.getStringElement().getFontSize();
    }

    public int getFontStyle() {
        return this.getStringElement().getFontStyle();
    }

    public String getFontFamilyName() {
        return this.getStringElement().getFontFamilyName();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getColor() {
        return this.getColor(0);
    }

    public boolean setColorList(ArrayList arrayList) {
        super.setColorList(arrayList);
        this.getStringElement().setColorList(arrayList);
        return true;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        this.getStringElement().setColor(color);
        return true;
    }

    public boolean addColor(Color color) {
        super.addColor(color);
        this.getStringElement().addColor(color);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public abstract boolean setX(float var1);

    public abstract boolean setY(float var1);

    public boolean setSize(float f, float f2, float f3) {
        this.setWidth(f);
        this.setPerpendicularHeight1(f2);
        this.setPerpendicularHeight2(f3);
        return true;
    }

    public boolean setWidth(float f) {
        this.mWidth = f / this.mMagnification;
        return true;
    }

    public boolean setPerpendicularHeight1(float f) {
        this.mPerpendicularHeight1 = f / this.mMagnification;
        return true;
    }

    public boolean setPerpendicularHeight2(float f) {
        this.mPerpendicularHeight2 = f / this.mMagnification;
        return true;
    }

    public boolean setSpace(float f) {
        if ((double)f < 0.0) {
            throw new IllegalArgumentException("space < 0.0");
        }
        this.mSpace = f / this.mMagnification;
        return true;
    }

    public boolean setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.getStringElement().setString(string);
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < Float.MIN_VALUE) {
            throw new IllegalArgumentException("lineWidth < Float.MIN_VALUE");
        }
        this.mLineWidth = f;
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        if (f < Float.MIN_VALUE) {
            throw new IllegalArgumentException("size < Float.MIN_VALUE");
        }
        this.getStringElement().setFont(string, n, f);
        return true;
    }

    public SGProperties getProperties() {
        SigDiffProperties sigDiffProperties = new SigDiffProperties();
        sigDiffProperties.x = this.mX;
        sigDiffProperties.y = this.mY;
        sigDiffProperties.width = this.mWidth;
        sigDiffProperties.height1 = this.mPerpendicularHeight1;
        sigDiffProperties.height2 = this.mPerpendicularHeight2;
        sigDiffProperties.space = this.mSpace;
        sigDiffProperties.colorList = this.mColorList;
        sigDiffProperties.lineWidth = this.mLineWidth;
        sigDiffProperties.text = this.getText();
        sigDiffProperties.fontFamilyName = this.getFontFamilyName();
        sigDiffProperties.fontSize = this.getFontSize();
        sigDiffProperties.fontStyle = this.getFontStyle();
        return sigDiffProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        this.mX = sigDiffProperties.x;
        this.mY = sigDiffProperties.y;
        this.mWidth = sigDiffProperties.width;
        this.mPerpendicularHeight1 = sigDiffProperties.height1;
        this.mPerpendicularHeight2 = sigDiffProperties.height2;
        this.mSpace = sigDiffProperties.space;
        this.setText(sigDiffProperties.text);
        this.setFont(sigDiffProperties.fontFamilyName, sigDiffProperties.fontStyle, sigDiffProperties.fontSize);
        this.setLineWidth(sigDiffProperties.lineWidth);
        this.setColorList(sigDiffProperties.colorList);
        return true;
    }

    public static class SigDiffProperties
    extends SGProperties {
        public float x;
        public float y;
        public float width;
        public float height1;
        public float height2;
        public float space;
        public float lineWidth;
        public String text;
        public String fontFamilyName;
        public float fontSize;
        public int fontStyle;
        public ArrayList colorList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffProperties)) {
                return false;
            }
            SigDiffProperties sigDiffProperties = (SigDiffProperties)object;
            if (sigDiffProperties.x != this.x) {
                return false;
            }
            if (sigDiffProperties.y != this.y) {
                return false;
            }
            if (sigDiffProperties.width != this.width) {
                return false;
            }
            if (sigDiffProperties.height1 != this.height1) {
                return false;
            }
            if (sigDiffProperties.height2 != this.height2) {
                return false;
            }
            if (sigDiffProperties.space != this.space) {
                return false;
            }
            if (sigDiffProperties.lineWidth != this.lineWidth) {
                return false;
            }
            if (!sigDiffProperties.text.equals(this.text)) {
                return false;
            }
            if (!sigDiffProperties.fontFamilyName.equals(this.fontFamilyName)) {
                return false;
            }
            if (sigDiffProperties.fontSize != this.fontSize) {
                return false;
            }
            if (sigDiffProperties.fontStyle != this.fontStyle) {
                return false;
            }
            return sigDiffProperties.colorList.equals(this.colorList);
        }
    }
}

